from sqlalchemy import Column,  Integer, DATE, ForeignKey, Float
from ETRMDatabase.base import Base


class BlotterDailyLinear(Base):

    __tablename__ = 'blotter_daily_linear'
    __table_args__ = {'schema': 'trade'}

    id = Column(Integer, primary_key=True)
    header_id = Column(Integer, ForeignKey('trade.trade_header.id'))
    curve_id = Column(Integer, ForeignKey('power.hub_curve.id'))
    peak_id = Column(Integer, ForeignKey('power.dim_peak.id'))
    trade_volume = Column(Float)
    trade_price = Column(Float)
    start_date = Column(DATE)
    end_date = Column(DATE)

    def __init__(self, header_id, curve_id, peak_id, trade_volume, trade_price, start_date, end_date):
        self.header_id = header_id
        self.curve_id = curve_id
        self.peak_id = peak_id
        self.trade_volume = trade_volume
        self.trade_price = trade_price
        self.start_date = start_date
        self.end_date = end_date

