from sqlalchemy import Column, Float, Integer, ForeignKey, DATE
from ETRMDatabase.base import Base


class ValuationVectors(Base):

    __tablename__ = 'valuation_vectors'
    __table_args__ = {'schema': 'power'}

    as_of_date = Column(DATE, primary_key=True)
    forward_date = Column(DATE, primary_key=True)
    curve_id = Column(Integer, ForeignKey('power.hub_curve.id'), primary_key=True)
    he = Column(Integer, primary_key=True)
    block_id = Column(Integer, ForeignKey('power.dim_peak.id'))
    peak_id = Column(Integer, ForeignKey('power.dim_peak.id'))
    price = Column(Float)

    def __int__(self, as_of_date, forward_date, curve_id, he, block_id, peak_id, price):
        self.as_of_date = as_of_date
        self.forward_date = forward_date
        self.curve_id = curve_id
        self.he = he
        self.block_id = block_id
        self.peak_id = peak_id
        self.price = price



