from sqlalchemy import Column, DateTime, ForeignKey, Index, Integer, String

from ETRMDatabase.AuditDatabase.auditbase import Base_audit


class Customer(Base_audit):
    __tablename__ = 'Customer'
    __table_args__ = {'schema': 'cms'}

    customer_id = Column('Customer_ID', Integer, primary_key=True, index=True)
    customer_name = Column('CustomerName', String(250, 'SQL_Latin1_General_CP1_CI_AS'), nullable=False, index=True)
    address = Column('Address', String(100, 'SQL_Latin1_General_CP1_CI_AS'))
    city = Column('City', String(25, 'SQL_Latin1_General_CP1_CI_AS'))
    state = Column('State', String(25, 'SQL_Latin1_General_CP1_CI_AS'))
    zip_code = Column('ZipCode', String(25, 'SQL_Latin1_General_CP1_CI_AS'))
    phone_number = Column('PhoneNumber', String(25, 'SQL_Latin1_General_CP1_CI_AS'))
    email = Column('EMail', String(25, 'SQL_Latin1_General_CP1_CI_AS'))
    created_date = Column('CreatedDate', DateTime, nullable=False)
    created_by = Column('CreatedBy', String(25, 'SQL_Latin1_General_CP1_CI_AS'), nullable=False)

    def __int__(self, _customer_id, _customer_name, _address, _city, _state, _zip_code, _phone_number,
                _email, _created_date, _created_by):
        self.customer_id = _customer_id
        self.customer_name = _customer_name
        self.address = _address
        self.city = _city
        self.state = _state
        self.zip_code = _zip_code
        self.phone_number = _phone_number
        self.email = _email
        self.created_date = _created_date
        self.created_by = _created_by

