from sqlalchemy import Column, ForeignKey, Integer, String, Table
from sqlalchemy.orm import relationship
from sqlalchemy.dialects.mssql import TINYINT
from ETRMDatabase.AuditDatabase.auditbase import Base_audit
metadata = Base_audit.metadata


class PNode(Base_audit):
    __tablename__ = 'PNodes'
    __table_args__ = {'schema': 'cms'}

    ID = Column(Integer, nullable=False)
    PNode_ID = Column(Integer, primary_key=True)
    PNode_Desc = Column(String(100, 'SQL_Latin1_General_CP1_CI_AS'), nullable=False)


class StateDesc(Base_audit):
    __tablename__ = 'StateDesc'
    __table_args__ = {'schema': 'cms'}

    ID = Column(Integer, nullable=False)
    StateID = Column(TINYINT, primary_key=True)
    StateDesc = Column(String(50, 'SQL_Latin1_General_CP1_CI_AS'), nullable=False)


t_TransmissionCompany = Table(
    'TransmissionCompany', metadata,
    Column('ID', Integer, nullable=False),
    Column('TransmissionCompanyID', Integer, nullable=False, unique=True),
    Column('TransmissionCompany', String(250, 'SQL_Latin1_General_CP1_CI_AS'), nullable=False),
    Column('DUNS', String(13, 'SQL_Latin1_General_CP1_CI_AS')),
    schema='cms'
)


class ISO(Base_audit):
    __tablename__ = 'ISO'
    __table_args__ = {'schema': 'pms'}

    ID = Column(Integer, nullable=False)
    ISO_ID = Column(Integer, primary_key=True)
    ISO_Desc = Column(String(25, 'SQL_Latin1_General_CP1_CI_AS'), nullable=False)


class MarketRegion(Base_audit):
    __tablename__ = 'MarketRegion'
    __table_args__ = {'schema': 'pms'}

    ID = Column(Integer, nullable=False)
    RegionID = Column(Integer, primary_key=True)
    RegionDesc = Column(String(25, 'SQL_Latin1_General_CP1_CI_AS'), nullable=False)


class EDC(Base_audit):
    __tablename__ = 'EDC'
    __table_args__ = {'schema': 'cms'}

    ID = Column(Integer, nullable=False)
    EDC_ID = Column(Integer, primary_key=True, index=True)
    EDC_Desc = Column(String(250, 'SQL_Latin1_General_CP1_CI_AS'), nullable=False)
    EDC_ShortDesc = Column(String(25, 'SQL_Latin1_General_CP1_CI_AS'), nullable=False)
    ISO_ID = Column(ForeignKey('pms.ISO.ISO_ID'), nullable=False)
    RegionID = Column(ForeignKey('pms.MarketRegion.RegionID'), nullable=False)
    TransmissionCompanyID = Column(ForeignKey('cms.TransmissionCompany.TransmissionCompanyID'), nullable=False)
    StateID = Column(ForeignKey('cms.StateDesc.StateID'), nullable=False)

    ISO = relationship('ISO')
    MarketRegion = relationship('MarketRegion')
    StateDesc = relationship('StateDesc')
    TransmissionCompany = relationship('TransmissionCompany')
