import datetime,time
import pandas as pd
import numpy as np


class WorkHours:

    def __init__(self):
        self.hour_id=0
        self.last_hour=0

    def add_hour_id(self,working_hour):
        ''' Hour ID creation for assigning to each working hour from the start of calendar '''
        if working_hour==0:
            self.last_hour=0
        else:
            if self.last_hour==1:
                self.hour_id=self.hour_id+self.last_hour
            self.last_hour=1
        return self.hour_id
            
    def business_hours(self,shift_start=8,shift_end=18,working_days="01234"):
        ''' Defining shift start and shift end numbers allowed between 0 to 24. As well define working day 0 is Monday '''
        self.shift_start=shift_start
        self.shift_end=shift_end
        self.working_days=map(lambda x: int(x), working_days)

    def holiday_calendar(self,holiday):
        ''' Specifically mark holidays in work calendar '''
        NewHolidayCalendar=pd.DataFrame(pd.date_range(holiday,holiday,freq="D"))
        NewHolidayCalendar["DATE"]=NewHolidayCalendar
        NewHolidayCalendar=NewHolidayCalendar.set_index("DATE")
        NewHolidayCalendar=NewHolidayCalendar.reset_index()
        NewHolidayCalendar=NewHolidayCalendar[["DATE"]]
        try:
            self.HolidayCalendar=self.HolidayCalendar.merge(NewHolidayCalendar,how="outer",on=["DATE"])                   
        except Exception:
            self.HolidayCalendar=pd.DataFrame(columns=["DATE"])
            self.HolidayCalendar=self.HolidayCalendar.merge(NewHolidayCalendar,how="outer",on=["DATE"])
        self.holidays=map(lambda x: x.date(),self.HolidayCalendar["DATE"])

    def working_calendar(self,start_date,end_date):
        ''' Generate the work calendar, prerequsites are business_hours and holiday_calendar(optional) '''
        self.holiday_calendar("2000/1/1")
        self.calendar_start_date=start_date
        self.calendar_end_date=end_date        
        WorkCalendar=pd.DataFrame(pd.date_range(self.calendar_start_date,self.calendar_end_date,freq="H"))
        WorkCalendar["DATE"]=WorkCalendar
        WorkCalendar=WorkCalendar.set_index("DATE")
        WorkCalendar["HOUR"]=WorkCalendar.index.hour        
        WorkCalendar["WEEKDAY"]=WorkCalendar.index.weekday
        WorkCalendar=WorkCalendar.reset_index()
        WorkCalendar=WorkCalendar[["DATE","HOUR","WEEKDAY"]]
        WorkCalendar["WORKINGHOUR"]=0
        WorkCalendar["HOURID"]=0
        WorkCalendar["HOLIDAY"]=WorkCalendar.apply(lambda x: 1 if x["DATE"].date() in self.holidays else 0,axis=1)
        WorkCalendar["WORKINGHOUR"]=WorkCalendar.apply(lambda x: 1 if x["WEEKDAY"] in self.working_days and x["HOLIDAY"]==0 and self.shift_start<=x["HOUR"]<=self.shift_end else 0, axis=1)
        WorkCalendar["HOURID"]=WorkCalendar.apply(lambda x: self.add_hour_id(x["WORKINGHOUR"]),axis=1)
        self.WorkCalendar=WorkCalendar

    def business_hour_diff(self,begin,end):
        ''' This function is finally called to get the difference in business hours between two datetime, it round off the minutes to nearest hour'''
        begin=pd.to_datetime(begin)
        end=pd.to_datetime(end)
        if begin.hour+(begin.minute//30)>23:
            begin=begin+datetime.timedelta(days=1)
            begin=datetime.datetime(begin.year, begin.month, begin.day,00,00,00)
        if end.hour+(end.minute//30)>23:
            end=end+datetime.timedelta(days=1)
            end=datetime.datetime(end.year, end.month, end.day,00,00,00)        
        begin=datetime.datetime(begin.year, begin.month, begin.day,begin.hour+(begin.minute//30),00,00)
        end=datetime.datetime(end.year, end.month, end.day,end.hour+(end.minute//30),00,00)
        self.begin=self.WorkCalendar[self.WorkCalendar["DATE"]==begin]["HOURID"].get_values()[0]
        self.end=self.WorkCalendar[self.WorkCalendar["DATE"]==end]["HOURID"].get_values()[0]
        return (self.end -self.begin)

def test():
    #Execute the specific test
    wc=WorkHours()
    wc.holiday_calendar("2017/7/3")
    wc.business_hours()
    wc.working_calendar("2017/7/24","2017/7/31")
    print wc.business_hour_diff("2017-07-24 17:00:00","2017-07-25 08:00:00")
    print wc.business_hour_diff("7/24/2017 10:00:00","7/25/2017 08:00:00")

