"""
Auto generated code

"""

import json
from snapp_email.datacontract.classes import Post_22
from snapp_email.datacontract.utils import export_dict, fill


class Post_22Endpoint:
    def __init__(self, api_client):
        self.api_client = api_client
    
    def options(self, impersonate_user_id=None, accept_type=None):
        """
        Retrieve options available for resource 'Post_22'.
        
        :param impersonate_user_id: 
        :type impersonate_user_id: str
        
        :param accept_type: 
        :type accept_type: str
        
        :return: 
        :rtype: Post_22
        """
        url_parameters = {
        }
        endpoint_parameters = {
        }
        endpoint = 'post'.format(**endpoint_parameters)
        add_headers = {
            'Content-Type': 'application/vnd.4thoffice.post-5.18+json',
            'Accept': 'application/vnd.4thoffice.post-5.18+json' if accept_type is None else accept_type,
        }
        response = self.api_client.api_call('options', endpoint, url_parameters, add_headers, impersonate_user_id=impersonate_user_id)
        
        return fill(Post_22, response.json(), content_type=response.headers['Content-Type'], silence_exceptions=self.api_client.silence_fill_exceptions)
    
    def get(self, postId, htmlFormat=None, impersonate_user_id=None, accept_type=None):
        """
        Retrieve post resource.
        
        :param postId: 
        :type postId: 
        
        :param htmlFormat: Mime format for html body of post resource.
            Available values:
            - text/html-stripped
            - text/html-stripped.mobile
        :type htmlFormat: String
        
        :param impersonate_user_id: 
        :type impersonate_user_id: str
        
        :param accept_type: 
        :type accept_type: str
        
        :return: 
        :rtype: Post_22
        """
        url_parameters = {
            'htmlFormat': htmlFormat,
        }
        endpoint_parameters = {
            'postId': postId,
        }
        endpoint = 'post'.format(**endpoint_parameters)
        add_headers = {
            'Content-Type': 'application/vnd.4thoffice.post-5.18+json',
            'Accept': 'application/vnd.4thoffice.post-5.18+json' if accept_type is None else accept_type,
        }
        response = self.api_client.api_call('get', endpoint, url_parameters, add_headers, impersonate_user_id=impersonate_user_id)
        
        return fill(Post_22, response.json(), content_type=response.headers['Content-Type'], silence_exceptions=self.api_client.silence_fill_exceptions)
    
    def create(self, obj, clientResourceId=None, customDateTime=None, signatureId=None, returnFullResource=None, impersonate_user_id=None, accept_type=None):
        """
        Create new post.
        
        :param obj: Object to be persisted
        :type obj: Post_22
        
        :param clientResourceId: Resource id generated by client-side. Required for double-post prevention on server-side.
        :type clientResourceId: String
        
        :param customDateTime: Specify custom create date time.
        :type customDateTime: DateTime
        
        :param signatureId: Specify signature id
        :type signatureId: String
        
        :param returnFullResource: Boolean flag indicating whether fully loaded resources should get returned.
        :type returnFullResource: Boolean
        
        :param impersonate_user_id: 
        :type impersonate_user_id: str
        
        :param accept_type: 
        :type accept_type: str
        
        :return: 
        :rtype: Post_22
        """
        url_parameters = {
            'clientResourceId': clientResourceId,
            'customDateTime': customDateTime,
            'signatureId': signatureId,
            'returnFullResource': returnFullResource,
        }
        endpoint_parameters = {
        }
        endpoint = 'post'.format(**endpoint_parameters)
        add_headers = {
            'Content-Type': 'application/vnd.4thoffice.post-5.18+json',
            'Accept': 'application/vnd.4thoffice.post-5.18+json' if accept_type is None else accept_type,
        }
        data = export_dict(obj)
        response = self.api_client.api_call('post', endpoint, url_parameters, add_headers, impersonate_user_id=impersonate_user_id, data=json.dumps(data))
        
        return fill(Post_22, response.json(), content_type=response.headers['Content-Type'], silence_exceptions=self.api_client.silence_fill_exceptions)
    
    def create_2(self, obj, sourceResourceId, sourceResourceModified, isForward=None, returnFullResource=None, impersonate_user_id=None, accept_type=None):
        """
        Copy existing post.
        
        :param obj: Object to be persisted
        :type obj: Post_22
        
        :param sourceResourceId: Specify id of source resource.
        :type sourceResourceId: String
        
        :param sourceResourceModified: Boolean flag indicating wheter source resource was modified by client-side while copying it.
        :type sourceResourceModified: String
        
        :param isForward: Boolean flag indicating forward action.
        :type isForward: String
        
        :param returnFullResource: Boolean flag indicating whether fully loaded resources should get returned.
        :type returnFullResource: Boolean
        
        :param impersonate_user_id: 
        :type impersonate_user_id: str
        
        :param accept_type: 
        :type accept_type: str
        
        :return: 
        :rtype: Post_22
        """
        url_parameters = {
            'sourceResourceId': sourceResourceId,
            'sourceResourceModified': sourceResourceModified,
            'isForward': isForward,
            'returnFullResource': returnFullResource,
        }
        endpoint_parameters = {
        }
        endpoint = 'post'.format(**endpoint_parameters)
        add_headers = {
            'Content-Type': 'application/vnd.4thoffice.post-5.18+json',
            'Accept': 'application/vnd.4thoffice.post-5.18+json' if accept_type is None else accept_type,
        }
        data = export_dict(obj)
        response = self.api_client.api_call('post', endpoint, url_parameters, add_headers, impersonate_user_id=impersonate_user_id, data=json.dumps(data))
        
        return fill(Post_22, response.json(), content_type=response.headers['Content-Type'], silence_exceptions=self.api_client.silence_fill_exceptions)
