(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     37817,        770]
NotebookOptionsPosition[     36813,        735]
NotebookOutlinePosition[     37179,        751]
CellTagsIndexPosition[     37136,        748]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"h8", "=", 
   RowBox[{
    RowBox[{"1", "/", "2"}], "*", 
    RowBox[{"(", 
     RowBox[{"1", "+", "xi"}], ")"}], "*", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"eta", "*", "eta"}]}], ")"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"h7", "=", 
   RowBox[{
    RowBox[{"1", "/", "2"}], "*", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"xi", "*", "xi"}]}], ")"}], "*", 
    RowBox[{"(", 
     RowBox[{"1", "-", "eta"}], ")"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"h6", "=", 
   RowBox[{
    RowBox[{"1", "/", "2"}], "*", 
    RowBox[{"(", 
     RowBox[{"1", "-", "xi"}], ")"}], "*", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"eta", "*", "eta"}]}], ")"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"h5", "=", 
    RowBox[{
     RowBox[{"1", "/", "2"}], "*", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"xi", "*", "xi"}]}], ")"}], "*", 
     RowBox[{"(", 
      RowBox[{"1", "+", "eta"}], ")"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"h1", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"1", "/", "4"}], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "xi"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"1", "+", "eta"}], ")"}]}], "-", 
    RowBox[{
     RowBox[{"1", "/", "2"}], " ", "h5"}], "-", 
    RowBox[{
     RowBox[{"1", "/", "2"}], " ", "h8"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"h2", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"1", "/", "4"}], " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", "xi"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"1", "+", "eta"}], ")"}]}], "-", 
    RowBox[{
     RowBox[{"1", "/", "2"}], " ", "h5"}], "-", 
    RowBox[{
     RowBox[{"1", "/", "2"}], " ", "h6"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"h3", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"1", "/", "4"}], " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", "xi"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"1", "-", "eta"}], ")"}]}], "-", 
    RowBox[{
     RowBox[{"1", "/", "2"}], " ", "h6"}], "-", 
    RowBox[{
     RowBox[{"1", "/", "2"}], " ", "h7"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"h4", "=", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "/", "4"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "xi"}], ")"}], 
      RowBox[{"(", 
       RowBox[{"1", "-", "eta"}], ")"}]}], "-", 
     RowBox[{
      RowBox[{"1", "/", "2"}], " ", "h7"}], "-", 
     RowBox[{
      RowBox[{"1", "/", "2"}], " ", "h8"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"hx", " ", "=", 
   RowBox[{"FullSimplify", "[", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"j11", "*", 
        RowBox[{"D", "[", 
         RowBox[{"h1", ",", "xi"}], "]"}]}], "+", 
       RowBox[{"j12", "*", 
        RowBox[{"D", "[", 
         RowBox[{"h1", ",", "eta"}], "]"}]}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"j11", "*", 
        RowBox[{"D", "[", 
         RowBox[{"h2", ",", "xi"}], "]"}]}], "+", 
       RowBox[{"j12", "*", 
        RowBox[{"D", "[", 
         RowBox[{"h2", ",", "eta"}], "]"}]}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"j11", "*", 
        RowBox[{"D", "[", 
         RowBox[{"h3", ",", "xi"}], "]"}]}], "+", 
       RowBox[{"j12", "*", 
        RowBox[{"D", "[", 
         RowBox[{"h3", ",", "eta"}], "]"}]}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"j11", "*", 
        RowBox[{"D", "[", 
         RowBox[{"h4", ",", "xi"}], "]"}]}], "+", 
       RowBox[{"j12", "*", 
        RowBox[{"D", "[", 
         RowBox[{"h4", ",", "eta"}], "]"}]}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"j11", "*", 
        RowBox[{"D", "[", 
         RowBox[{"h5", ",", "xi"}], "]"}]}], "+", 
       RowBox[{"j12", "*", 
        RowBox[{"D", "[", 
         RowBox[{"h5", ",", "eta"}], "]"}]}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"j11", "*", 
        RowBox[{"D", "[", 
         RowBox[{"h6", ",", "xi"}], "]"}]}], "+", 
       RowBox[{"j12", "*", 
        RowBox[{"D", "[", 
         RowBox[{"h6", ",", "eta"}], "]"}]}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"j11", "*", 
        RowBox[{"D", "[", 
         RowBox[{"h7", ",", "xi"}], "]"}]}], "+", 
       RowBox[{"j12", "*", 
        RowBox[{"D", "[", 
         RowBox[{"h7", ",", "eta"}], "]"}]}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"j11", "*", 
        RowBox[{"D", "[", 
         RowBox[{"h8", ",", "xi"}], "]"}]}], "+", 
       RowBox[{"j12", "*", 
        RowBox[{"D", "[", 
         RowBox[{"h8", ",", "eta"}], "]"}]}]}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Map", "[", 
    RowBox[{"Print", ",", 
     RowBox[{"Map", "[", 
      RowBox[{"FortranForm", ",", "hx"}], "]"}]}], "]"}], ";"}], 
  "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"hy", " ", "=", 
   RowBox[{"FullSimplify", "[", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"j21", "*", 
        RowBox[{"D", "[", 
         RowBox[{"h1", ",", "xi"}], "]"}]}], "+", 
       RowBox[{"j22", "*", 
        RowBox[{"D", "[", 
         RowBox[{"h1", ",", "eta"}], "]"}]}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"j21", "*", 
        RowBox[{"D", "[", 
         RowBox[{"h2", ",", "xi"}], "]"}]}], "+", 
       RowBox[{"j22", "*", 
        RowBox[{"D", "[", 
         RowBox[{"h2", ",", "eta"}], "]"}]}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"j21", "*", 
        RowBox[{"D", "[", 
         RowBox[{"h3", ",", "xi"}], "]"}]}], "+", 
       RowBox[{"j22", "*", 
        RowBox[{"D", "[", 
         RowBox[{"h3", ",", "eta"}], "]"}]}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"j21", "*", 
        RowBox[{"D", "[", 
         RowBox[{"h4", ",", "xi"}], "]"}]}], "+", 
       RowBox[{"j22", "*", 
        RowBox[{"D", "[", 
         RowBox[{"h4", ",", "eta"}], "]"}]}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"j21", "*", 
        RowBox[{"D", "[", 
         RowBox[{"h5", ",", "xi"}], "]"}]}], "+", 
       RowBox[{"j22", "*", 
        RowBox[{"D", "[", 
         RowBox[{"h5", ",", "eta"}], "]"}]}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"j21", "*", 
        RowBox[{"D", "[", 
         RowBox[{"h6", ",", "xi"}], "]"}]}], "+", 
       RowBox[{"j22", "*", 
        RowBox[{"D", "[", 
         RowBox[{"h6", ",", "eta"}], "]"}]}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"j21", "*", 
        RowBox[{"D", "[", 
         RowBox[{"h7", ",", "xi"}], "]"}]}], "+", 
       RowBox[{"j22", "*", 
        RowBox[{"D", "[", 
         RowBox[{"h7", ",", "eta"}], "]"}]}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"j21", "*", 
        RowBox[{"D", "[", 
         RowBox[{"h8", ",", "xi"}], "]"}]}], "+", 
       RowBox[{"j22", "*", 
        RowBox[{"D", "[", 
         RowBox[{"h8", ",", "eta"}], "]"}]}]}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", "\"\<\>\"", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Map", "[", 
    RowBox[{"Print", ",", 
     RowBox[{"Map", "[", 
      RowBox[{"FortranForm", ",", "hy"}], "]"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]", "\n", "\n"}], "\n"}], "Input",
 CellChangeTimes->{{3.5988751343024645`*^9, 3.598875149345325*^9}, {
   3.5988753108685637`*^9, 3.5988754321825027`*^9}, {3.598875479589214*^9, 
   3.5988755888094606`*^9}, 3.598875669691087*^9, {3.5988757097403774`*^9, 
   3.598875714802667*^9}, {3.598876419867995*^9, 3.598876470219875*^9}, {
   3.5988765343775444`*^9, 3.5988765453261704`*^9}, {3.5988765959400654`*^9, 
   3.598876606698681*^9}, {3.5988766473450055`*^9, 3.598876648712084*^9}, {
   3.598876704392268*^9, 3.5988767609205017`*^9}, {3.5988768236120872`*^9, 
   3.5988768269512787`*^9}, {3.5988768811743803`*^9, 3.598876910409052*^9}, {
   3.5988775028619385`*^9, 3.5988776175945005`*^9}, {3.5988776677223682`*^9, 
   3.5988776704695253`*^9}, {3.598877707026616*^9, 3.5988777811488557`*^9}, {
   3.5988778368220396`*^9, 3.5988778370500526`*^9}, {3.598877962448225*^9, 
   3.5988782071672225`*^9}, {3.5988784095227966`*^9, 3.59887864298915*^9}, {
   3.5988786775651274`*^9, 3.5988788208083205`*^9}, {3.598878884983991*^9, 
   3.5988789131836042`*^9}, {3.598878959114231*^9, 3.5988790727597313`*^9}, {
   3.598879133614212*^9, 3.5988792102165937`*^9}, {3.5988793276843123`*^9, 
   3.598879329754431*^9}, {3.59887957364038*^9, 3.5988796752711935`*^9}, {
   3.5988799419774475`*^9, 3.5988799476387715`*^9}, {3.598880004988052*^9, 
   3.5988800058301*^9}, {3.5988800420891743`*^9, 3.598880179809051*^9}, {
   3.5988802970207553`*^9, 3.5988803020230412`*^9}, 3.5988803406492505`*^9, 
   3.5988803958574085`*^9, 3.5988843138085203`*^9, {3.5988845886632404`*^9, 
   3.598884661836426*^9}, {3.598884945999679*^9, 3.598884981487709*^9}, {
   3.5988851178425083`*^9, 3.598885129732188*^9}, {3.5988851623350525`*^9, 
   3.598885167740362*^9}, {3.598889756412819*^9, 3.59888976919855*^9}, {
   3.598890243568183*^9, 3.5988902788182325`*^9}, {3.598890998621744*^9, 
   3.5988910004678497`*^9}, {3.598891399075649*^9, 3.598891643710641*^9}, {
   3.5988916877631607`*^9, 3.598891950161169*^9}, {3.5988921837895317`*^9, 
   3.5988926061946917`*^9}, {3.598892658503684*^9, 3.5988927533031063`*^9}, {
   3.5988928209009724`*^9, 3.598892850346657*^9}, {3.598892962158052*^9, 
   3.5988929865724487`*^9}, {3.598893040179515*^9, 3.598893317650385*^9}, {
   3.598893349510207*^9, 3.598893414857945*^9}, {3.5988934532411404`*^9, 
   3.598893456407322*^9}, {3.598893567842695*^9, 3.5988936027056894`*^9}, 
   3.5988937334091654`*^9, {3.5988937690862055`*^9, 3.5988938136977572`*^9}, {
   3.598893855144128*^9, 3.5988938768413687`*^9}, {3.5989008394098825`*^9, 
   3.5989009329788465`*^9}, {3.598901001556567*^9, 3.598901247506599*^9}, {
   3.5989015148677177`*^9, 3.598901541459239*^9}, {3.598901597638452*^9, 
   3.598901619842722*^9}, {3.59890169218886*^9, 3.5989017065556817`*^9}, {
   3.598901820250185*^9, 3.598901859666439*^9}, {3.5989019027429028`*^9, 
   3.5989021657859483`*^9}, {3.598902264550597*^9, 3.598902266162689*^9}, {
   3.598902380233214*^9, 3.5989023862195563`*^9}, {3.5989024342673044`*^9, 
   3.59890249066153*^9}, 3.59890252213433*^9, {3.5989283180587726`*^9, 
   3.5989283229130507`*^9}, {3.5989307440843363`*^9, 
   3.5989307484055443`*^9}, {3.5989308871769876`*^9, 
   3.5989309123554325`*^9}, {3.5989309979527826`*^9, 3.598931174591893*^9}, {
   3.598931234464798*^9, 3.5989312421088114`*^9}, {3.5989312797516775`*^9, 
   3.5989313035417194`*^9}, {3.598931447842772*^9, 3.5989314986520615`*^9}, {
   3.598931558868167*^9, 3.5989315800530043`*^9}, {3.5989317911681747`*^9, 
   3.5989318004501915`*^9}, {3.5989324456732283`*^9, 
   3.5989324464862747`*^9}, {3.5989328893606057`*^9, 
   3.5989330227812366`*^9}, {3.5989330749782224`*^9, 3.598933096754468*^9}, 
   3.598933207745816*^9, {3.598933315349971*^9, 3.5989334576691113`*^9}, {
   3.5989335193266373`*^9, 3.5989336409245925`*^9}, {3.5989337123766794`*^9, 
   3.5989337571212387`*^9}, {3.5989338200608387`*^9, 3.59893382253598*^9}, {
   3.598933872032811*^9, 3.598933872445835*^9}, {3.598933921258627*^9, 
   3.5989343830810413`*^9}, {3.598934471816117*^9, 3.598934477057417*^9}, {
   3.5989346025635953`*^9, 3.598934607990906*^9}, 3.5989357722394967`*^9, {
   3.598937289850994*^9, 3.5989372905217953`*^9}, {3.59893737290554*^9, 
   3.5989373892331686`*^9}, {3.5989378698544126`*^9, 3.598937965544981*^9}, {
   3.5989403021974573`*^9, 3.598940325923815*^9}, {3.5989404292897267`*^9, 
   3.598940429753753*^9}, {3.598940484633892*^9, 3.5989405463884244`*^9}, {
   3.5989406255849543`*^9, 3.5989406583168263`*^9}, {3.598940744685766*^9, 
   3.598940744871777*^9}, {3.59894082342627*^9, 3.5989409081201143`*^9}, 
   3.5989409741928935`*^9, {3.598941080525975*^9, 3.5989410951618123`*^9}, {
   3.5989411763134537`*^9, 3.598941199996809*^9}, {3.598941323328863*^9, 
   3.5989413410518765`*^9}, {3.5989413838193226`*^9, 3.598941418107284*^9}, {
   3.59894147765969*^9, 3.5989414853631306`*^9}, {3.5989415196480913`*^9, 
   3.5989415598783927`*^9}, {3.5989416249101124`*^9, 3.598941653385741*^9}, {
   3.598941813269886*^9, 3.5989418141589365`*^9}, {3.598941928595482*^9, 
   3.5989419505697393`*^9}, {3.5989420387787848`*^9, 
   3.5989420423249874`*^9}, {3.5989420735267715`*^9, 
   3.5989420995952625`*^9}, {3.598942162502861*^9, 3.598942197037836*^9}, {
   3.598942360156166*^9, 3.5989423615652466`*^9}, {3.5989424551666*^9, 
   3.598942521280382*^9}, {3.598942604497142*^9, 3.598942611254528*^9}, 
   3.5989426559970875`*^9, {3.598942697467459*^9, 3.5989428328192005`*^9}, {
   3.598942894615735*^9, 3.5989429033772364`*^9}, {3.598942950413927*^9, 
   3.5989429588694105`*^9}, {3.5989429960965395`*^9, 
   3.5989432881182423`*^9}, {3.5989463865184608`*^9, 
   3.5989463938128777`*^9}, {3.598946427188787*^9, 3.5989464309310007`*^9}, {
   3.5989464879652634`*^9, 3.5989464890233235`*^9}, {3.5989465415773296`*^9, 
   3.5989465948033743`*^9}, {3.598946657336951*^9, 3.5989467237547493`*^9}, {
   3.5989467912236085`*^9, 3.5989467919186487`*^9}, {3.5989468286947517`*^9, 
   3.598947002239678*^9}, {3.598947046580214*^9, 3.598947050161419*^9}, {
   3.5989471369873853`*^9, 3.598947176511646*^9}, {3.598947226504505*^9, 
   3.598947283849785*^9}, {3.5989473191518044`*^9, 3.598947320110859*^9}, {
   3.598947396647237*^9, 3.5989475024302874`*^9}, {3.598947556425376*^9, 
   3.598947605616189*^9}, {3.5989476817575445`*^9, 3.598947940226328*^9}, {
   3.5989479843508515`*^9, 3.5989479966745567`*^9}, {3.5989480925050373`*^9, 
   3.598948099923462*^9}, {3.5989481859433823`*^9, 3.5989482942445765`*^9}, {
   3.598948342116315*^9, 3.598948342665346*^9}, {3.598948381092544*^9, 
   3.598948398915563*^9}, 3.598948429952338*^9, 3.598948465970399*^9, {
   3.5989485131270957`*^9, 3.59894851529622*^9}, {3.59894854886514*^9, 
   3.59894859868499*^9}, {3.5989492197195106`*^9, 3.598949227157936*^9}, {
   3.5989492661921687`*^9, 3.5989492687833166`*^9}, {3.5989494288864746`*^9, 
   3.598949442571257*^9}, {3.5989494873338175`*^9, 3.598949519864678*^9}, {
   3.598949568399454*^9, 3.5989495694755154`*^9}, 3.5989496158311667`*^9, {
   3.598949727408549*^9, 3.5989497637656283`*^9}, {3.598949827415269*^9, 
   3.598949827889296*^9}, {3.5989500902032995`*^9, 3.5989500956716123`*^9}, 
   3.5989507114158306`*^9, {3.598952980884637*^9, 3.5989529973055763`*^9}, {
   3.598957466597205*^9, 3.598957483430168*^9}, {3.598957555606296*^9, 
   3.598957590505292*^9}, {3.5989576659356065`*^9, 3.5989577327594285`*^9}, {
   3.598957849311095*^9, 3.598957860429731*^9}, {3.598957937391133*^9, 
   3.598957944207523*^9}, {3.5989580490555196`*^9, 3.5989580801012955`*^9}, {
   3.5989581170834107`*^9, 3.5989581606899047`*^9}, {3.598958760223196*^9, 
   3.598958788981841*^9}, {3.598958818984557*^9, 3.598958819660596*^9}, {
   3.59895885015434*^9, 3.598959041927309*^9}, {3.598959664781934*^9, 
   3.598959836280743*^9}, {3.5989599195805073`*^9, 3.5989600401544037`*^9}, {
   3.5989601035640306`*^9, 3.598960104128063*^9}, {3.5989601554439983`*^9, 
   3.5989601566070647`*^9}, 3.598960193784191*^9, 3.598960309731823*^9, {
   3.5989621763145857`*^9, 3.598962183858017*^9}, {3.5989624612098804`*^9, 
   3.598962475481697*^9}, {3.5989625181551375`*^9, 3.598962533497015*^9}, 
   3.5990380589814873`*^9, {3.599039065738877*^9, 3.5990391194269476`*^9}, {
   3.599039680189021*^9, 3.5990397056494775`*^9}, {3.599040616635583*^9, 
   3.5990406172746196`*^9}, {3.599041429305065*^9, 3.5990414297000875`*^9}, 
   3.5990415101156874`*^9, {3.5990416092203555`*^9, 3.5990416223561068`*^9}, {
   3.5990417281541586`*^9, 3.599041757649845*^9}, {3.599041958725346*^9, 
   3.59904197452125*^9}, {3.5990421625350037`*^9, 3.5990421632540445`*^9}, {
   3.5991910375335283`*^9, 3.599191086860815*^9}, {3.5991911684645586`*^9, 
   3.599191182114582*^9}, {3.59919133416885*^9, 3.599191387739344*^9}, {
   3.5991923725646772`*^9, 3.5991923804738913`*^9}, 3.59919242541757*^9, {
   3.599547303663577*^9, 3.5995474528081074`*^9}, {3.599547556025011*^9, 
   3.599547813222722*^9}, {3.59954794780942*^9, 3.5995480687243357`*^9}, {
   3.599548126367633*^9, 3.599548193469471*^9}, 3.5995507096043854`*^9, {
   3.599550861245059*^9, 3.5995508919968176`*^9}, {3.599550968578198*^9, 
   3.5995510382031803`*^9}, {3.599551076213354*^9, 3.5995511047639875`*^9}, 
   3.5995512284830637`*^9, {3.599551261296941*^9, 3.5995512624100046`*^9}, {
   3.5995513174951553`*^9, 3.599551335259171*^9}, {3.599555382517661*^9, 
   3.5995553905711217`*^9}, {3.5995554906778474`*^9, 
   3.5995555130101247`*^9}, {3.599558329900242*^9, 3.5995583489363303`*^9}, {
   3.5995584073126693`*^9, 3.5995584079257045`*^9}, 3.599561217520404*^9, {
   3.599561277803852*^9, 3.5995612783418827`*^9}, {3.601054837836965*^9, 
   3.6010548545819225`*^9}, 3.6010550310190144`*^9, {3.601055062097792*^9, 
   3.601055092218515*^9}, {3.6010578042656355`*^9, 3.601057804644657*^9}, {
   3.6010934147001796`*^9, 3.601093452577046*^9}, {3.601093513900754*^9, 
   3.601093587408083*^9}, {3.6010936308541594`*^9, 3.601093639262574*^9}, {
   3.6010942107361393`*^9, 3.601094255835819*^9}, 3.60109431332192*^9, {
   3.6010949780822067`*^9, 3.6010949928554325`*^9}, {3.601095104848029*^9, 
   3.6010951052536297`*^9}, {3.601095627230361*^9, 3.601095650068801*^9}, {
   3.601095725741334*^9, 3.6010957297349405`*^9}, {3.6010973259793453`*^9, 
   3.601097414696701*^9}, {3.6010975148800774`*^9, 3.6010975154884777`*^9}, {
   3.6010985531116076`*^9, 3.6010985936872787`*^9}, {3.6010986458537703`*^9, 
   3.6010986464933715`*^9}, {3.601099027830043*^9, 3.601099053585688*^9}, 
   3.6011805374775176`*^9, {3.601208683718072*^9, 3.601208701722101*^9}, {
   3.6012087400332923`*^9, 3.6012087408183374`*^9}, {3.6012088574933186`*^9, 
   3.6012088580373497`*^9}, {3.6012303878174653`*^9, 
   3.6012304190532517`*^9}, {3.6012305073062997`*^9, 3.601230507738324*^9}, 
   3.601231286825886*^9, {3.6012314158592663`*^9, 3.6012314169193263`*^9}, {
   3.601272568083086*^9, 3.601272568546113*^9}, {3.601272743561123*^9, 
   3.6012727440401506`*^9}, {3.6012729040032997`*^9, 3.601272931484872*^9}, {
   3.6012742326072917`*^9, 3.60127423328333*^9}, 3.6012742708864813`*^9, {
   3.6012743224734316`*^9, 3.6012743463958*^9}, {3.601274432020697*^9, 
   3.6012744325637283`*^9}, {3.601274486423809*^9, 3.6012744904960423`*^9}, {
   3.601274746667694*^9, 3.601274748624806*^9}, {3.601274824524147*^9, 
   3.601274824955172*^9}, {3.6012748779612036`*^9, 3.601274889714876*^9}, {
   3.6012785497712193`*^9, 3.60127856219993*^9}, {3.6012790546820984`*^9, 
   3.6012790552161293`*^9}, 3.6012795345495453`*^9, {3.602230055587788*^9, 
   3.6022300559309883`*^9}, {3.6022307317613792`*^9, 
   3.6022307364569874`*^9}, {3.6022307941614885`*^9, 3.602230794567089*^9}, {
   3.602233375089223*^9, 3.6022333898624487`*^9}, {3.6029135627990055`*^9, 
   3.60291356568617*^9}, 3.6029140963325214`*^9, {3.602943141909201*^9, 
   3.602943212849259*^9}, 3.602995774425704*^9, 3.6029959082373576`*^9, {
   3.602995995576353*^9, 3.6029960005556383`*^9}, {3.6029974763840504`*^9, 
   3.6029974875146875`*^9}, {3.603000481871955*^9, 3.603000493072595*^9}, {
   3.6030005284976215`*^9, 3.6030006191468067`*^9}, 3.6030008018372555`*^9, {
   3.603000878459638*^9, 3.6030009545379896`*^9}, {3.6030963410867662`*^9, 
   3.603096342705859*^9}, {3.6030963794319596`*^9, 3.6030963795329657`*^9}, {
   3.6036983564295273`*^9, 3.6036983689582434`*^9}, {3.603698401081081*^9, 
   3.603698431182803*^9}, {3.603698476868416*^9, 3.6036984779384766`*^9}, {
   3.6036986497723055`*^9, 3.6036989475363364`*^9}, {3.603698989365729*^9, 
   3.6036992283904004`*^9}, {3.603699369671481*^9, 3.603699512983678*^9}, {
   3.6036995669807663`*^9, 3.603699567232781*^9}, {3.60369960864215*^9, 
   3.6036996114383097`*^9}, {3.6036996840764637`*^9, 3.603699785491265*^9}, {
   3.603699829027755*^9, 3.603699830841859*^9}, {3.603699875537415*^9, 
   3.6036999033420057`*^9}, {3.6037003600311265`*^9, 3.6037003606641626`*^9}, 
   3.603714985761771*^9, 3.6037150175665903`*^9, {3.603715070759633*^9, 
   3.6037150997942934`*^9}, {3.603719957295127*^9, 3.6037199777792983`*^9}, {
   3.6040366176747265`*^9, 3.6040366412640758`*^9}, {3.6040366963952293`*^9, 
   3.6040366989973783`*^9}, {3.604036769775457*^9, 3.6040367701654577`*^9}, {
   3.604036802270314*^9, 3.604036833033568*^9}, {3.6042974554489994`*^9, 
   3.6042974866537848`*^9}, {3.604298170884066*^9, 3.6042981966145377`*^9}, {
   3.6044599656434393`*^9, 3.6044599673438425`*^9}, {3.60614833369323*^9, 
   3.6061483532712646`*^9}, {3.6073951216434402`*^9, 3.60739512215947*^9}, {
   3.607395159101583*^9, 3.607395175401515*^9}, {3.6094086502076426`*^9, 
   3.609408652352646*^9}, 3.6121055394052343`*^9, {3.612105717971448*^9, 
   3.612105826788672*^9}, {3.6121058927664456`*^9, 3.612106225327467*^9}, {
   3.612106526226678*^9, 3.6121065305239234`*^9}, {3.6121066956193666`*^9, 
   3.612106839132575*^9}, {3.612106929664753*^9, 3.61210694482162*^9}, {
   3.6121069783835397`*^9, 3.612107136721596*^9}, {3.6121077662666035`*^9, 
   3.612107767934699*^9}, {3.6121078272220907`*^9, 3.612107889646661*^9}, {
   3.612107951758213*^9, 3.6121079726074057`*^9}, {3.6121081056020126`*^9, 
   3.6121082524424114`*^9}, {3.6121082966469398`*^9, 3.612108332967017*^9}, {
   3.612108365917902*^9, 3.6121083996728325`*^9}, {3.612108536678669*^9, 
   3.612108589080666*^9}, {3.6121086344732623`*^9, 3.612108638141472*^9}, {
   3.6121087016541047`*^9, 3.612108848387498*^9}, {3.6121090325720325`*^9, 
   3.6121091141646996`*^9}, {3.612109156763136*^9, 3.6121091614394035`*^9}, {
   3.6121091998566003`*^9, 3.6121092536886797`*^9}, {3.612109296719141*^9, 
   3.612109332964214*^9}, {3.61210938325509*^9, 3.6121094045913105`*^9}, {
   3.6121674263375893`*^9, 3.612167520081951*^9}, {3.6121675516427565`*^9, 
   3.612167591235021*^9}, {3.612167627186077*^9, 3.612167752338236*^9}, {
   3.6121869711279273`*^9, 3.6121870162276063`*^9}, {3.6121870714673033`*^9, 
   3.6121874478023643`*^9}, {3.6121875247104993`*^9, 3.612187653098725*^9}, {
   3.612187725014851*^9, 3.612187851312673*^9}, {3.612188045392614*^9, 
   3.6121882651502*^9}, {3.612191304046414*^9, 3.6121913571694527`*^9}, {
   3.612191438108082*^9, 3.612191447125598*^9}, {3.612191935620542*^9, 
   3.612192003901862*^9}, {3.612192137079296*^9, 3.6121921499805183`*^9}, {
   3.612192272581134*^9, 3.6121923460416627`*^9}, {3.6121923821557264`*^9, 
   3.6121923823117266`*^9}, {3.6121927022273817`*^9, 
   3.6121927165051985`*^9}, {3.612192807914427*^9, 3.6121929075131235`*^9}, {
   3.612192942225109*^9, 3.6121929883037443`*^9}, {3.6121930294460974`*^9, 
   3.6121930698734097`*^9}, {3.612193164148802*^9, 3.612193181152775*^9}, {
   3.612195209199094*^9, 3.612195327806102*^9}, {3.612195370347377*^9, 
   3.612195675047112*^9}, {3.6121957206459923`*^9, 3.6121958264609776`*^9}, {
   3.6121958676606503`*^9, 3.6121958858190823`*^9}, {3.6121977556868496`*^9, 
   3.6121977588068542`*^9}, {3.612198208352147*^9, 3.61219821013715*^9}, {
   3.6121985274557886`*^9, 3.612198562394787*^9}, {3.612198607794383*^9, 
   3.6121986175699425`*^9}, {3.6121986657336974`*^9, 3.612198959926524*^9}, {
   3.6121989906542816`*^9, 3.612199019333922*^9}, {3.612199058773178*^9, 
   3.6121990640754814`*^9}, {3.612199239123493*^9, 3.6121992485830345`*^9}, {
   3.612199640013423*^9, 3.6121996447986965`*^9}, {3.6122332516762075`*^9, 
   3.6122332816282597`*^9}, {3.6122338416348495`*^9, 
   3.6122338683576965`*^9}, {3.6122435570333405`*^9, 
   3.6122435930864024`*^9}, {3.612244260709588*^9, 3.6122442691730723`*^9}, {
   3.6122476513105197`*^9, 3.612247653152625*^9}, {3.612247898550661*^9, 
   3.6122479192598457`*^9}, {3.6122480170664396`*^9, 3.612248174158425*^9}, {
   3.6122498041076527`*^9, 3.6122498327792926`*^9}, {3.6122514182649775`*^9, 
   3.6122514538510127`*^9}, {3.612251556097861*^9, 3.6122515613571615`*^9}, {
   3.6122516264678855`*^9, 3.6122517552002487`*^9}, {3.6122517875921016`*^9, 
   3.6122518149876685`*^9}, {3.6122518611543093`*^9, 
   3.6122518645305023`*^9}, {3.612252174465229*^9, 3.612252340325716*^9}, {
   3.612252400272145*^9, 3.6122524105737343`*^9}, {3.6122524453737245`*^9, 
   3.6122524716022243`*^9}, {3.612253416711282*^9, 3.612253443993842*^9}, {
   3.612253532832924*^9, 3.612253533219946*^9}, {3.6122535712601213`*^9, 
   3.6122535739192734`*^9}, {3.61225362595825*^9, 3.6122536764891405`*^9}, {
   3.6122537342714453`*^9, 3.6122537355465183`*^9}, {3.612253771832594*^9, 
   3.61225377702089*^9}, {3.6122538992198796`*^9, 3.612253908829429*^9}, {
   3.612254060548107*^9, 3.6122540621091967`*^9}, {3.6122541260758553`*^9, 
   3.6122541436928625`*^9}, {3.6122541915546002`*^9, 3.612254285054948*^9}, {
   3.612254339707074*^9, 3.6122543843356266`*^9}, {3.6122544195546412`*^9, 
   3.612254601158028*^9}, {3.612255140599882*^9, 3.6122551416349416`*^9}, {
   3.612255597329006*^9, 3.6122555976450243`*^9}, {3.61225563202499*^9, 
   3.612255692369442*^9}, {3.6122557626374607`*^9, 3.6122558273381615`*^9}, {
   3.612259075076373*^9, 3.612259082292786*^9}, {3.612259123480142*^9, 
   3.61225915334485*^9}, {3.612259461597207*^9, 3.6122594708177347`*^9}, {
   3.6122595191755004`*^9, 3.612259524396799*^9}, {3.612260046309592*^9, 
   3.6122600509896*^9}, {3.6122600877744646`*^9, 3.6122600894280677`*^9}, {
   3.6122601705200267`*^9, 3.6122601819080467`*^9}, {3.6122607784486647`*^9, 
   3.6122608090715184`*^9}, {3.6122608725012293`*^9, 3.61226087864764*^9}, {
   3.6122612679000196`*^9, 3.6122613103304462`*^9}, {3.612261357583149*^9, 
   3.6122614152704487`*^9}, {3.6122615064256625`*^9, 3.612261526864832*^9}, {
   3.612261566122077*^9, 3.6122615729744687`*^9}, 3.6122616536120815`*^9, {
   3.6122616844458447`*^9, 3.6122616906732006`*^9}, {3.6122620987292824`*^9, 
   3.6122621010392857`*^9}, {3.612262184443407*^9, 3.612262246533494*^9}, {
   3.6122624515751944`*^9, 3.6122624842652397`*^9}, {3.612347004186615*^9, 
   3.6123470277229614`*^9}, {3.6137452278273563`*^9, 3.613745306997495*^9}, {
   3.613745361406791*^9, 3.6137454231672997`*^9}, {3.613745493211423*^9, 
   3.6137455465635166`*^9}, {3.613745596078004*^9, 3.6137456688833313`*^9}, {
   3.6137458737742605`*^9, 3.613745941709356*^9}, {3.613746033171213*^9, 
   3.613746234374496*^9}, {3.6137462984195857`*^9, 3.613746333294635*^9}, {
   3.613746419294755*^9, 3.6137464216997585`*^9}, {3.62040330720255*^9, 
   3.620403367699729*^9}, {3.621148122273617*^9, 3.6211481467790184`*^9}, 
   3.62114921802429*^9, {3.621149358460323*^9, 3.621149380333574*^9}, {
   3.6211494869496717`*^9, 3.621149589788554*^9}, {3.621150204893736*^9, 
   3.621150272941628*^9}, {3.6211503578864865`*^9, 3.621150490558075*^9}, {
   3.6211505440051317`*^9, 3.6211506259568195`*^9}, {3.621150689583459*^9, 
   3.621150782108751*^9}, {3.6211508450033484`*^9, 3.62115098962462*^9}, {
   3.6211511512978673`*^9, 3.6211511529709625`*^9}, {3.621151470699136*^9, 
   3.6211516017326307`*^9}, {3.621151642582967*^9, 3.6211518472906756`*^9}, {
   3.6211518841817856`*^9, 3.621151917614698*^9}, {3.621151948359456*^9, 
   3.6211520199345503`*^9}, {3.6211521010401893`*^9, 3.621152145903755*^9}, {
   3.621152246422505*^9, 3.6211522494526777`*^9}, {3.621152281511512*^9, 
   3.6211523044238224`*^9}, {3.62115254915782*^9, 3.6211525534130635`*^9}, {
   3.6211525845378437`*^9, 3.6211525874910126`*^9}, {3.6211527507163486`*^9, 
   3.6211527515183945`*^9}, {3.6211528581184916`*^9, 
   3.6211528585605173`*^9}, {3.621152921089093*^9, 3.621152997713476*^9}, 
   3.621156048776987*^9, {3.62115610058195*^9, 3.621156225027068*^9}, {
   3.6211562750449286`*^9, 3.621156283071388*^9}, {3.6211563435138445`*^9, 
   3.62115636108785*^9}, {3.6211565693797636`*^9, 3.6211565974703703`*^9}, {
   3.621156627813106*^9, 3.6211566471772137`*^9}, {3.621156762078786*^9, 
   3.6211567823619456`*^9}, {3.621156861272459*^9, 3.6211569833464413`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox["\<\"(eta**2*j11 + xi*(2*j11 + j12 + j12*xi) + eta*(j11 + \
2*j12 + 2*(j11 + j12)*xi))/4.\"\>",
  FortranForm[
  Rational[1, 
     4] ($CellContext`eta^2 $CellContext`j11 + $CellContext`xi (
      2 $CellContext`j11 + $CellContext`j12 + $CellContext`j12 \
$CellContext`xi) + $CellContext`eta ($CellContext`j11 + 2 $CellContext`j12 + 
      2 ($CellContext`j11 + $CellContext`j12) $CellContext`xi))],
  AutoDelete->True,
  Editable->True]], "Print",
 CellChangeTimes->{{3.6211566409058547`*^9, 3.621156647669242*^9}, {
  3.6211569645923686`*^9, 3.621156983688461*^9}}],

Cell[BoxData[
 InterpretationBox["\<\"(-(eta*(j11 + eta*j11 - 2*j12)) + (2*(1 + eta)*j11 - \
(1 + 2*eta)*j12)*xi + j12*xi**2)/4.\"\>",
  FortranForm[
  Rational[1, 
     4] (-$CellContext`eta ($CellContext`j11 + $CellContext`eta \
$CellContext`j11 - 2 $CellContext`j12) + (
      2 (1 + $CellContext`eta) $CellContext`j11 - (1 + 
       2 $CellContext`eta) $CellContext`j12) $CellContext`xi + \
$CellContext`j12 $CellContext`xi^2)],
  AutoDelete->True,
  Editable->True]], "Print",
 CellChangeTimes->{{3.6211566409058547`*^9, 3.621156647669242*^9}, {
  3.6211569645923686`*^9, 3.6211569836894608`*^9}}],

Cell[BoxData[
 InterpretationBox["\<\"(-(eta**2*j11) + xi*(2*j11 + j12 - j12*xi) + eta*(j11 \
+ 2*j12 - 2*(j11 + j12)*xi))/4.\"\>",
  FortranForm[
  Rational[1, 
     4] (-$CellContext`eta^2 $CellContext`j11 + $CellContext`xi (
      2 $CellContext`j11 + $CellContext`j12 - $CellContext`j12 \
$CellContext`xi) + $CellContext`eta ($CellContext`j11 + 2 $CellContext`j12 - 
      2 ($CellContext`j11 + $CellContext`j12) $CellContext`xi))],
  AutoDelete->True,
  Editable->True]], "Print",
 CellChangeTimes->{{3.6211566409058547`*^9, 3.621156647669242*^9}, {
  3.6211569645923686`*^9, 3.6211569836904607`*^9}}],

Cell[BoxData[
 InterpretationBox["\<\"(eta**2*j11 - xi*(-2*j11 + j12 + j12*xi) - eta*(j11 + \
2*j11*xi - 2*j12*(1 + xi)))/4.\"\>",
  FortranForm[
  Rational[1, 
     4] ($CellContext`eta^2 $CellContext`j11 - $CellContext`xi ((-2) \
$CellContext`j11 + $CellContext`j12 + $CellContext`j12 $CellContext`xi) - \
$CellContext`eta ($CellContext`j11 + 2 $CellContext`j11 $CellContext`xi - 
     2 $CellContext`j12 (1 + $CellContext`xi)))],
  AutoDelete->True,
  Editable->True]], "Print",
 CellChangeTimes->{{3.6211566409058547`*^9, 3.621156647669242*^9}, {
  3.6211569645923686`*^9, 3.621156983691461*^9}}],

Cell[BoxData[
 InterpretationBox["\<\"-((1 + eta)*j11*xi) - (j12*(-1 + xi**2))/2.\"\>",
  FortranForm[-(1 + $CellContext`eta) $CellContext`j11 $CellContext`xi + 
   Rational[-1, 2] $CellContext`j12 (-1 + $CellContext`xi^2)],
  AutoDelete->True,
  Editable->True]], "Print",
 CellChangeTimes->{{3.6211566409058547`*^9, 3.621156647669242*^9}, {
  3.6211569645923686`*^9, 3.621156983692461*^9}}],

Cell[BoxData[
 InterpretationBox["\<\"((-1 + eta**2)*j11)/2. + eta*j12*(-1 + xi)\"\>",
  FortranForm[
  Rational[1, 
      2] (-1 + $CellContext`eta^2) $CellContext`j11 + $CellContext`eta \
$CellContext`j12 (-1 + $CellContext`xi)],
  AutoDelete->True,
  Editable->True]], "Print",
 CellChangeTimes->{{3.6211566409058547`*^9, 3.621156647669242*^9}, {
  3.6211569645923686`*^9, 3.621156983692461*^9}}],

Cell[BoxData[
 InterpretationBox["\<\"(-1 + eta)*j11*xi + (j12*(-1 + xi**2))/2.\"\>",
  FortranForm[(-1 + $CellContext`eta) $CellContext`j11 $CellContext`xi + 
   Rational[1, 2] $CellContext`j12 (-1 + $CellContext`xi^2)],
  AutoDelete->True,
  Editable->True]], "Print",
 CellChangeTimes->{{3.6211566409058547`*^9, 3.621156647669242*^9}, {
  3.6211569645923686`*^9, 3.6211569836934614`*^9}}],

Cell[BoxData[
 InterpretationBox["\<\"-((-1 + eta**2)*j11)/2. - eta*j12*(1 + xi)\"\>",
  FortranForm[
  Rational[-1, 
      2] (-1 + $CellContext`eta^2) $CellContext`j11 - $CellContext`eta \
$CellContext`j12 (1 + $CellContext`xi)],
  AutoDelete->True,
  Editable->True]], "Print",
 CellChangeTimes->{{3.6211566409058547`*^9, 3.621156647669242*^9}, {
  3.6211569645923686`*^9, 3.621156983694461*^9}}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{{3.6211566409058547`*^9, 3.621156647669242*^9}, {
  3.6211569645923686`*^9, 3.621156983694461*^9}}],

Cell[BoxData[
 InterpretationBox["\<\"(eta**2*j21 + xi*(2*j21 + j22 + j22*xi) + eta*(j21 + \
2*j22 + 2*(j21 + j22)*xi))/4.\"\>",
  FortranForm[
  Rational[1, 
     4] ($CellContext`eta^2 $CellContext`j21 + $CellContext`xi (
      2 $CellContext`j21 + $CellContext`j22 + $CellContext`j22 \
$CellContext`xi) + $CellContext`eta ($CellContext`j21 + 2 $CellContext`j22 + 
      2 ($CellContext`j21 + $CellContext`j22) $CellContext`xi))],
  AutoDelete->True,
  Editable->True]], "Print",
 CellChangeTimes->{{3.6211566409058547`*^9, 3.621156647669242*^9}, {
  3.6211569645923686`*^9, 3.6211569836954613`*^9}}],

Cell[BoxData[
 InterpretationBox["\<\"(-(eta*(j21 + eta*j21 - 2*j22)) + (2*(1 + eta)*j21 - \
(1 + 2*eta)*j22)*xi + j22*xi**2)/4.\"\>",
  FortranForm[
  Rational[1, 
     4] (-$CellContext`eta ($CellContext`j21 + $CellContext`eta \
$CellContext`j21 - 2 $CellContext`j22) + (
      2 (1 + $CellContext`eta) $CellContext`j21 - (1 + 
       2 $CellContext`eta) $CellContext`j22) $CellContext`xi + \
$CellContext`j22 $CellContext`xi^2)],
  AutoDelete->True,
  Editable->True]], "Print",
 CellChangeTimes->{{3.6211566409058547`*^9, 3.621156647669242*^9}, {
  3.6211569645923686`*^9, 3.621156983696461*^9}}],

Cell[BoxData[
 InterpretationBox["\<\"(-(eta**2*j21) + xi*(2*j21 + j22 - j22*xi) + eta*(j21 \
+ 2*j22 - 2*(j21 + j22)*xi))/4.\"\>",
  FortranForm[
  Rational[1, 
     4] (-$CellContext`eta^2 $CellContext`j21 + $CellContext`xi (
      2 $CellContext`j21 + $CellContext`j22 - $CellContext`j22 \
$CellContext`xi) + $CellContext`eta ($CellContext`j21 + 2 $CellContext`j22 - 
      2 ($CellContext`j21 + $CellContext`j22) $CellContext`xi))],
  AutoDelete->True,
  Editable->True]], "Print",
 CellChangeTimes->{{3.6211566409058547`*^9, 3.621156647669242*^9}, {
  3.6211569645923686`*^9, 3.621156983696461*^9}}],

Cell[BoxData[
 InterpretationBox["\<\"(eta**2*j21 - xi*(-2*j21 + j22 + j22*xi) - eta*(j21 + \
2*j21*xi - 2*j22*(1 + xi)))/4.\"\>",
  FortranForm[
  Rational[1, 
     4] ($CellContext`eta^2 $CellContext`j21 - $CellContext`xi ((-2) \
$CellContext`j21 + $CellContext`j22 + $CellContext`j22 $CellContext`xi) - \
$CellContext`eta ($CellContext`j21 + 2 $CellContext`j21 $CellContext`xi - 
     2 $CellContext`j22 (1 + $CellContext`xi)))],
  AutoDelete->True,
  Editable->True]], "Print",
 CellChangeTimes->{{3.6211566409058547`*^9, 3.621156647669242*^9}, {
  3.6211569645923686`*^9, 3.621156983697461*^9}}],

Cell[BoxData[
 InterpretationBox["\<\"-((1 + eta)*j21*xi) - (j22*(-1 + xi**2))/2.\"\>",
  FortranForm[-(1 + $CellContext`eta) $CellContext`j21 $CellContext`xi + 
   Rational[-1, 2] $CellContext`j22 (-1 + $CellContext`xi^2)],
  AutoDelete->True,
  Editable->True]], "Print",
 CellChangeTimes->{{3.6211566409058547`*^9, 3.621156647669242*^9}, {
  3.6211569645923686`*^9, 3.6211569836984615`*^9}}],

Cell[BoxData[
 InterpretationBox["\<\"((-1 + eta**2)*j21)/2. + eta*j22*(-1 + xi)\"\>",
  FortranForm[
  Rational[1, 
      2] (-1 + $CellContext`eta^2) $CellContext`j21 + $CellContext`eta \
$CellContext`j22 (-1 + $CellContext`xi)],
  AutoDelete->True,
  Editable->True]], "Print",
 CellChangeTimes->{{3.6211566409058547`*^9, 3.621156647669242*^9}, {
  3.6211569645923686`*^9, 3.6211569836994615`*^9}}],

Cell[BoxData[
 InterpretationBox["\<\"(-1 + eta)*j21*xi + (j22*(-1 + xi**2))/2.\"\>",
  FortranForm[(-1 + $CellContext`eta) $CellContext`j21 $CellContext`xi + 
   Rational[1, 2] $CellContext`j22 (-1 + $CellContext`xi^2)],
  AutoDelete->True,
  Editable->True]], "Print",
 CellChangeTimes->{{3.6211566409058547`*^9, 3.621156647669242*^9}, {
  3.6211569645923686`*^9, 3.6211569836994615`*^9}}],

Cell[BoxData[
 InterpretationBox["\<\"-((-1 + eta**2)*j21)/2. - eta*j22*(1 + xi)\"\>",
  FortranForm[
  Rational[-1, 
      2] (-1 + $CellContext`eta^2) $CellContext`j21 - $CellContext`eta \
$CellContext`j22 (1 + $CellContext`xi)],
  AutoDelete->True,
  Editable->True]], "Print",
 CellChangeTimes->{{3.6211566409058547`*^9, 3.621156647669242*^9}, {
  3.6211569645923686`*^9, 3.6211569837004614`*^9}}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{954, 945},
WindowMargins->{{1, Automatic}, {Automatic, -2}},
CellContext->Notebook,
FrontEndVersion->"9.0 for Microsoft Windows (64-bit) (January 25, 2013)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 27998, 509, 732, "Input"],
Cell[CellGroupData[{
Cell[28602, 535, 600, 12, 23, "Print"],
Cell[29205, 549, 602, 13, 23, "Print"],
Cell[29810, 564, 606, 12, 23, "Print"],
Cell[30419, 578, 600, 12, 23, "Print"],
Cell[31022, 592, 392, 7, 23, "Print"],
Cell[31417, 601, 399, 9, 23, "Print"],
Cell[31819, 612, 391, 7, 23, "Print"],
Cell[32213, 621, 399, 9, 23, "Print"],
Cell[32615, 632, 153, 2, 23, "Print"],
Cell[32771, 636, 602, 12, 23, "Print"],
Cell[33376, 650, 600, 13, 23, "Print"],
Cell[33979, 665, 604, 12, 23, "Print"],
Cell[34586, 679, 600, 12, 23, "Print"],
Cell[35189, 693, 394, 7, 23, "Print"],
Cell[35586, 702, 401, 9, 23, "Print"],
Cell[35990, 713, 391, 7, 23, "Print"],
Cell[36384, 722, 401, 9, 23, "Print"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
