/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.util.ArrayList;
import java.util.List;
import org.sikuli.script.Match;
import org.sikuli.script.Pattern;
import org.sikuli.script.Region;

public class ObserveEvent {
    private Type type;
    private Region region = null;
    private Object pattern = null;
    private Match match = null;
    private int index = -1;
    private List<Match> changes = null;
    private long time;
    private String name;
    private Object[] vals = new Object[]{null, null, null};

    protected ObserveEvent() {
    }

    protected ObserveEvent(String name, Type type, Object ptn, Object m, Object r, long now) {
        this.init(name, type, ptn, m, r, now);
    }

    private void init(String name, Type type, Object ptn, Object m, Object r, long now) {
        this.name = name;
        this.type = type;
        this.time = now;
        if (type == Type.GENERIC) {
            this.setVals(ptn, m, r);
        } else {
            this.setRegion(r);
            this.setMatch(m);
            this.setPattern(ptn);
        }
    }

    public String getType() {
        return this.type.toString();
    }

    public boolean isAppear() {
        return this.type == Type.APPEAR;
    }

    public boolean isVanish() {
        return this.type == Type.VANISH;
    }

    public boolean isChange() {
        return this.type == Type.CHANGE;
    }

    public boolean isGeneric() {
        return this.type == Type.GENERIC;
    }

    protected void setVals(Object v1, Object v2, Object v3) {
        this.vals[0] = v1;
        this.vals[1] = v2;
        this.vals[2] = v3;
    }

    public Object[] getVals() {
        return this.vals;
    }

    public String getName() {
        return this.name;
    }

    public Region getRegion() {
        return this.region;
    }

    protected void setRegion(Object r) {
        if (r instanceof Region) {
            this.region = (Region)r;
        }
    }

    public Match getMatch() {
        return this.match;
    }

    protected void setMatch(Object m) {
        if (null != m && m instanceof Match) {
            this.match = new Match((Match)m);
        }
    }

    protected void setIndex(int index) {
        this.index = index;
    }

    public List<Match> getChanges() {
        return this.changes;
    }

    protected void setChanges(List<Match> c) {
        if (c != null) {
            this.changes = new ArrayList<Match>();
            this.changes.addAll(c);
        }
    }

    public Pattern getPattern() {
        if (null != this.pattern) {
            if (this.pattern.getClass().isInstance("")) {
                return new Pattern((String)this.pattern);
            }
            return new Pattern((Pattern)this.pattern);
        }
        return null;
    }

    protected void setPattern(Object p) {
        if (null != p) {
            if (p.getClass().isInstance("")) {
                this.pattern = new Pattern((String)p);
            } else if (p instanceof Pattern) {
                this.pattern = new Pattern((Pattern)p);
            }
        }
    }

    public long getTime() {
        return this.time;
    }

    public void repeat() {
        this.repeat(0L);
    }

    public void repeat(long secs) {
        this.region.getObserver().repeat(this.name, secs);
    }

    public int getCount() {
        return this.region.getObserver().getCount(this.name);
    }

    public void stopObserver() {
        this.region.stopObserver();
    }

    public void stopObserver(String text) {
        this.region.stopObserver(text);
    }

    public String toString() {
        if (this.type == Type.CHANGE) {
            return String.format("Event(%s) %s on: %s with: %d count: %d", new Object[]{this.type, this.name, this.region, this.index, this.getCount()});
        }
        return String.format("Event(%s) %s on: %s with: %s\nmatch: %s count: %d", new Object[]{this.type, this.name, this.region, this.pattern, this.match, this.getCount()});
    }

    public static enum Type {
        APPEAR,
        VANISH,
        CHANGE,
        GENERIC;

    }
}

