# -*- coding: utf-8 -*-
#html代码相关的函数
import re
from HTMLParser import HTMLParser
from BeautifulSoup import BeautifulSoup, NavigableString

def strip_tags(html, valid_tags=[],remove_tags=['script','style'],clear_property_tags=[]):
    soup = BeautifulSoup(html)
    for tag in soup.findAll(True):
        if not tag.name in valid_tags:
            s = ""
            for c in tag.contents:
                c=unicode(c)
                if c:
                    if not isinstance(c, NavigableString):
                        c = strip_tags(c, valid_tags,remove_tags)
                    if not tag.name in remove_tags:
                        if tag.name in clear_property_tags:
                            s += u"<%s>%s</%s>"%(tag.name,c,tag.name)
                        else:
                            s += unicode(c)
            tag.replaceWith(s)
    return soup


def html2js(content,format='string'):
    '''将html代码转换成js代码'''
    import re

    tab = '    '
    format = 'array'

    html = content\
           .replace('\r', '')\
           .replace('\n', '')\
           .replace('"', r'\"')\
           .replace('\'', r'\'')

    return html


def filter_tags(htmlstr):
    #先过滤CDATA
    re_cdata=re.compile('//<!\[CDATA\[[^>]*//\]\]>',re.I) #匹配CDATA
    re_script=re.compile('<\s*script[^>]*>[^<]*<\s*/\s*script\s*>',re.I)#Script
    re_style=re.compile('<\s*style[^>]*>[^<]*<\s*/\s*style\s*>',re.I)#style
    re_br=re.compile('<br\s*?/?>')#处理换行
    re_h=re.compile('</?[\w+^(img)][^>]*>')#HTML标签
    re_comment=re.compile('<!--[^>]*-->')#HTML注释
    s=re_cdata.sub('',htmlstr)#去掉CDATA
    s=re_script.sub('',s) #去掉SCRIPT
    s=re_style.sub('',s)#去掉style
    s=re_br.sub('\n',s)#将br转换为换行
    s=re_h.sub('',s) #去掉HTML 标签
    s=re_comment.sub('',s)#去掉HTML注释
    #去掉多余的空行
    blank_line=re.compile('\n+')
    s=blank_line.sub('\n',s)
    return s




def get_image_urls(content):
    result = []
    '''得到html代码中的所有图片地址'''
    str=r'''<img\b[^<>]*?\bsrc[\s\t\r\n]*=[\s\t\r\n]*["']?[\s\t\r\n]*([^\s\t\r\n"'<>]*)[^<>]*?/?[\s\t\r\n]*>'''
    #str='src="(.*?)\.jpg"'
    reObj=re.compile(str,re.IGNORECASE)
    allMatch=reObj.findall(content)
    if allMatch:
        allMatch = [item for item in allMatch if item]
    return allMatch


if __name__ == '__main__':
    str =u'''
      <img src=""/> <section label="Copyright Reserved by PLAYHUDONG." donone="shifuMouseDownCard(&#39;shifu_c_008&#39;)" style="padding: 0.5em 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; border-style: none; background-color: rgb(235, 235, 235); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><p style="padding: 16px; min-height: 1em; line-height: normal; text-align: justify; max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><span style="margin-right: 5px; font-size: 3em; line-height: 1em; vertical-align: middle; text-align: center; color: rgb(136, 136, 136); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;">“</span><span style="color: rgb(136, 136, 136); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;">周一马云在川普大厦会面了全球最有权势的人物之一——特朗普，马云成为特朗普当选以来第一个会见的中国人，不是外交官，而是企业家，会后特朗普还在镜头前说“要跟马云干一番大事业”，难道单单马云一人就能平息一场贸易战？厉害了word 哥！</span><span style="margin-left: 5px; font-size: 3em; line-height: 1em; vertical-align: middle; text-align: center; color: rgb(136, 136, 136); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;">”</span></p></section><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><br style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"  /></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; text-align: justify; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><span style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;">据说，马云这次的会见也是有备而来，有外媒称，马云为了这场40分钟的会面可能精心准备了两个多月，而<strong style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;">他这次也似乎戳中了特朗普的兴奋点，着重谈他的电子商务平台将如何给美国带来100万的就业机会。</strong>而在特朗普获选之后的几个月里，马云对于特朗普的言论也一直是小心翼翼。</span><br style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"  /></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><br style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"  /></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; text-align: justify; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><span style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;">之前特朗普曾说过上任前谁也不见，但为什么这次就见了马云呢，有消息人士透露，<strong style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;">阿里总裁Michael Evans与特朗普有私交，可能是他促成了此次的会面。而这位阿里总裁也一直致力于促进全球全贸易以及推进中美友好。</strong></span></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><br style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"  /></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; text-align: justify; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><span style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;">就说这次会面，同样都是商人，马云的气场完全不压这位美国总统。网友们这次除了把关注点继续放在马云的英语和身高上，马云后面的保镖也都是各有来头，据说其中就有奥巴马的贴身皇家护卫。</span></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><br style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"  /></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; text-align: center; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><img class="" data-ratio="0.75" data-src="http://mmbiz.qpic.cn/mmbiz_jpg/iclicNt0yXupqyI1KIQ4IKWeTl9FPt7tBakIaVxabvcVa6MPdiaicTCybH2c256LHJX4OFvdL4ziaa3XLKQ2siaVnz0A/640?wx_fmt=jpeg" data-type="jpeg" data-w="640" style="box-sizing: border-box !important; word-wrap: break-word !important; width: auto !important; visibility: visible !important;" width="auto"></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><br style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"  /></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; text-align: justify; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><span style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;">在富丽堂皇的川普大厅里，特朗普还是用他一贯喜欢的词“Great”来形容这次会面，还说他要马云一起做一些“伟大”的事业（不过从手势看，不一定是这么回事）。</span></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><br style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"  /></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; text-align: justify; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><span style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;">尤其是在特朗普说“他很爱美国，也爱中国”时，马云赶紧纠正“我爱中国，也爱美国”。这似乎也证明马云是为了给中国带来利益才跟特朗普谈判的。</span></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><br style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"  /></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; text-align: center; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><img class="" data-ratio="0.8692307692307693" data-src="http://mmbiz.qpic.cn/mmbiz_png/iclicNt0yXupqyI1KIQ4IKWeTl9FPt7tBaXx8vZh9SaYKFr0KkicxRHFsQ85gxonZT9SIYzjfPvECcSybr26hMXSQ/640?wx_fmt=png" data-type="png" data-w="520" style="box-sizing: border-box !important; word-wrap: break-word !important; width: auto !important; visibility: visible !important;" width="auto"></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><br style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"  /></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; text-align: justify; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><span style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;">两人在镜头面前“亲切”交谈，马云在回答记者问题时，特朗普还“深情”地看着马云。</span></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><br style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"  /></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; text-align: center; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><img class="" data-ratio="0.5625" data-type="jpeg" data-w="640" width="auto" data-src="http://mmbiz.qpic.cn/mmbiz_jpg/iclicNt0yXupqyI1KIQ4IKWeTl9FPt7tBaCekYCnDTlpgV4mic276gVvH8DN5a33wb6uRuiaBlEaeDyGwSgk9DFLtA/640?" style="height: 360px !important; box-sizing: border-box !important; word-wrap: break-word !important; width: 640px !important; visibility: visible !important;"  /></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><br style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"  /></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; text-align: justify; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><span style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;">马云用着流利的英语说：“我们还认为，中美关系应该加强-应该更加友好，讨论两国关系和贸易问题的门已经打开，我认为当选总统是很聪明的，而且思想开通，会想听我意见。我表达了我对于改善贸易的一些看法，特别是中美双方的小型企业贸易…他也想到了这些问题，而且有了解决方案，他也是希望与中国沟通的，也希望和我们沟通合作。”</span></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><br style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"  /></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; text-align: justify; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><span style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;">其实不只马云，<strong style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;">全球很多大型企业的高管早就已经向特朗普贴上了“热脸”，</strong>比如日本科技巨头软银就宣布增加对美投资500亿美元，并承诺给美国创造5万个就业岗位。其它几个公司，从IMB到福特汽车公司，也宣布计划为美国带来就业，虽然其中一些计划在选举之前就已经定下来了。而丰田最近也决定向美国投资10亿美元。</span></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><br style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"  /></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; text-align: justify; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><span style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;">其实，软银的CEO孙正义也是阿里巴巴董事会成员，但目前还不清楚，这两者是否有关联。</span></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><br style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"  /></p><blockquote style="border-left-width: 5px; border-left-color: rgb(0, 147, 234); color: rgb(62, 62, 62); font-size: 16px; white-space: normal; line-height: 25.6px; font-family: Simsun; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><span style="color: rgb(0, 112, 192); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;">美国人：这是马云的套路</span></blockquote><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><br style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"  /></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; text-align: justify; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><strong style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;">两个都是生意人，没人会做亏本的买卖，那这次马云有足够本事说服特朗普吗？</strong></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><br style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"  /></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; text-align: justify; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><span style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;">说到这个，<strong style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;">就得先说说会谈的背景。</strong></span></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><br style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"  /></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; text-align: justify; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><strong style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;">阿里与美国监管层的恩恩怨怨</strong></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><br style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"  /></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; text-align: justify; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><span style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;">这场会面的发生正值中国与这位美国奇葩总统的关系趋于紧张之时，特朗普在竞选期间就一直拿中国拉票，说中国抢走了美国的就业，并扬言要对中国的出口贸易增收巨额关税，马云的电子商务帝国也同样面临着这类风险。</span></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><br style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"  /></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; text-align: justify; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><span style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;">另外，就在不久前，也就是特朗普当选之后，<strong style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;">阿里巴巴时隔四年再次被美国列入了“恶名市场”名单，</strong>这主要还是因为淘宝成为了假货的天堂，而再次列入这个名单，也表明阿里巴巴在打击假货方面做得远远不够。</span></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><br style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"  /></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; text-align: justify; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><span style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;">去年5月份，马云也去白宫和奥巴马共进了一次午餐，但最后还是难逃“恶名市场”名单的厄运。阿里巴巴表示，这主要可能是因为政治因素影响，但并没有直指是特朗普背后指使。</span></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><br style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"  /></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; text-align: center; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><img class="" data-ratio="0.771900826446281" data-type="jpeg" data-w="605" width="auto" data-src="http://mmbiz.qpic.cn/mmbiz_jpg/iclicNt0yXupqyI1KIQ4IKWeTl9FPt7tBazGtxxwBBCCebkdtia8wLDMUARTNwnvGwUue3RWdlrnbM0ZtH97eqNxg/640?" style="height: 467px !important; box-sizing: border-box !important; word-wrap: break-word !important; width: 605px !important; visibility: visible !important;"  /></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><br style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"  /></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; text-align: justify; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><span style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;">一直以来，<strong style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;">阿里就备受美国证监会的“关注”，</strong>尤其是其股票与两年钱达到的历史最高水平低20%的时候。阿里之所以被美国证监会盯上，一个是阿里本身存在的“会计操作问题”，二个就是虎视眈眈的华尔街空头一直抓住这个来说事。</span></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><br style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"  /></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; text-align: justify; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><span style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;">阿里巴巴的“会计操作问题”一直都是华尔街空头拿来做空的武器，这也反应了委员会对阿里使用非公认会计准则方法(non-GAAP)的持续关注。但是，也有外媒对此次调查表示了不公。金融博客网站Zerohedge就说过，“同样都是使用非公认会计准则，SEC对特斯拉没有问题，却偏偏看不惯阿里。”</span></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><br style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"  /></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; text-align: justify; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><strong style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;">所以，这次马云会面特朗普，估计也是想互相试探底线。</strong></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><br style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"  /></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; text-align: justify; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><strong style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;">那这次两个生意人的会面能碰撞出了怎样的火花呢？</strong></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><br style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"  /></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; text-align: justify; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><strong style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;">对于增加就业的方式，马云表示通过阿里巴巴这个平台可以在美国增加100万个中小型美国企业，估计每一个企业因为增加的商业应用而招聘一个新人，而这至少就是100万的就业机会。</strong></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><br style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"  /></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; text-align: justify; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><span style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;">受此消息影响，阿里巴巴的股价昨日上涨近1%，纽约市场收盘价为94.72美元。去年一年来，阿里的股价上涨了8%。</span></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><br style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"  /></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; text-align: justify; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><span style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;">然而，对于这次会面，有一个人可能就不高兴了，那就是亚马逊的创始人Jeff Bezos，此前，特朗普批评Bezos将旗下《华盛顿邮报》作为影响企业税收政策的工具，还说Bezos有垄断嫌疑，因为他“控制了太多”。</span></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><br style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"  /></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; text-align: justify; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><strong style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;">美国人并不买账</strong></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><br style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"  /></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; text-align: justify; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><strong style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;">很多美国人似乎并没有买马云的账，</strong><span style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;">有国外分析师表示，马云真正在美国创造100万个就业机会是不容易的。阿里在美国只是增加自身业务的投资，通过激励机制吸引美国中小企业上阿里的平台，最终目的还是希望在阿里的电商平台上增加美国品牌。</span></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><br style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"  /></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; text-align: justify; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><span style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;">阿里巴巴虽然作为中国最有价值的企业之一，市值高达2300亿美元，但是美国证监会数据显示，截至去年3月31日，阿里的全职员工有36446名，而这些员工几乎都来自中国。但是，基于平台上1000万个活跃卖家（截至2015年），阿里估计其平台帮助创造了1500万个就业机会。</span></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><br style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"  /></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; text-align: justify; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><span style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;">相比之下，美国此类电子商务平台比如亚马逊截至2015年年底的员工人数为230800人，尽管它也通过卖家、承包商和支持服务创造了其它工作岗位，但是就正式员工人数还是远远高于阿里。另外，就沃尔玛主要着重线下销售的企业来说，截至2016年年底，沃尔玛在全球雇佣的员工数量高达230万名，其中包括的美国员工就有150万名。</span></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><br style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"  /></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; text-align: justify; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><span style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;">更何况，美国本地很多卖家也可以用其它电子商务平台，比如亚马逊和eBay。</span></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><br style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"  /></p><blockquote style="border-left-width: 5px; border-left-color: rgb(0, 147, 234); color: rgb(62, 62, 62); font-size: 16px; white-space: normal; line-height: 25.6px; font-family: Simsun; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><span style="color: rgb(0, 112, 192); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;">马云的国际野心：一半收入要从老外身上赚！</span></blockquote><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><br style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"  /></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; text-align: justify; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><span style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;">很多人调侃马云可能是想“跑”了，但是不管怎样，<strong style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;">马云自知还是需要跟特朗普政府建立积极的工作关系，毕竟阿里巴巴的目标不仅仅是国内市场，其国际扩张计划也一直是他们努力的目标。</strong></span></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; text-align: justify; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><span style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><br style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"  /></span></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; text-align: justify; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><span style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;">面对国内市场的逐渐饱和，<strong style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;">马云在谈论阿里巴巴的长期目标时，表示会把美国的产品带到中国消费者的面前，他同时也表示希望公司的一半收入能够来自海外，从而抵消国内经济放缓的影响。</strong></span></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><br style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"  /></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; text-align: justify; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><strong style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;">阿里成功控制多数美国企业</strong></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><br style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"  /></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; text-align: justify; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><span style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;">阿里的业务其实很大一部分是于美国的贸易有关的，估计这也给与马云强大的动力，作为国内企业家的代表，与特朗普谈判，以避免特朗普政策计划对中国企业的一系列冲击。高关税自然会降低阿里国际网购平台AliExpress的需求。任何随之而来的贸易纠纷都会上海到阿里这类企业。去年，中国消费者就阿里平台上7000个美国品牌的消费高达150亿美元。</span></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><br style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"  /></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; text-align: center; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><img class="" data-ratio="0.6984375" data-src="http://mmbiz.qpic.cn/mmbiz_jpg/iclicNt0yXupqyI1KIQ4IKWeTl9FPt7tBasribsKrj2gibv4lTH0WNgFfF35heWyiaJW9oWSSorahdHjmrtjoexvbjA/640?wx_fmt=jpeg" data-type="jpeg" data-w="640" style="box-sizing: border-box !important; word-wrap: break-word !important; width: auto !important; visibility: visible !important;" width="auto"></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><br style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"  /></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; text-align: justify; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><strong style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;">阿里广泛的国际业务，从金融服务到电子商务再到物流业，已经成功控制了美国在中国的许多科技公司。EMarketer估计到2020年，中国跨境电子商务的销售额度将超过1500亿美元。</strong></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><br style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"  /></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; text-align: justify; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><span style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;">会后，阿里宣布“希望通过帮助美国小型企业和美国农民向3亿个中国中产阶级销售其产品而为美国带来就业机会。”</span></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><br style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"  /></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; text-align: justify; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><strong style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;">阿里的扩张将侧重于服装、葡萄酒和水果等产品，特别关注美国中西部和东南亚之间的小型企业贸易。</strong></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><br style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"  /></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; text-align: justify; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><span style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;">比如，在阿里国际零售平台上销售的美国产品就包括西北太平洋樱桃、华盛顿州苹果和阿拉斯加海鲜。</span></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><br style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"  /></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; text-align: justify; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><strong style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;">26亿美元私有化银泰商业</strong></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><br style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"  /></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; text-align: justify; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><span style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;">而就在周二，<strong style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;">阿里再次砸出重磅，表示正带头私有化银泰商业，其交易金额达26亿美元，去主要目的就是深化与中国实体店的融合。近年来，马云就已经收购或投资了一些实体零售店，以寻求超越传统网上业务。</strong></span></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><br style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"  /></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; text-align: justify; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><span style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;">比如，去年阿里以战略者身份认购三江购物，并一度引发市场爆炒。同时，还接受了永辉超市持有的联华超市的全部股份。</span></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><br style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"  /></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; text-align: justify; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><span style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;">而此次<strong style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;">阿里宣布私有化银滩的消息也刺激银泰商业大涨38%。</strong></span></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><br style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"  /></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; text-align: justify; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><span style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;">据报道，目前阿里巴巴持有银泰约28%权益。私有化完成后阿里巴巴将成为银泰的控股股东，持股比例预计增至约74%。<strong style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;">阿里本身就是银泰的大股东，那为何还要私有化银泰呢？</strong></span></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><br style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"  /></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; text-align: justify; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><span style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;">多家媒体引用了阿里首席执行官张勇的一段话，他表示，中国零售行业的总规模已达到4.5万亿美元，并正以每年10.7%的速度增长。阿里正与线下零售商共同重构传统业态，创新用户消费体验，用实际行动拥抱新零售所带来的长期发展机遇。</span></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><br style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"  /></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; text-align: justify; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><span style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;">另外，张勇认为，经济没有实体和虚拟之分，只有新旧之别。如果漠视机遇，那么就会不可避免被边缘甚至被淘汰。若能融合移动互联网、实时用户数据及科技的力量来提升运营效率，实体零售企业能够为消费者创造出全新的价值。</span></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><br style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"  /></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; text-align: justify; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><span style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;">可见，阿里正在砸钱实现传统网络零售的转型。</span></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><br style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"  /></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; text-align: justify; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><span style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;">马云能改变世界吗？我们拭目以待。</span></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><br style="max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"  /></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; font-family: &#39;Hiragino Sans GB&#39;, &#39;Microsoft YaHei&#39;, Arial, sans-serif; line-height: 25.6px; text-align: center; background-color: rgb(255, 255, 255); max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;"><img class="" data-ratio="0.5622641509433962" data-src="http://mmbiz.qpic.cn/mmbiz_jpg/iclicNt0yXupqyI1KIQ4IKWeTl9FPt7tBa5lwiaY1RdzqE0YjBMtwl1G7uicbP4LWhraAQBPqoRjwk9ic40Rdx9NDkQ/640?wx_fmt=jpeg" data-type="jpeg" data-w="530" style="box-sizing: border-box !important; word-wrap: break-word !important; width: auto !important; visibility: visible !important;" width="auto"></p><p style="min-height: 1em; color: rgb(62, 62, 62); font-size: 16px; white-space: normal; line-height: 25.6px; max-width: 100% !important; box-sizing: border-box !important; word-wrap: break-word !important;">来源：环球老虎财经、和讯网</p><p><img data-ratio="0.540625" data-src="http://mmbiz.qpic.cn/mmbiz/dBcnENosppR8mianX2VdchZRknNlBo1jgW3hB9YW25mJDsyGicg1eHKbRfQjbl8BVuxwmIKT6SMyic4LGwKJNIJdQ/640?wx_fmt=jpeg" data-type="jpeg" data-w="640" style="color: rgb(62, 62, 62); font-size: 16px; text-align: center; background-color: rgb(255, 255, 255); -webkit-text-stroke-color: rgb(0, 0, 0); white-space: pre-wrap; text-indent: 21px; font-family: 宋体; line-height: 1.6; box-sizing: border-box !important; word-wrap: break-word !important; width: auto !important; visibility: visible !important;" width="auto"></p>
                    </div>

     '''
    print('source=',str)

    data=strip_tags(str,valid_tags=['img','video'])
    print(repr(data))

    print(get_image_urls(content=str))
