# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class LabeledUtterance(Model):
    """A prediction and label pair of an example.

    :param id: ID of Labeled Utterance.
    :type id: int
    :param text: The utterance. For example, "What's the weather like in
     seattle?"
    :type text: str
    :param tokenized_text: The utterance tokenized.
    :type tokenized_text: list[str]
    :param intent_label: The intent matching the example.
    :type intent_label: str
    :param entity_labels: The entities matching the example.
    :type entity_labels:
     list[~azure.cognitiveservices.language.luis.authoring.models.EntityLabel]
    :param intent_predictions: List of suggested intents.
    :type intent_predictions:
     list[~azure.cognitiveservices.language.luis.authoring.models.IntentPrediction]
    :param entity_predictions: List of suggested entities.
    :type entity_predictions:
     list[~azure.cognitiveservices.language.luis.authoring.models.EntityPrediction]
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'int'},
        'text': {'key': 'text', 'type': 'str'},
        'tokenized_text': {'key': 'tokenizedText', 'type': '[str]'},
        'intent_label': {'key': 'intentLabel', 'type': 'str'},
        'entity_labels': {'key': 'entityLabels', 'type': '[EntityLabel]'},
        'intent_predictions': {'key': 'intentPredictions', 'type': '[IntentPrediction]'},
        'entity_predictions': {'key': 'entityPredictions', 'type': '[EntityPrediction]'},
    }

    def __init__(self, *, id: int=None, text: str=None, tokenized_text=None, intent_label: str=None, entity_labels=None, intent_predictions=None, entity_predictions=None, **kwargs) -> None:
        super(LabeledUtterance, self).__init__(**kwargs)
        self.id = id
        self.text = text
        self.tokenized_text = tokenized_text
        self.intent_label = intent_label
        self.entity_labels = entity_labels
        self.intent_predictions = intent_predictions
        self.entity_predictions = entity_predictions
