from pydentify import *

'''
This script shows you how to run a profile likelihood 
calculation using copasi and pydentify from the parameters
that were estimated and printed to a file

Optimizations were performed prior to writing this script using copasi. The file PE_results.xlsx 
holds this data.Parameter estimation data can come from any parameter estimation tool, 
not just copasi. Just be sure to keep variable names consistant. 

Parameter sets are automaticaly ranked with parameter set 0 being the parameter 
set with the lowest RSS. The MultiProfileLikelihood class takes parameters
from the PE_data.xlsx file and inserts them into copasi using the python
module 'insert_copasi_parameters'. You can calculate profile likelihoods around
as many parameter sets as you like by providing the corresponding index i.e.
range(3), range(5), [0,1,2,3,4,5,6] would calculate PLs around the top 4, top 6 and top 7
parameter sets respectively. In this script, we'll just do the top two parameters sets. 
'''

#replace with the vilar_fit path on your own machine. Note the r at the begining of the string to remove escape characters
copasi_file=r'D:\MPhil\Model_Building\Models\Exercises\pydentify_examples\Vilar2006\Vilar_example\ProfileLikelihoodFromParametersInFile\Vilar2006.cps'
#path to parameter estimation data
PE_data_file=r'D:\MPhil\Model_Building\Models\Exercises\pydentify_examples\Vilar2006\Vilar_example\ProfileLikelihoodFromParametersInFile\PE_Data.txt'

#initialize multiprofile likelihood class
#MPL=pydentify.MultiProfileLikelihood(copasi_file,[0,1],results_file=PE_data_file,lb=6,ub=6,intervals=11)

#MPL.run('slow')


#we now initialize an instance of the MultiPlot class
#Notice we already have the RSS value now from file and do not
# need to supply it manually. 
M=pydentify.MultiPlot(copasi_file,PE_data_file)
#you can plot the profiles of a single index, i.e. just the best or second best parameter set
#M.plot_index(0,savefig=True)
#or you can plot all indexes in one command
M.plot_all_indexes(savefig=True,axis_size=22,fontsize=28)
#The multiplot option allows multiple profiles from different indexes to be plotted on the same axis
#M.plot_all_indexes(savefig=True,multiplot=True,extra_title='multiplot')


#See documentation for other optional arguments















