/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public final class SortSpecifierContainer
implements Serializable {
    public static final SortSpecifierContainer EMPTY_CONTAINER = new SortSpecifierContainer();
    private final ArrayList<SortSpecifierItem> sortParameters;
    private static final long serialVersionUID = 85L;

    public SortSpecifierContainer() {
        this.sortParameters = new ArrayList();
    }

    public SortSpecifierContainer(int size) {
        this.sortParameters = new ArrayList(size);
    }

    public SortSpecifierContainer(String values) {
        this.sortParameters = new ArrayList();
        if (values != null && "".compareTo(values) != 0) {
            for (String s : values.split(";")) {
                String[] sortParam = s.split(",");
                this.add(sortParam[0], sortParam[1]);
            }
        }
    }

    public void add(String field, String order) {
        this.sortParameters.add(new SortSpecifierItem(field, order));
    }

    public List<SortSpecifierItem> getSortParameters() {
        return this.sortParameters;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int paddedSize = this.sortParameters.size() - 1;
        for (int i = 0; i < this.sortParameters.size(); ++i) {
            sb.append(this.sortParameters.get(i).toString());
            if (i >= paddedSize) continue;
            sb.append(";");
        }
        return sb.toString();
    }

    public final class SortSpecifierItem
    implements Serializable {
        private final String field;
        private final String order;
        private static final long serialVersionUID = 85L;

        SortSpecifierItem(String field, String order) {
            this.field = field;
            this.order = order;
        }

        public SortSpecifierItem() {
            this.field = "NOTSET";
            this.order = "ASCENDING";
        }

        public String toString() {
            return this.field + "," + this.order;
        }

        public String getField() {
            return this.field;
        }

        public String getOrder() {
            return this.order;
        }
    }
}

