# -*- coding: utf-8 -*-
from 臺灣言語工具.解析整理.拆文分析器 import 拆文分析器
import Pyro4
from 臺灣言語服務.HTS載入 import HTS載入
from 臺灣言語工具.解析整理.文章粗胚 import 文章粗胚
from 臺灣言語工具.基本物件.公用變數 import 無音


@Pyro4.expose
class HTS服務:

    def __init__(self):
        self.全部合成母語模型 = HTS載入.HTS模型()

    @Pyro4.expose
    def 支援腔口(self):
        return sorted(self.全部合成母語模型.keys())

    @Pyro4.expose
    def 語音合成實作(self, 查詢腔口, 查詢語句):
        '查詢語句是分詞格式'
        合成母語模型 = self.全部合成母語模型[查詢腔口]
        母語章物件 = (
            拆文分析器.分詞章物件(查詢語句)
            .轉音(合成母語模型['拼音'], 函式='音值')
        )
        try:
            音值物件 = 母語章物件.做(合成母語模型['音韻'], '套用')
        except:
            音值物件 = 母語章物件
        標仔陣列 = 合成母語模型['語音標仔轉換'].物件轉完整合成標仔(音值物件)
        愛合成標仔 = 合成母語模型['語音標仔轉換'].跳脫標仔陣列(標仔陣列)
        return 合成母語模型['模型'].合成(愛合成標仔).wav格式資料()

    @Pyro4.expose
    def 文本直接合成(self, 查詢腔口, 查詢語句):
        '查詢語句無限格式'
        合成母語模型 = self.全部合成母語模型[查詢腔口]

        if 合成母語模型['語族'] == '漢語':
            整理後語句 = 文章粗胚.數字英文中央全加分字符號(
                文章粗胚.建立物件語句前處理減號(合成母語模型['拼音'], 查詢語句)
            )
        else:
            整理後語句 = 文章粗胚.建立物件語句前減號變標點符號(查詢語句)

        母語章物件 = (
            拆文分析器.建立章物件(整理後語句)
            .轉音(合成母語模型['拼音'])
        )
        for 字物件 in 母語章物件.篩出字物件():
            if 字物件.音 == 無音:
                字物件.音 = 字物件.型
        音值章物件 = (
            母語章物件
            .轉音(合成母語模型['拼音'], 函式='音值')
        )
        try:
            音值物件 = 音值章物件.做(合成母語模型['音韻'], '套用')
        except:
            音值物件 = 音值章物件
        標仔陣列 = 合成母語模型['語音標仔轉換'].物件轉完整合成標仔(音值物件)
        愛合成標仔 = 合成母語模型['語音標仔轉換'].跳脫標仔陣列(標仔陣列)
        return 合成母語模型['模型'].合成(愛合成標仔).wav格式資料()
