import re

contractions_dict = { 
	"ain't": "am not",
	"aren't": "are not",
	"can't": "cannot",
	"can't've": "cannot have",
	"'cause": "because",
	"could've": "could have",
	"couldn't": "could not",
	"couldn't've": "could not have",
	"didn't": "did not",
	"doesn't": "does not",
	"don't": "do not",
	"hadn't": "had not",
	"hadn't've": "had not have",
	"hasn't": "has not",
	"haven't": "have not",
	"he'd": "he had",
	"he'd've": "he would have",
	"he'll": "he shall",
	"he'll've": "he shall have",
	"he's": "he has",
	"how'd": "how did",
	"how'd'y": "how do you",
	"how'll": "how will",
	"how's": "how has",
	"I'd": "I had",
	"I'd've": "I would have",
	"I'll": "I shall",
	"I'll've": "I shall have",
	"I'm": "I am",
	"I've": "I have",
	"isn't": "is not",
	"it'd": "it had",
	"it'd've": "it would have",
	"it'll": "it shall",
	"it'll've": "it shall have",
	"it's": "it has",
	"let's": "let us",
	"ma'am": "madam",
	"mayn't": "may not",
	"might've": "might have",
	"mightn't": "might not",
	"mightn't've": "might not have",
	"must've": "must have",
	"mustn't": "must not",
	"mustn't've": "must not have",
	"needn't": "need not",
	"needn't've": "need not have",
	"o'clock": "of the clock",
	"oughtn't": "ought not",
	"oughtn't've": "ought not have",
	"shan't": "shall not",
	"sha'n't": "shall not",
	"shan't've": "shall not have",
	"she'd": "she had",
	"she'd've": "she would have",
	"she'll": "she shall",
	"she'll've": "she shall have",
	"she's": "she has",
	"should've": "should have",
	"shouldn't": "should not",
	"shouldn't've": "should not have",
	"so've": "so have",
	"so's": "so as",
	"that'd": "that would",
	"that'd've": "that would have",
	"that's": "that has",
	"there'd": "there had",
	"there'd've": "there would have",
	"there's": "there has",
	"they'd": "they had",
	"they'd've": "they would have",
	"they'll": "they shall",
	"they'll've": "they shall have",
	"they're": "they are",
	"they've": "they have",
	"to've": "to have",
	"wasn't": "was not",
	"we'd": "we had",
	"we'd've": "we would have",
	"we'll": "we will",
	"we'll've": "we will have",
	"we're": "we are",
	"we've": "we have",
	"weren't": "were not",
	"what'll": "what shall",
	"what'll've": "what shall have",
	"what're": "what are",
	"what's": "what has",
	"what've": "what have",
	"when's": "when has",
	"when've": "when have",
	"where'd": "where did",
	"where's": "where has",
	"where've": "where have",
	"who'll": "who shall",
	"who'll've": "who shall have",
	"who's": "who has",
	"who've": "who have",
	"why's": "why has",
	"why've": "why have",
	"will've": "will have",
	"won't": "will not",
	"won't've": "will not have",
	"would've": "would have",
	"wouldn't": "would not",
	"wouldn't've": "would not have",
	"y'all": "you all",
	"y'all'd": "you all would",
	"y'all'd've": "you all would have",
	"y'all're": "you all are",
	"y'all've": "you all have",
	"you'd": "you had",
	"you'd've": "you would have",
	"you'll": "you shall",
	"you'll've": "you shall have",
	"you're": "you are",
	"you've": "you have"
}

contractions_regex = re.compile('(%s)' % '|'.join(contractions_dict.keys()))

def expand_contractions(s, contractions_dict=contractions_dict):
	def replace(match):
		return contractions_dict[match.group(0)]
	return contractions_regex.sub(replace, s)
