#!/usr/bin/env python
# -*- coding:latin1 -*-

import sys
import os
import os.path
import math
import wx
import wx.stc  as  stc
from numpy import arange, sin, pi, cos, isnan

import matplotlib
## matplotlib.interactive(True)
## matplotlib.use('WXAgg')
from matplotlib.backends.backend_wxagg import FigureCanvasWxAgg #as FigureCanvas
from matplotlib.figure import Figure
from matplotlib.backends.backend_wxagg import NavigationToolbar2Wx as Toolbar

## from matplotlib.backends.backend_wxagg import FigureCanvasWxAgg
## from matplotlib.figure import Figure

##------------- Fonts to be used.
if wx.Platform == '__WXMSW__':
    faces = { 'times': 'Times New Roman',
              'mono' : 'Courier New',
              'helv' : 'Arial',
              'other': 'Comic Sans MS',
              'size' : 10,
              'size2': 8,
             }
else:
    faces = { 'times': 'Times',
              'mono' : 'Courier',
              'helv' : 'Helvetica',
              'other': 'new century schoolbook',
              'size' : 12,
              'size2': 10,
             }

##------------- Editor class

class SDLeditor(stc.StyledTextCtrl):
    def __init__(self, parent, ID, log, pos=wx.DefaultPosition, size=wx.DefaultSize):
        stc.StyledTextCtrl.__init__(self, parent, ID, pos, size)
        self.log = log
        self.SetLexer(stc.STC_LEX_PYTHON)

        # Highlight tab/space mixing (shouldn't be any)
        self.SetProperty("tab.timmy.whinge.level", "1")

        # Set left and right margins
        self.SetMargins(2,2)

        # Indentation and tab stuff
        self.SetIndent(4)                # Proscribed indent size for wx
        self.SetIndentationGuides(False) # Show indent guides
        self.SetBackSpaceUnIndents(True) # Backspace unindents rather than delete 1 space
        self.SetTabIndents(True)         # Tab key indents
        self.SetTabWidth(4)              # Proscribed tab size for wx
        self.SetUseTabs(False)           # Use spaces rather than tabs, or
                                         # TabTimmy will complain!    
        # White space
        self.SetViewWhiteSpace(False)   # Don't view white space

        #self.SetBufferedDraw(False)
        #self.SetViewEOL(True)
        #self.SetEOLMode(stc.STC_EOL_CRLF)
        #self.SetUseAntiAliasing(True)
        
        # No right-edge mode indicator
        self.SetEdgeMode(stc.STC_EDGE_NONE)
        #self.SetEdgeMode(stc.STC_EDGE_BACKGROUND)
        #self.SetEdgeColumn(78)

        self.Bind(stc.EVT_STC_UPDATEUI, self.OnUpdateUI)
        #self.Bind(stc.EVT_STC_MARGINCLICK, self.OnMarginClick)
        #self.Bind(wx.EVT_KEY_DOWN, self.OnKeyPressed)
        self.Bind(stc.EVT_STC_DO_DROP, self.OnDoDrop)
        self.Bind(stc.EVT_STC_DRAG_OVER, self.OnDragOver)
        self.Bind(stc.EVT_STC_START_DRAG, self.OnStartDrag)

        # Make some styles,  The lexer defines what each style is used for, we
        # just have to define what each style looks like.  This set is adapted from
        # Scintilla sample property files.

        # Global default styles for all languages
        self.StyleSetSpec(stc.STC_STYLE_DEFAULT,  "face:%(mono)s,size:%(size)d" % faces)
        self.StyleClearAll()  # Reset all to be like the default

        # Line numbers in margin
        self.StyleSetSpec(wx.stc.STC_STYLE_LINENUMBER,'fore:#000000,back:#99A9C2')    
        # Highlighted brace
        self.StyleSetSpec(wx.stc.STC_STYLE_BRACELIGHT,'fore:#00009D,back:#FFFF00')
        # Unmatched brace
        self.StyleSetSpec(wx.stc.STC_STYLE_BRACEBAD,'fore:#00009D,back:#FF0000')
        # Indentation guide
        self.StyleSetSpec(wx.stc.STC_STYLE_INDENTGUIDE, "fore:#CDCDCD")

        self.StyleSetSpec(stc.STC_STYLE_DEFAULT,     "face:%(mono)s,size:%(size)d" % faces)
        self.StyleSetSpec(stc.STC_STYLE_CONTROLCHAR, "face:%(other)s" % faces)

        # Python styles
        # Default 
        self.StyleSetSpec(stc.STC_P_DEFAULT, "fore:#000000,face:%(mono)s,size:%(size)d" % faces)
        # Comments
        self.StyleSetSpec(stc.STC_P_COMMENTLINE, "fore:#7F7F7F,face:%(helv)s,size:%(size)d" % faces)
        # Number
        self.StyleSetSpec(stc.STC_P_NUMBER, "fore:#007F7F,size:%(size)d" % faces)
        # String
        self.StyleSetSpec(stc.STC_P_STRING, "fore:#7F007F,face:%(mono)s,size:%(size)d" % faces)
        # Single quoted string
        self.StyleSetSpec(stc.STC_P_CHARACTER, "fore:#7F007F,face:%(mono)s,size:%(size)d" % faces)
        # Keyword
        self.StyleSetSpec(stc.STC_P_WORD, "fore:#00007F,bold,size:%(size)d" % faces)
        # Triple quotes
        self.StyleSetSpec(stc.STC_P_TRIPLE, "fore:#7F0000,size:%(size)d" % faces)
        # Triple double quotes
        self.StyleSetSpec(stc.STC_P_TRIPLEDOUBLE, "fore:#7F0000,size:%(size)d" % faces)
        # Class name definition
        self.StyleSetSpec(stc.STC_P_CLASSNAME, "fore:#0000FF,bold,underline,size:%(size)d" % faces)
        # Function or method name definition
        self.StyleSetSpec(stc.STC_P_DEFNAME, "fore:#007F7F,bold,size:%(size)d" % faces)
        # Operators
        self.StyleSetSpec(stc.STC_P_OPERATOR, "bold,size:%(size)d" % faces)
        # Identifiers
        self.StyleSetSpec(stc.STC_P_IDENTIFIER, "fore:#000000,face:%(mono)s,size:%(size)d" % faces)
        # Comment-blocks
        self.StyleSetSpec(stc.STC_P_COMMENTBLOCK, "fore:#7F7F7F,size:%(size)d" % faces)
        # End of line where string is not closed
        self.StyleSetSpec(stc.STC_P_STRINGEOL, "fore:#000000,face:%(mono)s,back:#E0C0E0,eol,size:%(size)d" % faces)

        self.SetCaretForeground("BLUE")


    def OnDestroy(self, evt):
        # This is how the clipboard contents can be preserved after
        # the app has exited.
        wx.TheClipboard.Flush()
        evt.Skip()

    def IsModified(self):
        return self.GetModify()

    def IsSelecting(self):
        """Return true if text is selected and can be cut."""
        if self.GetSelectionStart() != self.GetSelectionEnd():
            return True
        else:
            return False

    def Clear(self):
        self.ClearAll()

    def SetInsertionPoint(self, pos):
        self.SetCurrentPos(pos)
        self.SetAnchor(pos)

    def ShowPosition(self, pos):
        line = self.LineFromPosition(pos)
        #self.EnsureVisible(line)
        self.GotoLine(line)

    def GetLastPosition(self):
        return self.GetLength()

    def GetPositionFromLine(self, line):
        return self.PositionFromLine(line)

    def GetRange(self, start, end):
        return self.GetTextRange(start, end)

    def GetSelection(self):
        return self.GetAnchor(), self.GetCurrentPos()

    def SetSelection(self, start, end):
        self.SetSelectionStart(start)
        self.SetSelectionEnd(end)

    def SelectLine(self, line):
        start = self.PositionFromLine(line)
        end = self.GetLineEndPosition(line)
        self.SetSelection(start, end)

    def OnUpdateUI(self, evt):
        # check for matching braces
        braceAtCaret = -1
        braceOpposite = -1
        charBefore = None
        caretPos = self.GetCurrentPos()

        if caretPos > 0:
            charBefore = self.GetCharAt(caretPos - 1)
            styleBefore = self.GetStyleAt(caretPos - 1)

        # check before
        if charBefore and chr(charBefore) in "[]{}()" and styleBefore == stc.STC_P_OPERATOR:
            braceAtCaret = caretPos - 1

        # check after
        if braceAtCaret < 0:
            charAfter = self.GetCharAt(caretPos)
            styleAfter = self.GetStyleAt(caretPos)

            if charAfter and chr(charAfter) in "[]{}()" and styleAfter == stc.STC_P_OPERATOR:
                braceAtCaret = caretPos

        if braceAtCaret >= 0:
            braceOpposite = self.BraceMatch(braceAtCaret)

        if braceAtCaret != -1  and braceOpposite == -1:
            self.BraceBadLight(braceAtCaret)
        else:
            self.BraceHighlight(braceAtCaret, braceOpposite)
            #pt = self.PointFromPosition(braceOpposite)
            #self.Refresh(True, wxRect(pt.x, pt.y, 5,5))
            #print pt
            #self.Refresh(False)
        self.log.updateButtons()


    def OnStartDrag(self, evt):
        #self.log.write("OnStartDrag: %d, %s\n"
        #               % (evt.GetDragAllowMove(), evt.GetDragText()))

        if debug and evt.GetPosition() < 250:
            evt.SetDragAllowMove(False)     # you can prevent moving of text (only copy)
            evt.SetDragText("DRAGGED TEXT") # you can change what is dragged
            #evt.SetDragText("")             # or prevent the drag with empty text


    def OnDragOver(self, evt):
        #self.log.write(
        #    "OnDragOver: x,y=(%d, %d)  pos: %d  DragResult: %d\n"
        #    % (evt.GetX(), evt.GetY(), evt.GetPosition(), evt.GetDragResult())
        #    )

        if debug and evt.GetPosition() < 250:
            evt.SetDragResult(wx.DragNone)   # prevent dropping at the beginning of the buffer


    def OnDoDrop(self, evt):
        #self.log.write("OnDoDrop: x,y=(%d, %d)  pos: %d  DragResult: %d\n"
        #               "\ttext: %s\n"
        #               % (evt.GetX(), evt.GetY(), evt.GetPosition(), evt.GetDragResult(),
        #                  evt.GetDragText()))

        if debug and evt.GetPosition() < 500:
            evt.SetDragText("DROPPED TEXT")  # Can change text if needed
            #evt.SetDragResult(wx.DragNone)  # Can also change the drag operation, but it
                                             # is probably better to do it in OnDragOver so
                                             # there is visual feedback

            #evt.SetPosition(25)             # Can also change position, but I'm not sure why
                                             # you would want to...

##------------- Supporting classes for a "no flicker"-wxPanel to draw matplotlib plots
#~ """
#~ A demonstration of creating a matlibplot window from within wx.
#~ A resize only causes a single redraw of the panel.
#~ The WXAgg backend is used as it is quicker.

#~ Edward Abraham, Datamine, April, 2006
#~ (works with wxPython 2.6.1, Matplotlib 0.87 and Python 2.4)
#~ """


class PlotPanel (wx.Panel):
    """The PlotPanel has a Figure and a Canvas. OnSize events simply set a 
flag, and the actual resizing of the figure is triggered by an Idle event."""
    def __init__( self, parent, color=None, dpi=None, **kwargs ):
        self.solver = None
        self.model = None

        # initialize Panel
        if 'id' not in kwargs.keys():
            kwargs['id'] = wx.ID_ANY
        if 'style' not in kwargs.keys():
            kwargs['style'] = wx.NO_FULL_REPAINT_ON_RESIZE
        wx.Panel.__init__( self, parent, **kwargs )

        # initialize matplotlib stuff
        self.figure = Figure( None, dpi )
        self.canvas = FigureCanvasWxAgg( self, -1, self.figure )
        self.SetColor( color )

        if 'size' in kwargs.keys():
            self.SetClientSize(kwargs['size'])
            self._resizeflag = True
        else:
            self._resizeflag = False
        self._SetSize()

        self.Bind(wx.EVT_IDLE, self._onIdle)
        self.Bind(wx.EVT_SIZE, self._onSize)

    def SetColor( self, rgbtuple=None ):
        """Set figure and canvas colours to be the same."""
        if rgbtuple is None:
            rgbtuple = wx.SystemSettings.GetColour( wx.SYS_COLOUR_BTNFACE ).Get()
        clr = [c/255. for c in rgbtuple]
        self.figure.set_facecolor( clr )
        self.figure.set_edgecolor( clr )
        self.canvas.SetBackgroundColour( wx.Colour( *rgbtuple ) )

    def _onSize( self, event ):
        self._resizeflag = True

    def _onIdle( self, evt ):
        if self._resizeflag:
            self._resizeflag = False
            self._SetSize()
            self.draw()

    def SetNeedsRepaint(self, needs = True):
        self._resizeflag = needs

    def _SetSize( self ):
        pixels = tuple( self.GetClientSize() )
        #pixels = tuple( self.parent.GetClientSize() )
        self.SetSize( pixels )
        self.canvas.SetSize( pixels )
        self.figure.set_size_inches( float( pixels[0] )/self.figure.get_dpi(),
                                     float( pixels[1] )/self.figure.get_dpi() )

    def draw(self): pass # abstract, to be overridden by child classes

class YetAnotherPlot(wx.Panel):
    def __init__(self, parent, id = -1, color=None, dpi = None, **kwargs):
        self.solver = None
        self.model = None
        # initialize Panel
        if 'id' not in kwargs.keys():
            kwargs['id'] = wx.ID_ANY
        if 'style' not in kwargs.keys():
            kwargs['style'] = wx.NO_FULL_REPAINT_ON_RESIZE
        wx.Panel.__init__( self, parent, **kwargs )

        self.figure = Figure( None, dpi )
        self.canvas = FigureCanvasWxAgg( self, -1, self.figure )

        if color:
            self.SetColor( color )

        self.toolbar = Toolbar(self.canvas)
        self.toolbar.Realize()

        sizer = wx.BoxSizer(wx.VERTICAL)
        sizer.Add(self.toolbar, 0 , wx.LEFT | wx.EXPAND)
        sizer.Add(self.canvas,1,wx.EXPAND)
        self.SetSizer(sizer)

    def draw(self):
        #self._SetSize()    #?????
        if self.solver:
            self.solver.optimum.plot(self.figure)

    def SetColor( self, rgbtuple=None ):
        """Set figure and canvas colours to be the same."""
        if rgbtuple is None:
            rgbtuple = wx.SystemSettings.GetColour( wx.SYS_COLOUR_BTNFACE ).Get()
        clr = [c/255. for c in rgbtuple]
        self.figure.set_facecolor( clr )
        self.figure.set_edgecolor( clr )
        self.canvas.SetBackgroundColour( wx.Colour( *rgbtuple ) )

    def OnSize(self, event):
        event.Skip()
        wx.CallAfter(self.ResizeCanvas)

    def ResizeCanvas(self):
        size = self.parent.GetClientSize()
        self.figure.set_figwidth(size[0]/(1.0*self.fig.get_dpi()))
        self.figure.set_figheight(size[1]/(1.0*self.fig.get_dpi()))
        self.canvas.resize(size[0],size[1])
        self.canvas.draw() 

def newDemoFigure():
    figure = Figure()
    subplot = figure.add_subplot(111)
    theta = arange(0, 45*2*pi, 0.02)
    rad = (0.8*theta/(2*pi)+1)
    r = rad*(8 + sin(theta*7+rad/1.8))
    x = r*cos(theta)
    y = r*sin(theta)
    #Now draw it
    subplot.plot(x,y, '-b')
    #Set some plot attributes
    #self.subplot.set_title("A polar flower (%s points)" % len(x), fontsize = 12)
    subplot.set_title("Flower plot")
    subplot.set_xlabel("Flower is from  http://www.physics.emory.edu/~weeks/ideas/rose.html")
    subplot.set_xlim([-400, 400])
    subplot.set_ylim([-400, 400])
    return figure

def newFigure():
    figure = Figure()
    return figure
    
class PlotPanelFromFigure(wx.Panel):
    def __init__(self, parent, figure, id = -1, color=None, dpi = None, **kwargs):
        self.figure = figure
        # initialize Panel
        if 'id' not in kwargs.keys():
            kwargs['id'] = wx.ID_ANY
        if 'style' not in kwargs.keys():
            kwargs['style'] = wx.NO_FULL_REPAINT_ON_RESIZE
        wx.Panel.__init__( self, parent, **kwargs )

##         self.figure = newDemoFigure()
##         self.figure = Figure( None, dpi )
        self.canvas = FigureCanvasWxAgg( self, -1, self.figure )

        if color:
            self.SetColor( color )

        self.toolbar = Toolbar(self.canvas)
        self.toolbar.Realize()

        sizer = wx.BoxSizer(wx.VERTICAL)
        sizer.Add(self.toolbar, 0 , wx.LEFT | wx.EXPAND)
        sizer.Add(self.canvas,1,wx.EXPAND)
        self.SetSizer(sizer)

    def SetColor( self, rgbtuple=None ):
        """Set figure and canvas colours to be the same."""
        if rgbtuple is None:
            rgbtuple = wx.SystemSettings.GetColour( wx.SYS_COLOUR_BTNFACE ).Get()
        clr = [c/255. for c in rgbtuple]
        self.figure.set_facecolor( clr )
        self.figure.set_edgecolor( clr )
        self.canvas.SetBackgroundColour( wx.Colour( *rgbtuple ) )

    def OnSize(self, event):
        event.Skip()
        wx.CallAfter(self.ResizeCanvas)

    def ResizeCanvas(self):
        size = self.parent.GetClientSize()
        self.figure.set_figwidth(size[0]/(1.0*self.fig.get_dpi()))
        self.figure.set_figheight(size[1]/(1.0*self.fig.get_dpi()))
        self.canvas.resize(size[0],size[1])
        self.canvas.draw() 

class DemoPlotPanel(PlotPanel):
    """An example plotting panel. The only method that needs 
    overriding is the draw method"""
    def draw(self):
        #self._SetSize()    #?????
        if not hasattr(self, 'subplot'):
            self.subplot = self.figure.add_subplot(111)
        theta = arange(0, 45*2*pi, 0.02)
        rad = (0.8*theta/(2*pi)+1)
        r = rad*(8 + sin(theta*7+rad/1.8))
        x = r*cos(theta)
        y = r*sin(theta)
        #Now draw it
        self.subplot.plot(x,y, '-b')
        #Set some plot attributes
        #self.subplot.set_title("A polar flower (%s points)" % len(x), fontsize = 12)
        self.subplot.set_title("Flower plot")
        self.subplot.set_xlabel("Flower is from  http://www.physics.emory.edu/~weeks/ideas/rose.html")
        self.subplot.set_xlim([-400, 400])
        self.subplot.set_ylim([-400, 400])

class BestPlotPanel(PlotPanel):
    """Plots best data."""
    #TODO: implement graph settings
    def draw(self):
        #self._SetSize()    #?????
        if self.solver:
            self.solver.optimum.plot(self.figure)


##------------- Results Frame

class resultsFrame(wx.Frame):
    def __init__(self, *args, **kwds):
        kwds["style"] = wx.DEFAULT_FRAME_STYLE
        wx.Frame.__init__(self, *args, **kwds)

        self.notebook = wx.Notebook(self, -1, style=0)

        self.plotpanel = BestPlotPanel(self.notebook, color=[255.0]*3)
        
        self.notebook.AddPage(self.plotpanel, "Plots") 

        self.Bind(wx.EVT_CLOSE, self.OnCloseWindow)

        #self.MakeMenus()
        #self.MakeToolbar()

        #self.SetTitle("Results")
        self.SetSize((1024, 768))
        #self.SetBackgroundColour(wx.Colour(229, 229, 229))
        

##         # statusbar configuration
##         self.mainstatusbar = self.CreateStatusBar(1, wx.ST_SIZEGRIP)
##         self.mainstatusbar.SetStatusWidths([-1])
##         mainstatusbar_fields = ["Results frame"]
##         for i in range(len(mainstatusbar_fields)):
##             self.mainstatusbar.SetStatusText(mainstatusbar_fields[i], i)
##         #self.maintoolbar.Realize()


##------------- Initialization and __del__ functions

    def __del__(self):
        pass
    
    def loadBestData(self, model, solver):
        """Main initialization function.
        
        Should be called after __init__() but before Show()."""

        self.plotpanel.model = model
        self.plotpanel.solver = solver

        self.SetTitle("Results for %s" % model['title'])

##---------------- Event handlers

    def OnCloseWindow(self, event):
        self.Destroy()

    def OnExitMenu(self, event):
        self.Close()

# end of class resultsFrame

