import numpy as np
from math import pow

class griddingProtocol():
    def __init__(self):
        self.data = np.array
        self.data_piece = np.array
        self.weights = np.array
        self.traj_x = np.array
        self.traj_y = np.array
        self.traj = np.array
        self.kernel = np.array
        self.kernelWidth = 3
        self.overgridFactor = 1.5
        self.beta = 0
        self.kernelSamples = 200
        self.imageSize = np.array
        self.dim0 = 0
        self.dim0_oversampled = 0

    def check(self):
        if self.kernelWidth == 0:
            print("invalid")

        self.beta = np.pi*np.sqrt(pow(self.kernelWidth,2)/pow(self.overgridFactor,2)*pow((self.overgridFactor-0.5),2)-0.8 )
        self.kernel = np.kaiser(2*self.kernelSamples,self.beta)[-self.kernelSamples:]
        self.dim0 = len(self.traj)
        self.dim0_oversampled = round(self.dim0 * self.overgridFactor)

        if abs(np.amax(self.traj)) > 0.5:
            self.traj = self.traj/np.amax(self.traj)-0.5
            print("trajectory normalized")