#   Compatibility with python 3.x
from __future__ import print_function
from __future__ import unicode_literals

from BrukerDataSuperclass import BrukerDataSuperclass
from inout import readers
from tools import recos
import sys

class RawDataObject(BrukerDataSuperclass):
    def __init__(self, path):
        self.path = path

        self.Filespath.path_to_fid      = self.path+"/fid"
        self.Filespath.path_to_acqp     = self.path+"/acqp"
        self.Filespath.path_to_method   = self.path+"/method"
        self.Filespath.path_to_traj   = self.path+"/traj"

        readers.readBrukerParamFile2     (self.Filespath.path_to_method,   self)

        try:
            readers.readBrukerParamFile     (self.Filespath.path_to_acqp,   self)
        except:
            print("Failed to read acqp file, path: ",self.Filespath.path_to_acqp)
            sys.exit(1)
        try:
            readers.readBrukerParamFile    (self.Filespath.path_to_method, self)
        except:
            print("Failed to read method file, path: ",self.Filespath.path_to_method)
            sys.exit(1)
        try:
            readers.readBrukerFidFile       (self.Filespath.path_to_fid,    self)
        except:
            print("Failed to read fid file, path: ",self.Filespath.path_to_fid)
            sys.exit(1)
        try:
            readers.readBrukerTrajFile(self.Filespath.path_to_traj, self)
        except:
            pass

        self.fidMethodBasedReshape()

    def fidMethodBasedReshape(self):
        """
        Description
        -----------
        Call a particular function, according to the pulse program, to reshape fid data.
        If no function for handling of the fid of a given pulse program (sequence)
        is not specified, nothing happens.

        To add a new function for a certain sequence, just add an another elif line.

        Parameters
        ----------
        rawdataobject

        Returns
        -------

        -
        """

        method = self.acqp.PULPROG
        if method == 'UTE.ppg': readers.fidHandle_UTE(self)
        elif method == 'FAIR_RARE.ppg': readers.fidHandle_FAIR_RARE(self)
        elif method == 'DtiEpi.ppg' or method == 'EPI.ppg': readers.fidHandle_Epi(self)
        else: print('Function to reshape fid data of this sequence is not developed yet')
        return

    def reconstruct(self, **kwargs):
        """
        Description
        -----------
        Call a particular function, according to the pulse program, to reconstruct fid data.

        Parameters
        ----------
        rawdataobject

        Returns
        -------

        -
        """

        method = self.acqp.PULPROG
        if method == 'UTE.ppg': recos.uteReco(self, **kwargs)
        elif method == 'DtiEpi.ppg': recos.DtiEpiReco(self, **kwargs)
        elif method == 'EPI.ppg': recos.EpiReco(self, **kwargs)
        else: print('Reco for this sequence is not ready yet')
        return

    def export(self,attribute):

        names = eval('dir(' + 'self' +'.'+ str(attribute) + ')')

        for name in names:
            print(name, eval('getattr(' + 'self' +'.'+ str(attribute) + ',name)'))

        return