from BrukerDataSuperclass import BrukerDataSuperclass
from inout import readers
from datatypes.NiftiClass import NiftiObject
from inout import nifti

class ImageDataObject(BrukerDataSuperclass):
    def __init__(self, path):
        self.path = path

        print(path)

        self.Filespath.path_to_reco = self.path+"/reco"
        self.Filespath.path_to_visu = self.path+"/visu_pars"
        self.Filespath.path_to_2dseq = self.path+"/2dseq"

        readers.readBrukerParamFile(self.Filespath.path_to_reco,self)
        readers.readBrukerParamFile(self.Filespath.path_to_visu,self)
        readers.readBruker2dseq(self.Filespath.path_to_2dseq,self)

    def tonifiti(self,path):

        nii = NiftiObject(bruker=self)
        nifti.writeNifti(path, nii)

        return