# DeepSpeech Server

This is an http server that can be used to test the mozilla DeepSpeech project.
You need an environment with DeepSpeech and a model to run this server.

## Installation

You first need to install deepspeech. Depending on your system you can use the
CPU package:

    pip3 install deepspeech

Or the GPU package:

    pip3 install deepspeech-gpu

Then you can install the deepspeech server:

    python3 setup.py install   

The server is also available on pypi, so you can install it with pip:    

    pip3 install deepspeech-server


## Starting the server

    deepspeech-server --model [model file] --alphabet [alphabet file]

where [model file] is the protobuf model that was generated by deepspeech and
[alphabet file] is the alphabet dictionary. The dictionary file can be found in
the "data" directory of the DeepSpeech sources.

You can also use deepspeech without training a model yourself. Pre-trained
models are provided by Mozilla in the release page of the project (See the
download section at the bottom):

https://github.com/mozilla/DeepSpeech/releases


## Using the server

Inference on the model is done via http post requests. For example with the
following curl command:

     curl -X POST --data-binary @[myfile.wav] http://localhost:8000/stt
