from types import *

# regexp performed on all definition from Ian Stevens (http://www.assembla.com/wiki/show/pythonmagickwand)
# ^\w*\s=\_lib\.(\w*)$\n\w*\.restype\s=\s(.*)$\n\w*\.argtypes\s=\s(.*)$
# ('$1', $2, $3),

pixel = [
    ( 'PixelGetNextIteratorRow', POINTER( POINTER( PixelWand ) ), [POINTER( PixelIterator ), POINTER( c_ulong )] ),
    ( 'PixelGetPreviousIteratorRow', POINTER( POINTER( PixelWand ) ), [POINTER( PixelIterator ), POINTER( c_ulong )] ),
    ( 'ClearPixelIterator', None, [POINTER( PixelIterator )] ),
    ( 'PixelResetIterator', None, [POINTER( PixelIterator )] ),
    ( 'PixelSetFirstIteratorRow', None, [POINTER( PixelIterator )] ),
    ( 'PixelSetLastIteratorRow', None, [POINTER( PixelIterator )] ),
    ( 'PixelGetColorAsString', STRING, [POINTER( PixelWand )] ),
    ( 'PixelGetException', STRING, [POINTER( PixelWand ), POINTER( ExceptionType )] ),
    ( 'PixelGetAlpha', c_double, [POINTER( PixelWand )] ),
    ( 'PixelGetBlack', c_double, [POINTER( PixelWand )] ),
    ( 'PixelGetBlue', c_double, [POINTER( PixelWand )] ),
    ( 'PixelGetCyan', c_double, [POINTER( PixelWand )] ),
    ( 'PixelGetGreen', c_double, [POINTER( PixelWand )] ),
    ( 'PixelGetMagenta', c_double, [POINTER( PixelWand )] ),
    ( 'PixelGetOpacity', c_double, [POINTER( PixelWand )] ),
    ( 'PixelGetRed', c_double, [POINTER( PixelWand )] ),
    ( 'PixelGetYellow', c_double, [POINTER( PixelWand )] ),
    ( 'PixelGetIndex', IndexPacket, [POINTER( PixelWand )] ),
    ( 'IsPixelWand', MagickBooleanType, [POINTER( PixelWand )] ),
    ( 'IsPixelWandSimilar', MagickBooleanType, [POINTER( PixelWand ), POINTER( PixelWand ), c_double] ),
    ( 'PixelClearException', MagickBooleanType, [POINTER( PixelWand )] ),
    ( 'PixelSetColor', MagickBooleanType, [POINTER( PixelWand ), STRING] ),
    ( 'DestroyPixelWand', POINTER( PixelWand ), [POINTER( PixelWand )] ),
    ( 'DestroyPixelWands', POINTER( POINTER( PixelWand ) ), [POINTER( POINTER( PixelWand ) ), c_ulong] ),
    ( 'NewPixelWand', POINTER( PixelWand ), [] ),
    ( 'NewPixelWands', POINTER( POINTER( PixelWand ) ), [c_ulong] ),
    ( 'PixelGetAlphaQuantum', Quantum, [POINTER( PixelWand )] ),
    ( 'PixelGetBlackQuantum', Quantum, [POINTER( PixelWand )] ),
    ( 'PixelGetBlueQuantum', Quantum, [POINTER( PixelWand )] ),
    ( 'PixelGetCyanQuantum', Quantum, [POINTER( PixelWand )] ),
    ( 'PixelGetGreenQuantum', Quantum, [POINTER( PixelWand )] ),
    ( 'PixelGetMagentaQuantum', Quantum, [POINTER( PixelWand )] ),
    ( 'PixelGetOpacityQuantum', Quantum, [POINTER( PixelWand )] ),
    ( 'PixelGetRedQuantum', Quantum, [POINTER( PixelWand )] ),
    ( 'PixelGetYellowQuantum', Quantum, [POINTER( PixelWand )] ),
    ( 'PixelGetColorCount', c_ulong, [POINTER( PixelWand )] ),
    ( 'ClearPixelWand', None, [POINTER( PixelWand )] ),
    ( 'PixelGetMagickColor', None, [POINTER( PixelWand ), POINTER( MagickPixelPacket )] ),
    ( 'PixelGetQuantumColor', None, [POINTER( PixelWand ), POINTER( PixelPacket )] ),
    ( 'PixelSetAlpha', None, [POINTER( PixelWand ), c_double] ),
    ( 'PixelSetAlphaQuantum', None, [POINTER( PixelWand ), Quantum] ),
    ( 'PixelSetBlack', None, [POINTER( PixelWand ), c_double] ),
    ( 'PixelSetBlackQuantum', None, [POINTER( PixelWand ), Quantum] ),
    ( 'PixelSetBlue', None, [POINTER( PixelWand ), c_double] ),
    ( 'PixelSetBlueQuantum', None, [POINTER( PixelWand ), Quantum] ),
    ( 'PixelSetColorCount', None, [POINTER( PixelWand ), c_ulong] ),
    ( 'PixelSetCyan', None, [POINTER( PixelWand ), c_double] ),
    ( 'PixelSetCyanQuantum', None, [POINTER( PixelWand ), Quantum] ),
    ( 'PixelSetGreen', None, [POINTER( PixelWand ), c_double] ),
    ( 'PixelSetGreenQuantum', None, [POINTER( PixelWand ), Quantum] ),
    ( 'PixelSetIndex', None, [POINTER( PixelWand ), IndexPacket] ),
    ( 'PixelSetMagenta', None, [POINTER( PixelWand ), c_double] ),
    ( 'PixelSetMagentaQuantum', None, [POINTER( PixelWand ), Quantum] ),
    ( 'PixelSetOpacity', None, [POINTER( PixelWand ), c_double] ),
    ( 'PixelSetOpacityQuantum', None, [POINTER( PixelWand ), Quantum] ),
    ( 'PixelSetQuantumColor', None, [POINTER( PixelWand ), POINTER( PixelPacket )] ),
    ( 'PixelSetRed', None, [POINTER( PixelWand ), c_double] ),
    ( 'PixelSetRedQuantum', None, [POINTER( PixelWand ), Quantum] ),
    ( 'PixelSetYellow', None, [POINTER( PixelWand ), c_double] ),
    ( 'PixelSetYellowQuantum', None, [POINTER( PixelWand ), Quantum] )
     ]

image = [
    ( 'IsMagickWand', MagickBooleanType, [POINTER( MagickWand )] ),
    ( 'MagickGetException', STRING, [POINTER( MagickWand ), POINTER( ExceptionType )] ),
    ( 'MagickClearException', MagickBooleanType, [POINTER( MagickWand )] ),
    ( 'CloneMagickWand', POINTER( MagickWand ), [POINTER( MagickWand )] ),
    ( 'DestroyMagickWand', POINTER( MagickWand ), [POINTER( MagickWand )] ),
    ( 'NewMagickWand', POINTER( MagickWand ), [] ),
    ( 'NewMagickWandFromImage', POINTER( MagickWand ), [POINTER( Image )] ),
    ( 'ClearMagickWand', None, [POINTER( MagickWand )] ),
    ( 'MagickThumbnailImage', MagickBooleanType, [POINTER( MagickWand ), c_ulong, c_ulong] ),
    ( 'MagickGetImageChannelStatistics', POINTER( ChannelStatistics ), [POINTER( MagickWand )] ),
    ( 'MagickGetImageFilename', STRING, [POINTER( MagickWand )] ),
    ( 'MagickGetImageFormat', STRING, [POINTER( MagickWand )] ),
    ( 'MagickGetImageSignature', STRING, [POINTER( MagickWand )] ),
    ( 'MagickIdentifyImage', STRING, [POINTER( MagickWand )] ),
    ( 'MagickGetImageCompose', CompositeOperator, [POINTER( MagickWand )] ),
    ( 'MagickGetImageColorspace', ColorspaceType, [POINTER( MagickWand )] ),
    ( 'MagickGetImageCompression', CompressionType, [POINTER( MagickWand )] ),
    ( 'MagickGetImageDispose', DisposeType, [POINTER( MagickWand )] ),
    ( 'MagickGetImageGamma', c_double, [POINTER( MagickWand )] ),
    ( 'MagickGetImageTotalInkDensity', c_double, [POINTER( MagickWand )] ),
    ( 'GetImageFromMagickWand', POINTER( Image ), [POINTER( MagickWand )] ),
    ( 'MagickGetImageType', ImageType, [POINTER( MagickWand )] ),
    ( 'MagickGetImageInterlaceScheme', InterlaceType, [POINTER( MagickWand )] ),
    ( 'MagickAdaptiveThresholdImage', MagickBooleanType, [POINTER( MagickWand ), c_ulong, c_ulong, c_long] ),
    ( 'MagickAddImage', MagickBooleanType, [POINTER( MagickWand ), POINTER( MagickWand )] ),
    ( 'MagickAddNoiseImage', MagickBooleanType, [POINTER( MagickWand ), NoiseType] ),
    ( 'MagickAffineTransformImage', MagickBooleanType, [POINTER( MagickWand ), POINTER( DrawingWand )] ),
    ( 'MagickAnnotateImage', MagickBooleanType, [POINTER( MagickWand ), POINTER( DrawingWand ), c_double, c_double, c_double, STRING] ),
    ( 'MagickAnimateImages', MagickBooleanType, [POINTER( MagickWand ), STRING] ),
    ( 'MagickBlackThresholdImage', MagickBooleanType, [POINTER( MagickWand ), POINTER( PixelWand )] ),
    ( 'MagickBlurImage', MagickBooleanType, [POINTER( MagickWand ), c_double, c_double] ),
    ( 'MagickBlurImageChannel', MagickBooleanType, [POINTER( MagickWand ), ChannelType, c_double, c_double] ),
    ( 'MagickBorderImage', MagickBooleanType, [POINTER( MagickWand ), POINTER( PixelWand ), c_ulong, c_ulong] ),
    ( 'MagickCharcoalImage', MagickBooleanType, [POINTER( MagickWand ), c_double, c_double] ),
    ( 'MagickChopImage', MagickBooleanType, [POINTER( MagickWand ), c_ulong, c_ulong, c_long, c_long] ),
    ( 'MagickClipImage', MagickBooleanType, [POINTER( MagickWand )] ),
    ( 'MagickColorizeImage', MagickBooleanType, [POINTER( MagickWand ), POINTER( PixelWand ), POINTER( PixelWand )] ),
    ( 'MagickCommentImage', MagickBooleanType, [POINTER( MagickWand ), STRING] ),
    ( 'MagickCompositeImage', MagickBooleanType, [POINTER( MagickWand ), POINTER( MagickWand ), CompositeOperator, c_long, c_long] ),
    ( 'MagickConstituteImage', MagickBooleanType, [POINTER( MagickWand ), c_ulong, c_ulong, STRING, StorageType, c_void_p] ),
    ( 'MagickContrastImage', MagickBooleanType, [POINTER( MagickWand ), MagickBooleanType] ),
    ( 'MagickConvolveImage', MagickBooleanType, [POINTER( MagickWand ), c_ulong, POINTER( c_double )] ),
    ( 'MagickConvolveImageChannel', MagickBooleanType, [POINTER( MagickWand ), ChannelType, c_ulong, POINTER( c_double )] ),
    ( 'MagickCropImage', MagickBooleanType, [POINTER( MagickWand ), c_ulong, c_ulong, c_long, c_long] ),
    ( 'MagickCycleColormapImage', MagickBooleanType, [POINTER( MagickWand ), c_long] ),
    ( 'MagickDespeckleImage', MagickBooleanType, [POINTER( MagickWand )] ),
    ( 'MagickDisplayImage', MagickBooleanType, [POINTER( MagickWand ), STRING] ),
    ( 'MagickDisplayImages', MagickBooleanType, [POINTER( MagickWand ), STRING] ),
    ( 'MagickDrawImage', MagickBooleanType, [POINTER( MagickWand ), POINTER( DrawingWand )] ),
    ( 'MagickEdgeImage', MagickBooleanType, [POINTER( MagickWand ), c_double] ),
    ( 'MagickEmbossImage', MagickBooleanType, [POINTER( MagickWand ), c_double, c_double] ),
    ( 'MagickEnhanceImage', MagickBooleanType, [POINTER( MagickWand )] ),
    ( 'MagickEqualizeImage', MagickBooleanType, [POINTER( MagickWand )] ),
    ( 'MagickEvaluateImage', MagickBooleanType, [POINTER( MagickWand ), MagickEvaluateOperator, c_double] ),
    ( 'MagickEvaluateImageChannel', MagickBooleanType, [POINTER( MagickWand ), ChannelType, MagickEvaluateOperator, c_double] ),
    ( 'MagickFlipImage', MagickBooleanType, [POINTER( MagickWand )] ),
    ( 'MagickFlopImage', MagickBooleanType, [POINTER( MagickWand )] ),
    ( 'MagickFrameImage', MagickBooleanType, [POINTER( MagickWand ), POINTER( PixelWand ), c_ulong, c_ulong, c_long, c_long] ),
    ( 'MagickGammaImage', MagickBooleanType, [POINTER( MagickWand ), c_double] ),
    ( 'MagickGammaImageChannel', MagickBooleanType, [POINTER( MagickWand ), ChannelType, c_double] ),
    ( 'MagickGaussianBlurImage', MagickBooleanType, [POINTER( MagickWand ), c_double, c_double] ),
    ( 'MagickGaussianBlurImageChannel', MagickBooleanType, [POINTER( MagickWand ), ChannelType, c_double, c_double] ),
    ( 'MagickGetImageBackgroundColor', MagickBooleanType, [POINTER( MagickWand ), POINTER( PixelWand )] ),
    ( 'MagickGetImageBluePrimary', MagickBooleanType, [POINTER( MagickWand ), POINTER( c_double ), POINTER( c_double )] ),
    ( 'MagickGetImageBorderColor', MagickBooleanType, [POINTER( MagickWand ), POINTER( PixelWand )] ),
    ( 'MagickGetImageChannelDistortion', MagickBooleanType, [POINTER( MagickWand ), POINTER( MagickWand ), ChannelType, MetricType, POINTER( c_double )] ),
    ( 'MagickGetImageDistortion', MagickBooleanType, [POINTER( MagickWand ), POINTER( MagickWand ), MetricType, POINTER( c_double )] ),
    ( 'MagickGetImageChannelMean', MagickBooleanType, [POINTER( MagickWand ), ChannelType, POINTER( c_double ), POINTER( c_double )] ),
    ( 'MagickGetImageColormapColor', MagickBooleanType, [POINTER( MagickWand ), c_ulong, POINTER( PixelWand )] ),
    ( 'MagickGetImageGreenPrimary', MagickBooleanType, [POINTER( MagickWand ), POINTER( c_double ), POINTER( c_double )] ),
    ( 'MagickGetImageMatteColor', MagickBooleanType, [POINTER( MagickWand ), POINTER( PixelWand )] ),
    ( 'MagickGetImagePage', MagickBooleanType, [POINTER( MagickWand ), POINTER( c_ulong ), POINTER( c_ulong ), POINTER( c_long ), POINTER( c_long )] ),
    ( 'MagickGetImagePixelColor', MagickBooleanType, [POINTER( MagickWand ), c_long, c_long, POINTER( PixelWand )] ),
    ( 'MagickGetImagePixels', MagickBooleanType, [POINTER( MagickWand ), c_long, c_long, c_ulong, c_ulong, STRING, StorageType, c_void_p] ),
    ( 'MagickGetImageRedPrimary', MagickBooleanType, [POINTER( MagickWand ), POINTER( c_double ), POINTER( c_double )] ),
    ( 'MagickGetImageResolution', MagickBooleanType, [POINTER( MagickWand ), POINTER( c_double ), POINTER( c_double )] ),
    ( 'MagickGetImageWhitePoint', MagickBooleanType, [POINTER( MagickWand ), POINTER( c_double ), POINTER( c_double )] ),
    ( 'MagickHasNextImage', MagickBooleanType, [POINTER( MagickWand )] ),
    ( 'MagickHasPreviousImage', MagickBooleanType, [POINTER( MagickWand )] ),
    ( 'MagickImplodeImage', MagickBooleanType, [POINTER( MagickWand ), c_double] ),
    ( 'MagickLabelImage', MagickBooleanType, [POINTER( MagickWand ), STRING] ),
    ( 'MagickLevelImage', MagickBooleanType, [POINTER( MagickWand ), c_double, c_double, c_double] ),
    ( 'MagickLevelImageChannel', MagickBooleanType, [POINTER( MagickWand ), ChannelType, c_double, c_double, c_double] ),
    ( 'MagickMagnifyImage', MagickBooleanType, [POINTER( MagickWand )] ),
    ( 'MagickMapImage', MagickBooleanType, [POINTER( MagickWand ), POINTER( MagickWand ), MagickBooleanType] ),
    ( 'MagickMedianFilterImage', MagickBooleanType, [POINTER( MagickWand ), c_double] ),
    ( 'MagickMinifyImage', MagickBooleanType, [POINTER( MagickWand )] ),
    ( 'MagickModulateImage', MagickBooleanType, [POINTER( MagickWand ), c_double, c_double, c_double] ),
    ( 'MagickMotionBlurImage', MagickBooleanType, [POINTER( MagickWand ), c_double, c_double, c_double] ),
    ( 'MagickNegateImage', MagickBooleanType, [POINTER( MagickWand ), MagickBooleanType] ),
    ( 'MagickNegateImageChannel', MagickBooleanType, [POINTER( MagickWand ), ChannelType, MagickBooleanType] ),
    ( 'MagickNewImage', MagickBooleanType, [POINTER( MagickWand ), c_ulong, c_ulong, POINTER( PixelWand )] ),
    ( 'MagickNextImage', MagickBooleanType, [POINTER( MagickWand )] ),
    ( 'MagickNormalizeImage', MagickBooleanType, [POINTER( MagickWand )] ),
    ( 'MagickOilPaintImage', MagickBooleanType, [POINTER( MagickWand ), c_double] ),
    ( 'MagickPingImage', MagickBooleanType, [POINTER( MagickWand ), STRING] ),
    ( 'MagickPosterizeImage', MagickBooleanType, [POINTER( MagickWand ), c_ulong, MagickBooleanType] ),
    ( 'MagickPreviousImage', MagickBooleanType, [POINTER( MagickWand )] ),
    ( 'MagickQuantizeImage', MagickBooleanType, [POINTER( MagickWand ), c_ulong, ColorspaceType, c_ulong, MagickBooleanType, MagickBooleanType] ),
    ( 'MagickQuantizeImages', MagickBooleanType, [POINTER( MagickWand ), c_ulong, ColorspaceType, c_ulong, MagickBooleanType, MagickBooleanType] ),
    ( 'MagickRadialBlurImage', MagickBooleanType, [POINTER( MagickWand ), c_double] ),
    ( 'MagickRadialBlurImageChannel', MagickBooleanType, [POINTER( MagickWand ), ChannelType, c_double] ),
    ( 'MagickRaiseImage', MagickBooleanType, [POINTER( MagickWand ), c_ulong, c_ulong, c_long, c_long, MagickBooleanType] ),
    ( 'MagickReadImage', MagickBooleanType, [POINTER( MagickWand ), STRING] ),
    ( 'MagickReadImageBlob', MagickBooleanType, [POINTER( MagickWand ), c_void_p, size_t] ),
    ( 'MagickReadImageFile', MagickBooleanType, [POINTER( MagickWand ), POINTER( FILE )] ),
    ( 'MagickReduceNoiseImage', MagickBooleanType, [POINTER( MagickWand ), c_double] ),
    ( 'MagickRemoveImage', MagickBooleanType, [POINTER( MagickWand )] ),
    ( 'MagickResampleImage', MagickBooleanType, [POINTER( MagickWand ), c_double, c_double, FilterTypes, c_double] ),
    ( 'MagickResizeImage', MagickBooleanType, [POINTER( MagickWand ), c_ulong, c_ulong, FilterTypes, c_double] ),
    ( 'MagickRollImage', MagickBooleanType, [POINTER( MagickWand ), c_long, c_long] ),
    ( 'MagickRotateImage', MagickBooleanType, [POINTER( MagickWand ), POINTER( PixelWand ), c_double] ),
    ( 'MagickSampleImage', MagickBooleanType, [POINTER( MagickWand ), c_ulong, c_ulong] ),
    ( 'MagickScaleImage', MagickBooleanType, [POINTER( MagickWand ), c_ulong, c_ulong] ),
    ( 'MagickSeparateImageChannel', MagickBooleanType, [POINTER( MagickWand ), ChannelType] ),
    ( 'MagickSepiaToneImage', MagickBooleanType, [POINTER( MagickWand ), c_double] ),
    ( 'MagickSetImage', MagickBooleanType, [POINTER( MagickWand ), POINTER( MagickWand )] ),
    ( 'MagickSetImageBackgroundColor', MagickBooleanType, [POINTER( MagickWand ), POINTER( PixelWand )] ),
    ( 'MagickSetImageBias', MagickBooleanType, [POINTER( MagickWand ), c_double] ),
    ( 'MagickSetImageBluePrimary', MagickBooleanType, [POINTER( MagickWand ), c_double, c_double] ),
    ( 'MagickSetImageBorderColor', MagickBooleanType, [POINTER( MagickWand ), POINTER( PixelWand )] ),
    ( 'MagickSetImageChannelDepth', MagickBooleanType, [POINTER( MagickWand ), ChannelType, c_ulong] ),
    ( 'MagickSetImageColormapColor', MagickBooleanType, [POINTER( MagickWand ), c_ulong, POINTER( PixelWand )] ),
    ( 'MagickSetImageCompose', MagickBooleanType, [POINTER( MagickWand ), CompositeOperator] ),
    ( 'MagickSetImageCompression', MagickBooleanType, [POINTER( MagickWand ), CompressionType] ),
    ( 'MagickSetImageDelay', MagickBooleanType, [POINTER( MagickWand ), c_ulong] ),
    ( 'MagickSetImageDepth', MagickBooleanType, [POINTER( MagickWand ), c_ulong] ),
    ( 'MagickSetImageDispose', MagickBooleanType, [POINTER( MagickWand ), DisposeType] ),
    ( 'MagickSetImageColorspace', MagickBooleanType, [POINTER( MagickWand ), ColorspaceType] ),
    ( 'MagickSetImageCompressionQuality', MagickBooleanType, [POINTER( MagickWand ), c_ulong] ),
    ( 'MagickSetImageGreenPrimary', MagickBooleanType, [POINTER( MagickWand ), c_double, c_double] ),
    ( 'MagickSetImageGamma', MagickBooleanType, [POINTER( MagickWand ), c_double] ),
    ( 'MagickSetImageExtent', MagickBooleanType, [POINTER( MagickWand ), c_ulong, c_ulong] ),
    ( 'MagickSetImageFilename', MagickBooleanType, [POINTER( MagickWand ), STRING] ),
    ( 'MagickSetImageFormat', MagickBooleanType, [POINTER( MagickWand ), STRING] ),
    ( 'MagickSetImageInterlaceScheme', MagickBooleanType, [POINTER( MagickWand ), InterlaceType] ),
    ( 'MagickSetImageIterations', MagickBooleanType, [POINTER( MagickWand ), c_ulong] ),
    ( 'MagickSetImageMatteColor', MagickBooleanType, [POINTER( MagickWand ), POINTER( PixelWand )] ),
    ( 'MagickSetImagePage', MagickBooleanType, [POINTER( MagickWand ), c_ulong, c_ulong, c_long, c_long] ),
    ( 'MagickSetImagePixels', MagickBooleanType, [POINTER( MagickWand ), c_long, c_long, c_ulong, c_ulong, STRING, StorageType, c_void_p] ),
    ( 'MagickSetImageRedPrimary', MagickBooleanType, [POINTER( MagickWand ), c_double, c_double] ),
    ( 'MagickSetImageRenderingIntent', MagickBooleanType, [POINTER( MagickWand ), RenderingIntent] ),
    ( 'MagickSetImageResolution', MagickBooleanType, [POINTER( MagickWand ), c_double, c_double] ),
    ( 'MagickSetImageScene', MagickBooleanType, [POINTER( MagickWand ), c_ulong] ),
    ( 'MagickSetImageTicksPerSecond', MagickBooleanType, [POINTER( MagickWand ), c_long] ),
    ( 'MagickSetImageType', MagickBooleanType, [POINTER( MagickWand ), ImageType] ),
    ( 'MagickSetImageUnits', MagickBooleanType, [POINTER( MagickWand ), ResolutionType] ),
    ( 'MagickSetImageWhitePoint', MagickBooleanType, [POINTER( MagickWand ), c_double, c_double] ),
    ( 'MagickShadowImage', MagickBooleanType, [POINTER( MagickWand ), c_double, c_double, c_long, c_long] ),
    ( 'MagickSharpenImage', MagickBooleanType, [POINTER( MagickWand ), c_double, c_double] ),
    ( 'MagickSharpenImageChannel', MagickBooleanType, [POINTER( MagickWand ), ChannelType, c_double, c_double] ),
    ( 'MagickShaveImage', MagickBooleanType, [POINTER( MagickWand ), c_ulong, c_ulong] ),
    ( 'MagickShearImage', MagickBooleanType, [POINTER( MagickWand ), POINTER( PixelWand ), c_double, c_double] ),
    ( 'MagickSigmoidalContrastImage', MagickBooleanType, [POINTER( MagickWand ), MagickBooleanType, c_double, c_double] ),
    ( 'MagickSigmoidalContrastImageChannel', MagickBooleanType, [POINTER( MagickWand ), ChannelType, MagickBooleanType, c_double, c_double] ),
    ( 'MagickSolarizeImage', MagickBooleanType, [POINTER( MagickWand ), c_double] ),
    ( 'MagickSpliceImage', MagickBooleanType, [POINTER( MagickWand ), c_ulong, c_ulong, c_long, c_long] ),
    ( 'MagickSpreadImage', MagickBooleanType, [POINTER( MagickWand ), c_double] ),
    ( 'MagickStripImage', MagickBooleanType, [POINTER( MagickWand )] ),
    ( 'MagickSwirlImage', MagickBooleanType, [POINTER( MagickWand ), c_double] ),
    ( 'MagickTintImage', MagickBooleanType, [POINTER( MagickWand ), POINTER( PixelWand ), POINTER( PixelWand )] ),
    ( 'MagickThresholdImage', MagickBooleanType, [POINTER( MagickWand ), c_double] ),
    ( 'MagickThresholdImageChannel', MagickBooleanType, [POINTER( MagickWand ), ChannelType, c_double] ),
    ( 'MagickThumbnailImage', MagickBooleanType, [POINTER( MagickWand ), c_ulong, c_ulong] ),
    ( 'MagickTrimImage', MagickBooleanType, [POINTER( MagickWand ), c_double] ),
    ( 'MagickUnsharpMaskImage', MagickBooleanType, [POINTER( MagickWand ), c_double, c_double, c_double, c_double] ),
    ( 'MagickUnsharpMaskImageChannel', MagickBooleanType, [POINTER( MagickWand ), ChannelType, c_double, c_double, c_double, c_double] ),
    ( 'MagickWaveImage', MagickBooleanType, [POINTER( MagickWand ), c_double, c_double] ),
    ( 'MagickWhiteThresholdImage', MagickBooleanType, [POINTER( MagickWand ), POINTER( PixelWand )] ),
    ( 'MagickWriteImage', MagickBooleanType, [POINTER( MagickWand ), STRING] ),
    ( 'MagickWriteImageFile', MagickBooleanType, [POINTER( MagickWand ), POINTER( FILE )] ),
    ( 'MagickWriteImages', MagickBooleanType, [POINTER( MagickWand ), STRING, MagickBooleanType] ),
    ( 'MagickWriteImagesFile', MagickBooleanType, [POINTER( MagickWand ), POINTER( FILE )] ),
    ( 'MagickSetImageProgressMonitor', MagickProgressMonitor, [POINTER( MagickWand ), MagickProgressMonitor, c_void_p] ),
    ( 'MagickAppendImages', POINTER( MagickWand ), [POINTER( MagickWand ), MagickBooleanType] ),
    ( 'MagickAverageImages', POINTER( MagickWand ), [POINTER( MagickWand )] ),
    ( 'MagickCoalesceImages', POINTER( MagickWand ), [POINTER( MagickWand )] ),
    ( 'MagickCombineImages', POINTER( MagickWand ), [POINTER( MagickWand ), ChannelType] ),
    ( 'MagickCompareImageChannels', POINTER( MagickWand ), [POINTER( MagickWand ), POINTER( MagickWand ), ChannelType, MetricType, POINTER( c_double )] ),
    ( 'MagickCompareImages', POINTER( MagickWand ), [POINTER( MagickWand ), POINTER( MagickWand ), MetricType, POINTER( c_double )] ),
    ( 'MagickDeconstructImages', POINTER( MagickWand ), [POINTER( MagickWand )] ),
    ( 'MagickFxImage', POINTER( MagickWand ), [POINTER( MagickWand ), STRING] ),
    ( 'MagickFxImageChannel', POINTER( MagickWand ), [POINTER( MagickWand ), ChannelType, STRING] ),
    ( 'MagickGetImage', POINTER( MagickWand ), [POINTER( MagickWand )] ),
    ( 'MagickGetImageRegion', POINTER( MagickWand ), [POINTER( MagickWand ), c_ulong, c_ulong, c_long, c_long] ),
    ( 'MagickMorphImages', POINTER( MagickWand ), [POINTER( MagickWand ), c_ulong] ),
    ( 'MagickMontageImage', POINTER( MagickWand ), [POINTER( MagickWand ), POINTER( DrawingWand ), STRING, STRING, MontageMode, STRING] ),
    ( 'MagickPreviewImages', POINTER( MagickWand ), [POINTER( MagickWand ), PreviewType] ),
    ( 'MagickSteganoImage', POINTER( MagickWand ), [POINTER( MagickWand ), POINTER( MagickWand ), c_long] ),
    ( 'MagickStereoImage', POINTER( MagickWand ), [POINTER( MagickWand ), POINTER( MagickWand )] ),
    ( 'MagickTextureImage', POINTER( MagickWand ), [POINTER( MagickWand ), POINTER( MagickWand )] ),
    ( 'MagickTransformImage', POINTER( MagickWand ), [POINTER( MagickWand ), STRING, STRING] ),
    ( 'MagickGetImageHistogram', POINTER( POINTER( PixelWand ) ), [POINTER( MagickWand ), POINTER( c_ulong )] ),
    ( 'MagickGetImageRenderingIntent', RenderingIntent, [POINTER( MagickWand )] ),
    ( 'MagickGetImageUnits', ResolutionType, [POINTER( MagickWand )] ),
    ( 'MagickGetImageBlob', POINTER( c_ubyte ), [POINTER( MagickWand ), POINTER( size_t )] ),
    ( 'MagickGetImagesBlob', POINTER( c_ubyte ), [POINTER( MagickWand ), POINTER( size_t )] ),
    ( 'MagickGetImageColors', c_ulong, [POINTER( MagickWand )] ),
    ( 'MagickGetImageCompressionQuality', c_ulong, [POINTER( MagickWand )] ),
    ( 'MagickGetImageDelay', c_ulong, [POINTER( MagickWand )] ),
    ( 'MagickGetImageChannelDepth', c_ulong, [POINTER( MagickWand ), ChannelType] ),
    ( 'MagickGetImageDepth', c_ulong, [POINTER( MagickWand )] ),
    ( 'MagickGetImageHeight', c_ulong, [POINTER( MagickWand )] ),
    ( 'MagickGetImageIterations', c_ulong, [POINTER( MagickWand )] ),
    ( 'MagickGetImageScene', c_ulong, [POINTER( MagickWand )] ),
    ( 'MagickGetImageTicksPerSecond', c_ulong, [POINTER( MagickWand )] ),
    ( 'MagickGetImageWidth', c_ulong, [POINTER( MagickWand )] ),
    ( 'MagickGetNumberImages', c_ulong, [POINTER( MagickWand )] ),
    ( 'MagickGetImageVirtualPixelMethod', VirtualPixelMethod, [POINTER( MagickWand )] ),
    ( 'MagickGetFilename', STRING, [POINTER( MagickWand )] ),
    ( 'MagickGetFormat', STRING, [POINTER( MagickWand )] ),
    ( 'MagickGetHomeURL', STRING, [] ),
    ( 'MagickGetOption', STRING, [POINTER( MagickWand ), STRING] ),
    ( 'MagickQueryConfigureOption', STRING, [STRING] ),
    ( 'MagickQueryConfigureOptions', POINTER( STRING ), [STRING, POINTER( c_ulong )] ),
    ( 'MagickQueryFonts', POINTER( STRING ), [STRING, POINTER( c_ulong )] ),
    ( 'MagickQueryFormats', POINTER( STRING ), [STRING, POINTER( c_ulong )] ),
    ( 'MagickGetCompression', CompressionType, [POINTER( MagickWand )] ),
    ( 'MagickGetCopyright', STRING, [] ),
    ( 'MagickGetPackageName', STRING, [] ),
    ( 'MagickGetQuantumDepth', STRING, [POINTER( c_ulong )] ),
    ( 'MagickGetQuantumRange', STRING, [POINTER( c_ulong )] ),
    ( 'MagickGetReleaseDate', STRING, [] ),
    ( 'MagickGetVersion', STRING, [POINTER( c_ulong )] ),
    ( 'MagickGetSamplingFactors', POINTER( c_double ), [POINTER( MagickWand ), POINTER( c_ulong )] ),
    ( 'MagickQueryFontMetrics', POINTER( c_double ), [POINTER( MagickWand ), POINTER( DrawingWand ), STRING] ),
    ( 'MagickQueryMultilineFontMetrics', POINTER( c_double ), [POINTER( MagickWand ), POINTER( DrawingWand ), STRING] ),
    ( 'MagickGetInterlaceScheme', InterlaceType, [POINTER( MagickWand )] ),
    ( 'MagickGetPage', MagickBooleanType, [POINTER( MagickWand ), POINTER( c_ulong ), POINTER( c_ulong ), POINTER( c_long ), POINTER( c_long )] ),
    ( 'MagickGetSize', MagickBooleanType, [POINTER( MagickWand ), POINTER( c_ulong ), POINTER( c_ulong )] ),
    ( 'MagickProfileImage', MagickBooleanType, [POINTER( MagickWand ), STRING, c_void_p, size_t] ),
    ( 'MagickSetBackgroundColor', MagickBooleanType, [POINTER( MagickWand ), POINTER( PixelWand )] ),
    ( 'MagickSetCompression', MagickBooleanType, [POINTER( MagickWand ), CompressionType] ),
    ( 'MagickSetCompressionQuality', MagickBooleanType, [POINTER( MagickWand ), c_ulong] ),
    ( 'MagickSetFilename', MagickBooleanType, [POINTER( MagickWand ), STRING] ),
    ( 'MagickSetFormat', MagickBooleanType, [POINTER( MagickWand ), STRING] ),
    ( 'MagickSetImageProfile', MagickBooleanType, [POINTER( MagickWand ), STRING, c_void_p, size_t] ),
    ( 'MagickSetImageAlphaChannel', MagickBooleanType, [POINTER( MagickWand ), MagickBooleanType] ),
    ( 'MagickSetInterlaceScheme', MagickBooleanType, [POINTER( MagickWand ), InterlaceType] ),
    ( 'MagickSetOption', MagickBooleanType, [POINTER( MagickWand ), STRING, STRING] ),
    ( 'MagickSetPage', MagickBooleanType, [POINTER( MagickWand ), c_ulong, c_ulong, c_long, c_long] ),
    ( 'MagickSetPassphrase', MagickBooleanType, [POINTER( MagickWand ), STRING] ),
    ( 'MagickSetResolution', MagickBooleanType, [POINTER( MagickWand ), c_double, c_double] ),
    ( 'MagickSetResourceLimit', MagickBooleanType, [ResourceType, MagickSizeType] ),
    ( 'MagickSetSamplingFactors', MagickBooleanType, [POINTER( MagickWand ), c_ulong, POINTER( c_double )] ),
    ( 'MagickSetSize', MagickBooleanType, [POINTER( MagickWand ), c_ulong, c_ulong] ),
    ( 'MagickSetType', MagickBooleanType, [POINTER( MagickWand ), ImageType] ),
    ( 'MagickSetProgressMonitor', MagickProgressMonitor, [POINTER( MagickWand ), MagickProgressMonitor, c_void_p] ),
    ( 'MagickGetImageProfile', POINTER( c_ubyte ), [POINTER( MagickWand ), STRING, POINTER( size_t )] ),
    ( 'MagickRemoveImageProfile', POINTER( c_ubyte ), [POINTER( MagickWand ), STRING, POINTER( size_t )] ),
    ( 'MagickGetCompressionQuality', c_ulong, [POINTER( MagickWand )] ),
    ( 'MagickGetResource', c_ulong, [ResourceType] ),
    ( 'MagickGetResourceLimit', c_ulong, [ResourceType] )]

all = [( 'AnimateImages', MagickBooleanType, [POINTER( ImageInfo ), POINTER( Image )] ),
( 'AnnotateImage', MagickBooleanType, [POINTER( Image ), POINTER( DrawInfo )] ),
( 'GetMultilineTypeMetrics', MagickBooleanType, [POINTER( Image ), POINTER( DrawInfo ), POINTER( TypeMetric )] ),
( 'GetTypeMetrics', MagickBooleanType, [POINTER( Image ), POINTER( DrawInfo ), POINTER( TypeMetric )] ),
( 'GetBlobFileHandle', POINTER( FILE ), [POINTER( Image )] ),
( 'BlobToImage', POINTER( Image ), [POINTER( ImageInfo ), c_void_p, size_t, POINTER( ExceptionInfo )] ),
( 'PingBlob', POINTER( Image ), [POINTER( ImageInfo ), c_void_p, size_t, POINTER( ExceptionInfo )] ),
( 'BlobToFile', MagickBooleanType, [STRING, c_void_p, size_t, POINTER( ExceptionInfo )] ),
( 'GetBlobError', MagickBooleanType, [POINTER( Image )] ),
( 'ImageToFile', MagickBooleanType, [POINTER( Image ), STRING, POINTER( ExceptionInfo )] ),
( 'IsBlobExempt', MagickBooleanType, [POINTER( Image )] ),
( 'IsBlobSeekable', MagickBooleanType, [POINTER( Image )] ),
( 'IsBlobTemporary', MagickBooleanType, [POINTER( Image )] ),
( 'GetBlobSize', MagickSizeType, [POINTER( Image )] ),
( 'GetBlobStreamHandler', StreamHandler, [POINTER( Image )] ),
( 'FileToBlob', POINTER( c_ubyte ), [STRING, size_t, POINTER( size_t ), POINTER( ExceptionInfo )] ),
( 'GetBlobStreamData', POINTER( c_ubyte ), [POINTER( Image )] ),
( 'ImageToBlob', POINTER( c_ubyte ), [POINTER( ImageInfo ), POINTER( Image ), POINTER( size_t ), POINTER( ExceptionInfo )] ),
( 'ImagesToBlob', POINTER( c_ubyte ), [POINTER( ImageInfo ), POINTER( Image ), POINTER( size_t ), POINTER( ExceptionInfo )] ),
( 'DestroyBlob', None, [POINTER( Image )] ),
( 'SetBlobExempt', None, [POINTER( Image ), MagickBooleanType] ),
( 'GetCacheViewIndexes', POINTER( IndexPacket ), [POINTER( ViewInfo )] ),
( 'SyncCacheView', MagickBooleanType, [POINTER( ViewInfo )] ),
( 'GetCacheViewPixels', POINTER( PixelPacket ), [POINTER( ViewInfo ), c_long, c_long, c_ulong, c_ulong] ),
# xxx: seems deprecated in 6.6.0
#SetCacheView = _lib_MagickCore.SetCacheView
#SetCacheView.restype = POINTER( PixelPacket )
#SetCacheView.argtypes = [POINTER( ViewInfo ), c_long, c_long, c_ulong, c_ulong]
( 'CloseCacheView', POINTER( ViewInfo ), [POINTER( ViewInfo )] ),
( 'OpenCacheView', POINTER( ViewInfo ), [POINTER( Image )] ),
#AcquireCacheNexus = _lib_MagickWand.AcquireCacheNexus
#AcquireCacheNexus.restype = POINTER( PixelPacket )
#AcquireCacheNexus.argtypes = [POINTER( Image ), VirtualPixelMethod, c_long, c_long, c_ulong, c_ulong, c_ulong, POINTER( ExceptionInfo )]
#GetPixelCacheArea = _lib_MagickWand.GetPixelCacheArea
#GetPixelCacheArea.restype = MagickSizeType
#GetPixelCacheArea.argtypes = [POINTER( Image )]
#PersistCache = _lib_MagickWand.PersistCache
#PersistCache.restype = MagickBooleanType
#PersistCache.argtypes = [POINTER( Image ), STRING, MagickBooleanType, POINTER( MagickOffsetType ), POINTER( ExceptionInfo )]
#SyncCacheNexus = _lib_MagickWand.SyncCacheNexus
#SyncCacheNexus.restype = MagickBooleanType
#SyncCacheNexus.argtypes = [POINTER( Image ), c_ulong]
#GetCacheNexus = _lib_MagickWand.GetCacheNexus
#GetCacheNexus.restype = POINTER( PixelPacket )
#GetCacheNexus.argtypes = [POINTER( Image ), c_long, c_long, c_ulong, c_ulong, c_ulong]
#SetCacheNexus = _lib_MagickWand.SetCacheNexus
#SetCacheNexus.restype = POINTER( PixelPacket )
#SetCacheNexus.argtypes = [POINTER( Image ), c_long, c_long, c_ulong, c_ulong, c_ulong]
( 'GetClientPath', STRING, [] ),
( 'GetClientName', STRING, [] ),
( 'SetClientName', STRING, [STRING] ),
( 'SetClientPath', STRING, [STRING] ),
( 'GetCoderList', POINTER( STRING ), [STRING, POINTER( c_ulong ), POINTER( ExceptionInfo )] ),
( 'GetCoderInfo', POINTER( CoderInfo ), [STRING, POINTER( ExceptionInfo )] ),
( 'GetCoderInfoList', POINTER( POINTER( CoderInfo ) ), [STRING, POINTER( c_ulong ), POINTER( ExceptionInfo )] ),
( 'ListCoderInfo', MagickBooleanType, [POINTER( FILE ), POINTER( ExceptionInfo )] ),
#DestroyCoderList = _lib_MagickWand.DestroyCoderList
#DestroyCoderList.restype = None
#DestroyCoderList.argtypes = []
( 'GetColorList', POINTER( STRING ), [STRING, POINTER( c_ulong ), POINTER( ExceptionInfo )] ),
( 'GetColorInfo', POINTER( ColorInfo ), [STRING, POINTER( ExceptionInfo )] ),
( 'GetColorInfoList', POINTER( POINTER( ColorInfo ) ), [STRING, POINTER( c_ulong ), POINTER( ExceptionInfo )] ),
( 'GetImageHistogram', POINTER( ColorPacket ), [POINTER( Image ), POINTER( c_ulong ), POINTER( ExceptionInfo )] ),
( 'IsGrayImage', MagickBooleanType, [POINTER( Image ), POINTER( ExceptionInfo )] ),
( 'IsMagickColorSimilar', MagickBooleanType, [POINTER( MagickPixelPacket ), POINTER( MagickPixelPacket )] ),
( 'IsMonochromeImage', MagickBooleanType, [POINTER( Image ), POINTER( ExceptionInfo )] ),
( 'IsOpaqueImage', MagickBooleanType, [POINTER( Image ), POINTER( ExceptionInfo )] ),
( 'IsPaletteImage', MagickBooleanType, [POINTER( Image ), POINTER( ExceptionInfo )] ),
( 'ListColorInfo', MagickBooleanType, [POINTER( FILE ), POINTER( ExceptionInfo )] ),
( 'QueryColorDatabase', MagickBooleanType, [STRING, POINTER( PixelPacket ), POINTER( ExceptionInfo )] ),
( 'QueryColorname', MagickBooleanType, [POINTER( Image ), POINTER( PixelPacket ), ComplianceType, STRING, POINTER( ExceptionInfo )] ),
( 'QueryMagickColor', MagickBooleanType, [STRING, POINTER( MagickPixelPacket ), POINTER( ExceptionInfo )] ),
( 'GetNumberColors', c_ulong, [POINTER( Image ), POINTER( FILE ), POINTER( ExceptionInfo )] ),
#DestroyColorList = _lib_MagickWand.DestroyColorList
#DestroyColorList.restype = None
#DestroyColorList.argtypes = []
( 'GetColorTuple', None, [POINTER( MagickPixelPacket ), MagickBooleanType, STRING] ),
( 'RGBTransformImage', MagickBooleanType, [POINTER( Image ), ColorspaceType] ),
( 'SetImageColorspace', MagickBooleanType, [POINTER( Image ), ColorspaceType] ),
( 'TransformRGBImage', MagickBooleanType, [POINTER( Image ), ColorspaceType] ),
( 'CompareImageChannels', POINTER( Image ), [POINTER( Image ), POINTER( Image ), ChannelType, MetricType, POINTER( c_double ), POINTER( ExceptionInfo )] ),
( 'CompareImages', POINTER( Image ), [POINTER( Image ), POINTER( Image ), MetricType, POINTER( c_double ), POINTER( ExceptionInfo )] ),
( 'GetImageChannelDistortion', MagickBooleanType, [POINTER( Image ), POINTER( Image ), ChannelType, MetricType, POINTER( c_double ), POINTER( ExceptionInfo )] ),
( 'GetImageDistortion', MagickBooleanType, [POINTER( Image ), POINTER( Image ), MetricType, POINTER( c_double ), POINTER( ExceptionInfo )] ),
( 'IsImagesEqual', MagickBooleanType, [POINTER( Image ), POINTER( Image )] ),
( 'CompositeImage', MagickBooleanType, [POINTER( Image ), CompositeOperator, POINTER( Image ), c_long, c_long] ),
( 'HuffmanDecodeImage', MagickBooleanType, [POINTER( Image )] ),
( 'HuffmanEncodeImage', MagickBooleanType, [POINTER( ImageInfo ), POINTER( Image )] ),
#Huffman2DEncodeImage = _lib_MagickWand.Huffman2DEncodeImage
#Huffman2DEncodeImage.restype = MagickBooleanType
#Huffman2DEncodeImage.argtypes = [POINTER( ImageInfo ), POINTER( Image )]
( 'LZWEncodeImage', MagickBooleanType, [POINTER( Image ), size_t, POINTER( c_ubyte )] ),
( 'PackbitsEncodeImage', MagickBooleanType, [POINTER( Image ), size_t, POINTER( c_ubyte )] ),
( 'ZLIBEncodeImage', MagickBooleanType, [POINTER( Image ), size_t, POINTER( c_ubyte )] ),
( 'Ascii85Encode', None, [POINTER( Image ), c_ubyte] ),
( 'Ascii85Flush', None, [POINTER( Image )] ),
( 'Ascii85Initialize', None, [POINTER( Image )] ),
( 'GetConfigureList', POINTER( STRING ), [STRING, POINTER( c_ulong ), POINTER( ExceptionInfo )] ),
( 'GetConfigureValue', STRING, [POINTER( ConfigureInfo )] ),
( 'GetConfigureInfo', POINTER( ConfigureInfo ), [STRING, POINTER( ExceptionInfo )] ),
( 'GetConfigureInfoList', POINTER( POINTER( ConfigureInfo ) ), [STRING, POINTER( c_ulong ), POINTER( ExceptionInfo )] ),
( 'DestroyConfigureOptions', POINTER( LinkedListInfo ), [POINTER( LinkedListInfo )] ),
( 'GetConfigurePaths', POINTER( LinkedListInfo ), [STRING, POINTER( ExceptionInfo )] ),
( 'GetConfigureOptions', POINTER( LinkedListInfo ), [STRING, POINTER( ExceptionInfo )] ),
( 'ListConfigureInfo', MagickBooleanType, [POINTER( FILE ), POINTER( ExceptionInfo )] ),
#DestroyConfigureList = _lib_MagickWand.DestroyConfigureList
#DestroyConfigureList.restype = None
#DestroyConfigureList.argtypes = []
( 'ConstituteImage', POINTER( Image ), [c_ulong, c_ulong, STRING, StorageType, c_void_p, POINTER( ExceptionInfo )] ),
( 'PingImage', POINTER( Image ), [POINTER( ImageInfo ), POINTER( ExceptionInfo )] ),
( 'ReadImage', POINTER( Image ), [POINTER( ImageInfo ), POINTER( ExceptionInfo )] ),
( 'ReadInlineImage', POINTER( Image ), [POINTER( ImageInfo ), STRING, POINTER( ExceptionInfo )] ),
( 'WriteImage', MagickBooleanType, [POINTER( ImageInfo ), POINTER( Image )] ),
( 'WriteImages', MagickBooleanType, [POINTER( ImageInfo ), POINTER( Image ), STRING, POINTER( ExceptionInfo )] ),
#DestroyConstitute = _lib_MagickWand.DestroyConstitute
#DestroyConstitute.restype = None
#DestroyConstitute.argtypes = []
( 'BorderImage', POINTER( Image ), [POINTER( Image ), POINTER( RectangleInfo ), POINTER( ExceptionInfo )] ),
( 'FrameImage', POINTER( Image ), [POINTER( Image ), POINTER( FrameInfo ), POINTER( ExceptionInfo )] ),
( 'RaiseImage', MagickBooleanType, [POINTER( Image ), POINTER( RectangleInfo ), MagickBooleanType] ),
( 'GetDelegateCommand', STRING, [POINTER( ImageInfo ), POINTER( Image ), STRING, STRING, POINTER( ExceptionInfo )] ),
( 'GetDelegateList', POINTER( STRING ), [STRING, POINTER( c_ulong ), POINTER( ExceptionInfo )] ),
( 'GetDelegateCommands', STRING, [POINTER( DelegateInfo )] ),
( 'GetDelegateInfo', POINTER( DelegateInfo ), [STRING, STRING, POINTER( ExceptionInfo )] ),
( 'GetDelegateInfoList', POINTER( POINTER( DelegateInfo ) ), [STRING, POINTER( c_ulong ), POINTER( ExceptionInfo )] ),
( 'GetDelegateMode', c_long, [POINTER( DelegateInfo )] ),
( 'InvokeDelegate', MagickBooleanType, [POINTER( ImageInfo ), POINTER( Image ), STRING, STRING, POINTER( ExceptionInfo )] ),
( 'ListDelegateInfo', MagickBooleanType, [POINTER( FILE ), POINTER( ExceptionInfo )] ),
#DestroyDelegateList = _lib_MagickWand.DestroyDelegateList
#DestroyDelegateList.restype = None
#DestroyDelegateList.argtypes = []
( 'AllocateString', STRING, [STRING] ),
( 'PostscriptGeometry', STRING, [STRING] ),
( 'TranslateText', STRING, [POINTER( ImageInfo ), POINTER( Image ), STRING] ),
( 'GetImageAttribute', POINTER( ImageAttribute ), [POINTER( Image ), STRING] ),
( 'GetImageClippingPathAttribute', POINTER( ImageAttribute ), [POINTER( Image )] ),
( 'GetNextImageAttribute', POINTER( ImageAttribute ), [POINTER( Image )] ),
( 'GetImageFromMagickRegistry', POINTER( Image ), [STRING, POINTER( c_long ), POINTER( ExceptionInfo )] ),
( 'GetImageList', POINTER( Image ), [POINTER( Image ), c_long, POINTER( ExceptionInfo )] ),
( 'GetNextImage', POINTER( Image ), [POINTER( Image )] ),
( 'GetPreviousImage', POINTER( Image ), [POINTER( Image )] ),
( 'FlattenImages', POINTER( Image ), [POINTER( Image ), POINTER( ExceptionInfo )] ),
( 'MosaicImages', POINTER( Image ), [POINTER( Image ), POINTER( ExceptionInfo )] ),
( 'PopImageList', POINTER( Image ), [POINTER( POINTER( Image ) )] ),
( 'ShiftImageList', POINTER( Image ), [POINTER( POINTER( Image ) )] ),
( 'SpliceImageList', POINTER( Image ), [POINTER( Image ), c_long, c_ulong, POINTER( Image ), POINTER( ExceptionInfo )] ),
( 'ValidateColormapIndex', IndexPacket, [POINTER( Image ), c_ulong] ),
( 'GetImageGeometry', c_int, [POINTER( Image ), STRING, c_uint, POINTER( RectangleInfo )] ),
( 'ParseImageGeometry', c_int, [STRING, POINTER( c_long ), POINTER( c_long ), POINTER( c_ulong ), POINTER( c_ulong )] ),
( 'GetImageListIndex', c_long, [POINTER( Image )] ),
( 'SetMagickRegistry', c_long, [RegistryType, c_void_p, size_t, POINTER( ExceptionInfo )] ),
( 'ClipPathImage', MagickBooleanType, [POINTER( Image ), STRING, MagickBooleanType] ),
( 'CloneImageAttributes', MagickBooleanType, [POINTER( Image ), POINTER( Image )] ),
( 'ColorFloodfillImage', MagickBooleanType, [POINTER( Image ), POINTER( DrawInfo ), PixelPacket, c_long, c_long, PaintMethod] ),
( 'DeleteImageAttribute', MagickBooleanType, [POINTER( Image ), STRING] ),
( 'DeleteMagickRegistry', MagickBooleanType, [c_long] ),
( 'DescribeImage', MagickBooleanType, [POINTER( Image ), POINTER( FILE ), MagickBooleanType] ),
( 'FormatImageAttribute', MagickBooleanType, [POINTER( Image ), STRING, STRING] ),
( 'FormatImageAttributeList', MagickBooleanType, [POINTER( Image ), STRING, STRING, va_list] ),
( 'FuzzyColorCompare', MagickBooleanType, [POINTER( Image ), POINTER( PixelPacket ), POINTER( PixelPacket )] ),
( 'FuzzyOpacityCompare', MagickBooleanType, [POINTER( Image ), POINTER( PixelPacket ), POINTER( PixelPacket )] ),
( 'MagickMonitor', MagickBooleanType, [STRING, MagickOffsetType, MagickSizeType, c_void_p] ),
( 'MatteFloodfillImage', MagickBooleanType, [POINTER( Image ), PixelPacket, Quantum, c_long, c_long, PaintMethod] ),
( 'OpaqueImage', MagickBooleanType, [POINTER( Image ), PixelPacket, PixelPacket] ),
( 'PaintOpaqueImage', MagickBooleanType, [POINTER( Image ), POINTER( MagickPixelPacket ), POINTER( MagickPixelPacket )] ),
( 'PaintTransparentImage', MagickBooleanType, [POINTER( Image ), POINTER( MagickPixelPacket ), Quantum] ),
( 'PopImagePixels', MagickBooleanType, [POINTER( Image ), QuantumType, POINTER( c_ubyte )] ),
( 'PushImagePixels', MagickBooleanType, [POINTER( Image ), QuantumType, POINTER( c_ubyte )] ),
( 'SetExceptionInfo', MagickBooleanType, [POINTER( ExceptionInfo ), ExceptionType] ),
( 'SetImageAttribute', MagickBooleanType, [POINTER( Image ), STRING, STRING] ),
( 'TransparentImage', MagickBooleanType, [POINTER( Image ), PixelPacket, Quantum] ),
( 'GetMonitorHandler', MonitorHandler, [] ),
( 'SetMonitorHandler', MonitorHandler, [MonitorHandler] ),
( 'SizeBlob', MagickOffsetType, [POINTER( Image )] ),
( 'GetCacheView', POINTER( PixelPacket ), [POINTER( ViewInfo ), c_long, c_long, c_ulong, c_ulong] ),
( 'ChannelImage', c_uint, [POINTER( Image ), ChannelType] ),
( 'ChannelThresholdImage', c_uint, [POINTER( Image ), STRING] ),
( 'DispatchImage', c_uint, [POINTER( Image ), c_long, c_long, c_ulong, c_ulong, STRING, StorageType, c_void_p, POINTER( ExceptionInfo )] ),
( 'FuzzyColorMatch', c_uint, [POINTER( PixelPacket ), POINTER( PixelPacket ), c_double] ),
( 'GetNumberScenes', c_uint, [POINTER( Image )] ),
( 'GetMagickGeometry', c_uint, [STRING, POINTER( c_long ), POINTER( c_long ), POINTER( c_ulong ), POINTER( c_ulong )] ),
( 'IsSubimage', c_uint, [STRING, c_uint] ),
( 'PushImageList', c_uint, [POINTER( POINTER( Image ) ), POINTER( Image ), POINTER( ExceptionInfo )] ),
( 'QuantizationError', c_uint, [POINTER( Image )] ),
( 'RandomChannelThresholdImage', c_uint, [POINTER( Image ), STRING, STRING, POINTER( ExceptionInfo )] ),
( 'SetImageList', c_uint, [POINTER( POINTER( Image ) ), POINTER( Image ), c_long, POINTER( ExceptionInfo )] ),
( 'TransformColorspace', c_uint, [POINTER( Image ), ColorspaceType] ),
( 'ThresholdImage', c_uint, [POINTER( Image ), c_double] ),
( 'ThresholdImageChannel', c_uint, [POINTER( Image ), STRING] ),
( 'UnshiftImageList', c_uint, [POINTER( POINTER( Image ) ), POINTER( Image ), POINTER( ExceptionInfo )] ),
( 'GetImageListSize', c_ulong, [POINTER( Image )] ),
( 'AcquireMemory', c_void_p, [size_t] ),
( 'CloneMemory', c_void_p, [c_void_p, c_void_p, size_t] ),
( 'DestroyImageAttributes', None, [POINTER( Image )] ),
( 'DestroyImages', None, [POINTER( Image )] ),
( 'DestroyMagick', None, [] ),
( 'DestroyMagickRegistry', None, [] ),
( 'GetConfigureBlob', c_void_p, [STRING, STRING, POINTER( size_t ), POINTER( ExceptionInfo )] ),
( 'GetMagickRegistry', c_void_p, [c_long, POINTER( RegistryType ), POINTER( size_t ), POINTER( ExceptionInfo )] ),
( 'IdentityAffine', None, [POINTER( AffineMatrix )] ),
( 'LiberateMemory', None, [POINTER( c_void_p )] ),
( 'LiberateSemaphoreInfo', None, [POINTER( POINTER( SemaphoreInfo ) )] ),
( 'FormatString', None, [STRING, STRING] ),
( 'FormatStringList', None, [STRING, STRING, va_list] ),
( 'InitializeMagick', None, [STRING] ),
( 'ReacquireMemory', None, [POINTER( c_void_p ), size_t] ),
( 'ResetImageAttributeIterator', None, [POINTER( Image )] ),
( 'SetCacheThreshold', None, [c_ulong] ),
( 'SetImage', None, [POINTER( Image ), Quantum] ),
( 'Strip', None, [STRING] ),
( 'TemporaryFilename', None, [STRING] ),
( 'DisplayImages', MagickBooleanType, [POINTER( ImageInfo ), POINTER( Image )] ),
( 'RemoteDisplayCommand', MagickBooleanType, [POINTER( ImageInfo ), STRING, STRING, POINTER( ExceptionInfo )] ),
( 'CloneDrawInfo', POINTER( DrawInfo ), [POINTER( ImageInfo ), POINTER( DrawInfo )] ),
( 'DestroyDrawInfo', POINTER( DrawInfo ), [POINTER( DrawInfo )] ),
( 'DrawAffineImage', MagickBooleanType, [POINTER( Image ), POINTER( Image ), POINTER( AffineMatrix )] ),
( 'DrawClipPath', MagickBooleanType, [POINTER( Image ), POINTER( DrawInfo ), STRING] ),
( 'DrawImage', MagickBooleanType, [POINTER( Image ), POINTER( DrawInfo )] ),
( 'DrawPatternPath', MagickBooleanType, [POINTER( Image ), POINTER( DrawInfo ), STRING, POINTER( POINTER( Image ) )] ),
( 'DrawPrimitive', MagickBooleanType, [POINTER( Image ), POINTER( DrawInfo ), POINTER( PrimitiveInfo )] ),
( 'GetAffineMatrix', None, [POINTER( AffineMatrix )] ),
( 'GetDrawInfo', None, [POINTER( ImageInfo ), POINTER( DrawInfo )] ),
( 'AddNoiseImage', POINTER( Image ), [POINTER( Image ), NoiseType, POINTER( ExceptionInfo )] ),
( 'BlurImage', POINTER( Image ), [POINTER( Image ), c_double, c_double, POINTER( ExceptionInfo )] ),
( 'BlurImageChannel', POINTER( Image ), [POINTER( Image ), ChannelType, c_double, c_double, POINTER( ExceptionInfo )] ),
( 'DespeckleImage', POINTER( Image ), [POINTER( Image ), POINTER( ExceptionInfo )] ),
( 'EdgeImage', POINTER( Image ), [POINTER( Image ), c_double, POINTER( ExceptionInfo )] ),
( 'EmbossImage', POINTER( Image ), [POINTER( Image ), c_double, c_double, POINTER( ExceptionInfo )] ),
( 'GaussianBlurImage', POINTER( Image ), [POINTER( Image ), c_double, c_double, POINTER( ExceptionInfo )] ),
( 'GaussianBlurImageChannel', POINTER( Image ), [POINTER( Image ), ChannelType, c_double, c_double, POINTER( ExceptionInfo )] ),
( 'MedianFilterImage', POINTER( Image ), [POINTER( Image ), c_double, POINTER( ExceptionInfo )] ),
( 'MotionBlurImage', POINTER( Image ), [POINTER( Image ), c_double, c_double, c_double, POINTER( ExceptionInfo )] ),
( 'PreviewImage', POINTER( Image ), [POINTER( Image ), PreviewType, POINTER( ExceptionInfo )] ),
( 'RadialBlurImage', POINTER( Image ), [POINTER( Image ), c_double, POINTER( ExceptionInfo )] ),
( 'RadialBlurImageChannel', POINTER( Image ), [POINTER( Image ), ChannelType, c_double, POINTER( ExceptionInfo )] ),
( 'ReduceNoiseImage', POINTER( Image ), [POINTER( Image ), c_double, POINTER( ExceptionInfo )] ),
( 'ShadeImage', POINTER( Image ), [POINTER( Image ), MagickBooleanType, c_double, c_double, POINTER( ExceptionInfo )] ),
( 'SharpenImage', POINTER( Image ), [POINTER( Image ), c_double, c_double, POINTER( ExceptionInfo )] ),
( 'SharpenImageChannel', POINTER( Image ), [POINTER( Image ), ChannelType, c_double, c_double, POINTER( ExceptionInfo )] ),
( 'SpreadImage', POINTER( Image ), [POINTER( Image ), c_double, POINTER( ExceptionInfo )] ),
( 'UnsharpMaskImage', POINTER( Image ), [POINTER( Image ), c_double, c_double, c_double, c_double, POINTER( ExceptionInfo )] ),
( 'UnsharpMaskImageChannel', POINTER( Image ), [POINTER( Image ), ChannelType, c_double, c_double, c_double, c_double, POINTER( ExceptionInfo )] ),
( 'ContrastImage', MagickBooleanType, [POINTER( Image ), MagickBooleanType] ),
( 'EqualizeImage', MagickBooleanType, [POINTER( Image )] ),
( 'GammaImage', MagickBooleanType, [POINTER( Image ), STRING] ),
( 'GammaImageChannel', MagickBooleanType, [POINTER( Image ), ChannelType, c_double] ),
( 'LevelImage', MagickBooleanType, [POINTER( Image ), STRING] ),
( 'LevelImageChannel', MagickBooleanType, [POINTER( Image ), ChannelType, c_double, c_double, c_double] ),
( 'ModulateImage', MagickBooleanType, [POINTER( Image ), STRING] ),
( 'NegateImage', MagickBooleanType, [POINTER( Image ), MagickBooleanType] ),
( 'NegateImageChannel', MagickBooleanType, [POINTER( Image ), ChannelType, MagickBooleanType] ),
( 'NormalizeImage', MagickBooleanType, [POINTER( Image )] ),
( 'NormalizeImageChannel', MagickBooleanType, [POINTER( Image ), ChannelType] ),
( 'SigmoidalContrastImage', MagickBooleanType, [POINTER( Image ), MagickBooleanType, STRING] ),
( 'SigmoidalContrastImageChannel', MagickBooleanType, [POINTER( Image ), ChannelType, MagickBooleanType, c_double, c_double] ),
( 'EnhanceImage', POINTER( Image ), [POINTER( Image ), POINTER( ExceptionInfo )] ),
( 'GetLocaleExceptionMessage', STRING, [ExceptionType, STRING] ),
( 'SetErrorHandler', ErrorHandler, [ErrorHandler] ),
( 'DestroyExceptionInfo', POINTER( ExceptionInfo ), [POINTER( ExceptionInfo )] ),
( 'SetFatalErrorHandler', FatalErrorHandler, [FatalErrorHandler] ),
( 'ThrowException', MagickBooleanType, [POINTER( ExceptionInfo ), ExceptionType, STRING, STRING] ),
( 'ThrowMagickException', MagickBooleanType, [POINTER( ExceptionInfo ), STRING, STRING, c_ulong, ExceptionType, STRING, STRING] ),
( 'ThrowMagickExceptionList', MagickBooleanType, [POINTER( ExceptionInfo ), STRING, STRING, c_ulong, ExceptionType, STRING, STRING, va_list] ),
( 'CatchException', None, [POINTER( ExceptionInfo )] ),
( 'GetExceptionInfo', None, [POINTER( ExceptionInfo )] ),
( 'InheritException', None, [POINTER( ExceptionInfo ), POINTER( ExceptionInfo )] ),
( 'MagickError', None, [ExceptionType, STRING, STRING] ),
( 'MagickFatalError', None, [ExceptionType, STRING, STRING] ),
( 'MagickWarning', None, [ExceptionType, STRING, STRING] ),
( 'SetWarningHandler', WarningHandler, [WarningHandler] ),
( 'CharcoalImage', POINTER( Image ), [POINTER( Image ), c_double, c_double, POINTER( ExceptionInfo )] ),
( 'ColorizeImage', POINTER( Image ), [POINTER( Image ), STRING, PixelPacket, POINTER( ExceptionInfo )] ),
( 'ConvolveImage', POINTER( Image ), [POINTER( Image ), c_ulong, POINTER( c_double ), POINTER( ExceptionInfo )] ),
( 'ConvolveImageChannel', POINTER( Image ), [POINTER( Image ), ChannelType, c_ulong, POINTER( c_double ), POINTER( ExceptionInfo )] ),
( 'FxImage', POINTER( Image ), [POINTER( Image ), STRING, POINTER( ExceptionInfo )] ),
( 'FxImageChannel', POINTER( Image ), [POINTER( Image ), ChannelType, STRING, POINTER( ExceptionInfo )] ),
( 'ImplodeImage', POINTER( Image ), [POINTER( Image ), c_double, POINTER( ExceptionInfo )] ),
( 'MorphImages', POINTER( Image ), [POINTER( Image ), c_ulong, POINTER( ExceptionInfo )] ),
( 'SepiaToneImage', POINTER( Image ), [POINTER( Image ), c_double, POINTER( ExceptionInfo )] ),
( 'ShadowImage', POINTER( Image ), [POINTER( Image ), c_double, c_double, c_long, c_long, POINTER( ExceptionInfo )] ),
( 'SteganoImage', POINTER( Image ), [POINTER( Image ), POINTER( Image ), POINTER( ExceptionInfo )] ),
( 'StereoImage', POINTER( Image ), [POINTER( Image ), POINTER( Image ), POINTER( ExceptionInfo )] ),
( 'SwirlImage', POINTER( Image ), [POINTER( Image ), c_double, POINTER( ExceptionInfo )] ),
( 'TintImage', POINTER( Image ), [POINTER( Image ), STRING, PixelPacket, POINTER( ExceptionInfo )] ),
( 'WaveImage', POINTER( Image ), [POINTER( Image ), c_double, c_double, POINTER( ExceptionInfo )] ),
( 'EvaluateImage', MagickBooleanType, [POINTER( Image ), MagickEvaluateOperator, c_double, POINTER( ExceptionInfo )] ),
( 'EvaluateImageChannel', MagickBooleanType, [POINTER( Image ), ChannelType, MagickEvaluateOperator, c_double, POINTER( ExceptionInfo )] ),
( 'SolarizeImage', MagickBooleanType, [POINTER( Image ), c_double] ),
( 'ExpandAffine', c_double, [POINTER( AffineMatrix )] ),
( 'GetOptimalKernelWidth', c_ulong, [c_double, c_double] ),
( 'GetOptimalKernelWidth1D', c_ulong, [c_double, c_double] ),
( 'GetOptimalKernelWidth2D', c_ulong, [c_double, c_double] ),
( 'GetPageGeometry', STRING, [STRING] ),
( 'IsGeometry', MagickBooleanType, [STRING] ),
( 'IsSceneGeometry', MagickBooleanType, [STRING, MagickBooleanType] ),
( 'GetGeometry', MagickStatusType, [STRING, POINTER( c_long ), POINTER( c_long ), POINTER( c_ulong ), POINTER( c_ulong )] ),
( 'ParseAbsoluteGeometry', MagickStatusType, [STRING, POINTER( RectangleInfo )] ),
( 'ParseGeometry', MagickStatusType, [STRING, POINTER( GeometryInfo )] ),
( 'ParseGravityGeometry', MagickStatusType, [POINTER( Image ), STRING, POINTER( RectangleInfo )] ),
( 'ParseMetaGeometry', MagickStatusType, [STRING, POINTER( c_long ), POINTER( c_long ), POINTER( c_ulong ), POINTER( c_ulong )] ),
( 'ParsePageGeometry', MagickStatusType, [POINTER( Image ), STRING, POINTER( RectangleInfo )] ),
( 'ParseSizeGeometry', MagickStatusType, [POINTER( Image ), STRING, POINTER( RectangleInfo )] ),
( 'SetGeometry', None, [POINTER( Image ), POINTER( RectangleInfo )] ),
( 'SetGeometryInfo', None, [POINTER( GeometryInfo )] ),
( 'DestroyHashmap', POINTER( HashmapInfo ), [POINTER( HashmapInfo )] ),
( 'NewHashmap', POINTER( HashmapInfo ), [c_ulong, CFUNCTYPE( size_t, c_void_p ), CFUNCTYPE( MagickBooleanType, c_void_p, c_void_p ), CFUNCTYPE( c_void_p, c_void_p ), CFUNCTYPE( c_void_p, c_void_p )] ),
( 'DestroyLinkedList', POINTER( LinkedListInfo ), [POINTER( LinkedListInfo ), CFUNCTYPE( c_void_p, c_void_p )] ),
( 'NewLinkedList', POINTER( LinkedListInfo ), [c_ulong] ),
( 'AppendValueToLinkedList', MagickBooleanType, [POINTER( LinkedListInfo ), c_void_p] ),
( 'CompareHashmapString', MagickBooleanType, [c_void_p, c_void_p] ),
( 'CompareHashmapStringInfo', MagickBooleanType, [c_void_p, c_void_p] ),
( 'InsertValueInLinkedList', MagickBooleanType, [POINTER( LinkedListInfo ), c_ulong, c_void_p] ),
( 'InsertValueInSortedLinkedList', MagickBooleanType, [POINTER( LinkedListInfo ), CFUNCTYPE( c_int, c_void_p, c_void_p ), POINTER( c_void_p ), c_void_p] ),
( 'IsHashmapEmpty', MagickBooleanType, [POINTER( HashmapInfo )] ),
( 'IsLinkedListEmpty', MagickBooleanType, [POINTER( LinkedListInfo )] ),
( 'LinkedListToArray', MagickBooleanType, [POINTER( LinkedListInfo ), POINTER( c_void_p )] ),
( 'PutEntryInHashmap', MagickBooleanType, [POINTER( HashmapInfo ), c_void_p, c_void_p] ),
( 'HashPointerType', size_t, [c_void_p] ),
( 'HashStringType', size_t, [c_void_p] ),
( 'HashStringInfoType', size_t, [c_void_p] ),
( 'GetNumberOfElementsInLinkedList', c_ulong, [POINTER( LinkedListInfo )] ),
( 'GetNumberOfEntriesInHashmap', c_ulong, [POINTER( HashmapInfo )] ),
( 'ClearLinkedList', None, [POINTER( LinkedListInfo ), CFUNCTYPE( c_void_p, c_void_p )] ),
( 'GetLastValueInLinkedList', c_void_p, [POINTER( LinkedListInfo )] ),
( 'GetNextKeyInHashmap', c_void_p, [POINTER( HashmapInfo )] ),
( 'GetNextValueInHashmap', c_void_p, [POINTER( HashmapInfo )] ),
( 'GetNextValueInLinkedList', c_void_p, [POINTER( LinkedListInfo )] ),
( 'GetValueFromHashmap', c_void_p, [POINTER( HashmapInfo ), c_void_p] ),
( 'GetValueFromLinkedList', c_void_p, [POINTER( LinkedListInfo ), c_ulong] ),
( 'RemoveElementByValueFromLinkedList', c_void_p, [POINTER( LinkedListInfo ), c_void_p] ),
( 'RemoveElementFromLinkedList', c_void_p, [POINTER( LinkedListInfo ), c_ulong] ),
( 'RemoveEntryFromHashmap', c_void_p, [POINTER( HashmapInfo ), c_void_p] ),
( 'RemoveLastElementFromLinkedList', c_void_p, [POINTER( LinkedListInfo )] ),
( 'ResetHashmapIterator', None, [POINTER( HashmapInfo )] ),
( 'ResetLinkedListIterator', None, [POINTER( LinkedListInfo )] ),
( 'IdentifyImage', MagickBooleanType, [POINTER( Image ), POINTER( FILE ), MagickBooleanType] ),
( 'AcquireImagePixels', POINTER( PixelPacket ), [POINTER( Image ), c_long, c_long, c_ulong, c_ulong, POINTER( ExceptionInfo )] ),
( 'CatchImageException', ExceptionType, [POINTER( Image )] ),
( 'AllocateImage', POINTER( Image ), [POINTER( ImageInfo )] ),
( 'AppendImages', POINTER( Image ), [POINTER( Image ), MagickBooleanType, POINTER( ExceptionInfo )] ),
( 'AverageImages', POINTER( Image ), [POINTER( Image ), POINTER( ExceptionInfo )] ),
( 'CloneImage', POINTER( Image ), [POINTER( Image ), c_ulong, c_ulong, MagickBooleanType, POINTER( ExceptionInfo )] ),
( 'CombineImages', POINTER( Image ), [POINTER( Image ), ChannelType, POINTER( ExceptionInfo )] ),
( 'DestroyImage', POINTER( Image ), [POINTER( Image )] ),
( 'GetImageClipMask', POINTER( Image ), [POINTER( Image ), POINTER( ExceptionInfo )] ),
( 'NewMagickImage', POINTER( Image ), [POINTER( ImageInfo ), c_ulong, c_ulong, POINTER( MagickPixelPacket )] ),
( 'ReferenceImage', POINTER( Image ), [POINTER( Image )] ),
( 'CloneImageInfo', POINTER( ImageInfo ), [POINTER( ImageInfo )] ),
( 'DestroyImageInfo', POINTER( ImageInfo ), [POINTER( ImageInfo )] ),
( 'GetImageType', ImageType, [POINTER( Image ), POINTER( ExceptionInfo )] ),
( 'GetIndexes', POINTER( IndexPacket ), [POINTER( Image )] ),
( 'AllocateImageColormap', MagickBooleanType, [POINTER( Image ), c_ulong] ),
( 'ClipImage', MagickBooleanType, [POINTER( Image )] ),
( 'CycleColormapImage', MagickBooleanType, [POINTER( Image ), c_long] ),
( 'GradientImage', MagickBooleanType, [POINTER( Image ), POINTER( PixelPacket ), POINTER( PixelPacket )] ),
( 'IsTaintImage', MagickBooleanType, [POINTER( Image )] ),
( 'IsMagickConflict', MagickBooleanType, [STRING] ),
( 'ListMagickInfo', MagickBooleanType, [POINTER( FILE ), POINTER( ExceptionInfo )] ),
( 'ModifyImage', MagickBooleanType, [POINTER( POINTER( Image ) ), POINTER( ExceptionInfo )] ),
( 'PlasmaImage', MagickBooleanType, [POINTER( Image ), POINTER( SegmentInfo ), c_ulong, c_ulong] ),
( 'SeparateImageChannel', MagickBooleanType, [POINTER( Image ), ChannelType] ),
( 'SetImageBackgroundColor', MagickBooleanType, [POINTER( Image )] ),
( 'SetImageClipMask', MagickBooleanType, [POINTER( Image ), POINTER( Image )] ),
( 'SetImageExtent', MagickBooleanType, [POINTER( Image ), c_ulong, c_ulong] ),
( 'SetImageInfo', MagickBooleanType, [POINTER( ImageInfo ), MagickBooleanType, POINTER( ExceptionInfo )] ),
( 'SetImageOpacity', MagickBooleanType, [POINTER( Image ), Quantum] ),
( 'SetImageType', MagickBooleanType, [POINTER( Image ), ImageType] ),
( 'SortColormapByIntensity', MagickBooleanType, [POINTER( Image )] ),
( 'StripImage', MagickBooleanType, [POINTER( Image )] ),
( 'SyncImage', MagickBooleanType, [POINTER( Image )] ),
( 'SyncImagePixels', MagickBooleanType, [POINTER( Image )] ),
( 'TextureImage', MagickBooleanType, [POINTER( Image ), POINTER( Image )] ),
( 'AcquireOnePixel', PixelPacket, [POINTER( Image ), c_long, c_long, POINTER( ExceptionInfo )] ),
( 'GetImagePixels', POINTER( PixelPacket ), [POINTER( Image ), c_long, c_long, c_ulong, c_ulong] ),
( 'GetOnePixel', PixelPacket, [POINTER( Image ), c_long, c_long] ),
( 'GetPixels', POINTER( PixelPacket ), [POINTER( Image )] ),
( 'SetImagePixels', POINTER( PixelPacket ), [POINTER( Image ), c_long, c_long, c_ulong, c_ulong] ),
( 'GetImageVirtualPixelMethod', VirtualPixelMethod, [POINTER( Image )] ),
( 'SetImageVirtualPixelMethod', VirtualPixelMethod, [POINTER( Image ), VirtualPixelMethod] ),
( 'AllocateNextImage', None, [POINTER( ImageInfo ), POINTER( Image )] ),
( 'DestroyImagePixels', None, [POINTER( Image )] ),
( 'GetImageException', None, [POINTER( Image ), POINTER( ExceptionInfo )] ),
( 'GetImageInfo', None, [POINTER( ImageInfo )] ),
( 'SetImageInfoBlob', None, [POINTER( ImageInfo ), c_void_p, size_t] ),
( 'SetImageInfoFile', None, [POINTER( ImageInfo ), POINTER( FILE )] ),
( 'CoalesceImages', POINTER( Image ), [POINTER( Image ), POINTER( ExceptionInfo )] ),
( 'DeconstructImages', POINTER( Image ), [POINTER( Image ), POINTER( ExceptionInfo )] ),
( 'CloneImageList', POINTER( Image ), [POINTER( Image ), POINTER( ExceptionInfo )] ),
( 'CloneImages', POINTER( Image ), [POINTER( Image ), STRING, POINTER( ExceptionInfo )] ),
( 'DestroyImageList', POINTER( Image ), [POINTER( Image )] ),
( 'GetFirstImageInList', POINTER( Image ), [POINTER( Image )] ),
( 'GetImageFromList', POINTER( Image ), [POINTER( Image ), c_long] ),
( 'GetLastImageInList', POINTER( Image ), [POINTER( Image )] ),
( 'GetNextImageInList', POINTER( Image ), [POINTER( Image )] ),
( 'GetPreviousImageInList', POINTER( Image ), [POINTER( Image )] ),
( 'ImageListToArray', POINTER( POINTER( Image ) ), [POINTER( Image ), POINTER( ExceptionInfo )] ),
( 'NewImageList', POINTER( Image ), [] ),
( 'RemoveImageFromList', POINTER( Image ), [POINTER( POINTER( Image ) )] ),
( 'RemoveLastImageFromList', POINTER( Image ), [POINTER( POINTER( Image ) )] ),
( 'RemoveFirstImageFromList', POINTER( Image ), [POINTER( POINTER( Image ) )] ),
( 'SpliceImageIntoList', POINTER( Image ), [POINTER( POINTER( Image ) ), c_ulong, POINTER( Image )] ),
( 'SplitImageList', POINTER( Image ), [POINTER( Image )] ),
( 'SyncNextImageInList', POINTER( Image ), [POINTER( Image )] ),
( 'GetImageIndexInList', c_long, [POINTER( Image )] ),
( 'GetImageListLength', c_ulong, [POINTER( Image )] ),
( 'AppendImageToList', None, [POINTER( POINTER( Image ) ), POINTER( Image )] ),
( 'DeleteImageFromList', None, [POINTER( POINTER( Image ) )] ),
( 'InsertImageInList', None, [POINTER( POINTER( Image ) ), POINTER( Image )] ),
( 'PrependImageToList', None, [POINTER( POINTER( Image ) ), POINTER( Image )] ),
( 'ReplaceImageInList', None, [POINTER( POINTER( Image ) ), POINTER( Image )] ),
( 'ReverseImageList', None, [POINTER( POINTER( Image ) )] ),
( 'SyncImageList', None, [POINTER( Image )] ),
( 'GetLocaleList', POINTER( STRING ), [STRING, POINTER( c_ulong ), POINTER( ExceptionInfo )] ),
( 'GetLocaleMessage', STRING, [STRING] ),
( 'GetLocaleInfo_', POINTER( LocaleInfo ), [STRING, POINTER( ExceptionInfo )] ),
( 'GetLocaleInfoList', POINTER( POINTER( LocaleInfo ) ), [STRING, POINTER( c_ulong ), POINTER( ExceptionInfo )] ),
( 'DestroyLocaleOptions', POINTER( LinkedListInfo ), [POINTER( LinkedListInfo )] ),
( 'GetLocaleOptions', POINTER( LinkedListInfo ), [STRING, POINTER( ExceptionInfo )] ),
( 'ListLocaleInfo', MagickBooleanType, [POINTER( FILE ), POINTER( ExceptionInfo )] ),
#DestroyLocaleList = _lib_MagickWand.DestroyLocaleList
#DestroyLocaleList.restype = None
#DestroyLocaleList.argtypes = []
( 'GetLogList', POINTER( STRING ), [STRING, POINTER( c_ulong ), POINTER( ExceptionInfo )] ),
#GetLogInfo = _lib_MagickWand.GetLogInfo
#GetLogInfo.restype = POINTER( LogInfo )
#GetLogInfo.argtypes = [STRING, POINTER( ExceptionInfo )]
( 'GetLogInfoList', POINTER( POINTER( LogInfo ) ), [STRING, POINTER( c_ulong ), POINTER( ExceptionInfo )] ),
( 'SetLogEventMask', LogEventType, [STRING] ),
( 'IsEventLogging', MagickBooleanType, [] ),
( 'ListLogInfo', MagickBooleanType, [POINTER( FILE ), POINTER( ExceptionInfo )] ),
( 'LogMagickEvent', MagickBooleanType, [LogEventType, STRING, STRING, c_ulong, STRING] ),
( 'LogMagickEventList', MagickBooleanType, [LogEventType, STRING, STRING, c_ulong, STRING, va_list] ),
#DestroyLogList = _lib_MagickWand.DestroyLogList
#DestroyLogList.restype = None
#DestroyLogList.argtypes = []
( 'SetLogFormat', None, [STRING] ),
( 'GetMagicList', POINTER( STRING ), [STRING, POINTER( c_ulong ), POINTER( ExceptionInfo )] ),
( 'GetMagicName', STRING, [POINTER( MagicInfo )] ),
( 'ListMagicInfo', MagickBooleanType, [POINTER( FILE ), POINTER( ExceptionInfo )] ),
( 'GetMagicInfo', POINTER( MagicInfo ), [POINTER( c_ubyte ), size_t, POINTER( ExceptionInfo )] ),
( 'GetMagicInfoList', POINTER( POINTER( MagicInfo ) ), [STRING, POINTER( c_ulong ), POINTER( ExceptionInfo )] ),
#DestroyMagicList = _lib_MagickWand.DestroyMagicList
#DestroyMagicList.restype = None
#DestroyMagicList.argtypes = []
( 'GetMagickList', POINTER( STRING ), [STRING, POINTER( c_ulong ), POINTER( ExceptionInfo )] ),
( 'GetImageMagick', STRING, [POINTER( c_ubyte ), size_t] ),
( 'GetMagickDescription', STRING, [POINTER( MagickInfo )] ),
( 'GetMagickAdjoin', MagickBooleanType, [POINTER( MagickInfo )] ),
( 'GetMagickBlobSupport', MagickBooleanType, [POINTER( MagickInfo )] ),
( 'GetMagickEndianSupport', MagickBooleanType, [POINTER( MagickInfo )] ),
( 'GetMagickSeekableStream', MagickBooleanType, [POINTER( MagickInfo )] ),
( 'IsMagickInstantiated', MagickBooleanType, [] ),
( 'UnregisterMagickInfo', MagickBooleanType, [STRING] ),
( 'GetMagickInfo', POINTER( MagickInfo ), [STRING, POINTER( ExceptionInfo )] ),
( 'GetMagickInfoList', POINTER( POINTER( MagickInfo ) ), [STRING, POINTER( c_ulong ), POINTER( ExceptionInfo )] ),
( 'RegisterMagickInfo', POINTER( MagickInfo ), [POINTER( MagickInfo )] ),
( 'SetMagickInfo', POINTER( MagickInfo ), [STRING] ),
( 'GetMagickThreadSupport', MagickStatusType, [POINTER( MagickInfo )] ),
#DestroyMagickList = _lib_MagickWand.DestroyMagickList
#DestroyMagickList.restype = None
#DestroyMagickList.argtypes = []
( 'AcquireMagickMemory', c_void_p, [size_t] ),
( 'CopyMagickMemory', c_void_p, [c_void_p, c_void_p, size_t] ),
( 'DestroyMagickMemory', None, [] ),
( 'RelinquishMagickMemory', c_void_p, [c_void_p] ),
( 'ResetMagickMemory', c_void_p, [c_void_p, c_int, size_t] ),
( 'ResizeMagickMemory', c_void_p, [c_void_p, size_t] ),
( 'MagickToMime', STRING, [STRING] ),
( 'GetModuleList', POINTER( STRING ), [STRING, POINTER( c_ulong ), POINTER( ExceptionInfo )] ),
( 'GetModuleInfo', POINTER( ModuleInfo ), [STRING, POINTER( ExceptionInfo )] ),
( 'GetModuleInfoList', POINTER( POINTER( ModuleInfo ) ), [STRING, POINTER( c_ulong ), POINTER( ExceptionInfo )] ),
( 'ListModuleInfo', MagickBooleanType, [POINTER( FILE ), POINTER( ExceptionInfo )] ),
( 'OpenModule', MagickBooleanType, [STRING, POINTER( ExceptionInfo )] ),
( 'OpenModules', MagickBooleanType, [POINTER( ExceptionInfo )] ),
( 'DestroyModuleList', None, [] ),
( 'RegisterStaticModules', None, [] ),
( 'UnregisterStaticModules', None, [] ),
( 'SetImageProgressMonitor', MagickProgressMonitor, [POINTER( Image ), MagickProgressMonitor, c_void_p] ),
( 'SetImageInfoProgressMonitor', MagickProgressMonitor, [POINTER( ImageInfo ), MagickProgressMonitor, c_void_p] ),
( 'MontageImages', POINTER( Image ), [POINTER( Image ), POINTER( MontageInfo ), POINTER( ExceptionInfo )] ),
( 'CloneMontageInfo', POINTER( MontageInfo ), [POINTER( ImageInfo ), POINTER( MontageInfo )] ),
( 'DestroyMontageInfo', POINTER( MontageInfo ), [POINTER( MontageInfo )] ),
( 'GetMontageInfo', None, [POINTER( ImageInfo ), POINTER( MontageInfo )] ),
( 'GetMagickOptions', POINTER( STRING ), [MagickOption] ),
( 'GetNextImageOption', STRING, [POINTER( ImageInfo )] ),
( 'RemoveImageOption', STRING, [POINTER( ImageInfo ), STRING] ),
( 'GetImageOption', STRING, [POINTER( ImageInfo ), STRING] ),
( 'MagickOptionToMnemonic', STRING, [MagickOption, c_long] ),
( 'ParseChannelOption', c_long, [STRING] ),
( 'ParseMagickOption', c_long, [MagickOption, MagickBooleanType, STRING] ),
( 'CloneImageOptions', MagickBooleanType, [POINTER( ImageInfo ), POINTER( ImageInfo )] ),
( 'DefineImageOption', MagickBooleanType, [POINTER( ImageInfo ), STRING] ),
( 'DeleteImageOption', MagickBooleanType, [POINTER( ImageInfo ), STRING] ),
( 'IsMagickOption', MagickBooleanType, [STRING] ),
( 'SetImageOption', MagickBooleanType, [POINTER( ImageInfo ), STRING, STRING] ),
( 'DestroyImageOptions', None, [POINTER( ImageInfo )] ),
( 'ResetImageOptionIterator', None, [POINTER( ImageInfo )] ),
( 'OilPaintImage', POINTER( Image ), [POINTER( Image ), c_double, POINTER( ExceptionInfo )] ),
( 'ExportImagePixels', MagickBooleanType, [POINTER( Image ), c_long, c_long, c_ulong, c_ulong, STRING, StorageType, c_void_p, POINTER( ExceptionInfo )] ),
( 'ImportImagePixels', MagickBooleanType, [POINTER( Image ), c_long, c_long, c_ulong, c_ulong, STRING, StorageType, c_void_p] ),
( 'GetMagickPixelPacket', None, [POINTER( Image ), POINTER( MagickPixelPacket )] ),
( 'GetImageTotalInkDensity', c_double, [POINTER( Image )] ),
( 'GetNextImageProfile', STRING, [POINTER( Image )] ),
( 'GetImageProfile', POINTER( StringInfo ), [POINTER( Image ), STRING] ),
( 'CloneImageProfiles', MagickBooleanType, [POINTER( Image ), POINTER( Image )] ),
( 'ProfileImage', MagickBooleanType, [POINTER( Image ), STRING, c_void_p, size_t, MagickBooleanType] ),
( 'SetImageProfile', MagickBooleanType, [POINTER( Image ), STRING, POINTER( StringInfo )] ),
( 'RemoveImageProfile', POINTER( StringInfo ), [POINTER( Image ), STRING] ),
( 'DestroyImageProfiles', None, [POINTER( Image )] ),
( 'ResetImageProfileIterator', None, [POINTER( Image )] ),
( 'GetImageQuantizeError', MagickBooleanType, [POINTER( Image )] ),
( 'MapImage', MagickBooleanType, [POINTER( Image ), POINTER( Image ), MagickBooleanType] ),
( 'MapImages', MagickBooleanType, [POINTER( Image ), POINTER( Image ), MagickBooleanType] ),
( 'PosterizeImage', MagickBooleanType, [POINTER( Image ), c_ulong, MagickBooleanType] ),
( 'QuantizeImage', MagickBooleanType, [POINTER( QuantizeInfo ), POINTER( Image )] ),
( 'QuantizeImages', MagickBooleanType, [POINTER( QuantizeInfo ), POINTER( Image )] ),
( 'CloneQuantizeInfo', POINTER( QuantizeInfo ), [POINTER( QuantizeInfo )] ),
( 'DestroyQuantizeInfo', POINTER( QuantizeInfo ), [POINTER( QuantizeInfo )] ),
( 'CompressImageColormap', None, [POINTER( Image )] ),
( 'GetQuantizeInfo', None, [POINTER( QuantizeInfo )] ),
( 'ExportQuantumPixels', MagickBooleanType, [POINTER( Image ), POINTER( QuantumInfo ), QuantumType, POINTER( c_ubyte )] ),
( 'ImportQuantumPixels', MagickBooleanType, [POINTER( Image ), POINTER( QuantumInfo ), QuantumType, POINTER( c_ubyte )] ),
( 'GetRandomValue', c_double, [] ),
#DestroyRandomReservoir = _lib_MagickWand.DestroyRandomReservoir
#DestroyRandomReservoir.restype = None
#DestroyRandomReservoir.argtypes = []
#DistillRandomEvent = _lib_MagickWand.DistillRandomEvent
#DistillRandomEvent.restype = None
#DistillRandomEvent.argtypes = [POINTER( c_ubyte ), size_t]
( 'GetRandomKey', None, [POINTER( c_ubyte ), size_t] ),
( 'MagnifyImage', POINTER( Image ), [POINTER( Image ), POINTER( ExceptionInfo )] ),
( 'MinifyImage', POINTER( Image ), [POINTER( Image ), POINTER( ExceptionInfo )] ),
( 'ResizeImage', POINTER( Image ), [POINTER( Image ), c_ulong, c_ulong, FilterTypes, c_double, POINTER( ExceptionInfo )] ),
( 'SampleImage', POINTER( Image ), [POINTER( Image ), c_ulong, c_ulong, POINTER( ExceptionInfo )] ),
( 'ScaleImage', POINTER( Image ), [POINTER( Image ), c_ulong, c_ulong, POINTER( ExceptionInfo )] ),
( 'ThumbnailImage', POINTER( Image ), [POINTER( Image ), c_ulong, c_ulong, POINTER( ExceptionInfo )] ),
( 'ZoomImage', POINTER( Image ), [POINTER( Image ), c_ulong, c_ulong, POINTER( ExceptionInfo )] ),
( 'AcquireUniqueFileResource', c_int, [STRING] ),
( 'AcquireMagickResource', MagickBooleanType, [ResourceType, MagickSizeType] ),
( 'RelinquishUniqueFileResource', MagickBooleanType, [STRING] ),
( 'ListMagickResourceInfo', MagickBooleanType, [POINTER( FILE ), POINTER( ExceptionInfo )] ),
( 'SetMagickResourceLimit', MagickBooleanType, [ResourceType, MagickSizeType] ),
( 'GetMagickResource', MagickSizeType, [ResourceType] ),
( 'GetMagickResourceLimit', MagickSizeType, [ResourceType] ),
#AsynchronousDestroyMagickResources = _lib_MagickWand.AsynchronousDestroyMagickResources
#AsynchronousDestroyMagickResources.restype = None
#AsynchronousDestroyMagickResources.argtypes = []
#DestroyMagickResources = _lib_MagickWand.DestroyMagickResources
#DestroyMagickResources.restype = None
#DestroyMagickResources.argtypes = []
#InitializeMagickResources = _lib_MagickWand.InitializeMagickResources
#InitializeMagickResources.restype = None
#InitializeMagickResources.argtypes = []
( 'RelinquishMagickResource', None, [ResourceType, MagickSizeType] ),
( 'GetImageDynamicThreshold', MagickPixelPacket, [POINTER( Image ), c_double, c_double, POINTER( ExceptionInfo )] ),
( 'SegmentImage', MagickBooleanType, [POINTER( Image ), ColorspaceType, MagickBooleanType, c_double, c_double] ),
( 'LockSemaphoreInfo', MagickBooleanType, [POINTER( SemaphoreInfo )] ),
( 'UnlockSemaphoreInfo', MagickBooleanType, [POINTER( SemaphoreInfo )] ),
( 'AllocateSemaphoreInfo', POINTER( SemaphoreInfo ), [] ),
( 'DestroySemaphoreInfo', POINTER( SemaphoreInfo ), [POINTER( SemaphoreInfo )] ),
( 'AcquireSemaphoreInfo', None, [POINTER( POINTER( SemaphoreInfo ) )] ),
#DestroySemaphore = _lib_MagickWand.DestroySemaphore
#DestroySemaphore.restype = None
#DestroySemaphore.argtypes = []
#InitializeSemaphore = _lib_MagickWand.InitializeSemaphore
#InitializeSemaphore.restype = None
#InitializeSemaphore.argtypes = []
( 'RelinquishSemaphoreInfo', None, [POINTER( SemaphoreInfo )] ),
( 'AffineTransformImage', POINTER( Image ), [POINTER( Image ), POINTER( AffineMatrix ), POINTER( ExceptionInfo )] ),
( 'RotateImage', POINTER( Image ), [POINTER( Image ), c_double, POINTER( ExceptionInfo )] ),
( 'ShearImage', POINTER( Image ), [POINTER( Image ), c_double, c_double, POINTER( ExceptionInfo )] ),
( 'SignatureImage', MagickBooleanType, [POINTER( Image )] ),
( 'FinalizeSignature', None, [POINTER( SignatureInfo )] ),
( 'UpdateSignature', None, [POINTER( SignatureInfo ), POINTER( StringInfo )] ),
( 'AddValueToSplayTree', MagickBooleanType, [POINTER( SplayTreeInfo ), c_void_p, c_void_p] ),
( 'CompareSplayTreeString', c_int, [c_void_p, c_void_p] ),
( 'CompareSplayTreeStringInfo', c_int, [c_void_p, c_void_p] ),
( 'DestroySplayTree', POINTER( SplayTreeInfo ), [POINTER( SplayTreeInfo )] ),
( 'NewSplayTree', POINTER( SplayTreeInfo ), [CFUNCTYPE( c_int, c_void_p, c_void_p ), CFUNCTYPE( c_void_p, c_void_p ), CFUNCTYPE( c_void_p, c_void_p )] ),
( 'GetNumberOfNodesInSplayTree', c_ulong, [POINTER( SplayTreeInfo )] ),
( 'GetNextKeyInSplayTree', c_void_p, [POINTER( SplayTreeInfo )] ),
( 'GetNextValueInSplayTree', c_void_p, [POINTER( SplayTreeInfo )] ),
( 'GetValueFromSplayTree', c_void_p, [POINTER( SplayTreeInfo ), c_void_p] ),
( 'RemoveNodeByValueFromSplayTree', c_void_p, [POINTER( SplayTreeInfo ), c_void_p] ),
( 'RemoveNodeFromSplayTree', c_void_p, [POINTER( SplayTreeInfo ), c_void_p] ),
( 'ResetSplayTreeIterator', None, [POINTER( SplayTreeInfo )] ),
( 'GetImageChannelStatistics', POINTER( ChannelStatistics ), [POINTER( Image ), POINTER( ExceptionInfo )] ),
( 'GetImageChannelExtrema', MagickBooleanType, [POINTER( Image ), ChannelType, POINTER( c_ulong ), POINTER( c_ulong ), POINTER( ExceptionInfo )] ),
( 'GetImageChannelMean', MagickBooleanType, [POINTER( Image ), ChannelType, POINTER( c_double ), POINTER( c_double ), POINTER( ExceptionInfo )] ),
( 'GetImageExtrema', MagickBooleanType, [POINTER( Image ), POINTER( c_ulong ), POINTER( c_ulong ), POINTER( ExceptionInfo )] ),
( 'GetImageMean', MagickBooleanType, [POINTER( Image ), POINTER( c_double ), POINTER( c_double ), POINTER( ExceptionInfo )] ),
( 'SetImageChannelDepth', MagickBooleanType, [POINTER( Image ), ChannelType, c_ulong] ),
( 'SetImageDepth', MagickBooleanType, [POINTER( Image ), c_ulong] ),
( 'GetImageBoundingBox', RectangleInfo, [POINTER( Image ), POINTER( ExceptionInfo )] ),
( 'GetImageChannelDepth', c_ulong, [POINTER( Image ), ChannelType, POINTER( ExceptionInfo )] ),
( 'GetImageDepth', c_ulong, [POINTER( Image ), POINTER( ExceptionInfo )] ),
( 'GetImageQuantumDepth', c_ulong, [POINTER( Image ), MagickBooleanType] ),
( 'ReadStream', POINTER( Image ), [POINTER( ImageInfo ), StreamHandler, POINTER( ExceptionInfo )] ),
( 'WriteStream', MagickBooleanType, [POINTER( ImageInfo ), POINTER( Image ), StreamHandler] ),
( 'AcquireString', STRING, [STRING] ),
( 'CloneString', STRING, [POINTER( STRING ), STRING] ),
( 'ConstantString', STRING, [STRING] ),
( 'DestroyString', STRING, [STRING] ),
( 'DestroyStringList', POINTER( STRING ), [POINTER( STRING )] ),
( 'EscapeString', STRING, [STRING, c_char] ),
( 'FileToString', STRING, [STRING, size_t, POINTER( ExceptionInfo )] ),
( 'StringInfoToString', STRING, [POINTER( StringInfo )] ),
( 'StringToArgv', POINTER( STRING ), [STRING, POINTER( c_int )] ),
( 'StringToList', POINTER( STRING ), [STRING] ),
#StringToDouble = _lib_MagickWand.StringToDouble
#StringToDouble.restype = c_double
#StringToDouble.argtypes = [STRING, c_double]
( 'FormatMagickString', c_long, [STRING, size_t, STRING] ),
( 'FormatMagickStringList', c_long, [STRING, size_t, STRING, va_list] ),
( 'LocaleCompare', c_long, [STRING, STRING] ),
( 'LocaleNCompare', c_long, [STRING, STRING, size_t] ),
( 'ConcatenateString', MagickBooleanType, [POINTER( STRING ), STRING] ),
( 'SubstituteString', MagickBooleanType, [POINTER( STRING ), STRING, STRING] ),
( 'CompareStringInfo', c_int, [POINTER( StringInfo ), POINTER( StringInfo )] ),
( 'ConcatenateMagickString', size_t, [STRING, STRING, size_t] ),
( 'CopyMagickString', size_t, [STRING, STRING, size_t] ),
( 'AcquireStringInfo', POINTER( StringInfo ), [size_t] ),
( 'CloneStringInfo', POINTER( StringInfo ), [POINTER( StringInfo )] ),
( 'ConfigureFileToStringInfo', POINTER( StringInfo ), [STRING] ),
( 'DestroyStringInfo', POINTER( StringInfo ), [POINTER( StringInfo )] ),
( 'FileToStringInfo', POINTER( StringInfo ), [STRING, size_t, POINTER( ExceptionInfo )] ),
( 'SplitStringInfo', POINTER( StringInfo ), [POINTER( StringInfo ), size_t] ),
( 'StringToStringInfo', POINTER( StringInfo ), [STRING] ),
( 'ConcatenateStringInfo', None, [POINTER( StringInfo ), POINTER( StringInfo )] ),
( 'LocaleLower', None, [STRING] ),
( 'LocaleUpper', None, [STRING] ),
( 'PrintStringInfo', None, [POINTER( FILE ), STRING, POINTER( StringInfo )] ),
( 'ResetStringInfo', None, [POINTER( StringInfo )] ),
( 'SetStringInfo', None, [POINTER( StringInfo ), POINTER( StringInfo )] ),
( 'SetStringInfoDatum', None, [POINTER( StringInfo ), POINTER( c_ubyte )] ),
( 'SetStringInfoLength', None, [POINTER( StringInfo ), size_t] ),
( 'StripString', None, [STRING] ),
( 'AdaptiveThresholdImage', POINTER( Image ), [POINTER( Image ), c_ulong, c_ulong, c_long, POINTER( ExceptionInfo )] ),
( 'BilevelImage', MagickBooleanType, [POINTER( Image ), c_double] ),
( 'BilevelImageChannel', MagickBooleanType, [POINTER( Image ), ChannelType, c_double] ),
( 'BlackThresholdImage', MagickBooleanType, [POINTER( Image ), STRING] ),
( 'OrderedDitherImage', MagickBooleanType, [POINTER( Image )] ),
( 'RandomThresholdImage', MagickBooleanType, [POINTER( Image ), STRING, POINTER( ExceptionInfo )] ),
( 'RandomThresholdImageChannel', MagickBooleanType, [POINTER( Image ), ChannelType, STRING, POINTER( ExceptionInfo )] ),
( 'WhiteThresholdImage', MagickBooleanType, [POINTER( Image ), STRING] ),
( 'GetElapsedTime', c_double, [POINTER( TimerInfo )] ),
( 'GetUserTime', c_double, [POINTER( TimerInfo )] ),
( 'ContinueTimer', MagickBooleanType, [POINTER( TimerInfo )] ),
( 'GetTimerInfo', None, [POINTER( TimerInfo )] ),
( 'ResetTimer', None, [POINTER( TimerInfo )] ),
( 'StartTimer', None, [POINTER( TimerInfo ), MagickBooleanType] ),
( 'Tokenizer', c_int, [POINTER( TokenInfo ), c_uint, STRING, size_t, STRING, STRING, STRING, STRING, c_char, STRING, POINTER( c_int ), STRING] ),
( 'GlobExpression', MagickBooleanType, [STRING, STRING, MagickBooleanType] ),
( 'IsGlob', MagickBooleanType, [STRING] ),
( 'GetMagickToken', None, [STRING, POINTER( STRING ), STRING] ),
( 'ChopImage', POINTER( Image ), [POINTER( Image ), POINTER( RectangleInfo ), POINTER( ExceptionInfo )] ),
( 'ConsolidateCMYKImages', POINTER( Image ), [POINTER( Image ), POINTER( ExceptionInfo )] ),
( 'CropImage', POINTER( Image ), [POINTER( Image ), POINTER( RectangleInfo ), POINTER( ExceptionInfo )] ),
( 'FlipImage', POINTER( Image ), [POINTER( Image ), POINTER( ExceptionInfo )] ),
( 'FlopImage', POINTER( Image ), [POINTER( Image ), POINTER( ExceptionInfo )] ),
( 'RollImage', POINTER( Image ), [POINTER( Image ), c_long, c_long, POINTER( ExceptionInfo )] ),
( 'ShaveImage', POINTER( Image ), [POINTER( Image ), POINTER( RectangleInfo ), POINTER( ExceptionInfo )] ),
( 'SpliceImage', POINTER( Image ), [POINTER( Image ), POINTER( RectangleInfo ), POINTER( ExceptionInfo )] ),
( 'TrimImage', POINTER( Image ), [POINTER( Image ), POINTER( ExceptionInfo )] ),
( 'TransformImage', MagickBooleanType, [POINTER( POINTER( Image ) ), STRING, STRING] ),
( 'TransformImages', MagickBooleanType, [POINTER( POINTER( Image ) ), STRING, STRING] ),
( 'GetTypeList', POINTER( STRING ), [STRING, POINTER( c_ulong ), POINTER( ExceptionInfo )] ),
( 'ListTypeInfo', MagickBooleanType, [POINTER( FILE ), POINTER( ExceptionInfo )] ),
( 'GetTypeInfo', POINTER( TypeInfo ), [STRING, POINTER( ExceptionInfo )] ),
( 'GetTypeInfoByFamily', POINTER( TypeInfo ), [STRING, StyleType, StretchType, c_ulong, POINTER( ExceptionInfo )] ),
( 'GetTypeInfoList', POINTER( POINTER( TypeInfo ) ), [STRING, POINTER( c_ulong ), POINTER( ExceptionInfo )] ),
#DestroyTypeList = _lib_MagickWand.DestroyTypeList
#DestroyTypeList.restype = None
#DestroyTypeList.argtypes = []
( 'Base64Encode', STRING, [POINTER( c_ubyte ), size_t, POINTER( size_t )] ),
( 'ListFiles', POINTER( STRING ), [STRING, STRING, POINTER( c_ulong )] ),
( 'SystemCommand', c_int, [MagickBooleanType, STRING] ),
( 'AcquireUniqueFilename', MagickBooleanType, [STRING] ),
( 'ExpandFilenames', MagickBooleanType, [POINTER( c_int ), POINTER( POINTER( STRING ) )] ),
( 'GetExecutionPath', MagickBooleanType, [STRING, size_t] ),
#IsAccessible = _lib_MagickWand.IsAccessible
#IsAccessible.restype = MagickBooleanType
#IsAccessible.argtypes = [STRING]
( 'Base64Decode', POINTER( c_ubyte ), [STRING, POINTER( size_t )] ),
( 'MultilineCensus', c_ulong, [STRING] ),
( 'AppendImageFormat', None, [STRING, STRING] ),
( 'ChopPathComponents', None, [STRING, c_ulong] ),
( 'ExpandFilename', None, [STRING] ),
( 'GetPathComponent', None, [STRING, PathType, STRING] ),
( 'GetMagickHomeURL', STRING, [] ),
( 'GetMagickCopyright', STRING, [] ),
( 'GetMagickPackageName', STRING, [] ),
( 'GetMagickQuantumDepth', STRING, [POINTER( c_ulong )] ),
( 'GetMagickQuantumRange', STRING, [POINTER( c_ulong )] ),
( 'GetMagickReleaseDate', STRING, [] ),
( 'GetMagickVersion', STRING, [POINTER( c_ulong )] ),
( 'XImportImage', POINTER( Image ), [POINTER( ImageInfo ), POINTER( XImportInfo )] ),
( 'XGetImportInfo', None, [POINTER( XImportInfo )] ),
( 'MagickWandGenesis', None, [] ),
( 'MagickWandTerminus', None, [] ),
( 'MagickRelinquishMemory', c_void_p, [c_void_p] ),
( 'MagickResetIterator', None, [POINTER( MagickWand )] ),
( 'MagickSetFirstIterator', None, [POINTER( MagickWand )] ),
( 'MagickSetLastIterator', None, [POINTER( MagickWand )] ),
( 'AnimateImageCommand', MagickBooleanType, [POINTER( ImageInfo ), c_int, POINTER( STRING ), POINTER( STRING ), POINTER( ExceptionInfo )] ),
( 'CompareImageCommand', MagickBooleanType, [POINTER( ImageInfo ), c_int, POINTER( STRING ), POINTER( STRING ), POINTER( ExceptionInfo )] ),
( 'CompositeImageCommand', MagickBooleanType, [POINTER( ImageInfo ), c_int, POINTER( STRING ), POINTER( STRING ), POINTER( ExceptionInfo )] ),
( 'ConjureImageCommand', MagickBooleanType, [POINTER( ImageInfo ), c_int, POINTER( STRING ), POINTER( STRING ), POINTER( ExceptionInfo )] ),
( 'ConvertImageCommand', MagickBooleanType, [POINTER( ImageInfo ), c_int, POINTER( STRING ), POINTER( STRING ), POINTER( ExceptionInfo )] ),
( 'DrawGetFillAlpha', c_double, [POINTER( DrawingWand )] ),
( 'DrawGetStrokeAlpha', c_double, [POINTER( DrawingWand )] ),
( 'DrawPeekGraphicWand', POINTER( DrawInfo ), [POINTER( DrawingWand )] ),
( 'PixelIteratorGetException', STRING, [POINTER( PixelIterator ), POINTER( ExceptionType )] ),
( 'MagickDescribeImage', STRING, [POINTER( MagickWand )] ),
( 'MagickGetImageAttribute', STRING, [POINTER( MagickWand ), STRING] ),
( 'MagickGetImageIndex', c_long, [POINTER( MagickWand )] ),
( 'MagickClipPathImage', MagickBooleanType, [POINTER( MagickWand ), STRING, MagickBooleanType] ),
( 'MagickColorFloodfillImage', MagickBooleanType, [POINTER( MagickWand ), POINTER( PixelWand ), c_double, POINTER( PixelWand ), c_long, c_long] ),
( 'MagickGetImageChannelExtrema', MagickBooleanType, [POINTER( MagickWand ), ChannelType, POINTER( c_ulong ), POINTER( c_ulong )] ),
( 'MagickGetImageExtrema', MagickBooleanType, [POINTER( MagickWand ), POINTER( c_ulong ), POINTER( c_ulong )] ),
( 'MagickMatteFloodfillImage', MagickBooleanType, [POINTER( MagickWand ), c_double, c_double, POINTER( PixelWand ), c_long, c_long] ),
( 'MagickOpaqueImage', MagickBooleanType, [POINTER( MagickWand ), POINTER( PixelWand ), POINTER( PixelWand ), c_double] ),
( 'MagickPaintOpaqueImage', MagickBooleanType, [POINTER( MagickWand ), POINTER( PixelWand ), POINTER( PixelWand ), c_double] ),
( 'MagickPaintTransparentImage', MagickBooleanType, [POINTER( MagickWand ), POINTER( PixelWand ), c_double, c_double] ),
( 'MagickSetImageAttribute', MagickBooleanType, [POINTER( MagickWand ), STRING, STRING] ),
( 'MagickSetImageIndex', MagickBooleanType, [POINTER( MagickWand ), c_long] ),
( 'MagickSetImageOption', MagickBooleanType, [POINTER( MagickWand ), STRING, STRING, STRING] ),
( 'MagickTransparentImage', MagickBooleanType, [POINTER( MagickWand ), POINTER( PixelWand ), c_double, c_double] ),
( 'MagickFlattenImages', POINTER( MagickWand ), [POINTER( MagickWand )] ),
( 'MagickMosaicImages', POINTER( MagickWand ), [POINTER( MagickWand )] ),
( 'MagickRegionOfInterestImage', POINTER( MagickWand ), [POINTER( MagickWand ), c_ulong, c_ulong, c_long, c_long] ),
( 'MagickGetImageSize', MagickSizeType, [POINTER( MagickWand )] ),
( 'PixelGetNextRow', POINTER( POINTER( PixelWand ) ), [POINTER( PixelIterator )] ),
( 'MagickWriteImageBlob', POINTER( c_ubyte ), [POINTER( MagickWand ), POINTER( size_t )] ),
( 'MagickSetImageVirtualPixelMethod', VirtualPixelMethod, [POINTER( MagickWand ), VirtualPixelMethod] ),
( 'DrawPopGraphicContext', None, [POINTER( DrawingWand )] ),
( 'DrawPushGraphicContext', None, [POINTER( DrawingWand )] ),
( 'DrawSetFillAlpha', None, [POINTER( DrawingWand ), c_double] ),
( 'DrawSetStrokeAlpha', None, [POINTER( DrawingWand ), c_double] ),
( 'DisplayImageCommand', MagickBooleanType, [POINTER( ImageInfo ), c_int, POINTER( STRING ), POINTER( STRING ), POINTER( ExceptionInfo )] ),
( 'DrawGetTextAlignment', AlignType, [POINTER( DrawingWand )] ),
( 'DrawGetClipPath', STRING, [POINTER( DrawingWand )] ),
( 'DrawGetException', STRING, [POINTER( DrawingWand ), POINTER( ExceptionType )] ),
( 'DrawGetFont', STRING, [POINTER( DrawingWand )] ),
( 'DrawGetFontFamily', STRING, [POINTER( DrawingWand )] ),
( 'DrawGetTextEncoding', STRING, [POINTER( DrawingWand )] ),
( 'DrawGetVectorGraphics', STRING, [POINTER( DrawingWand )] ),
( 'DrawGetClipUnits', ClipPathUnits, [POINTER( DrawingWand )] ),
( 'DrawGetTextDecoration', DecorationType, [POINTER( DrawingWand )] ),
( 'DrawGetFillOpacity', c_double, [POINTER( DrawingWand )] ),
( 'DrawGetFontSize', c_double, [POINTER( DrawingWand )] ),
( 'DrawGetStrokeDashArray', POINTER( c_double ), [POINTER( DrawingWand ), POINTER( c_ulong )] ),
( 'DrawGetStrokeDashOffset', c_double, [POINTER( DrawingWand )] ),
( 'DrawGetStrokeOpacity', c_double, [POINTER( DrawingWand )] ),
( 'DrawGetStrokeWidth', c_double, [POINTER( DrawingWand )] ),
( 'PeekDrawingWand', POINTER( DrawInfo ), [POINTER( DrawingWand )] ),
( 'CloneDrawingWand', POINTER( DrawingWand ), [POINTER( DrawingWand )] ),
( 'DestroyDrawingWand', POINTER( DrawingWand ), [POINTER( DrawingWand )] ),
( 'DrawAllocateWand', POINTER( DrawingWand ), [POINTER( DrawInfo ), POINTER( Image )] ),
( 'NewDrawingWand', POINTER( DrawingWand ), [] ),
( 'DrawGetClipRule', FillRule, [POINTER( DrawingWand )] ),
( 'DrawGetFillRule', FillRule, [POINTER( DrawingWand )] ),
( 'DrawGetGravity', GravityType, [POINTER( DrawingWand )] ),
( 'DrawGetStrokeLineCap', LineCap, [POINTER( DrawingWand )] ),
( 'DrawGetStrokeLineJoin', LineJoin, [POINTER( DrawingWand )] ),
( 'DrawClearException', MagickBooleanType, [POINTER( DrawingWand )] ),
( 'DrawComposite', MagickBooleanType, [POINTER( DrawingWand ), CompositeOperator, c_double, c_double, c_double, c_double, POINTER( MagickWand )] ),
( 'DrawGetStrokeAntialias', MagickBooleanType, [POINTER( DrawingWand )] ),
( 'DrawGetTextAntialias', MagickBooleanType, [POINTER( DrawingWand )] ),
( 'DrawPopPattern', MagickBooleanType, [POINTER( DrawingWand )] ),
( 'DrawPushPattern', MagickBooleanType, [POINTER( DrawingWand ), STRING, c_double, c_double, c_double, c_double] ),
( 'DrawRender', MagickBooleanType, [POINTER( DrawingWand )] ),
( 'DrawSetClipPath', MagickBooleanType, [POINTER( DrawingWand ), STRING] ),
( 'DrawSetFillPatternURL', MagickBooleanType, [POINTER( DrawingWand ), STRING] ),
( 'DrawSetFont', MagickBooleanType, [POINTER( DrawingWand ), STRING] ),
( 'DrawSetFontFamily', MagickBooleanType, [POINTER( DrawingWand ), STRING] ),
( 'DrawSetStrokeDashArray', MagickBooleanType, [POINTER( DrawingWand ), c_ulong, POINTER( c_double )] ),
( 'DrawSetStrokePatternURL', MagickBooleanType, [POINTER( DrawingWand ), STRING] ),
( 'DrawSetVectorGraphics', MagickBooleanType, [POINTER( DrawingWand ), STRING] ),
( 'IsDrawingWand', MagickBooleanType, [POINTER( DrawingWand )] ),
( 'PopDrawingWand', MagickBooleanType, [POINTER( DrawingWand )] ),
( 'PushDrawingWand', MagickBooleanType, [POINTER( DrawingWand )] ),
( 'DrawGetFontStretch', StretchType, [POINTER( DrawingWand )] ),
( 'DrawGetFontStyle', StyleType, [POINTER( DrawingWand )] ),
( 'DrawGetFontWeight', c_ulong, [POINTER( DrawingWand )] ),
( 'DrawGetStrokeMiterLimit', c_ulong, [POINTER( DrawingWand )] ),
( 'ClearDrawingWand', None, [POINTER( DrawingWand )] ),
( 'DrawAffine', None, [POINTER( DrawingWand ), POINTER( AffineMatrix )] ),
( 'DrawAnnotation', None, [POINTER( DrawingWand ), c_double, c_double, POINTER( c_ubyte )] ),
( 'DrawArc', None, [POINTER( DrawingWand ), c_double, c_double, c_double, c_double, c_double, c_double] ),
( 'DrawBezier', None, [POINTER( DrawingWand ), c_ulong, POINTER( PointInfo )] ),
( 'DrawCircle', None, [POINTER( DrawingWand ), c_double, c_double, c_double, c_double] ),
( 'DrawColor', None, [POINTER( DrawingWand ), c_double, c_double, PaintMethod] ),
( 'DrawComment', None, [POINTER( DrawingWand ), STRING] ),
( 'DrawEllipse', None, [POINTER( DrawingWand ), c_double, c_double, c_double, c_double, c_double, c_double] ),
( 'DrawGetFillColor', None, [POINTER( DrawingWand ), POINTER( PixelWand )] ),
( 'DrawGetStrokeColor', None, [POINTER( DrawingWand ), POINTER( PixelWand )] ),
( 'DrawGetTextUnderColor', None, [POINTER( DrawingWand ), POINTER( PixelWand )] ),
( 'DrawLine', None, [POINTER( DrawingWand ), c_double, c_double, c_double, c_double] ),
( 'DrawMatte', None, [POINTER( DrawingWand ), c_double, c_double, PaintMethod] ),
( 'DrawPathClose', None, [POINTER( DrawingWand )] ),
( 'DrawPathCurveToAbsolute', None, [POINTER( DrawingWand ), c_double, c_double, c_double, c_double, c_double, c_double] ),
( 'DrawPathCurveToRelative', None, [POINTER( DrawingWand ), c_double, c_double, c_double, c_double, c_double, c_double] ),
( 'DrawPathCurveToQuadraticBezierAbsolute', None, [POINTER( DrawingWand ), c_double, c_double, c_double, c_double] ),
( 'DrawPathCurveToQuadraticBezierRelative', None, [POINTER( DrawingWand ), c_double, c_double, c_double, c_double] ),
( 'DrawPathCurveToQuadraticBezierSmoothAbsolute', None, [POINTER( DrawingWand ), c_double, c_double] ),
( 'DrawPathCurveToQuadraticBezierSmoothRelative', None, [POINTER( DrawingWand ), c_double, c_double] ),
( 'DrawPathCurveToSmoothAbsolute', None, [POINTER( DrawingWand ), c_double, c_double, c_double, c_double] ),
( 'DrawPathCurveToSmoothRelative', None, [POINTER( DrawingWand ), c_double, c_double, c_double, c_double] ),
( 'DrawPathEllipticArcAbsolute', None, [POINTER( DrawingWand ), c_double, c_double, c_double, MagickBooleanType, MagickBooleanType, c_double, c_double] ),
( 'DrawPathEllipticArcRelative', None, [POINTER( DrawingWand ), c_double, c_double, c_double, MagickBooleanType, MagickBooleanType, c_double, c_double] ),
( 'DrawPathFinish', None, [POINTER( DrawingWand )] ),
( 'DrawPathLineToAbsolute', None, [POINTER( DrawingWand ), c_double, c_double] ),
( 'DrawPathLineToRelative', None, [POINTER( DrawingWand ), c_double, c_double] ),
( 'DrawPathLineToHorizontalAbsolute', None, [POINTER( DrawingWand ), c_double] ),
( 'DrawPathLineToHorizontalRelative', None, [POINTER( DrawingWand ), c_double] ),
( 'DrawPathLineToVerticalAbsolute', None, [POINTER( DrawingWand ), c_double] ),
( 'DrawPathLineToVerticalRelative', None, [POINTER( DrawingWand ), c_double] ),
( 'DrawPathMoveToAbsolute', None, [POINTER( DrawingWand ), c_double, c_double] ),
( 'DrawPathMoveToRelative', None, [POINTER( DrawingWand ), c_double, c_double] ),
( 'DrawPathStart', None, [POINTER( DrawingWand )] ),
( 'DrawPoint', None, [POINTER( DrawingWand ), c_double, c_double] ),
( 'DrawPolygon', None, [POINTER( DrawingWand ), c_ulong, POINTER( PointInfo )] ),
( 'DrawPolyline', None, [POINTER( DrawingWand ), c_ulong, POINTER( PointInfo )] ),
( 'DrawPopClipPath', None, [POINTER( DrawingWand )] ),
( 'DrawPopDefs', None, [POINTER( DrawingWand )] ),
( 'DrawPushClipPath', None, [POINTER( DrawingWand ), STRING] ),
( 'DrawPushDefs', None, [POINTER( DrawingWand )] ),
( 'DrawRectangle', None, [POINTER( DrawingWand ), c_double, c_double, c_double, c_double] ),
( 'DrawRotate', None, [POINTER( DrawingWand ), c_double] ),
( 'DrawRoundRectangle', None, [POINTER( DrawingWand ), c_double, c_double, c_double, c_double, c_double, c_double] ),
( 'DrawScale', None, [POINTER( DrawingWand ), c_double, c_double] ),
( 'DrawSetClipRule', None, [POINTER( DrawingWand ), FillRule] ),
( 'DrawSetClipUnits', None, [POINTER( DrawingWand ), ClipPathUnits] ),
( 'DrawSetFillColor', None, [POINTER( DrawingWand ), POINTER( PixelWand )] ),
( 'DrawSetFillOpacity', None, [POINTER( DrawingWand ), c_double] ),
( 'DrawSetFillRule', None, [POINTER( DrawingWand ), FillRule] ),
( 'DrawSetFontSize', None, [POINTER( DrawingWand ), c_double] ),
( 'DrawSetFontStretch', None, [POINTER( DrawingWand ), StretchType] ),
( 'DrawSetFontStyle', None, [POINTER( DrawingWand ), StyleType] ),
( 'DrawSetFontWeight', None, [POINTER( DrawingWand ), c_ulong] ),
( 'DrawSetGravity', None, [POINTER( DrawingWand ), GravityType] ),
( 'DrawSetStrokeAntialias', None, [POINTER( DrawingWand ), MagickBooleanType] ),
( 'DrawSetStrokeColor', None, [POINTER( DrawingWand ), POINTER( PixelWand )] ),
( 'DrawSetStrokeDashOffset', None, [POINTER( DrawingWand ), c_double] ),
( 'DrawSetStrokeLineCap', None, [POINTER( DrawingWand ), LineCap] ),
( 'DrawSetStrokeLineJoin', None, [POINTER( DrawingWand ), LineJoin] ),
( 'DrawSetStrokeMiterLimit', None, [POINTER( DrawingWand ), c_ulong] ),
( 'DrawSetStrokeOpacity', None, [POINTER( DrawingWand ), c_double] ),
( 'DrawSetStrokeWidth', None, [POINTER( DrawingWand ), c_double] ),
( 'DrawSetTextAlignment', None, [POINTER( DrawingWand ), AlignType] ),
( 'DrawSetTextAntialias', None, [POINTER( DrawingWand ), MagickBooleanType] ),
( 'DrawSetTextDecoration', None, [POINTER( DrawingWand ), DecorationType] ),
( 'DrawSetTextEncoding', None, [POINTER( DrawingWand ), STRING] ),
( 'DrawSetTextUnderColor', None, [POINTER( DrawingWand ), POINTER( PixelWand )] ),
( 'DrawSetViewbox', None, [POINTER( DrawingWand ), c_ulong, c_ulong, c_ulong, c_ulong] ),
( 'DrawSkewX', None, [POINTER( DrawingWand ), c_double] ),
( 'DrawSkewY', None, [POINTER( DrawingWand ), c_double] ),
( 'DrawTranslate', None, [POINTER( DrawingWand ), c_double, c_double] ),
( 'IdentifyImageCommand', MagickBooleanType, [POINTER( ImageInfo ), c_int, POINTER( STRING ), POINTER( STRING ), POINTER( ExceptionInfo )] ),
( 'ImportImageCommand', MagickBooleanType, [POINTER( ImageInfo ), c_int, POINTER( STRING ), POINTER( STRING ), POINTER( ExceptionInfo )] ),
( 'MogrifyImage', MagickBooleanType, [POINTER( ImageInfo ), c_int, POINTER( STRING ), POINTER( POINTER( Image ) ), POINTER( ExceptionInfo )] ),
( 'MogrifyImageCommand', MagickBooleanType, [POINTER( ImageInfo ), c_int, POINTER( STRING ), POINTER( STRING ), POINTER( ExceptionInfo )] ),
( 'MogrifyImageInfo', MagickBooleanType, [POINTER( ImageInfo ), c_int, POINTER( STRING ), POINTER( ExceptionInfo )] ),
( 'MogrifyImageList', MagickBooleanType, [POINTER( ImageInfo ), c_int, POINTER( STRING ), POINTER( POINTER( Image ) ), POINTER( ExceptionInfo )] ),
( 'MogrifyImages', MagickBooleanType, [POINTER( ImageInfo ), c_int, POINTER( STRING ), POINTER( POINTER( Image ) ), POINTER( ExceptionInfo )] ),
( 'MontageImageCommand', MagickBooleanType, [POINTER( ImageInfo ), c_int, POINTER( STRING ), POINTER( STRING ), POINTER( ExceptionInfo )] ),
( 'PixelGetIteratorException', STRING, [POINTER( PixelIterator ), POINTER( ExceptionType )] ),
( 'IsPixelIterator', MagickBooleanType, [POINTER( PixelIterator )] ),
( 'PixelClearIteratorException', MagickBooleanType, [POINTER( PixelIterator )] ),
( 'PixelSetIteratorRow', MagickBooleanType, [POINTER( PixelIterator ), c_long] ),
( 'PixelSyncIterator', MagickBooleanType, [POINTER( PixelIterator )] ),
( 'DestroyPixelIterator', POINTER( PixelIterator ), [POINTER( PixelIterator )] ),
( 'NewPixelIterator', POINTER( PixelIterator ), [POINTER( MagickWand )] ),
( 'NewPixelRegionIterator', POINTER( PixelIterator ), [POINTER( MagickWand ), c_long, c_long, c_ulong, c_ulong] ),
]
