/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.maps;

import org.brunel.maps.Point;
import org.brunel.maps.Rect;

abstract class Projection {
    Projection() {
    }

    private static double asRadians(double lon) {
        return Math.toRadians(lon);
    }

    public double getTissotArea(Point p) {
        double h = 5.0E-4;
        double dx = Math.abs(this.transform((Point)p.translate((double)(-h), (double)0.0)).x - this.transform((Point)p.translate((double)h, (double)0.0)).x);
        double dy = Math.abs(this.transform((Point)p.translate((double)0.0, (double)(-h))).y - this.transform((Point)p.translate((double)0.0, (double)h)).y);
        return dx * dy;
    }

    public abstract Point transform(Point var1);

    public abstract Point inverse(Point var1);

    public Rect projectedExtent(Rect b) {
        Rect bounds = null;
        for (Point pt : b.makeBoundaryPoints()) {
            Point p = this.transform(pt);
            bounds = bounds == null ? new Rect(p.x, p.x, p.y, p.y) : bounds.union(p);
        }
        return bounds;
    }

    public static final class Albers
    extends Projection {
        private final double sin1;
        private final double sin2;
        private final double n;
        private final double C;
        private final double r1;
        private final double rotation;

        public Albers(double parallelA, double parallelB, double rotation) {
            this.rotation = rotation;
            double s1 = Projection.asRadians(parallelA);
            double s2 = Projection.asRadians(parallelB);
            this.sin1 = Math.sin(s1);
            this.sin2 = Math.sin(s2);
            this.n = (this.sin1 + this.sin2) / 2.0;
            this.C = 1.0 + this.sin1 * (2.0 * this.n - this.sin1);
            this.r1 = Math.sqrt(this.C) / this.n;
        }

        @Override
        public Point transform(Point p) {
            double a = Projection.asRadians(p.x + this.rotation);
            double b = Projection.asRadians(p.y);
            double r = Math.sqrt(this.C - 2.0 * this.n * Math.sin(b)) / this.n;
            return new Point(r * Math.sin(a * this.n), this.r1 - r * Math.cos(a * this.n));
        }

        @Override
        public Point inverse(Point p) {
            double r1y = this.r1 - p.y;
            double lon = Math.atan2(p.x, r1y) / this.n;
            double v = (this.C - (p.x * p.x + r1y * r1y) * this.n * this.n) / (2.0 * this.n);
            double lat = Math.asin(Math.min(1.0, Math.max(-1.0, v)));
            return new Point(Math.toDegrees(lon) - this.rotation, Math.toDegrees(lat));
        }
    }

    public static final class WinkelTripel
    extends Projection {
        @Override
        public Point transform(Point p) {
            double x = Projection.asRadians(p.x);
            double y = Projection.asRadians(p.y);
            double a = Math.acos(Math.cos(y) * Math.cos(x / 2.0));
            double sinca = Math.abs(a) < 1.0E-6 ? 1.0 : Math.sin(a) / a;
            return new Point(Math.cos(y) * Math.sin(x / 2.0) / sinca + x / Math.PI, (Math.sin(y) * sinca + y) / 2.0);
        }

        @Override
        public Point inverse(Point p) {
            throw new UnsupportedOperationException("Inverse not available for Winkel Triple");
        }
    }

    public static final class Mercator
    extends Projection {
        @Override
        public Point transform(Point p) {
            double a = Projection.asRadians(p.x);
            double b = Projection.asRadians(p.y);
            return new Point(a, Math.log(Math.tan(0.7853981633974483 + b / 2.0)));
        }

        @Override
        public Point inverse(Point p) {
            double a = Math.toDegrees(p.x);
            double b = Math.toDegrees(2.0 * Math.atan(Math.exp(p.y)) - 1.5707963267948966);
            return new Point(a, b);
        }
    }
}

