/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.maps;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.brunel.maps.Point;
import org.brunel.maps.Rect;

public class PointCollection {
    private final Set<Point> points = new HashSet<Point>();
    private Rect bounds;
    private Point[] hull;

    public void add(double x, double y) {
        this.points.add(new Point(x, y));
    }

    public Rect bounds() {
        if (this.bounds == null) {
            this.build();
        }
        return this.bounds;
    }

    private void build() {
        this.makeConvexHull();
        this.bounds = this.makeBounds();
        this.points.clear();
        Collections.addAll(this.points, this.hull);
    }

    private void makeConvexHull() {
        int i;
        Point[] points = this.sortedPoints();
        Stack<Point> stack = new Stack<Point>();
        if (points.length == 0) {
            this.hull = new Point[0];
            return;
        }
        Point p0 = points[0];
        stack.push(p0);
        int N = points.length;
        Arrays.sort(points, 1, N, new PolarComparator(p0));
        for (i = 1; i < N && p0.equals(points[i]); ++i) {
        }
        if (i == N) {
            return;
        }
        Point p1 = points[i];
        ++i;
        while (i < N && Point.ccw(p0, p1, points[i]) == 0) {
            ++i;
        }
        stack.push(points[i - 1]);
        while (i < N) {
            Point top = (Point)stack.pop();
            while (Point.ccw((Point)stack.peek(), top, points[i]) <= 0) {
                top = (Point)stack.pop();
            }
            stack.push(top);
            stack.push(points[i]);
            ++i;
        }
        this.hull = stack.toArray(new Point[stack.size()]);
        if (!this.isConvex()) {
            throw new IllegalStateException("NOT CONVEX!");
        }
    }

    private Rect makeBounds() {
        Rect bounds = null;
        for (Point p : this.hull) {
            bounds = bounds == null ? new Rect(p.x, p.x, p.y, p.y) : bounds.union(p);
        }
        return bounds;
    }

    private Point[] sortedPoints() {
        Object[] pts = this.points.toArray(new Point[this.points.size()]);
        Arrays.sort(pts);
        return pts;
    }

    private boolean isConvex() {
        int N = this.hull.length;
        if (N <= 2) {
            return true;
        }
        for (int i = 0; i < N; ++i) {
            if (Point.ccw(this.hull[i], this.hull[(i + 1) % N], this.hull[(i + 2) % N]) > 0) continue;
            return false;
        }
        return true;
    }

    public Point[] convexHull() {
        if (this.hull == null) {
            this.build();
        }
        return this.hull;
    }

    public boolean isEmpty() {
        return this.points.isEmpty();
    }

    private class PolarComparator
    implements Comparator<Point> {
        private final Point p;

        public PolarComparator(Point p) {
            this.p = p;
        }

        @Override
        public int compare(Point q1, Point q2) {
            return -Point.ccw(this.p, q1, q2);
        }
    }
}

