/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.maps;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.brunel.maps.GeoFile;
import org.brunel.maps.Rect;

class GeoFileGroup {
    private static final int MAX_FILES = 3;
    public final Set<GeoFile> files;
    private final Map<GeoFile, List<Object>> itemsMap;
    private final int requiredContentCount;
    private final Set<Object> content;
    private Rect totalBounds;

    public static GeoFileGroup makeEmpty(Map<GeoFile, List<Object>> containedItems) {
        HashSet<Object> all = new HashSet<Object>();
        for (List<Object> f : containedItems.values()) {
            all.addAll(f);
        }
        return new GeoFileGroup(all.size(), containedItems, Collections.emptySet(), Collections.emptySet());
    }

    private GeoFileGroup(int requiredCount, Map<GeoFile, List<Object>> itemsMap, Collection<GeoFile> files, Collection<?> features) {
        this.requiredContentCount = requiredCount;
        this.itemsMap = itemsMap;
        this.files = new LinkedHashSet<GeoFile>(files);
        this.content = new HashSet(features);
    }

    public GeoFileGroup add(GeoFile file) {
        if (this.files.contains(file)) {
            return null;
        }
        HashSet<Object> combinedFeatures = new HashSet<Object>(this.content);
        if (!combinedFeatures.addAll((Collection<Object>)this.itemsMap.get(file))) {
            return null;
        }
        HashSet<GeoFile> combinedFiles = new HashSet<GeoFile>(this.files);
        combinedFiles.add(file);
        return new GeoFileGroup(this.requiredContentCount, this.itemsMap, combinedFiles, combinedFeatures);
    }

    public boolean cannotImprove(GeoFileGroup best, int maxFeaturesPerFile) {
        if (this.content.size() == this.requiredContentCount) {
            return true;
        }
        if (this.files.size() == 3) {
            return true;
        }
        int upperFeatureBound = this.content.size() + (3 - this.files.size()) * maxFeaturesPerFile;
        return upperFeatureBound < best.content.size();
    }

    public boolean isBetter(GeoFileGroup o) {
        double otherScore;
        if (o == this) {
            return false;
        }
        int d = this.content.size() - o.content.size();
        if (d < 0) {
            return false;
        }
        if (d > 0) {
            return true;
        }
        double myScore = this.area() * (double)(1 + this.files.size());
        return myScore < (otherScore = o.area() * (double)(1 + o.files.size()));
    }

    private double area() {
        if (this.files.isEmpty()) {
            return 0.0;
        }
        if (this.totalBounds == null) {
            for (GeoFile f : this.files) {
                this.totalBounds = f.bounds.union(this.totalBounds);
            }
        }
        return this.totalBounds.area();
    }

    public String toString() {
        return this.files + ":" + this.content.size() + "/" + this.requiredContentCount;
    }
}

