/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.util;

import org.brunel.build.util.ModelUtil;
import org.brunel.model.VisSingle;
import org.brunel.model.VisTypes;

public class ElementDetails {
    public final boolean splitIntoShapes;
    public final String colorAttribute;
    public final String dataSource;
    public final boolean producesPath;
    public final String elementType;
    public final String classes;
    public final String textMethod;
    public final boolean textMustFit;
    public boolean needsStrokeSize;

    public static ElementDetails makeForDiagram(String dataSource, String elementType, String elementClass, String textMethod, boolean textFits) {
        return new ElementDetails(dataSource, elementType, elementClass, textMethod, textFits);
    }

    public static ElementDetails makeForCoordinates(VisSingle vis, String symbol) {
        return new ElementDetails(vis, symbol);
    }

    private ElementDetails(VisSingle vis, String symbol) {
        VisTypes.Element element = vis.tElement;
        String classList = "element " + element.name();
        boolean filled = element.filled;
        if (!(vis.fSize.isEmpty() || element != VisTypes.Element.line && element != VisTypes.Element.path)) {
            filled = true;
            classList = classList + " filled";
        }
        this.classes = "'" + classList + "'";
        this.splitIntoShapes = element.producesSingleShape;
        this.colorAttribute = "'" + (filled ? "fill" : "stroke") + "'";
        this.dataSource = element.producesSingleShape ? "splits" : "data._rows";
        boolean bl = this.producesPath = element.producesSingleShape || element == VisTypes.Element.bar && vis.coords == VisTypes.Coordinates.polar;
        this.elementType = this.producesPath ? "path" : (element == VisTypes.Element.edge ? "line" : (element == VisTypes.Element.text ? "text" : (element == VisTypes.Element.bar ? "rect" : ("rect".equals(symbol) ? "rect" : "circle"))));
        String textLocation = ModelUtil.getLabelPosition(vis);
        this.textMethod = textLocation != null ? textLocation : (this.producesPath ? (element == VisTypes.Element.bar ? "wedge" : (element == VisTypes.Element.area ? "area" : (filled ? "poly" : "path"))) : (this.elementType.equals("circle") ? "right" : "box"));
        this.textMustFit = filled && element != VisTypes.Element.point || "box".equals(textLocation);
        this.needsStrokeSize = !vis.fSize.isEmpty() && vis.tElement == VisTypes.Element.edge;
    }

    private ElementDetails(String dataSource, String elementType, String elementClass, String textMethod, boolean textFits) {
        this.splitIntoShapes = false;
        this.colorAttribute = "fill";
        this.dataSource = dataSource;
        this.producesPath = false;
        this.elementType = elementType;
        this.classes = "'element " + elementClass + "'";
        this.textMethod = textMethod;
        this.textMustFit = textFits;
    }

    public ElementDetails modifyForTooltip(boolean transposed) {
        String method;
        String string = method = this.textMethod.equals("box") ? "top" : this.textMethod;
        if (method.equals("left") || method.equals("right")) {
            method = "top";
        }
        if (transposed) {
            if (method.equals("top")) {
                method = "left";
            }
            if (method.equals("bottom")) {
                method = "right";
            }
        }
        return ElementDetails.makeForDiagram(this.dataSource, this.elementType, "point", method, false);
    }
}

