/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.d3.diagrams;

import org.brunel.build.d3.D3Util;
import org.brunel.build.d3.ElementDefinition;
import org.brunel.build.d3.diagrams.D3Diagram;
import org.brunel.build.util.ElementDetails;
import org.brunel.build.util.PositionFields;
import org.brunel.build.util.ScriptWriter;
import org.brunel.data.Dataset;
import org.brunel.maps.GeoAnalysis;
import org.brunel.maps.GeoMapping;
import org.brunel.maps.GeoProjection;
import org.brunel.maps.PointCollection;
import org.brunel.maps.Rect;
import org.brunel.model.VisSingle;

public class GeoMap
extends D3Diagram {
    private final String idField;
    private final GeoMapping mapping;

    public static GeoMapping makeMapping(VisSingle vis, Dataset data, PositionFields positions) {
        String idField = GeoMap.getIDField(vis);
        if (idField != null) {
            return GeoAnalysis.instance().make(data.field(idField).categories(), vis.tDiagramParameters);
        }
        PointCollection p = positions.getAllPoints();
        return GeoAnalysis.instance().makeForPoints(p, vis.tDiagramParameters);
    }

    public GeoMap(VisSingle vis, Dataset data, PositionFields positions, ScriptWriter out) {
        super(vis, data, out);
        this.idField = GeoMap.getIDField(vis);
        this.mapping = GeoMap.makeMapping(vis, data, positions);
        if (this.mapping == null) {
            throw new IllegalStateException("Maps need either a position field or key with the feature names; or another element to define positions");
        }
    }

    private static String getIDField(VisSingle vis) {
        if (vis.fKeys.isEmpty()) {
            if (vis.positionFields().length == 0) {
                return null;
            }
            return vis.positionFields()[0];
        }
        return vis.fKeys.get(0).asField();
    }

    public static void writeProjection(ScriptWriter out, Rect bounds) {
        out.comment("Define the projection");
        GeoProjection projection = new GeoProjection("geom.inner_width", "geom.inner_height", "winkel3");
        String[] projectionDescription = projection.makeProjection(bounds).split("\n");
        out.indentMore();
        out.add("var ");
        out.indentMore();
        if (projectionDescription[0].contains("winkel3")) {
            String[] strings = GeoProjection.WinkelD3Function;
            out.add("winkel3 =", strings[0]);
            out.indentMore();
            for (int i = 1; i < strings.length; ++i) {
                out.onNewLine().add(strings[i]);
            }
            out.add(",").onNewLine();
            out.indentLess();
        }
        out.add("projection =", projectionDescription[0].trim());
        out.indentMore();
        for (int i = 1; i < projectionDescription.length; ++i) {
            out.onNewLine().add(projectionDescription[i].trim());
        }
        out.add(",").onNewLine();
        out.indentLess();
        out.add("zoom = d3.behavior.zoom()").addChained("scale(projection.scale()).translate(projection.translate())").addChained("on('zoom', function() {").onNewLine();
        out.indentMore();
        out.add("projection.translate(zoom.translate()).scale(zoom.scale())").endStatement();
        out.add("rebuildSystem(0)").endStatement();
        out.indentLess().add("})");
        out.endStatement();
        out.indentLess();
        out.add("vis.call(zoom)").endStatement();
    }

    @Override
    public void writeDiagramEnter() {
        super.writeDiagramEnter();
    }

    @Override
    public ElementDetails writeDataConstruction() {
        this.out.add("var path = d3.geo.path().projection(projection)").endStatement();
        this.out.indentLess();
        this.out.comment("Read in the feature data and call build again when done");
        this.writeFeatureHookup(this.mapping, this.idField);
        return ElementDetails.makeForDiagram("data._rows", "path", "polygon", "geo", false);
    }

    private void writeFeatureHookup(GeoMapping mapping, String idField) {
        if (mapping.fileCount() == 0) {
            throw new IllegalStateException("No suitable map found");
        }
        this.out.add("var features = ");
        GeoAnalysis.writeMapping(this.out, mapping);
        this.out.endStatement();
        String idName = idField == null ? "null" : "data." + D3Util.canonicalFieldName(idField);
        this.out.add("if (BrunelD3.addFeatures(data, features,", idName, ", this, transitionMillis)) return").endStatement();
    }

    @Override
    public void writeDefinition(ElementDetails details, ElementDefinition elementDef) {
        this.out.addChained("attr('d', path )").endStatement();
        this.addAestheticsAndTooltips(details, true);
    }

    @Override
    public void writePreDefinition(ElementDetails details, ElementDefinition elementDef) {
        this.out.add("selection.classed('nondata', function(d) {return !d || d.row == null})").endStatement();
    }
}

