/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build;

import java.util.LinkedHashSet;
import java.util.Set;
import org.brunel.build.d3.D3Util;
import org.brunel.data.Field;
import org.brunel.model.VisSingle;
import org.brunel.model.VisTypes;

public class ElementDependency {
    public final int sourceIndex;
    private final Set<VisSingle> linked = new LinkedHashSet<VisSingle>();
    private final VisSingle[] elements;
    private boolean usesMapProjection;

    public ElementDependency(VisSingle[] elements) {
        this.elements = elements;
        int src = -1;
        for (int i = 0; i < elements.length; ++i) {
            VisSingle v = elements[i];
            if (v.fKeys.isEmpty()) continue;
            if (v.positionFields().length > 0 || v.tDiagram != null) {
                if (src < 0) {
                    src = i;
                }
            } else {
                this.linked.add(v);
            }
            if (v.tDiagram != VisTypes.Diagram.map) continue;
            this.usesMapProjection = true;
        }
        if (src < 0) {
            this.linked.clear();
        }
        this.sourceIndex = src;
    }

    public VisSingle getEdgeElement() {
        for (VisSingle v : this.linked) {
            if (v.fKeys.size() != 2) continue;
            return v;
        }
        return null;
    }

    public boolean isDependent(VisSingle vis) {
        return this.linked.contains(vis);
    }

    public boolean isEdge(VisSingle vis) {
        return this.getEdgeElement() == vis && this.elements[this.sourceIndex].tDiagram == VisTypes.Diagram.network;
    }

    public String keyedLocation(String dimName, Field key) {
        String idToPointName = "elements[" + this.sourceIndex + "].internal()._idToPoint(";
        return idToPointName + D3Util.writeCall(key) + ")." + dimName;
    }

    public VisSingle sourceElement() {
        return this.sourceIndex < 0 ? null : this.elements[this.sourceIndex];
    }

    public String linkedDataReference(VisSingle other) {
        for (int i = 0; i < this.elements.length; ++i) {
            if (this.elements[i] != other) continue;
            return "elements[" + i + "].data()";
        }
        throw new IllegalStateException("Could not find other VisSingle element");
    }
}

