from distutils.core import setup

setup(name='met',
	version='0.1.5.0',
	description="Multinomial Exact Tests",
	author='Dreas Nielsen',
	author_email='dnielsen@integral-corp.com',
    url='none',
	py_modules=['met/met'],
    license='GPL',
	classifiers=[
		'Intended Audience :: End Users/Desktop',
		'Programming Language :: Python',
		'License :: OSI Approved :: GNU General Public License (GPL)',
		'Operating System :: OS Independent',
		'Topic :: Office/Business'
          ],
	long_description="""``met.py`` is a Python module that allows you to define a pair of
multinomial distributions (conceptually 'control' and 'test' or
'reference' and 'site' distributions) and then compute one- and
two-sided p values to test whether the 'site' distribution is equivalent
to the 'reference' distribution. The likelihood of all possible
'reference' distributions can be evaluated and the distribution of *p*
values can be expressed in terms of the likelihood of the observed
'reference' distribution.

The ``met`` module defines one class, one exception, and several
functions.  The class (``Multinom``) defines objects that represent
specific combinations of multinomial data for site and reference
conditions.  Methods of ``Multinom`` objects allow one-sided and two-sided
exact tests to be performed.  Attributes of ``Multinom`` objects allow
access to additional information generated by the exact tests, such as
the number of different rearrangements of site data that were found to
be more extreme than the reference data.

Functions in the ``met`` module allow *p* values to be calculated for a
variety of reference probability distributions that might have produced
the observed reference data, producing a likelihood estimate for each
*p* value.
"""
	)
