import re

# Global Variables
__all__ = [
    "MIMETYPE_REGEX",
    "MIMETYPE_DOMAINS",
    "EXTENSION_TO_MIMETYPE"
]
MIMETYPE_REGEX = re.compile(b"^([^/]+)/([^/]+)$")
EXTENSION_TO_MIMETYPE = {
    ".3dm":         [b"x-world/x-3dmf"],
    ".3dmf":        [b"x-world/x-3dmf"],
    ".a":           [b"application/octet-stream"],
    ".aab":         [b"application/x-authorware-bin"],
    ".aam":         [b"application/x-authorware-map"],
    ".aas":         [b"application/x-authorware-seg"],
    ".abc":         [b"text/vnd.abc"],
    ".acgi":        [b"text/html"],
    ".afl":         [b"video/animaflex"],
    ".ai":          [b"application/postscript"],
    ".aif":         [b"audio/x-aiff"],
    ".aifc":        [b"audio/x-aiff"],
    ".aiff":        [b"audio/x-aiff"],
    ".aim":         [b"application/x-aim"],
    ".aip":         [b"text/x-audiosoft-intra"],
    ".ani":         [b"application/x-navi-animation"],
    ".aos":         [b"application/x-nokia-9000-communicator-add-on-software"],
    ".aps":         [b"application/mime"],
    ".arc":         [b"application/octet-stream"],
    ".arj":         [b"application/octet-stream"],
    ".art":         [b"image/x-jg"],
    ".asf":         [b"video/x-ms-asf"],
    ".asm":         [b"text/x-asm"],
    ".asp":         [b"text/asp"],
    ".asx":         [b"video/x-ms-asf-plugin"],
    ".au":          [b"audio/x-au"],
    ".avi":         [b"video/x-msvideo"],
    ".avs":         [b"video/avs-video"],
    ".bcpio":       [b"application/x-bcpio"],
    ".bin":         [b"application/x-macbinary"],
    ".bm":          [b"image/bmp"],
    ".bmp":         [b"image/x-windows-bmp"],
    ".boo":         [b"application/book"],
    ".book":        [b"application/book"],
    ".boz":         [b"application/x-bzip2"],
    ".bsh":         [b"application/x-bsh"],
    ".bz":          [b"application/x-bzip"],
    ".bz2":         [b"application/x-bzip2"],
    ".c":           [b"text/x-c"],
    ".c++":         [b"text/plain"],
    ".cat":         [b"application/vnd.ms-pki.seccat"],
    ".cc":          [b"text/x-c"],
    ".ccad":        [b"application/clariscad"],
    ".cco":         [b"application/x-cocoa"],
    ".cdf":         [b"application/x-netcdf"],
    ".cer":         [b"application/x-x509-ca-cert"],
    ".cha":         [b"application/x-chat"],
    ".chat":        [b"application/x-chat"],
    ".class":       [b"application/x-java-class"],
    ".com":         [b"text/plain"],
    ".conf":        [b"text/plain"],
    ".cpio":        [b"application/x-cpio"],
    ".cpp":         [b"text/x-c"],
    ".cpt":         [b"application/x-cpt"],
    ".crl":         [b"application/pkix-crl"],
    ".crt":         [b"application/x-x509-user-cert"],
    ".csh":         [b"text/x-script.csh"],
    ".css":         [b"text/css"],
    ".cxx":         [b"text/plain"],
    ".dcr":         [b"application/x-director"],
    ".deepv":       [b"application/x-deepv"],
    ".def":         [b"text/plain"],
    ".der":         [b"application/x-x509-ca-cert"],
    ".dif":         [b"video/x-dv"],
    ".dir":         [b"application/x-director"],
    ".dl":          [b"video/x-dl"],
    ".doc":         [b"application/msword"],
    ".dot":         [b"application/msword"],
    ".dp":          [b"application/commonground"],
    ".drw":         [b"application/drafting"],
    ".dump":        [b"application/octet-stream"],
    ".dv":          [b"video/x-dv"],
    ".dvi":         [b"application/x-dvi"],
    ".dwf":         [b"model/vnd.dwf"],
    ".dwg":         [b"image/x-dwg"],
    ".dxf":         [b"image/x-dwg"],
    ".dxr":         [b"application/x-director"],
    ".el":          [b"text/x-script.elisp"],
    ".elc":         [b"application/x-elc"],
    ".env":         [b"application/x-envoy"],
    ".eps":         [b"application/postscript"],
    ".es":          [b"application/x-esrehber"],
    ".etx":         [b"text/x-setext"],
    ".evy":         [b"application/x-envoy"],
    ".exe":         [b"application/octet-stream"],
    ".f":           [b"text/x-fortran"],
    ".f77":         [b"text/x-fortran"],
    ".f90":         [b"text/x-fortran"],
    ".fdf":         [b"application/vnd.fdf"],
    ".fif":         [b"image/fif"],
    ".fli":         [b"video/x-fli"],
    ".flo":         [b"image/florian"],
    ".flx":         [b"text/vnd.fmi.flexstor"],
    ".fmf":         [b"video/x-atomic3d-feature"],
    ".for":         [b"text/x-fortran"],
    ".fpx":         [b"image/vnd.net-fpx"],
    ".frl":         [b"application/freeloader"],
    ".funk":        [b"audio/make"],
    ".g":           [b"text/plain"],
    ".g3":          [b"image/g3fax"],
    ".gif":         [b"image/gif"],
    ".gl":          [b"video/x-gl"],
    ".gsd":         [b"audio/x-gsm"],
    ".gsm":         [b"audio/x-gsm"],
    ".gsp":         [b"application/x-gsp"],
    ".gss":         [b"application/x-gss"],
    ".gtar":        [b"application/x-gtar"],
    ".gz":          [b"application/x-gzip"],
    ".gzip":        [b"multipart/x-gzip"],
    ".h":           [b"text/x-h"],
    ".hdf":         [b"application/x-hdf"],
    ".help":        [b"application/x-helpfile"],
    ".hgl":         [b"application/vnd.hp-hpgl"],
    ".hh":          [b"text/x-h"],
    ".hlb":         [b"text/x-script"],
    ".hlp":         [b"application/x-winhelp"],
    ".hpg":         [b"application/vnd.hp-hpgl"],
    ".hpgl":        [b"application/vnd.hp-hpgl"],
    ".hqx":         [b"application/x-mac-binhex40"],
    ".hta":         [b"application/hta"],
    ".htc":         [b"text/x-component"],
    ".htm":         [b"text/html"],
    ".html":        [b"text/html"],
    ".htmls":       [b"text/html"],
    ".htt":         [b"text/webviewhtml"],
    ".htx":         [b"text/html"],
    ".ice":         [b"x-conference/x-cooltalk"],
    ".ico":         [b"image/x-icon"],
    ".idc":         [b"text/plain"],
    ".ief":         [b"image/ief"],
    ".iefs":        [b"image/ief"],
    ".iges":        [b"model/iges"],
    ".igs":         [b"model/iges"],
    ".ima":         [b"application/x-ima"],
    ".imap":        [b"application/x-httpd-imap"],
    ".inf":         [b"application/inf"],
    ".ins":         [b"application/x-internett-signup"],
    ".ip":          [b"application/x-ip2"],
    ".isu":         [b"video/x-isvideo"],
    ".it":          [b"audio/it"],
    ".iv":          [b"application/x-inventor"],
    ".ivr":         [b"i-world/i-vrml"],
    ".ivy":         [b"application/x-livescreen"],
    ".jam":         [b"audio/x-jam"],
    ".jav":         [b"text/x-java-source"],
    ".java":        [b"text/x-java-source"],
    ".jcm":         [b"application/x-java-commerce"],
    ".jfif":        [b"image/pjpeg"],
    ".jfif-tbnl":   [b"image/jpeg"],
    ".jpe":         [b"image/pjpeg"],
    ".jpeg":        [b"image/pjpeg"],
    ".jpg":         [b"image/pjpeg"],
    ".jps":         [b"image/x-jps"],
    ".js":          [b"text/javascript", b"application/javascript", b"text/emcascript", b"application/emcascript"],
    ".json":        [b"application/json", b"text/json"],
    ".jut":         [b"image/jutvision"],
    ".kar":         [b"music/x-karaoke"],
    ".ksh":         [b"text/x-script.ksh"],
    ".la":          [b"audio/x-nspaudio"],
    ".lam":         [b"audio/x-liveaudio"],
    ".latex":       [b"application/x-latex"],
    ".lha":         [b"application/x-lha"],
    ".lhx":         [b"application/octet-stream"],
    ".list":        [b"text/plain"],
    ".lma":         [b"audio/x-nspaudio"],
    ".log":         [b"text/plain"],
    ".lsp":         [b"text/x-script.lisp"],
    ".lst":         [b"text/plain"],
    ".lsx":         [b"text/x-la-asf"],
    ".ltx":         [b"application/x-latex"],
    ".lzh":         [b"application/x-lzh"],
    ".lzx":         [b"application/x-lzx"],
    ".m":           [b"text/x-m"],
    ".m1v":         [b"video/mpeg"],
    ".m2a":         [b"audio/mpeg"],
    ".m2v":         [b"video/mpeg"],
    ".m3u":         [b"audio/x-mpequrl"],
    ".man":         [b"application/x-troff-man"],
    ".map":         [b"application/x-navimap"],
    ".mar":         [b"text/plain"],
    ".mbd":         [b"application/mbedlet"],
    ".mc$":         [b"application/x-magic-cap-package-1.0"],
    ".mcd":         [b"application/x-mathcad"],
    ".mcf":         [b"text/mcf"],
    ".mcp":         [b"application/netmc"],
    ".me":          [b"application/x-troff-me"],
    ".mht":         [b"message/rfc822"],
    ".mhtml":       [b"message/rfc822"],
    ".mid":         [b"x-music/x-midi"],
    ".midi":        [b"x-music/x-midi"],
    ".mif":         [b"application/x-mif"],
    ".mime":        [b"www/mime"],
    ".mjf":         [b"audio/x-vnd.audioexplosion.mjuicemediafile"],
    ".mjpg":        [b"video/x-motion-jpeg"],
    ".mm":          [b"application/x-meme"],
    ".mme":         [b"application/base64"],
    ".mod":         [b"audio/x-mod"],
    ".moov":        [b"video/quicktime"],
    ".mov":         [b"video/quicktime"],
    ".movie":       [b"video/x-sgi-movie"],
    ".mp2":         [b"video/x-mpeq2a"],
    ".mp3":         [b"video/x-mpeg"],
    ".mpa":         [b"video/mpeg"],
    ".mpc":         [b"application/x-project"],
    ".mpe":         [b"video/mpeg"],
    ".mpeg":        [b"video/mpeg"],
    ".mpg":         [b"video/mpeg"],
    ".mpga":        [b"audio/mpeg"],
    ".mpp":         [b"application/vnd.ms-project"],
    ".mpt":         [b"application/x-project"],
    ".mpv":         [b"application/x-project"],
    ".mpx":         [b"application/x-project"],
    ".mrc":         [b"application/marc"],
    ".ms":          [b"application/x-troff-ms"],
    ".mv":          [b"video/x-sgi-movie"],
    ".my":          [b"audio/make"],
    ".mzz":         [b"application/x-vnd.audioexplosion.mzz"],
    ".nap":         [b"image/naplps"],
    ".naplps":      [b"image/naplps"],
    ".nc":          [b"application/x-netcdf"],
    ".ncm":         [b"application/vnd.nokia.configuration-message"],
    ".nif":         [b"image/x-niff"],
    ".niff":        [b"image/x-niff"],
    ".nix":         [b"application/x-mix-transfer"],
    ".nsc":         [b"application/x-conference"],
    ".nvd":         [b"application/x-navidoc"],
    ".o":           [b"application/octet-stream"],
    ".oda":         [b"application/oda"],
    ".omc":         [b"application/x-omc"],
    ".omcd":        [b"application/x-omcdatamaker"],
    ".omcr":        [b"application/x-omcregerator"],
    ".p":           [b"text/x-pascal"],
    ".p10":         [b"application/x-pkcs10"],
    ".p12":         [b"application/x-pkcs12"],
    ".p7a":         [b"application/x-pkcs7-signature"],
    ".p7c":         [b"application/x-pkcs7-mime"],
    ".p7m":         [b"application/x-pkcs7-mime"],
    ".p7r":         [b"application/x-pkcs7-certreqresp"],
    ".p7s":         [b"application/pkcs7-signature"],
    ".part":        [b"application/pro_eng"],
    ".pas":         [b"text/pascal"],
    ".pbm":         [b"image/x-portable-bitmap"],
    ".pcl":         [b"application/x-pcl"],
    ".pct":         [b"image/x-pict"],
    ".pcx":         [b"image/x-pcx"],
    ".pdb":         [b"chemical/x-pdb"],
    ".pdf":         [b"application/pdf"],
    ".pfunk":       [b"audio/make.my.funk"],
    ".pgm":         [b"image/x-portable-greymap"],
    ".pic":         [b"image/pict"],
    ".pict":        [b"image/pict"],
    ".pkg":         [b"application/x-newton-compatible-pkg"],
    ".pko":         [b"application/vnd.ms-pki.pko"],
    ".pl":          [b"text/x-script.perl"],
    ".plx":         [b"application/x-pixclscript"],
    ".pm":          [b"text/x-script.perl-module"],
    ".pm4":         [b"application/x-pagemaker"],
    ".pm5":         [b"application/x-pagemaker"],
    ".png":         [b"image/png"],
    ".pnm":         [b"image/x-portable-anymap"],
    ".pot":         [b"application/vnd.ms-powerpoint"],
    ".pov":         [b"model/x-pov"],
    ".ppa":         [b"application/vnd.ms-powerpoint"],
    ".ppm":         [b"image/x-portable-pixmap"],
    ".pps":         [b"application/vnd.ms-powerpoint"],
    ".ppt":         [b"application/x-mspowerpoint"],
    ".ppz":         [b"application/mspowerpoint"],
    ".pre":         [b"application/x-freelance"],
    ".prt":         [b"application/pro_eng"],
    ".ps":          [b"application/postscript"],
    ".psd":         [b"application/octet-stream"],
    ".pvu":         [b"paleovu/x-pv"],
    ".pwz":         [b"application/vnd.ms-powerpoint"],
    ".py":          [b"text/x-script.python"],
    ".pyc":         [b"application/x-bytecode.python"],
    ".qcp":         [b"audio/vnd.qcelp"],
    ".qd3":         [b"x-world/x-3dmf"],
    ".qd3d":        [b"x-world/x-3dmf"],
    ".qif":         [b"image/x-quicktime"],
    ".qt":          [b"video/quicktime"],
    ".qtc":         [b"video/x-qtc"],
    ".qti":         [b"image/x-quicktime"],
    ".qtif":        [b"image/x-quicktime"],
    ".ra":          [b"audio/x-realaudio"],
    ".ram":         [b"audio/x-pn-realaudio"],
    ".ras":         [b"image/x-cmu-raster"],
    ".rast":        [b"image/cmu-raster"],
    ".rexx":        [b"text/x-script.rexx"],
    ".rf":          [b"image/vnd.rn-realflash"],
    ".rgb":         [b"image/x-rgb"],
    ".rm":          [b"audio/x-pn-realaudio"],
    ".rmi":         [b"audio/mid"],
    ".rmm":         [b"audio/x-pn-realaudio"],
    ".rmp":         [b"audio/x-pn-realaudio-plugin"],
    ".rng":         [b"application/vnd.nokia.ringing-tone"],
    ".rnx":         [b"application/vnd.rn-realplayer"],
    ".roff":        [b"application/x-troff"],
    ".rp":          [b"image/vnd.rn-realpix"],
    ".rpm":         [b"audio/x-pn-realaudio-plugin"],
    ".rt":          [b"text/vnd.rn-realtext"],
    ".rtf":         [b"text/richtext"],
    ".rtx":         [b"text/richtext"],
    ".rv":          [b"video/vnd.rn-realvideo"],
    ".s":           [b"text/x-asm"],
    ".s3m":         [b"audio/s3m"],
    ".saveme":      [b"application/octet-stream"],
    ".sbk":         [b"application/x-tbook"],
    ".scm":         [b"video/x-scm"],
    ".sdml":        [b"text/plain"],
    ".sdp":         [b"application/x-sdp"],
    ".sdr":         [b"application/sounder"],
    ".sea":         [b"application/x-sea"],
    ".set":         [b"application/set"],
    ".sgm":         [b"text/x-sgml"],
    ".sgml":        [b"text/x-sgml"],
    ".sh":          [b"text/x-script.sh"],
    ".shar":        [b"application/x-shar"],
    ".shtml":       [b"text/x-server-parsed-html"],
    ".sid":         [b"audio/x-psid"],
    ".sit":         [b"application/x-stuffit"],
    ".skd":         [b"application/x-koan"],
    ".skm":         [b"application/x-koan"],
    ".skp":         [b"application/x-koan"],
    ".skt":         [b"application/x-koan"],
    ".sl":          [b"application/x-seelogo"],
    ".smi":         [b"application/smil"],
    ".smil":        [b"application/smil"],
    ".snd":         [b"audio/x-adpcm"],
    ".sol":         [b"application/solids"],
    ".spc":         [b"text/x-speech"],
    ".spl":         [b"application/futuresplash"],
    ".spr":         [b"application/x-sprite"],
    ".sprite":      [b"application/x-sprite"],
    ".src":         [b"application/x-wais-source"],
    ".ssi":         [b"text/x-server-parsed-html"],
    ".ssm":         [b"application/streamingmedia"],
    ".sst":         [b"application/vnd.ms-pki.certstore"],
    ".step":        [b"application/step"],
    ".stl":         [b"application/x-navistyle"],
    ".stp":         [b"application/step"],
    ".sv4cpio":     [b"application/x-sv4cpio"],
    ".sv4crc":      [b"application/x-sv4crc"],
    ".svf":         [b"image/x-dwg"],
    ".svr":         [b"x-world/x-svr"],
    ".swf":         [b"application/x-shockwave-flash"],
    ".t":           [b"application/x-troff"],
    ".talk":        [b"text/x-speech"],
    ".tar":         [b"application/x-tar"],
    ".tbk":         [b"application/x-tbook"],
    ".tcl":         [b"text/x-script.tcl"],
    ".tcsh":        [b"text/x-script.tcsh"],
    ".tex":         [b"application/x-tex"],
    ".texi":        [b"application/x-texinfo"],
    ".texinfo":     [b"application/x-texinfo"],
    ".text":        [b"text/plain"],
    ".tgz":         [b"application/x-compressed"],
    ".tif":         [b"image/x-tiff"],
    ".tiff":        [b"image/x-tiff"],
    ".tr":          [b"application/x-troff"],
    ".tsi":         [b"audio/tsp-audio"],
    ".tsp":         [b"audio/tsplayer"],
    ".tsv":         [b"text/tab-separated-values"],
    ".turbot":      [b"image/florian"],
    ".txt":         [b"text/plain"],
    ".uil":         [b"text/x-uil"],
    ".uni":         [b"text/uri-list"],
    ".unis":        [b"text/uri-list"],
    ".unv":         [b"application/i-deas"],
    ".uri":         [b"text/uri-list"],
    ".uris":        [b"text/uri-list"],
    ".ustar":       [b"multipart/x-ustar"],
    ".uu":          [b"text/x-uuencode"],
    ".uue":         [b"text/x-uuencode"],
    ".vcd":         [b"application/x-cdlink"],
    ".vcs":         [b"text/x-vcalendar"],
    ".vda":         [b"application/vda"],
    ".vdo":         [b"video/vdo"],
    ".vew":         [b"application/groupwise"],
    ".viv":         [b"video/vnd.vivo"],
    ".vivo":        [b"video/vnd.vivo"],
    ".vmd":         [b"application/vocaltec-media-desc"],
    ".vmf":         [b"application/vocaltec-media-file"],
    ".voc":         [b"audio/x-voc"],
    ".vos":         [b"video/vosaic"],
    ".vox":         [b"audio/voxware"],
    ".vqe":         [b"audio/x-twinvq-plugin"],
    ".vqf":         [b"audio/x-twinvq"],
    ".vql":         [b"audio/x-twinvq-plugin"],
    ".vrml":        [b"x-world/x-vrml"],
    ".vrt":         [b"x-world/x-vrt"],
    ".vsd":         [b"application/x-visio"],
    ".vst":         [b"application/x-visio"],
    ".vsw":         [b"application/x-visio"],
    ".w60":         [b"application/wordperfect6.0"],
    ".w61":         [b"application/wordperfect6.1"],
    ".w6w":         [b"application/msword"],
    ".wav":         [b"audio/x-wav"],
    ".wb1":         [b"application/x-qpro"],
    ".wbmp":        [b"image/vnd.wap.wbmp"],
    ".web":         [b"application/vnd.xara"],
    ".wiz":         [b"application/msword"],
    ".wk1":         [b"application/x-123"],
    ".wmf":         [b"windows/metafile"],
    ".wml":         [b"text/vnd.wap.wml"],
    ".wmlc":        [b"application/vnd.wap.wmlc"],
    ".wmls":        [b"text/vnd.wap.wmlscript"],
    ".wmlsc":       [b"application/vnd.wap.wmlscriptc"],
    ".word":        [b"application/msword"],
    ".wp":          [b"application/wordperfect"],
    ".wp5":         [b"application/wordperfect6.0"],
    ".wp6":         [b"application/wordperfect"],
    ".wpd":         [b"application/x-wpwin"],
    ".wq1":         [b"application/x-lotus"],
    ".wri":         [b"application/x-wri"],
    ".wrl":         [b"x-world/x-vrml"],
    ".wrz":         [b"x-world/x-vrml"],
    ".wsc":         [b"text/scriplet"],
    ".wsrc":        [b"application/x-wais-source"],
    ".wtk":         [b"application/x-wintalk"],
    ".x-png":       [b"image/png"],
    ".xbm":         [b"image/xbm"],
    ".xdr":         [b"video/x-amt-demorun"],
    ".xgz":         [b"xgl/drawing"],
    ".xif":         [b"image/vnd.xiff"],
    ".xl":          [b"application/excel"],
    ".xla":         [b"application/x-msexcel"],
    ".xlb":         [b"application/x-excel"],
    ".xlc":         [b"application/x-excel"],
    ".xld":         [b"application/x-excel"],
    ".xlk":         [b"application/x-excel"],
    ".xll":         [b"application/x-excel"],
    ".xlm":         [b"application/x-excel"],
    ".xls":         [b"application/x-msexcel"],
    ".xlt":         [b"application/x-excel"],
    ".xlv":         [b"application/x-excel"],
    ".xlw":         [b"application/x-msexcel"],
    ".xm":          [b"audio/xm"],
    ".xml":         [b"text/xml"],
    ".xmz":         [b"xgl/movie"],
    ".xpix":        [b"application/x-vnd.ls-xpix"],
    ".xpm":         [b"image/xpm"],
    ".xsr":         [b"video/x-amt-showrun"],
    ".xwd":         [b"image/x-xwindowdump"],
    ".xyz":         [b"chemical/x-pdb"],
    ".z":           [b"application/x-compressed"],
    ".zip":         [b"multipart/x-zip"],
    ".zoo":         [b"application/octet-stream"],
    ".zsh":         [b"text/x-script.zsh"]
}
MIMETYPES = set(sum(EXTENSION_TO_MIMETYPE.values(), []))
MIMETYPE_DOMAINS = set(sum([[MIMETYPE_REGEX.match(mimetype).groups()[0] for mimetype in mimetypes] for mimetypes in EXTENSION_TO_MIMETYPE.values()], []))


