# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class LabVirtualMachine(Model):
    """A virtual machine.

    :param notes: The notes of the virtual machine.
    :type notes: str
    :param owner_object_id: The object identifier of the owner of the virtual
     machine.
    :type owner_object_id: str
    :param created_by_user_id: The object identifier of the creator of the
     virtual machine.
    :type created_by_user_id: str
    :param created_by_user: The email address of creator of the virtual
     machine.
    :type created_by_user: str
    :param compute_id: The resource identifier (Microsoft.Compute) of the
     virtual machine.
    :type compute_id: str
    :param custom_image_id: The custom image identifier of the virtual
     machine.
    :type custom_image_id: str
    :param os_type: The OS type of the virtual machine.
    :type os_type: str
    :param size: The size of the virtual machine.
    :type size: str
    :param user_name: The user name of the virtual machine.
    :type user_name: str
    :param password: The password of the virtual machine administrator.
    :type password: str
    :param ssh_key: The SSH key of the virtual machine administrator.
    :type ssh_key: str
    :param is_authentication_with_ssh_key: A value indicating whether this
     virtual machine uses an SSH key for authentication.
    :type is_authentication_with_ssh_key: bool
    :param fqdn: The fully-qualified domain name of the virtual machine.
    :type fqdn: str
    :param lab_subnet_name: The lab subnet name of the virtual machine.
    :type lab_subnet_name: str
    :param lab_virtual_network_id: The lab virtual network identifier of the
     virtual machine.
    :type lab_virtual_network_id: str
    :param disallow_public_ip_address: Indicates whether the virtual machine
     is to be created without a public IP address.
    :type disallow_public_ip_address: bool
    :param artifacts: The artifacts to be installed on the virtual machine.
    :type artifacts: list of :class:`ArtifactInstallProperties
     <azure.mgmt.devtestlabs.models.ArtifactInstallProperties>`
    :param artifact_deployment_status: The artifact deployment status for the
     virtual machine.
    :type artifact_deployment_status:
     :class:`ArtifactDeploymentStatusProperties
     <azure.mgmt.devtestlabs.models.ArtifactDeploymentStatusProperties>`
    :param gallery_image_reference: The Microsoft Azure Marketplace image
     reference of the virtual machine.
    :type gallery_image_reference: :class:`GalleryImageReference
     <azure.mgmt.devtestlabs.models.GalleryImageReference>`
    :param provisioning_state: The provisioning status of the resource.
    :type provisioning_state: str
    :param unique_identifier: The unique immutable identifier of a resource
     (Guid).
    :type unique_identifier: str
    :param id: The identifier of the resource.
    :type id: str
    :param name: The name of the resource.
    :type name: str
    :param type: The type of the resource.
    :type type: str
    :param location: The location of the resource.
    :type location: str
    :param tags: The tags of the resource.
    :type tags: dict
    """ 

    _attribute_map = {
        'notes': {'key': 'properties.notes', 'type': 'str'},
        'owner_object_id': {'key': 'properties.ownerObjectId', 'type': 'str'},
        'created_by_user_id': {'key': 'properties.createdByUserId', 'type': 'str'},
        'created_by_user': {'key': 'properties.createdByUser', 'type': 'str'},
        'compute_id': {'key': 'properties.computeId', 'type': 'str'},
        'custom_image_id': {'key': 'properties.customImageId', 'type': 'str'},
        'os_type': {'key': 'properties.osType', 'type': 'str'},
        'size': {'key': 'properties.size', 'type': 'str'},
        'user_name': {'key': 'properties.userName', 'type': 'str'},
        'password': {'key': 'properties.password', 'type': 'str'},
        'ssh_key': {'key': 'properties.sshKey', 'type': 'str'},
        'is_authentication_with_ssh_key': {'key': 'properties.isAuthenticationWithSshKey', 'type': 'bool'},
        'fqdn': {'key': 'properties.fqdn', 'type': 'str'},
        'lab_subnet_name': {'key': 'properties.labSubnetName', 'type': 'str'},
        'lab_virtual_network_id': {'key': 'properties.labVirtualNetworkId', 'type': 'str'},
        'disallow_public_ip_address': {'key': 'properties.disallowPublicIpAddress', 'type': 'bool'},
        'artifacts': {'key': 'properties.artifacts', 'type': '[ArtifactInstallProperties]'},
        'artifact_deployment_status': {'key': 'properties.artifactDeploymentStatus', 'type': 'ArtifactDeploymentStatusProperties'},
        'gallery_image_reference': {'key': 'properties.galleryImageReference', 'type': 'GalleryImageReference'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'unique_identifier': {'key': 'properties.uniqueIdentifier', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, notes=None, owner_object_id=None, created_by_user_id=None, created_by_user=None, compute_id=None, custom_image_id=None, os_type=None, size=None, user_name=None, password=None, ssh_key=None, is_authentication_with_ssh_key=None, fqdn=None, lab_subnet_name=None, lab_virtual_network_id=None, disallow_public_ip_address=None, artifacts=None, artifact_deployment_status=None, gallery_image_reference=None, provisioning_state=None, unique_identifier=None, id=None, name=None, type=None, location=None, tags=None):
        self.notes = notes
        self.owner_object_id = owner_object_id
        self.created_by_user_id = created_by_user_id
        self.created_by_user = created_by_user
        self.compute_id = compute_id
        self.custom_image_id = custom_image_id
        self.os_type = os_type
        self.size = size
        self.user_name = user_name
        self.password = password
        self.ssh_key = ssh_key
        self.is_authentication_with_ssh_key = is_authentication_with_ssh_key
        self.fqdn = fqdn
        self.lab_subnet_name = lab_subnet_name
        self.lab_virtual_network_id = lab_virtual_network_id
        self.disallow_public_ip_address = disallow_public_ip_address
        self.artifacts = artifacts
        self.artifact_deployment_status = artifact_deployment_status
        self.gallery_image_reference = gallery_image_reference
        self.provisioning_state = provisioning_state
        self.unique_identifier = unique_identifier
        self.id = id
        self.name = name
        self.type = type
        self.location = location
        self.tags = tags
