
[![Documentation Status](https://readthedocs.org/projects/landlab/badge/?version=latest)](https://readthedocs.org/projects/landlab/?badge=latest)
[![Build Status](https://travis-ci.org/landlab/landlab.svg?branch=master)](https://travis-ci.org/landlab/landlab)
[![Coverage Status](https://coveralls.io/repos/landlab/landlab/badge.png)](https://coveralls.io/r/landlab/landlab)
[![Code Health](https://landscape.io/github/landlab/landlab/master/landscape.svg)](https://landscape.io/github/landlab/landlab/master)
landlab
=======

The Landlab project creates an environment in which scientists can build a
numerical landscape model without having to code all of the individual
components. Landscape models compute flows of mass, such as water, sediment,
glacial ice, volcanic material, or landslide debris, across a gridded terrain
surface. Landscape models have a number of commonalities, such as operating on
a grid of points and routing material across the grid. Scientists who want to
use a landscape model often build their own unique model from the ground up,
re-coding the basic building blocks of their landscape model rather than
taking advantage of codes that have already been written.

More information can be found at the website:

http://landlab.readthedocs.org

After installation, tests can be run with:

    python -c 'import landlab; landlab.test()'

The most current development version is always available from our git
repository:

http://github.com/landlab/landlab


