/*
 * Decompiled with CFR 0.152.
 */
package py4j.reflection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import py4j.JVMView;
import py4j.Py4JException;
import py4j.reflection.ReflectionUtil;
import py4j.reflection.TypeConverter;

public class TypeUtil {
    private static Set<String> primitiveTypes = new HashSet<String>();
    private static Map<String, Class<?>> primitiveClasses;
    public static final int DISTANCE_FACTOR = 100;

    public static int computeCharacterConversion(Class<?> parent, Class<?> child, List<TypeConverter> converters) {
        int cost = -1;
        if (TypeUtil.isCharacter(child)) {
            cost = 0;
            converters.add(TypeConverter.NO_CONVERTER);
        } else if (CharSequence.class.isAssignableFrom(child)) {
            cost = 1;
            converters.add(TypeConverter.CHAR_CONVERTER);
        }
        return cost;
    }

    public static int computeDistance(Class<?> parent, Class<?> child) {
        int distance = -1;
        if (parent.equals(child)) {
            distance = 0;
        }
        if (distance == -1) {
            distance = TypeUtil.computeSuperDistance(parent, child);
        }
        if (distance == -1) {
            distance = TypeUtil.computeInterfaceDistance(parent, child, new HashSet<String>(), Arrays.asList(child.getInterfaces()));
        }
        if (distance != -1) {
            distance *= 100;
        }
        return distance;
    }

    private static int computeInterfaceDistance(Class<?> parent, Class<?> child, Set<String> visitedInterfaces, List<Class<?>> interfacesToVisit) {
        int distance = -1;
        ArrayList nextInterfaces = new ArrayList();
        for (Class<?> clazz : interfacesToVisit) {
            if (parent.equals(clazz)) {
                distance = 1;
                break;
            }
            visitedInterfaces.add(clazz.getName());
            TypeUtil.getNextInterfaces(clazz, nextInterfaces, visitedInterfaces);
        }
        if (distance == -1) {
            int newDistance;
            Class<?> grandChild = null;
            if (child != null) {
                grandChild = child.getSuperclass();
                TypeUtil.getNextInterfaces(grandChild, nextInterfaces, visitedInterfaces);
            }
            if (nextInterfaces.size() > 0 && (newDistance = TypeUtil.computeInterfaceDistance(parent, grandChild, visitedInterfaces, nextInterfaces)) != -1) {
                distance = newDistance + 1;
            }
        }
        return distance;
    }

    public static int computeNumericConversion(Class<?> parent, Class<?> child, List<TypeConverter> converters) {
        int cost = -1;
        if (TypeUtil.isLong(parent) && !TypeUtil.isFloat(child) && !TypeUtil.isDouble(child)) {
            cost = TypeUtil.getCost(parent, child);
            if (TypeUtil.isLong(child)) {
                converters.add(TypeConverter.NO_CONVERTER);
            } else {
                converters.add(TypeConverter.LONG_CONVERTER);
            }
        } else if (TypeUtil.isInteger(parent) && (TypeUtil.isInteger(child) || TypeUtil.isShort(child) || TypeUtil.isByte(child))) {
            cost = TypeUtil.getCost(parent, child);
            converters.add(TypeConverter.NO_CONVERTER);
        } else if (TypeUtil.isShort(parent)) {
            if (TypeUtil.isShort(child) || TypeUtil.isByte(child)) {
                cost = TypeUtil.getCost(parent, child);
                converters.add(TypeConverter.NO_CONVERTER);
            } else if (TypeUtil.isInteger(child)) {
                cost = 1;
                converters.add(TypeConverter.SHORT_CONVERTER);
            }
        } else if (TypeUtil.isByte(parent)) {
            if (TypeUtil.isByte(child)) {
                cost = 0;
                converters.add(TypeConverter.NO_CONVERTER);
            } else if (TypeUtil.isInteger(child)) {
                cost = 2;
                converters.add(TypeConverter.BYTE_CONVERTER);
            }
        } else if (TypeUtil.isDouble(parent)) {
            if (TypeUtil.isDouble(child)) {
                cost = 0;
                converters.add(TypeConverter.NO_CONVERTER);
            } else if (TypeUtil.isFloat(child)) {
                cost = 1;
                converters.add(TypeConverter.NO_CONVERTER);
            }
        } else if (TypeUtil.isFloat(parent)) {
            if (TypeUtil.isFloat(child)) {
                cost = 0;
                converters.add(TypeConverter.NO_CONVERTER);
            } else if (TypeUtil.isDouble(child)) {
                cost = 1;
                converters.add(TypeConverter.FLOAT_CONVERTER);
            }
        }
        return cost;
    }

    private static int computeSuperDistance(Class<?> parent, Class<?> child) {
        Class<?> superChild = child.getSuperclass();
        if (superChild == null) {
            return -1;
        }
        if (superChild.equals(parent)) {
            return 1;
        }
        int distance = TypeUtil.computeSuperDistance(parent, superChild);
        if (distance != -1) {
            return distance + 1;
        }
        return distance;
    }

    public static Class<?> forName(String fqn) throws ClassNotFoundException {
        Class<?> clazz = primitiveClasses.get(fqn);
        if (clazz == null) {
            clazz = ReflectionUtil.classForName(fqn);
        }
        return clazz;
    }

    public static Class<?> forName(String fqn, JVMView view) throws ClassNotFoundException {
        Class<?> clazz = primitiveClasses.get(fqn);
        if (clazz == null) {
            clazz = fqn.indexOf(46) < 0 ? TypeUtil.getClass(fqn, view) : ReflectionUtil.classForName(fqn);
        }
        return clazz;
    }

    public static Class<?> getClass(String simpleName, JVMView view) throws ClassNotFoundException {
        Class<?> clazz = null;
        try {
            clazz = ReflectionUtil.classForName(simpleName);
        }
        catch (Exception e) {
            Map<String, String> singleImportsMap = view.getSingleImportsMap();
            String newFQN = singleImportsMap.get(simpleName);
            if (newFQN != null) {
                clazz = ReflectionUtil.classForName(newFQN);
            }
            for (String starImport : view.getStarImports()) {
                try {
                    clazz = ReflectionUtil.classForName(starImport + "." + simpleName);
                    break;
                }
                catch (Exception e2) {
                }
            }
        }
        if (clazz == null) {
            throw new ClassNotFoundException(simpleName + " not found.");
        }
        return clazz;
    }

    public static int getCost(Class<?> parent, Class<?> child) {
        return TypeUtil.getPoint(parent) - TypeUtil.getPoint(child);
    }

    public static String getName(String name, boolean shortName) {
        if (!shortName) {
            return name;
        }
        int index = name.lastIndexOf(".");
        if (index >= 0 && index < name.length() + 1) {
            return name.substring(index + 1);
        }
        return name;
    }

    public static String[] getNames(Class<?>[] classes) {
        String[] names = new String[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            names[i] = classes[i].getCanonicalName();
        }
        return names;
    }

    private static void getNextInterfaces(Class<?> clazz, List<Class<?>> nextInterfaces, Set<String> visitedInterfaces) {
        if (clazz != null) {
            for (Class<?> nextClazz : clazz.getInterfaces()) {
                if (visitedInterfaces.contains(nextClazz.getName())) continue;
                nextInterfaces.add(nextClazz);
            }
        }
    }

    public static String getPackage(String name) {
        int index = name.lastIndexOf(".");
        if (index < 0) {
            return name;
        }
        return name.substring(0, index);
    }

    public static int getPoint(Class<?> clazz) {
        int point = -1;
        if (TypeUtil.isByte(clazz)) {
            point = 0;
        } else if (TypeUtil.isShort(clazz)) {
            point = 1;
        } else if (TypeUtil.isInteger(clazz)) {
            point = 2;
        } else if (TypeUtil.isLong(clazz)) {
            point = 3;
        }
        return point;
    }

    public static boolean isBoolean(Class<?> clazz) {
        return clazz.equals(Boolean.class) || clazz.equals(Boolean.TYPE);
    }

    public static boolean isByte(Class<?> clazz) {
        return clazz.equals(Byte.class) || clazz.equals(Byte.TYPE);
    }

    public static boolean isCharacter(Class<?> clazz) {
        return clazz.equals(Character.class) || clazz.equals(Character.TYPE);
    }

    public static boolean isDouble(Class<?> clazz) {
        return clazz.equals(Double.class) || clazz.equals(Double.TYPE);
    }

    public static boolean isFloat(Class<?> clazz) {
        return clazz.equals(Float.class) || clazz.equals(Float.TYPE);
    }

    public static boolean isInteger(Class<?> clazz) {
        return clazz.equals(Integer.class) || clazz.equals(Integer.TYPE);
    }

    public static boolean isLong(Class<?> clazz) {
        return clazz.equals(Long.class) || clazz.equals(Long.TYPE);
    }

    public static boolean isNumeric(Class<?> clazz) {
        return primitiveTypes.contains(clazz.getName());
    }

    public static boolean isShort(Class<?> clazz) {
        return clazz.equals(Short.class) || clazz.equals(Short.TYPE);
    }

    public static boolean isInstanceOf(Class<?> clazz, Object object) {
        return clazz.isInstance(object);
    }

    public static boolean isInstanceOf(String classFQN, Object object) {
        Class<?> clazz = null;
        try {
            clazz = ReflectionUtil.classForName(classFQN);
        }
        catch (Exception e) {
            throw new Py4JException(e);
        }
        return TypeUtil.isInstanceOf(clazz, object);
    }

    static {
        primitiveTypes.add(Long.TYPE.getName());
        primitiveTypes.add(Integer.TYPE.getName());
        primitiveTypes.add(Short.TYPE.getName());
        primitiveTypes.add(Byte.TYPE.getName());
        primitiveTypes.add(Double.TYPE.getName());
        primitiveTypes.add(Float.TYPE.getName());
        primitiveTypes.add(Long.class.getName());
        primitiveTypes.add(Integer.class.getName());
        primitiveTypes.add(Short.class.getName());
        primitiveTypes.add(Byte.class.getName());
        primitiveTypes.add(Double.class.getName());
        primitiveTypes.add(Float.class.getName());
        primitiveClasses = new HashMap();
        primitiveClasses.put("long", Long.TYPE);
        primitiveClasses.put("int", Integer.TYPE);
        primitiveClasses.put("short", Short.TYPE);
        primitiveClasses.put("byte", Byte.TYPE);
        primitiveClasses.put("double", Double.TYPE);
        primitiveClasses.put("float", Float.TYPE);
        primitiveClasses.put("boolean", Boolean.TYPE);
        primitiveClasses.put("char", Character.TYPE);
    }
}

