# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .proxy_resource import ProxyResource


class RestorePoint(ProxyResource):
    """A database restore point.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar restore_point_type: The restore point type of the database restore
     point. Possible values include: 'DISCRETE', 'CONTINUOUS'
    :vartype restore_point_type: str or :class:`RestorePointType
     <azure.mgmt.sql.models.RestorePointType>`
    :ivar restore_point_creation_date: Restore point creation time (ISO8601
     format). Populated when restorePointType = CONTINUOUS. Null otherwise.
    :vartype restore_point_creation_date: datetime
    :ivar earliest_restore_date: Earliest restore time (ISO8601 format).
     Populated when restorePointType = DISCRETE. Null otherwise.
    :vartype earliest_restore_date: datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'restore_point_type': {'readonly': True},
        'restore_point_creation_date': {'readonly': True},
        'earliest_restore_date': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'restore_point_type': {'key': 'properties.restorePointType', 'type': 'RestorePointType'},
        'restore_point_creation_date': {'key': 'properties.restorePointCreationDate', 'type': 'iso-8601'},
        'earliest_restore_date': {'key': 'properties.earliestRestoreDate', 'type': 'iso-8601'},
    }

    def __init__(self):
        super(RestorePoint, self).__init__()
        self.restore_point_type = None
        self.restore_point_creation_date = None
        self.earliest_restore_date = None
