import difflib

items = {"Iron Pickaxe": "1", "Dirt Block": "2", "Stone Block": "3", "Iron Broadsword": "4", "Mushroom": "5", "Iron Shortsword": "6", "Iron Hammer": "7", "Torch": "8", "Wood": "9", "Iron Axe": "10", "Iron Ore": "11", "Copper Ore": "12", "Gold Ore": "13", "Silver Ore": "14", "Copper Watch": "15", "Silver Watch": "16", "Gold Watch": "17", "Depth Meter": "18", "Gold Bar": "19", "Copper Bar": "20", "Silver Bar": "21", "Iron Bar": "22", "Gel": "23", "Wooden Sword": "24", "Wooden Door": "25", "Stone Wall": "26", "Acorn": "27", "Lesser Healing Potion": "28", "Life Crystal": "29", "Dirt Wall": "30", "Bottle": "31", "Wooden Table": "32", "Furnace": "33", "Wooden Chair": "34", "Iron Anvil": "35", "Work Bench": "36", "Goggles": "37", "Lens": "38", "Wooden Bow": "39", "Wooden Arrow": "40", "Flaming Arrow": "41", "Shuriken": "42", "Suspicious Looking Eye": "43", "Demon Bow": "44", "War Axe of the Night": "45", "Light's Bane": "46", "Unholy Arrow": "47", "Chest": "48", "Band of Regeneration": "49", "Magic Mirror": "50", "Jester's Arrow": "51", "Angel Statue": "52", "Cloud in a Bottle": "53", "Hermes Boots": "54", "Enchanted Boomerang": "55", "Demonite Ore": "56", "Demonite Bar": "57", "Heart": "58", "Corrupt Seeds": "59", "Vile Mushroom": "60", "Ebonstone Block": "61", "Grass Seeds": "62", "Sunflower": "63", "Vilethorn": "64", "Starfury": "65", "Purification Powder": "66", "Vile Powder": "67", "Rotten Chunk": "68", "Worm Tooth": "69", "Worm Food": "70", "Copper Coin": "71", "Silver Coin": "72", "Gold Coin": "73", "Platinum Coin": "74", "Fallen Star": "75", "Copper Greaves": "76", "Iron Greaves": "77", "Silver Greaves": "78", "Gold Greaves": "79", "Copper Chainmail": "80", "Iron Chainmail": "81", "Silver Chainmail": "82", "Gold Chainmail": "83", "Grappling Hook": "84", "Iron Chain": "85", "Shadow Scale": "86", "Piggy Bank": "87", "Mining Helmet": "88", "Copper Helmet": "89", "Iron Helmet": "90", "Silver Helmet": "91", "Gold Helmet": "92", "Wood Wall": "93", "Wood Platform": "94", "Flintlock Pistol": "95", "Musket": "96", "Musket Ball": "97", "Minishark": "98", "Iron Bow": "99", "Shadow Greaves": "100", "Shadow Scalemail": "101", "Shadow Helmet": "102", "Nightmare Pickaxe": "103", "The Breaker": "104", "Candle": "105", "Copper Chandelier": "106", "Silver Chandelier": "107", "Gold Chandelier": "108", "Mana Crystal": "109", "Lesser Mana Potion": "110", "Band of Starpower": "111", "Flower of Fire": "112", "Magic Missile": "113", "Dirt Rod": "114", "Orb of Light": "115", "Meteorite": "116", "Meteorite Bar": "117", "Hook": "118", "Flamarang": "119", "Molten Fury": "120", "Fiery Greatsword": "121", "Molten Pickaxe": "122", "Meteor Helmet": "123", "Meteor Suit": "124", "Meteor Leggings": "125", "Bottled Water": "126", "Space Gun": "127", "Rocket Boots": "128", "Gray Brick": "129", "Gray Brick Wall": "130", "Red Brick": "131", "Red Brick Wall": "132", "Clay Block": "133", "Blue Brick": "134", "Blue Brick Wall": "135", "Chain Lantern": "136", "Green Brick": "137", "Green Brick Wall": "138", "Pink Brick": "139", "Pink Brick Wall": "140", "Gold Brick": "141", "Gold Brick Wall": "142", "Silver Brick": "143", "Silver Brick Wall": "144", "Copper Brick": "145", "Copper Brick Wall": "146", "Spike": "147", "Water Candle": "148", "Book": "149", "Cobweb": "150", "Necro Helmet": "151", "Necro Breastplate": "152", "Necro Greaves": "153", "Bone": "154", "Muramasa": "155", "Cobalt Shield": "156", "Aqua Scepter": "157", "Lucky Horseshoe": "158", "Shiny Red Balloon": "159", "Harpoon": "160", "Spiky Ball": "161", "Ball 'O Hurt": "162", "Blue Moon": "163", "Handgun": "164", "Water Bolt": "165", "Bomb": "166", "Dynamite": "167", "Grenade": "168", "Sand Block": "169", "Glass": "170", "Sign": "171", "Ash Block": "172", "Obsidian": "173", "Hellstone": "174", "Hellstone Bar": "175", "Mud Block": "176", "Sapphire": "177", "Ruby": "178", "Emerald": "179", "Topaz": "180", "Amethyst": "181", "Diamond": "182", "Glowing Mushroom": "183", "Star": "184", "Ivy Whip": "185", "Breathing Reed": "186", "Flipper": "187", "Healing Potion": "188", "Mana Potion": "189", "Blade of Grass": "190", "Thorn Chakram": "191", "Obsidian Brick": "192", "Obsidian Skull": "193", "Mushroom Grass Seeds": "194", "Jungle Grass Seeds": "195", "Wooden Hammer": "196", "Star Cannon": "197", "Blue Phaseblade": "198", "Red Phaseblade": "199", "Green Phaseblade": "200", "Purple Phaseblade": "201", "White Phaseblade": "202", "Yellow Phaseblade": "203", "Meteor Hamaxe": "204", "Empty Bucket": "205", "Water Bucket": "206", "Lava Bucket": "207", "Jungle Rose": "208", "Stinger": "209", "Vine": "210", "Feral Claws": "211", "Anklet of the Wind": "212", "Staff of Regrowth": "213", "Hellstone Brick": "214", "Whoopie Cushion": "215", "Shackle": "216", "Molten Hamaxe": "217", "Flamelash": "218", "Phoenix Blaster": "219", "Sunfury": "220", "Hellforge": "221", "Clay Pot": "222", "Nature's Gift": "223", "Bed": "224", "Silk": "225", "Lesser Restoration Potion": "226", "Restoration Potion": "227", "Jungle Hat": "228", "Jungle Shirt": "229", "Jungle Pants": "230", "Molten Helmet": "231", "Molten Breastplate": "232", "Molten Greaves": "233", "Meteor Shot": "234", "Sticky Bomb": "235", "Black Lens": "236", "Sunglasses": "237", "Wizard Hat": "238", "Top Hat": "239", "Tuxedo Shirt": "240", "Tuxedo Pants": "241", "Summer Hat": "242", "Bunny Hood": "243", "Plumber's Hat": "244", "Plumber's Shirt": "245", "Plumber's Pants": "246", "Hero's Hat": "247", "Hero's Shirt": "248", "Hero's Pants": "249", "Fish Bowl": "250", "Archaeologist's Hat": "251", "Archaeologist's Jacket": "252", "Archaeologist's Pants": "253", "Black Dye": "254", "Green Dye": "255", "Ninja Hood": "256", "Ninja Shirt": "257", "Ninja Pants": "258", "Leather": "259", "Red Hat": "260", "Goldfish": "261", "Robe": "262", "Robot Hat": "263", "Gold Crown": "264", "Hellfire Arrow": "265", "Sandgun": "266", "Guide Voodoo Doll": "267", "Diving Helmet": "268", "Familiar Shirt": "269", "Familiar Pants": "270", "Familiar Wig": "271", "Demon Scythe": "272", "Night's Edge": "273", "Dark Lance": "274", "Coral": "275", "Cactus": "276", "Trident": "277", "Silver Bullet": "278", "Throwing Knife": "279", "Spear": "280", "Blowpipe": "281", "Glowstick": "282", "Seed": "283", "Wooden Boomerang": "284", "Aglet": "285", "Sticky Glowstick": "286", "Poisoned Knife": "287", "Obsidian Skin Potion": "288", "Regeneration Potion": "289", "Swiftness Potion": "290", "Gills Potion": "291", "Ironskin Potion": "292", "Mana Regeneration Potion": "293", "Magic Power Potion": "294", "Featherfall Potion": "295", "Spelunker Potion": "296", "Invisibility Potion": "297", "Shine Potion": "298", "Night Owl Potion": "299", "Battle Potion": "300", "Thorns Potion": "301", "Water Walking Potion": "302", "Archery Potion": "303", "Hunter Potion": "304", "Gravitation Potion": "305", "Gold Chest": "306", "Daybloom Seeds": "307", "Moonglow Seeds": "308", "Blinkroot Seeds": "309", "Deathweed Seeds": "310", "Waterleaf Seeds": "311", "Fireblossom Seeds": "312", "Daybloom": "313", "Moonglow": "314", "Blinkroot": "315", "Deathweed": "316", "Waterleaf": "317", "Fireblossom": "318", "Shark Fin": "319", "Feather": "320", "Tombstone": "321", "Mime Mask": "322", "Antlion Mandible": "323", "Illegal Gun Parts": "324", "The Doctor's Shirt": "325", "The Doctor's Pants": "326", "Golden Key": "327", "Shadow Chest": "328", "Shadow Key": "329", "Obsidian Brick Wall": "330", "Jungle Spores": "331", "Loom": "332", "Piano": "333", "Dresser": "334", "Bench": "335", "Bathtub": "336", "Red Banner": "337", "Green Banner": "338", "Blue Banner": "339", "Yellow Banner": "340", "Lamp Post": "341", "Tiki Torch": "342", "Barrel": "343", "Chinese Lantern": "344", "Cooking Pot": "345", "Safe": "346", "Skull Lantern": "347", "Trash Can": "348", "Candelabra": "349", "Pink Vase": "350", "Mug": "351", "Keg": "352", "Ale": "353", "Bookcase": "354", "Throne": "355", "Bowl": "356", "Bowl of Soup": "357", "Toilet": "358", "Grandfather Clock": "359", "Armor Statue": "360", "Goblin Battle Standard": "361", "Tattered Cloth": "362", "Sawmill": "363", "Cobalt Ore": "364", "Mythril Ore": "365", "Adamantite Ore": "366", "Pwnhammer": "367", "Excalibur": "368", "Hallowed Seeds": "369", "Ebonsand Block": "370", "Cobalt Hat": "371", "Cobalt Helmet": "372", "Cobalt Mask": "373", "Cobalt Breastplate": "374", "Cobalt Leggings": "375", "Mythril Hood": "376", "Mythril Helmet": "377", "Mythril Hat": "378", "Mythril Chainmail": "379", "Mythril Greaves": "380", "Cobalt Bar": "381", "Mythril Bar": "382", "Cobalt Chainsaw": "383", "Mythril Chainsaw": "384", "Cobalt Drill": "385", "Mythril Drill": "386", "Adamantite Chainsaw": "387", "Adamantite Drill": "388", "Dao of Pow": "389", "Mythril Halberd": "390", "Adamantite Bar": "391", "Glass Wall": "392", "Compass": "393", "Diving Gear": "394", "GPS": "395", "Obsidian Horseshoe": "396", "Obsidian Shield": "397", "Tinkerer's Workshop": "398", "Cloud in a Balloon": "399", "Adamantite Headgear": "400", "Adamantite Helmet": "401", "Adamantite Mask": "402", "Adamantite Breastplate": "403", "Adamantite Leggings": "404", "Spectre Boots": "405", "Adamantite Glaive": "406", "Toolbelt": "407", "Pearlsand Block": "408", "Pearlstone Block": "409", "Mining Shirt": "410", "Mining Pants": "411", "Pearlstone Brick": "412", "Iridescent Brick": "413", "Mudstone Block": "414", "Cobalt Brick": "415", "Mythril Brick": "416", "Pearlstone Brick Wall": "417", "Iridescent Brick Wall": "418", "Mudstone Brick Wall": "419", "Cobalt Brick Wall": "420", "Mythril Brick Wall": "421", "Holy Water": "422", "Unholy Water": "423", "Silt Block": "424", "Fairy Bell": "425", "Breaker Blade": "426", "Blue Torch": "427", "Red Torch": "428", "Green Torch": "429", "Purple Torch": "430", "White Torch": "431", "Yellow Torch": "432", "Demon Torch": "433", "Clockwork Assault Rifle": "434", "Cobalt Repeater": "435", "Mythril Repeater": "436", "Dual Hook": "437", "Star Statue": "438", "Sword Statue": "439", "Slime Statue": "440", "Goblin Statue": "441", "Shield Statue": "442", "Bat Statue": "443", "Fish Statue": "444", "Bunny Statue": "445", "Skeleton Statue": "446", "Reaper Statue": "447", "Woman Statue": "448", "Imp Statue": "449", "Gargoyle Statue": "450", "Gloom Statue": "451", "Hornet Statue": "452", "Bomb Statue": "453", "Crab Statue": "454", "Hammer Statue": "455", "Potion Statue": "456", "Spear Statue": "457", "Cross Statue": "458", "Jellyfish Statue": "459", "Bow Statue": "460", "Boomerang Statue": "461", "Boot Statue": "462", "Chest Statue": "463", "Bird Statue": "464", "Axe Statue": "465", "Corrupt Statue": "466", "Tree Statue": "467", "Anvil Statue": "468", "Pickaxe Statue": "469", "Mushroom Statue": "470", "Eyeball Statue": "471", "Pillar Statue": "472", "Heart Statue": "473", "Pot Statue": "474", "Sunflower Statue": "475", "King Statue": "476", "Queen Statue": "477", "Piranha Statue": "478", "Planked Wall": "479", "Wooden Beam": "480", "Adamantite Repeater": "481", "Adamantite Sword": "482", "Cobalt Sword": "483", "Mythril Sword": "484", "Moon Charm": "485", "Ruler": "486", "Crystal Ball": "487", "Disco Ball": "488", "Sorcerer Emblem": "489", "Warrior Emblem": "490", "Ranger Emblem": "491", "Demon Wings": "492", "Angel Wings": "493", "Magical Harp": "494", "Rainbow Rod": "495", "Ice Rod": "496", "Neptune's Shell": "497", "Mannequin": "498", "Greater Healing Potion": "499", "Greater Mana Potion": "500", "Pixie Dust": "501", "Crystal Shard": "502", "Clown Hat": "503", "Clown Shirt": "504", "Clown Pants": "505", "Flamethrower": "506", "Bell": "507", "Harp": "508", "Wrench": "509", "Wire Cutter": "510", "Active Stone Block": "511", "Inactive Stone Block": "512", "Lever": "513", "Laser Rifle": "514", "Crystal Bullet": "515", "Holy Arrow": "516", "Magic Dagger": "517", "Crystal Storm": "518", "Cursed Flames": "519", "Soul of Light": "520", "Soul of Night": "521", "Cursed Flame": "522", "Cursed Torch": "523", "Adamantite Forge": "524", "Mythril Anvil": "525", "Unicorn Horn": "526", "Dark Shard": "527", "Light Shard": "528", "Red Pressure Plate": "529", "Wire": "530", "Spell Tome": "531", "Star Cloak": "532", "Megashark": "533", "Shotgun": "534", "Philosopher's Stone": "535", "Titan Glove": "536", "Cobalt Naginata": "537", "Switch": "538", "Dart Trap": "539", "Boulder": "540", "Green Pressure Plate": "541", "Gray Pressure Plate": "542", "Brown Pressure Plate": "543", "Mechanical Eye": "544", "Cursed Arrow": "545", "Cursed Bullet": "546", "Soul of Fright": "547", "Soul of Might": "548", "Soul of Sight": "549", "Gungnir": "550", "Hallowed Plate Mail": "551", "Hallowed Greaves": "552", "Hallowed Helmet": "553", "Cross Necklace": "554", "Mana Flower": "555", "Mechanical Worm": "556", "Mechanical Skull": "557", "Hallowed Headgear": "558", "Hallowed Mask": "559", "Slime Crown": "560", "Light Disc": "561", "Music Box (Overworld Day)": "562", "Music Box (Eerie)": "563", "Music Box (Night)": "564", "Music Box (Title)": "565", "Music Box (Underground)": "566", "Music Box (Boss 1)": "567", "Music Box (Jungle)": "568", "Music Box (Corruption)": "569", "Music Box (Underground Corruption)": "570", "Music Box (The Hallow)": "571", "Music Box (Boss 2)": "572", "Music Box (Underground Hallow)": "573", "Music Box (Boss 3)": "574", "Soul of Flight": "575", "Music Box": "576", "Demonite Brick": "577", "Hallowed Repeater": "578", "Hamdrax": "579", "Explosives": "580", "Inlet Pump": "581", "Outlet Pump": "582", "1 Second Timer": "583", "3 Second Timer": "584", "5 Second Timer": "585", "Candy Cane Block": "586", "Candy Cane Wall": "587", "Santa Hat": "588", "Santa Shirt": "589", "Santa Pants": "590", "Green Candy Cane Block": "591", "Green Candy Cane Wall": "592", "Snow Block": "593", "Snow Brick": "594", "Snow Brick Wall": "595", "Blue Light": "596", "Red Light": "597", "Green Light": "598", "Blue Present": "599", "Green Present": "600", "Yellow Present": "601", "Snow Globe": "602", "Carrot": "603", "Tizona": "613"}
npcs = {"Blue Slime": "1", "Demon Eye": "2", "Zombie": "3", "Eye of Cthulhu": "4", "Servant of Cthulhu": "5", "Eater of Souls": "6", "Devourer Head": "7", "Devourer Body": "8", "Devourer Tail": "9", "Giant Worm Head": "10", "Giant Worm Body": "11", "Giant Worm Tail": "12", "Eater of Worlds Head": "13", "Eater of Worlds Body": "14", "Eater of Worlds Tail": "15", "Mother Slime": "16", "Merchant": "17", "Nurse": "18", "Arms Dealer": "19", "Dryad": "20", "Skeleton": "21", "Guide": "22", "Meteor Head": "23", "Fire Imp": "24", "Burning Sphere": "25", "Goblin Peon": "26", "Goblin Thief": "27", "Goblin Warrior": "28", "Goblin Sorcerer": "29", "Chaos Ball": "30", "Angry Bones": "31", "Dark Caster": "32", "Water Sphere": "33", "Cursed Skull": "34", "Skeletron Head": "35", "Skeletron Hand": "36", "Old Man": "37", "Demolitionist": "38", "Bone Serpent Head": "39", "Bone Serpent Body": "40", "Bone Serpent Tail": "41", "Hornet": "42", "Man Eater": "43", "Undead Miner": "44", "Tim": "45", "Bunny": "46", "Corrupt Bunny": "47", "Harpy": "48", "Cave Bat": "49", "King Slime": "50", "Jungle Bat": "51", "Doctor Bones": "52", "The Groom": "53", "Clothier": "54", "Goldfish": "55", "Snatcher": "56", "Corrupt Goldfish": "57", "Piranha": "58", "Lava Slime": "59", "Hellbat": "60", "Vulture": "61", "Demon": "62", "Blue Jellyfish": "63", "Pink Jellyfish": "64", "Shark": "65", "Voodoo Demon": "66", "Crab": "67", "Dungeon Guardian": "68", "Antlion": "69", "Spike Ball": "70", "Dungeon Slime": "71", "Blazing Wheel": "72", "Goblin Scout": "73", "Bird": "74", "Pixie": "75", "Armored Skeleton": "77", "Mummy": "78", "Dark Mummy": "79", "Light Mummy": "80", "Corrupt Slime": "81", "Wraith": "82", "Cursed Hammer": "83", "Enchanted Sword": "84", "Mimic": "85", "Unicorn": "86", "Wyvern Head": "87", "Wyvern Legs": "88", "Wyvern Body": "89", "Wyvern Body 2": "90", "Wyvern Body 3": "91", "Wyvern Tail": "92", "Giant Bat": "93", "Corruptor": "94", "Digger Head": "95", "Digger Body": "96", "Digger Tail": "97", "Seeker Head": "98", "Seeker Body": "99", "Seeker Tail": "100", "Clinger": "101", "Angler Fish": "102", "Green Jellyfish": "103", "Werewolf": "104", "Bound Goblin": "105", "Bound Wizard": "106", "Goblin Tinkerer": "107", "Wizard": "108", "Clown": "109", "Skeleton Archer": "110", "Goblin Archer": "111", "Vile Spit": "112", "Wall of Flesh Wall of Flesh": "113", "Wall of Flesh Eye": "114", "The Hungry": "115", "The Hungry II": "116", "Leech Head": "117", "Leech Body": "118", "Leech Tail": "119", "Chaos Elemental": "120", "Slimer": "121", "Gastropod": "122", "Bound Mechanic": "123", "Mechanic": "124", "Retinazer": "125", "Spazmatism": "126", "Skeletron Prime": "127", "Prime Cannon": "128", "Prime Saw": "129", "Prime Vice": "130", "Prime Laser": "131", "Bald Zombie": "132", "Wandering Eye": "133", "The Destroyer": "134", "The Destroyer Body": "135", "The Destroyer Tail": "136", "Illuminant Bat": "137", "Illuminant Slime": "138", "Probe": "139", "Possessed Armor": "140", "Toxic Sludge": "141", "Santa Claus": "142", "Snowman Gangsta": "143", "Mister Stabby": "144", "Snow Balla": "145"}
buffs = {"Obsidian Skin": "1", "Regeneration": "2", "Swiftness": "3", "Gills": "4", "Ironskin": "5", "Mana Regeneration": "6", "Magic Power": "7", "Featherfall": "8", "Spelunker": "9", "Invisibility": "10", "Shine": "11", "Night Owl": "12", "Battle": "13", "Thorns": "14", "Water Walking": "15", "Archery": "16", "Hunter": "17", "Gravitation": "18", "Orb of Light": "19", "Poisoned": "20", "Potion Sickness": "21", "Darkness": "22", "Cursed": "23", "On Fire!": "24", "Tipsy": "25", "Well Fed": "26", "Fairy": "27", "Werewolf": "28", "Clairvoyance": "29", "Bleeding": "30", "Confused": "31", "Slow": "32", "Weak": "33", "Merfolk": "34", "Silenced": "35", "Broken Armor": "36", "Horrified": "37", "The Tongue": "38", "Cursed Inferno": "39", "Pet Bunny": "40"}
projectiles = {"Wooden Arrow": "1", "Fire Arrow": "2", "Shuriken": "3", "Unholy Arrow": "4", "Jester's Arrow": "5", "Enchanted Boomerang": "6", "Vilethorn": "7", "Vilethorn (end)": "8", "Starfury": "9", "Purification Powder": "10", "Vile Powder": "11", "Fallen Star": "12", "Grappling Hook": "13", "Musket Ball": "14", "Ball of Fire": "15", "Magic Missile": "16", "Dirt Ball": "17", "Orb of Light": "18", "Flamarang": "19", "Green Laser": "20", "Bone": "21", "Water Stream": "22", "Harpoon": "23", "Spiky Ball": "24", "Ball 'O Hurt": "25", "Blue Moon": "26", "Water Bolt": "27", "Bomb": "28", "Dynamite": "29", "Grenade": "30", "Sand Ball": "31", "Ivy Whip": "32", "Thorn Chakrum": "33", "Flamelash": "34", "Sunfury": "35", "Meteor Shot": "36", "Sticky Bomb": "37", "Harpy Feather": "38", "Mud Ball*": "39", "Ash Ball*": "40", "Hellfire Arrow": "41", "Sand Ball": "42", "Tombstone": "43", "Demon Sickle": "44", "Demon Scythe": "45", "Dark Lance": "46", "Trident": "47", "Throwing Knife": "48", "Spear": "49", "Glowstick": "50", "Seed": "51", "Wooden Boomerang": "52", "Sticky Glowstick": "53", "Poisoned Knife": "54", "Stinger": "55", "Ebonsand Ball": "56", "Cobalt Chainsaw": "57", "Mythril Chainsaw": "58", "Cobalt Drill": "59", "Mythril Drill": "60", "Adamantite Chainsaw": "61", "Adamantite Drill": "62", "The Dao of Pow": "63", "Mythril Halberd": "64", "Ebonsand Ball": "65", "Adamantite Glaive": "66", "Pearl Sand Ball": "67", "Pearl Sand Ball": "68", "Holy Water": "69", "Unholy Water": "70", "Silt Ball": "71", "Blue Fairy": "72", "Hook": "73", "Hook": "74", "Happy Bomb": "75", "Note (small)": "76", "Note (medium)": "77", "Note (large)": "78", "Rainbow": "79", "Ice Block": "80", "Wooden Arrow (Goblin Archer)": "81", "Flaming Arrow (Skeleton Archer)": "82", "Eye Laser": "83", "Pink Laser": "84", "Flames": "85", "Pink Fairy": "86", "Green Fairy": "87", "Purple Laser": "88", "Crystal Bullet": "89", "Crystal Shard": "90", "Holy Arrow": "91", "Hallow Star (Falls on Holy Arrow impact)": "92", "Magic Dagger": "93", "Crystal Storm": "94", "Cursed Flame": "95", "Cursed Flame": "96", "Cobalt Naginata": "97", "Poison Dart": "98", "Boulder": "99", "Death laser": "100", "Eye Fire": "101", "Bomb": "102", "Cursed Arrow": "103", "Cursed Bullet": "104", "Gungnir": "105", "Light Disc": "106", "Hamdrax": "107", "Explosives": "108", "Snow Ball": "109", "Bullet": "110", "Bunny": "111"}
tiles = {"Dirt": "0", "Stone Block": "1", "Grass": "2", "Short Grass Plants": "3", "Torch": "4", "50 Tree": "5", "Iron Ore": "6", "Copper Ore": "7", "Gold Ore": "8", "Silver Ore": "9", "Wooden Door (closed)": "10", "Wooden Door (open)": "11", "Crystal Heart": "12", "bottle": "13", "Wooden Table": "14", "Wooden Chair": "15", "Iron Anvil": "16", "Furnace": "17", "Work Bench": "18", "Wood Platform": "19", "Sapling": "20", "Chest": "21", "Demonite Ore": "22", "Corrupt grass": "23", "Corruption Plants": "24", "Ebonstone Block": "25", "Demon Altar": "26", "Sunflower": "27", "Pot": "28", "Piggy Bank": "29", "Wood": "30", "Shadow Orb": "31", "Corruption Thorny Bush": "32", "Candle": "33", "Copper Chandelier": "34", "Silver Chandelier": "35", "Gold Chandelier": "36", "Meteorite": "37", "Gray Brick": "38", "Red Brick": "39", "Clay Block": "40", "Blue Brick": "41", "Chain Lantern": "42", "Green Brick": "43", "Pink Brick": "44", "Gold Brick": "45", "Silver Brick": "46", "Copper Brick": "47", "Spike": "48", "Water Candle": "49", "Book": "50", "Cobweb": "51", "Vines": "52", "Sand Block": "53", "Glass": "54", "Sign": "55", "Obsidian": "56", "Ash Block": "57", "Hellstone": "58", "Mud Block": "59", "Jungle grass": "60", "Short Jungle Plants": "61", "Jungle Vines": "62", "Sapphire": "63", "Ruby": "64", "Emerald": "65", "Topaz": "66", "Amethyst": "67", "Diamond": "68", "Jungle Thorny Bush": "69", "Mushroom grass": "70", "Glowing Mushroom": "71", "Giant Glowing Mushroom": "72", "Tall Grass Plants": "73", "Tall Jungle Plants": "74", "Obsidian Brick": "75", "Hellstone Brick": "76", "Hellforge": "77", "Clay Pot": "78", "Bed": "79", "Cactus": "80", "Coral": "81", "Daybloom (growing)": "82", "Daybloom (mature)": "83", "Daybloom (blooming)": "84", "Tombstone": "85", "Loom": "86", "Piano": "87", "Dresser": "88", "Bench": "89", "Bathtub": "90", "Red Banner": "91", "Lamp Post": "92", "Tiki Torch": "93", "Keg": "94", "Chinese Lantern": "95", "Cooking Pot": "96", "Safe": "97", "Skull Lantern": "98", "Trash Can (not used)": "99", "Candelabra": "100", "Bookcase": "101", "Throne": "102", "Bowl": "103", "Grandfather Clock": "104", "Statue": "105", "Sawmill": "106", "Cobalt Ore": "107", "Mythril Ore": "108", "Hallowed Grass": "109", "Short Hallowed Plants": "110", "Adamantite Ore": "111", "Ebonsand Block": "112", "Tall Hallowed Plants": "113", "Tinkerer's Workshop": "114", "Hallowed Vines": "115", "Pearlsand Block": "116", "Pearlstone Block": "117", "Pearlstone Brick": "118", "Iridescent Brick": "119", "Mudstone Block": "120", "Cobalt Brick": "121", "Mythril Brick": "122", "Silt Block": "123", "Wooden Beam": "124", "Crystal Ball": "125", "Disco Ball": "126", "Ice Rod)": "127", "Mannequin": "128", "Crystal Shard": "129", "Active Stone Block": "130", "Inactive Stone Block": "131", "Lever": "132", "Adamantite Forge": "133", "Mythril Anvil": "134", "Red Pressure Plate": "135", "Switch": "136", "Dart Trap": "137", "Boulder": "138", "Music Box (Overworld Day)": "139", "Demonite Brick": "140", "Explosives": "141", "Inlet Pump": "142", "Outlet Pump": "143", "1 Second Timer": "144", "Candy Cane Block": "145", "Green Candy Cane Block": "146", "Snow Block": "147", "Snow Brick": "148", "Blue Light": "149"}
walls = {"Sky": "0", "Stone Wall": "1", "Dirt Wall (natural)": "2", "Ebonstone Wall (natural)": "3", "Wood Wall": "4", "Gray Brick Wall": "5", "Red Brick Wall": "6", "Blue Brick Wall (natural)": "7", "Green Brick Wall (natural)": "8", "Pink Brick Wall (natural)": "9", "Gold Brick Wall": "10", "Silver Brick Wall": "11", "Copper Brick Wall": "12", "Hellstone Brick Wall (natural)": "13", "Obsidian Brick Wall (natural)": "14", "Mud Wall (natural)": "15", "Dirt Wall": "16", "Blue Brick Wall": "17", "Green Brick Wall": "18", "Pink Brick Wall": "19", "Obsidian Brick Wall": "20", "Glass Wall": "21", "Pearlstone Brick Wall": "22", "Iridescent Brick Wall": "23", "Mudstone Brick Wall": "24", "Cobalt Brick Wall": "25", "Mythril Brick Wall": "26", "Planked Wall": "27", "Pearlstone Wall (natural)": "28", "Candy Cane Wall": "29", "Green Candy Cane Wall": "30", "Snow Brick Wall": "31"}
prefixes = {"Large": "1", "Massive": "2", "Dangerous": "3", "Savage": "4", "Sharp": "5", "Pointy": "6", "Tiny": "7", "Terrible": "8", "Small": "9", "Dull": "10", "Unhappy": "11", "Bulky": "12", "Shameful": "13", "Heavy": "14", "Light": "15", "Sighted": "16", "Rapid": "17", "Hasty": "18", "Intimidating": "19", "Deadly": "20", "Staunch": "21", "Awful": "22", "Lethargic": "23", "Awkward": "24", "Powerful": "25", "Mystic": "26", "Adept": "27", "Masterful": "28", "Inept": "29", "Ignorant": "30", "Deranged": "31", "Intense": "32", "Taboo": "33", "Celestial": "34", "Furious": "35", "Manic": "36", "Keen": "37", "Superior": "38", "Forceful": "39", "Broken": "40", "Damaged": "41", "Shoddy": "42", "Quick": "43", "Deadly": "44", "Agile": "45", "Nimble": "46", "Murderous": "47", "Slow": "48", "Sluggish": "49", "Lazy": "50", "Annoying": "51", "Nasty": "52", "Manic": "53", "Hurtful": "54", "Strong": "55", "Unpleasant": "56", "Weak": "57", "Ruthless": "58", "Frenzying": "59", "Godly": "60", "Demonic": "61", "Zealous": "62", "Hard": "63", "Guarding": "64", "Armored": "65", "Warding": "66", "Arcane": "67", "Precise": "68", "Lucky": "69", "Jagged": "70", "Spiked": "71", "Angry": "72", "Menacing": "73", "Brisk": "74", "Fleeting": "75", "Hasty": "76", "Quick": "77", "Wild": "78", "Rash": "79", "Intrepid": "80", "Violent": "81", "Legendary": "82", "Unreal": "83", "Mythical": "84"}


def get():
    """ Returns dict containing all dicts in this package """
    return {"items": items, "npcs": npcs, "buffs": buffs, "projectiles": projectiles, "tiles": tiles, "walls": walls}


def find(search, place="items"):
    """ Searches in data dicts for specified item/tile/npc/buff/etc """
    search = search.title()
    data = get()
    if place in data:
        if search in data[place]:
            return data[place][search]
        else:
            return difflib.get_close_matches(search, data[place])
    else:
        return find(search, difflib.get_close_matches(place, data, 1)[0])