# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.service_client import ServiceClient
from msrest import Serializer, Deserializer
from msrestazure import AzureConfiguration
from .version import VERSION
from .operations.operations import Operations
from .operations.components_operations import ComponentsOperations
from .operations.web_tests_operations import WebTestsOperations
from .operations.export_configurations_operations import ExportConfigurationsOperations
from .operations.component_current_billing_features_operations import ComponentCurrentBillingFeaturesOperations
from .operations.component_quota_status_operations import ComponentQuotaStatusOperations
from .operations.api_keys_operations import APIKeysOperations
from . import models


class ApplicationInsightsManagementClientConfiguration(AzureConfiguration):
    """Configuration for ApplicationInsightsManagementClient
    Note that all parameters used to create this instance are saved as instance
    attributes.

    :param credentials: Credentials needed for the client to connect to Azure.
    :type credentials: :mod:`A msrestazure Credentials
     object<msrestazure.azure_active_directory>`
    :param subscription_id: The Azure subscription ID.
    :type subscription_id: str
    :param str base_url: Service URL
    """

    def __init__(
            self, credentials, subscription_id, base_url=None):

        if credentials is None:
            raise ValueError("Parameter 'credentials' must not be None.")
        if subscription_id is None:
            raise ValueError("Parameter 'subscription_id' must not be None.")
        if not base_url:
            base_url = 'https://management.azure.com'

        super(ApplicationInsightsManagementClientConfiguration, self).__init__(base_url)

        self.add_user_agent('azure-mgmt-applicationinsights/{}'.format(VERSION))
        self.add_user_agent('Azure-SDK-For-Python')

        self.credentials = credentials
        self.subscription_id = subscription_id


class ApplicationInsightsManagementClient(object):
    """Composite Swagger for Application Insights Management Client

    :ivar config: Configuration for client.
    :vartype config: ApplicationInsightsManagementClientConfiguration

    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.applicationinsights.operations.Operations
    :ivar components: Components operations
    :vartype components: azure.mgmt.applicationinsights.operations.ComponentsOperations
    :ivar web_tests: WebTests operations
    :vartype web_tests: azure.mgmt.applicationinsights.operations.WebTestsOperations
    :ivar export_configurations: ExportConfigurations operations
    :vartype export_configurations: azure.mgmt.applicationinsights.operations.ExportConfigurationsOperations
    :ivar component_current_billing_features: ComponentCurrentBillingFeatures operations
    :vartype component_current_billing_features: azure.mgmt.applicationinsights.operations.ComponentCurrentBillingFeaturesOperations
    :ivar component_quota_status: ComponentQuotaStatus operations
    :vartype component_quota_status: azure.mgmt.applicationinsights.operations.ComponentQuotaStatusOperations
    :ivar api_keys: APIKeys operations
    :vartype api_keys: azure.mgmt.applicationinsights.operations.APIKeysOperations

    :param credentials: Credentials needed for the client to connect to Azure.
    :type credentials: :mod:`A msrestazure Credentials
     object<msrestazure.azure_active_directory>`
    :param subscription_id: The Azure subscription ID.
    :type subscription_id: str
    :param str base_url: Service URL
    """

    def __init__(
            self, credentials, subscription_id, base_url=None):

        self.config = ApplicationInsightsManagementClientConfiguration(credentials, subscription_id, base_url)
        self._client = ServiceClient(self.config.credentials, self.config)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self.api_version = '2015-05-01'
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)

        self.operations = Operations(
            self._client, self.config, self._serialize, self._deserialize)
        self.components = ComponentsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.web_tests = WebTestsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.export_configurations = ExportConfigurationsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.component_current_billing_features = ComponentCurrentBillingFeaturesOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.component_quota_status = ComponentQuotaStatusOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.api_keys = APIKeysOperations(
            self._client, self.config, self._serialize, self._deserialize)
