# Created: 21.07.12
# License: MIT License
from __future__ import unicode_literals
__author__ = "mozman <mozman@gmx.at>"

import unittest
from dxfgrabber.tags import Tags
from dxfgrabber.entitysection import EntitySection


class DrawingProxy:
    def __init__(self, version):
        self.dxfversion = version


class TestPolylineDXF12(unittest.TestCase):
    def setUp(self):
        tags = Tags.from_text(POLYLINE_DXF12)
        self.entities = EntitySection.from_tags(tags, DrawingProxy('AC1009'))

    def test_polyline(self):
        self.assertEqual(len(self.entities), 1)

    def test_polyline_attribs(self):
        polyline = self.entities[0]
        self.assertEqual(polyline.default_start_width, 0.)
        self.assertEqual(polyline.default_end_width, 0.)

    def test_polyline_data(self):
        polyline = self.entities[0]
        self.assertEqual(len(polyline), 4)

    def test_polyline_points(self):
        polyline = self.entities[0]
        self.assertEqual(polyline.points[3], (0., 1., 0.))

    def test_polyline_width(self):
        polyline = self.entities[0]
        self.assertEqual(len(polyline.width), len(polyline.points))

    def test_polyline_bulge(self):
        polyline = self.entities[0]
        self.assertEqual(len(polyline.bulge), len(polyline.points))


class TestPolylineDXF13(unittest.TestCase):
    def setUp(self):
        tags = Tags.from_text(POLYLINE_DXF13)
        self.entities = EntitySection.from_tags(tags, DrawingProxy('AC1024'))

POLYLINE_DXF13 = """  0
SECTION
  2
ENTITIES
  0
ENDSEC
"""

POLYLINE_DXF12 = """  0
SECTION
  2
ENTITIES
  0
POLYLINE
 62
7
  8
mozman
 66
1
 10
0.0
 20
0.0
 30
0.0
 70
8
  0
VERTEX
  8
0
 10
0.0
 20
0.0
 30
0.0
  0
VERTEX
  8
0
 10
1.0
 20
0.0
 30
0.0
  0
VERTEX
  8
0
 10
1.0
 20
1.0
 30
0.0
  0
VERTEX
  8
0
 10
0.0
 20
1.0
 30
0.0
  0
SEQEND
  0
ENDSEC
"""
