from os.path import sep, normpath, normcase, isabs

from fsn import Directory
from funcs import validdrivespec

class FileSystem(Directory):

    bases = None

    def _checkname(self, s):
        return validdrivespec(s)

    def absname(self):
        return self.name

    def getDir(self, dn):
        if isinstance(dn, basestring):
            liz = list(normpath(dn).split(sep))
            if isabs(dn) and liz[0]:
                assert validdrivespec(liz[0]) == self.name
                del liz[0]
        else:
            liz = list(dn)
        # import pdb; pdb.set_trace()
        return self._getDir(liz)

    def getAliases(self, done=set()):
        if self in done:
            return
        for a in getattr(self, 'aliases', list()):
            x

    def substitutes(self, do):
        """
        self substitutes the directory object "do"
        """
        do.make_available_as(self)
        if do.name == 'Y:':
            import pdb; pdb.set_trace()
        print do.absname(), '<-', [a.absname() for a in do.aliases]
        self.parent.unroot(self)
        if not hasattr(self, 'abbreviates'):
            setattr(self, 'abbreviates', set())
        self.abbreviates.add(do)

# vim: ts=8 sts=4 si et tw=79 sw=4
