// The MIT License
//
// Copyright (c) 2019 Herbert Shin
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

#ifndef __CPADDING_H__
#define __CPADDING_H__

/* AES_128_BLOCKSIZE is the default block size used in Padding/cPadding.
 * According to RFC-3565, default AES algorithm uses 16 Bytes (or 128 bits)
 * for encryption/decryption. */
#define AES_128_BLOCKSIZE 16
#define AES_256_BLOCKSIZE 32

/* Blowfish is a symmetric-key block cipher that uses block cipher of 64 bit
 * blocks (8 Bytes), with variable key lengths from 32 to 448 bits. */
#define BLOWFISH_BLOCKSIZE 8

/* CAST5 is a symmetric-key block cipher that uses block cipher of 64 bit
 * blocks (8 Bytes), with variable key lengths from 40 to 128 bits. */
#define CAST5_BLOCKSIZE 8

/* DES is a symmetric-key block cipher that uses block cipher of 64 bit
 * blocks (8 Bytes), with static key lengths of 64 bits (8 parity bits). */
#define DES_BLOCKSIZE 8


/* Calculate padding offset required for `size` to fill `blocksize`. */
int padding_length(int size, int blocksize) {
  if (size < 0 || blocksize <= 0) {
    return -1;
  }
  return blocksize - (size % blocksize);
}

#endif
