/**
*    The Nomensa accessible media player is a flexible multimedia solution for websites and intranets.  
*    The core player consists of JavaScript wrapper responsible for generating an accessible HTML toolbar 
*    for interacting with a media player of your choice. We currently provide support for YouTube (default),
*    Vimeo and JWPlayer although it should be possible to integrate the player with almost any media player on
*    the web (provided a JavaScript api for the player in question is available).
*    
*    Copyright (C) 2012  Nomensa Ltd
*
*    This program is free software: you can redistribute it and/or modify
*    it under the terms of the GNU General Public License as published by
*    the Free Software Foundation, either version 3 of the License, or
*    (at your option) any later version.
*
*    This program is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*    GNU General Public License for more details.
*
*    You should have received a copy of the GNU General Public License
*    along with this program.  If not, see <http://www.gnu.org/licenses/>.
**/

// Method for adding/remove class of 'wide' to player for wider layouts
$(document).ready(function(){$(window).resize(function(){$('.player-container').each(function(){if($(this).width()>580){$(this).addClass('player-wide');}else{$(this).removeClass('player-wide');}});});});
// Instantiation method for the player manager
var PlayerManager=function(){this.players={};this.getPlayer=function(playerID){if(this.players[playerID]!==undefined){return this.players[playerID];}return null;};this.addPlayer=function(player){if(this.players[player.config.id]===undefined){this.players[player.config.id]=player;return true;}return false;};this.removePlayer=function(playerID){if(this.players[playerID]!==undefined){delete this.players[playerID];}};};
// Create an instance of the player manager called PlayerDaemon
var PlayerDaemon=new PlayerManager();var html5_methods={play:function(){this.player.play();this.setSliderTimeout();if(this.config.captionsOn&&this.captions){this.setCaptionTimeout();}},pause:function(){this.player.pause();this.clearSliderTimeout();if(this.config.captionsOn&&this.captions){this.clearCaptionTimeout();}},ffwd:function(){var time=this.getCurrentTime()+this.config.player_skip;this.seek(time);},rewd:function(){var time=this.getCurrentTime()-this.config.player_skip;if(time<0){time=0;}this.seek(time);},mute:function(){var $button=this.$html.find('button.mute');if(this.player.muted){this.player.muted=false;if($button.hasClass('muted')){$button.removeClass('muted');}}else{this.player.muted=true;$button.addClass('muted');}},volup:function(){var vol=this.player.volume*100;if(vol<(100-this.config.volume_step)){vol+=this.config.volume_step;}else{vol=100;}this.player.volume=(vol/100);this.updateVolume(Math.round(vol));},voldwn:function(){var vol=this.player.volume*100;if(vol>this.config.volume_step){vol-=this.config.volume_step;}else{vol=0;}this.player.volume=(vol/100);this.updateVolume(Math.round(vol));},getDuration:function(){return this.player.duration;},getCurrentTime:function(){return this.player.currentTime;},getBytesLoaded:function(){return this.player.buffered.end(0);},getBytesTotal:function(){if(this.player.seekable!==undefined){return this.player.seekable.end();}else{return this.player.duration;}},seek:function(time){this.player.currentTime=time;},cue:function(){return;}};
// Main media player plugin
$(document).ready(function(){$(window).resize(function(){$('.player-container').each(function(){if($(this).width()>580){$(this).addClass('player-wide');}else{$(this).removeClass('player-wide');}});});});var PlayerManager=function(){this.players={};this.getPlayer=function(playerID){if(this.players[playerID]!=undefined){return this.players[playerID];}return null;};this.addPlayer=function(player){if(this.players[player.config.id]==undefined){this.players[player.config.id]=player;return true;}return false;};this.removePlayer=function(playerID){if(this.players[playerID]!=undefined){delete this.players[playerID];}};};var PlayerDaemon=new PlayerManager();var html5_methods={play:function(){this.player.play();this.setSliderTimeout();if(this.config.captionsOn&&this.captions){this.setCaptionTimeout();}},pause:function(){this.player.pause();this.clearSliderTimeout();if(this.config.captionsOn&&this.captions){this.clearCaptionTimeout();}},ffwd:function(){var time=this.getCurrentTime()+this.config.player_skip;this.seek(time);},rewd:function(){var time=this.getCurrentTime()-this.config.player_skip;if(time<0){time=0;}this.seek(time);},mute:function(){var $button=this.$html.find('button.mute');if(this.player.muted){this.player.muted=false;if($button.hasClass('muted')){$button.removeClass('muted');}}else{this.player.muted=true;$button.addClass('muted');}},volup:function(){var vol=this.player.volume*100;if(vol<(100-this.config.volume_step)){vol+=this.config.volume_step;}else{vol=100;}this.player.volume=(vol/100);this.updateVolume(Math.round(vol));},voldwn:function(){var vol=this.player.volume*100;if(vol>this.config.volume_step){vol-=this.config.volume_step;}else{vol=0;}this.player.volume=(vol/100);this.updateVolume(Math.round(vol));},getDuration:function(){return this.player.duration;},getCurrentTime:function(){return this.player.currentTime;},getBytesLoaded:function(){return this.player.buffered.end(0);},getBytesTotal:function(){if(this.player.seekable!=undefined){return this.player.seekable.end();}else{return this.player.duration;}},seek:function(time){this.player.currentTime=time;},cue:function(){return;}};(function($){$.fn.player=function(options,functions){var defaults={id:'media_player',url:'http://www.youtube.com/apiplayer?enablejsapi=1&version=3&playerapiid=',media:'8LiQ-bLJaM4',repeat:false,captions:null,captionsOn:true,flashWidth:'100%',flashHeight:'300px',playerStyles:{'height':'100%','width':'100%'},sliderTimeout:350,flashContainer:'span',playerContainer:'span',image:'',playerSkip:10,volumeStep:10,buttons:{forward:true,rewind:true,toggle:true},logoURL:'http://www.nomensa.com?ref=logo',useHtml5:true,swfCallback:null};var config=$.extend(true,{},defaults,options);var supports_media=function(mimetype,container){var elem=document.createElement(container);if(elem.canPlayType!=undefined){var playable=elem.canPlayType(mimetype);if((playable.toLowerCase()=='maybe')||(playable.toLowerCase()=='probably')){return true}}return false};var get_mime=function(filetype){var mimetype='';var media_container='video';switch(filetype){case'mp4':mimetype='video/mp4; codecs="avc1.42E01E, mp4a.40.2"';break;case'm4v':mimetype='video/mp4; codecs="avc1.42E01E, mp4a.40.2"';break;case'ogg':mimetype='video/ogg; codecs="theora, vorbis"';break;case'ogv':mimetype='video/ogg; codecs="theora, vorbis"';break;case'webm':mimetype='video/webm; codecs="vp8, vorbis"';break;case'mp3':mimetype='audio/mpeg';media_container='audio';break}return{'mimetype':mimetype,'container':media_container}};var get_media_type=function(player){var media=player.config.media;var strt=media.lastIndexOf('.');if(strt!=-1){var ext=media.substring(strt+1);var mime=get_mime(ext);return mime}return null};var isFirefox=function(){if($.browser.mozilla){return(parseInt($.browser.version,10)>=2)?true:false}return false};var methods={init:function(player){this.player=player;this.cue();this.player.addEventListener("onStateChange",'(function(state) { return playerState(state, "'+this.config.id+'"); })')},generatePlayerContainer:function(){var $container=$('<'+this.config.playerContainer+' />').css(this.config.playerStyles).addClass('player-container');if($.browser.msie){$container.addClass('player-container-ie player-container-ie-'+$.browser.version.substring(0,1))}return $container},getFlashVars:function(){var flashvars={controlbar:'none',file:this.config.media};if(this.config.image!=''){flashvars.image=this.config.image}if(this.config.repeat){flashvars.repeat=this.config.repeat}return flashvars},getFlashParams:function(){return{allowScriptAccess:"always",wmode:'transparent'}},getURL:function(){return[this.config.url,this.config.id].join('')},generateFlashPlayer:function($playerContainer){var $self=this;var flashvars=this.getFlashVars();var params=this.getFlashParams();var atts={id:this.config.id,name:this.config.id};var $container=$('<'+this.config.flashContainer+' />').attr('id','player-'+this.config.id).addClass('flashReplace').html('This content requires Macromedia Flash Player. You can <a href="http://get.adobe.com/flashplayer/">install or upgrade the Adobe Flash Player here</a>.');var $videoContainer=$('<span />').addClass('video');var url=this.getURL();setTimeout(function(){swfobject.embedSWF(url,$container.attr('id'),$self.config.flashWidth,$self.config.flashHeight,"9.0.115",null,flashvars,params,atts,$self.config.swfCallback);if(isFirefox()){$self.$html.find('object').attr("tabindex",'-1')}},0);$playerContainer.append($videoContainer.append($container));return $playerContainer},generateHTML5Player:function($playerContainer,container_type,mime_type){var $videoContainer=$('<span />');$videoContainer[0].className='video';var $video=$('<'+container_type+' />').attr({'id':this.config.id,'src':this.config.media,'type':mime_type}).css({'width':'100%','height':'50%'});if($.trim(this.config.image)!=''){$video.attr({'poster':$.trim(this.config.image)})}return $playerContainer.append($videoContainer.append($video))},createButton:function(action,name){var $label=0;var btnId=[action,this.config.id].join('-');var $btn=$('<button />').append(name).addClass(action).attr({'title':action,'id':btnId}).addClass('ui-corner-all ui-state-default').hover(function(){$(this).addClass("ui-state-hover")},function(){$(this).removeClass("ui-state-hover")}).focus(function(){$(this).addClass("ui-state-focus")}).blur(function(){$(this).removeClass("ui-state-focus")}).click(function(e){e.preventDefault();});return $btn},getFuncControls:function(){var self=this;var $cont=$('<div>');$cont[0].className='player-controls';var buttons=[];if(self.config.buttons.toggle){var $toggle=self.createButton('play','Play').attr({'aria-live':'assertive'}).click(function(){if($(this).hasClass('play')){$(this).removeClass('play').addClass('pause').attr({'title':'Pause','id':'pause-'+self.config.id}).text('Pause');self.play()}else{$(this).removeClass('pause').addClass('play').attr({'title':'Play','id':'play-'+self.config.id}).text('Play');self.pause()}});buttons.push($toggle)}else{var $play=self.createButton('play','Play').click(function(){self.play()});var $pause=self.createButton('pause','Pause').click(function(){self.pause()});buttons.push($play);buttons.push($pause)}if(self.config.buttons.rewind){var $rwd=self.createButton('rewind','Rewind').click(function(){self.rewd()});buttons.push($rwd)}if(self.config.buttons.forward){var $ffwd=self.createButton('forward','Forward').click(function(){self.ffwd()});buttons.push($ffwd)}if(self.config.captions){var $capt=self.createButton('captions','Captions').click(function(){self.toggleCaptions()});var myClass=(self.config.captionsOn==true)?'captions-on':'captions-off';$capt.addClass(myClass);buttons.push($capt)}var i;for(i=0;i<buttons.length;i=i+1){$cont[0].appendChild(buttons[i][0])}return $cont},getVolControls:function(){var self=this;var $cont=$('<div>').addClass('volume-controls');var $mute=self.createButton('mute','Mute').click(function(){self.mute()});var $up=self.createButton('vol-up','+<span class="ui-helper-hidden-accessible"> Volume Up</span>').click(function(){self.volup()});var $dwn=self.createButton('vol-down','-<span class="ui-helper-hidden-accessible"> Volume Down</span>').click(function(){self.voldwn()});var $vol=$('<span />').attr({'id':'vol-'+self.config.id,'class':'vol-display'}).text('100%');var controls=[$mute,$dwn,$up,$vol];var i;for(i=0;i<controls.length;i=i+1){$cont[0].appendChild(controls[i][0])}return $cont},getSliderBar:function(){var $info=$('<span />').addClass('ui-helper-hidden-accessible').html('<p>The timeline slider below uses WAI ARIA. Please use the documentation for your screen reader to find out more.</p>');var $curr_time=$('<span />').addClass('current-time').attr({'id':'current-'+this.config.id}).text('00:00:00');var $slider=this.getSlider();var $dur_time=$('<span />').addClass('duration-time').attr({'id':'duration-'+this.config.id}).text('00:00:00');var $bar=$('<div />').addClass('timer-bar').append($info);var bits=[$curr_time,$slider,$dur_time];var i;for(i=0;i<bits.length;i=i+1){$bar[0].appendChild(bits[i][0])}return $bar},getSlider:function(){var self=this;var $sliderBar=$('<span />').attr('id','slider-'+this.config.id).slider({orientation:'horizontal',change:function(event,ui){var percentage=ui.value;var seconds=(percentage/100)*self.getDuration();self.seek(seconds)}});$sliderBar.find('a.ui-slider-handle').attr({'role':'slider','aria-valuemin':'0','aria-valuemax':'100','aria-valuenow':'0','aria-valuetext':'0 percent','title':'Slider Control'});var $progressBar=$('<span />').addClass('progress-bar').attr({'id':'progress-bar-'+this.config.id,'tabindex':'-1'}).addClass('ui-progressbar-value ui-widget-header ui-corner-left').css({'width':'0%','height':'95%'});var $loadedBar=$('<span />').attr({'id':'loaded-bar-'+this.config.id,'tabindex':'-1'}).addClass('loaded-bar ui-progressbar-value ui-widget-header ui-corner-left').css({'height':'95%','width':'0%'});return $sliderBar.append($progressBar,$loadedBar)},setSliderTimeout:function(){var self=this;self.sliderInterval=setInterval(function(){self.updateSlider()},self.config.sliderTimeout)},clearSliderTimeout:function(){var self=this;if(self.sliderInterval!=undefined){self.sliderInterval=clearInterval(self.sliderInterval)}},updateSlider:function(){var duration=(typeof(this.duration)!='undefined')?this.duration:this.getDuration();var duration_found=(typeof(this.duration_found)=='boolean')?this.duration_found:false;var current_time=this.getCurrentTime();var markerPosition=0;if(duration>0){markerPosition=(current_time/duration)*100;markerPosition=parseInt(markerPosition,10)}else{duration=0}if(!duration_found){$('#duration-'+this.config.id).html(this.formatTime(parseInt(duration,10)));this.duration_found=true}$('#slider-'+this.config.id).find('a.ui-slider-handle').attr({'aria-valuenow':markerPosition,'aria-valuetext':markerPosition.toString()+' percent'}).css('left',markerPosition.toString()+'%');$('#progress-bar-'+this.config.id).attr({'aria-valuenow':markerPosition,'aria-valuetext':markerPosition.toString()+' percent'}).css('width',markerPosition.toString()+'%');this.updateLoaderBar();this.updateTime(current_time)},updateLoaderBar:function(){var loaded=(this.getBytesLoaded()/this.getBytesTotal())*100;loaded=parseInt(loaded,10);if(!isFinite(loaded)){loaded=0}$('#loaded-bar-'+this.config.id).attr({'aria-valuetext':loaded.toString()+' percent','aria-valuenow':loaded}).css('width',loaded.toString()+'%')},formatTime:function(time){var hours=0;var minutes=0;var seconds=0;if(time>=60){minutes=parseInt(time/60,10);seconds=time-(minutes*60);if(minutes>=60){hours=parseInt(minutes/60,10);minutes-=parseInt(hours*60,10)}}else{seconds=time}var tmp=[hours,minutes,seconds];var i;for(i=0;i<tmp.length;i=i+1){tmp[i]=(tmp[i]<10)?'0'+tmp[i].toString():tmp[i].toString()}return tmp.join(":")},updateTime:function(time){var t=this.formatTime(parseInt(time,10));this.$html.find('#current-'+this.config.id).html(t)},getControls:function(){var $controls=$('<span />').addClass('ui-corner-bottom').addClass('control-bar');var $logo=$('<a />').attr('href','http://www.nomensa.com?ref=logo').html('Accessible Media Player by Nomensa').addClass('logo');$controls.append($logo);var $func=this.getFuncControls();var $vol=this.getVolControls();var $slider=this.getSliderBar();var bits=[$func,$vol,$slider];var i;for(i=0;i<bits.length;i=i+1){$controls[0].appendChild(bits[i][0])}return $controls},assembleHTML:function(){var $playerContainer=this.generatePlayerContainer();var $flashContainer=this.generateFlashPlayer($playerContainer);var $container=$flashContainer.append(this.getControls());return $container},assembleHTML5:function(container_type,mime_type){var $playerContainer=this.generatePlayerContainer();var $videoContainer=this.generateHTML5Player($playerContainer,container_type,mime_type);var $container=$videoContainer.append(this.getControls());return $container},updateVolume:function(volume){$('#vol-'+this.config.id).text(volume.toString()+'%');var $mute=this.$html.find('button.mute');if(volume==0){$mute.addClass('muted')}else{if($mute.hasClass('muted')){$mute.removeClass('muted')}}},getCaptions:function(){var self=this;if(self.config.captions){var $captions=[];$.ajax({url:self.config.captions,success:function(data){if($(data).find('p').length>0){self.captions=$(data).find('p')}}})}},syncCaptions:function(){var caption;if(this.captions){var time=this.getCurrentTime();time=this.formatTime(parseInt(time,10));caption=this.captions.filter('[begin="'+time+'"]');if(caption.length==1){this.insertCaption(caption)}}},insertCaption:function(caption){if(this.$html.find('.caption').length==1){this.$html.find('.caption').text(caption.text())}else{var $c=$('<div>').text(caption.text());$c[0].className='caption';this.$html.find('.video').prepend($c)}},getPreviousCaption:function(time){var caption;if(time==undefined){time=this.getCurrentTime()}var formattedTime=this.formatTime(parseInt(time,10));if(this.captions){caption=this.captions.filter('[begin="'+formattedTime+'"]');while((caption.length!=1)&&(time>0)){time--;formattedTime=this.formatTime(parseInt(time,10));caption=this.captions.filter('[begin="'+formattedTime+'"]')}if(caption.length==1){this.insertCaption(caption)}}},setCaptionTimeout:function(){var self=this;if(self.captionInterval==undefined){self.captionInterval=setInterval(function(){self.syncCaptions()},500)}},clearCaptionTimeout:function(){if(this.captionInterval!=undefined){this.captionInterval=clearInterval(this.captionInterval)}},play:function(){this.player.playVideo();this.setSliderTimeout();if(this.config.captionsOn&&this.captions){this.setCaptionTimeout()}},pause:function(){this.player.pauseVideo();this.clearSliderTimeout();if(this.config.captionsOn&&this.captions){this.clearCaptionTimeout()}},ffwd:function(){var time=this.getCurrentTime()+this.config.playerSkip;this.seek(time)},rewd:function(){var time=this.getCurrentTime()-this.config.playerSkip;if(time<0){time=0}this.seek(time)},mute:function(){var $button=this.$html.find('button.mute');if(this.player.isMuted()){this.player.unMute();if($button.hasClass('muted')){$button.removeClass('muted')}}else{this.player.mute();$button.addClass('muted')}},volup:function(){var vol=this.player.getVolume();if(vol<(100-this.config.volumeStep)){vol+=this.config.volumeStep}else{vol=100}this.player.setVolume(vol);this.updateVolume(vol)},voldwn:function(){var vol=this.player.getVolume();if(vol>this.config.volumeStep){vol-=this.config.volumeStep}else{vol=0}this.player.setVolume(vol);this.updateVolume(vol)},getDuration:function(){return this.player.getDuration()},getCurrentTime:function(){return this.player.getCurrentTime()},getBytesLoaded:function(){return this.player.getVideoBytesLoaded()},getBytesTotal:function(){return this.player.getVideoBytesTotal()},seek:function(time){this.player.seekTo(time);if(this.config.captionsOn&&this.captions){this.$html.find('.caption').remove();this.clearCaptionTimeout();this.setCaptionTimeout();this.getPreviousCaption()}},cue:function(){this.player.cueVideoById(this.config.media)},toggleCaptions:function(){var self=this;var $c=this.$html.find('.captions');if($c.hasClass('captions-off')){$c.removeClass('captions-off').addClass('captions-on');self.getPreviousCaption();self.setCaptionTimeout();self.config.captionsOn=true}else{$c.removeClass('captions-on').addClass('captions-off');self.clearCaptionTimeout();self.$html.find('.caption').remove();self.config.captionsOn=false}}};function mediaplayer(index){this.config=config;$.extend(true,this,methods,functions);this.is_html5=false;var media=get_media_type(this);if(media&&supports_media(media.mimetype,media.container)&&this.config.useHtml5){this.is_html5=true;this.$html=this.assembleHTML5(media.container,media.mimetype);$.extend(this,html5_methods)}else{this.$html=this.assembleHTML()}if(this.config.captions){this.getCaptions()}}return this.each(function(i){var $self=$(this);var player=new mediaplayer(i);$self.html(player.$html);if(player.$html.width()>580){player.$html.addClass('player-wide')}if(player.is_html5){player.player=document.getElementById(player.config.id)}PlayerDaemon.addPlayer(player)})}}(jQuery));function onYouTubePlayerReady(playerId){var player=PlayerDaemon.getPlayer(playerId);var myplayer=document.getElementById(player.config.id);player.init(myplayer);}function playerState(state,playerId){var player=PlayerDaemon.getPlayer(playerId);if(state==1){player.play();if(player.config.buttons.toggle){player.$html.find('.play').removeClass('play').addClass('pause').text('Pause');}}else if(player.config.repeat&&(state==0)){player.play();}}
// Callback function for when the youtube player is ready
function onYouTubePlayerReady(playerId){var player=PlayerDaemon.getPlayer(playerId);var myplayer=document.getElementById(player.config.id);player.init(myplayer);}
// Callback function for when the player state changes using youtube's native (flash) player interface
function playerState(state,playerId){var player=PlayerDaemon.getPlayer(playerId);if(state===1){player.play();if(player.config.buttons.toggle){player.$html.find('.play').removeClass('play').addClass('pause').text('Pause');}}else if(player.config.repeat&&(state===0)){player.play();}}