# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class InputDirectory(Model):
    """Input directory for the job.

    :param id: The id for the input directory. It will be available for the
     job as an environment variable under AZ_BATCHAI_INPUT_id. The service will
     also provide the following  environment variable:
     AZ_BATCHAI_PREV_OUTPUT_Name. The value of the variable will be populated
     if the job is being retried after a previous failure, otherwise it will be
     set to nothing.
    :type id: str
    :param path: The path to the input directory.
    :type path: str
    """

    _validation = {
        'id': {'required': True},
        'path': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'path': {'key': 'path', 'type': 'str'},
    }

    def __init__(self, id, path):
        self.id = id
        self.path = path
