/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.data.values;

import org.brunel.data.util.MapInt;
import org.brunel.data.values.ColumnProvider;
import org.brunel.data.values.Provider;

public class ReorderedProvider
implements Provider {
    private final Provider base;
    private final int[] order;

    public ReorderedProvider(Provider base, int[] order) {
        if (base instanceof ReorderedProvider) {
            ReorderedProvider other = (ReorderedProvider)base;
            this.base = other.base;
            this.order = new int[order.length];
            for (int i = 0; i < order.length; ++i) {
                this.order[i] = other.order[order[i]];
            }
        } else {
            this.base = base;
            this.order = order;
        }
    }

    @Override
    public int compareRows(int a, int b, MapInt categoryOrder) {
        return this.base.compareRows(this.order[a], this.order[b], categoryOrder);
    }

    @Override
    public int count() {
        return this.order.length;
    }

    @Override
    public int expectedSize() {
        return 24 + this.order.length * 4 + this.base.expectedSize();
    }

    @Override
    public Provider setValue(Object o, int index) {
        return ColumnProvider.copy(this).setValue(o, index);
    }

    @Override
    public Object value(int index) {
        return this.base.value(this.order[index]);
    }
}

