/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.model.style;

import org.brunel.data.Data;
import org.brunel.model.style.StyleSelector;
import org.brunel.model.style.StyleTarget;

class BasicSelector
extends StyleSelector {
    private final String element;
    private final String[] classes;

    public BasicSelector(String element, String[] classes) {
        super(classes.length * 1000 + (element == null || element.isEmpty() ? 0 : 1));
        this.element = element == null || element.isEmpty() ? null : element;
        this.classes = classes;
    }

    @Override
    public String debug() {
        String s = "{";
        if (this.element != null) {
            s = s + this.element + " ";
        }
        return s + "classes=[" + Data.join((Object[])this.classes, (String)",") + "]}";
    }

    @Override
    public boolean match(StyleTarget target) {
        if (this.element != null && !this.element.equals(target.element)) {
            return false;
        }
        for (String s : this.classes) {
            if (!this.unmatched(s, target.classes)) continue;
            return false;
        }
        return true;
    }

    @Override
    public StyleSelector replaceClass(String target, String replace) {
        String[] replaced = new String[this.classes.length];
        boolean changed = false;
        for (int i = 0; i < replaced.length; ++i) {
            if (this.classes[i].equals(target)) {
                replaced[i] = replace;
                changed = true;
                continue;
            }
            replaced[i] = this.classes[i];
        }
        return changed ? new BasicSelector(this.element, replaced) : this;
    }

    private boolean unmatched(String c, String[] classes) {
        for (String s : classes) {
            if (!c.equals(s)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        String txt = this.element == null ? "" : this.element;
        for (String s : this.classes) {
            txt = txt + "." + s;
        }
        return txt;
    }
}

