/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.maps.projection;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.brunel.geom.Point;
import org.brunel.geom.Rect;

public abstract class Projection {
    static final String width = "geom.inner_width";
    static final String height = "geom.inner_height";
    static final NumberFormat F = new DecimalFormat("#.####");
    static final String LN = "\n\t\t";

    public Rect projectedBounds(Point[] points) {
        Rect r = null;
        for (Point p : points) {
            Point q = this.transform(p);
            r = r == null ? new Rect(q.x, q.x, q.y, q.y) : r.union(q);
        }
        return r;
    }

    String translateDefinition() {
        return ".translate([geom.inner_width/2, geom.inner_height/2])";
    }

    String scaleDefinition(Rect extent) {
        return ".scale(Math.min((geom.inner_width-4)/" + F.format(extent.width()) + ", (" + height + "-4)/" + F.format(extent.height()) + "))";
    }

    public abstract String d3Definition(Rect var1);

    public double getTissotArea(Point p) {
        double h = 5.0E-4;
        double dx = Math.abs(this.transform((Point)p.translate((double)(-h), (double)0.0)).x - this.transform((Point)p.translate((double)h, (double)0.0)).x);
        double dy = Math.abs(this.transform((Point)p.translate((double)0.0, (double)(-h))).y - this.transform((Point)p.translate((double)0.0, (double)h)).y);
        return dx * dy;
    }

    public abstract Point transform(Point var1);

    public abstract Point inverse(Point var1);

    Rect transform(Rect b) {
        Rect bounds = null;
        for (Point pt : b.makeBoundaryPoints()) {
            Point p = this.transform(pt);
            bounds = bounds == null ? new Rect(p.x, p.x, p.y, p.y) : bounds.union(p);
        }
        return bounds;
    }
}

