/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.maps.projection;

import org.brunel.geom.Point;
import org.brunel.geom.Rect;
import org.brunel.maps.projection.Projection;

class Mercator
extends Projection {
    Mercator() {
    }

    @Override
    public String d3Definition(Rect bounds) {
        Rect ext = this.transform(bounds);
        Point c = this.inverse(ext.center());
        String center = ".center([" + F.format(c.x) + ", " + F.format(c.y) + "])";
        return "d3.geoMercator()\n\t\t" + this.translateDefinition() + "\n\t\t" + this.scaleDefinition(ext) + "\n\t\t" + center;
    }

    @Override
    public Point transform(Point p) {
        double a = Math.toRadians(p.x);
        double lon = Math.min(89.5, Math.max(p.y, -89.5));
        double b = Math.toRadians(lon);
        return new Point(a, Math.log(Math.tan(0.7853981633974483 + b / 2.0)));
    }

    @Override
    public Point inverse(Point p) {
        double a = Math.toDegrees(p.x);
        double b = Math.toDegrees(2.0 * Math.atan(Math.exp(p.y)) - 1.5707963267948966);
        return new Point(a, b);
    }
}

