/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.d3.diagrams;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.List;
import org.brunel.build.d3.D3Interaction;
import org.brunel.build.d3.diagrams.D3Diagram;
import org.brunel.build.d3.element.ElementDetails;
import org.brunel.build.d3.element.ElementRepresentation;
import org.brunel.build.info.ChartStructure;
import org.brunel.build.util.ScriptWriter;
import org.brunel.data.Data;
import org.brunel.data.Dataset;
import org.brunel.maps.LabelPoint;
import org.brunel.model.VisSingle;

public class GeoMapLabels
extends D3Diagram {
    private final NumberFormat F = new DecimalFormat("#.####");
    private final ChartStructure structure;
    private int pointCount;

    public GeoMapLabels(VisSingle vis, Dataset data, ChartStructure structure, D3Interaction interaction, ScriptWriter out) {
        super(vis, data, interaction, out);
        this.structure = structure;
    }

    @Override
    public String getRowKey() {
        return "d[2]";
    }

    @Override
    public void preBuildDefinitions() {
        List<LabelPoint> pointsMax;
        List<LabelPoint> all = this.structure.geo.getLabelsForFiles();
        int maxPoints = 40;
        if (this.vis.tDiagramParameters[0].modifiers().length > 0) {
            maxPoints = (int)this.vis.tDiagramParameters[0].modifiers()[0].asDouble();
        }
        List<LabelPoint> points = (pointsMax = this.subset(all, maxPoints)).size() <= maxPoints ? pointsMax : pointsMax.subList(0, maxPoints);
        int popHigh = 0;
        int popLow = 100;
        for (LabelPoint p : points) {
            popHigh = Math.max(popHigh, p.pop);
            popLow = Math.min(popLow, p.pop);
        }
        this.out.onNewLine().comment("lon, lat, label, size, type");
        this.out.add("var geo_labels = [").indentMore();
        boolean first = true;
        Collections.reverse(points);
        this.pointCount = points.size();
        for (LabelPoint p : points) {
            if (!first) {
                this.out.add(", ");
            }
            String s = "[" + this.F.format(p.x) + "," + this.F.format(p.y) + "," + Data.quote((String)p.label) + "," + this.radiusFor(p, popHigh, popLow) + "," + Math.min(6 - p.importance, 4) + "]";
            if (this.out.currentColumn() + s.length() > 120) {
                this.out.onNewLine();
            }
            this.out.add(s);
            first = false;
        }
        this.out.indentLess().add("]").endStatement();
    }

    private List<LabelPoint> subset(List<LabelPoint> all, int maxPoints) {
        return maxPoints < all.size() ? all.subList(0, maxPoints) : all;
    }

    @Override
    public ElementDetails initializeDiagram() {
        return ElementDetails.makeForDiagram(this.vis, ElementRepresentation.symbol, "point", "geo_labels");
    }

    @Override
    public void writeDefinition(ElementDetails details) {
        this.out.addChained("attr('d', function(d) { return BrunelD3.symbol(d[4] == 0 ? 'star' : (d[4] == 1 ? 'square' : 'circle'), d[3]*geom.default_point_size/14)})").addChained("attr('class', function(d) { return 'element mark L' + d[4] })");
        this.out.addChained("attr('transform', function(d) {").indentMore().indentMore().onNewLine().add("var p = projection(d) || [9e6,9e6]").endStatement().add("return 'translate(' + p[0] + ', ' + p[1] + ')'").indentLess().indentLess().onNewLine().add("} )").endStatement();
        this.out.add("labels.classed('map', true)").endStatement();
        int granularity = (int)Math.ceil(Math.sqrt((double)this.pointCount / 10.0));
        this.out.add("var labeling = {").indentMore().onNewLine().add("method:'box', pad:3, inside:false, align:'start', granularity:" + granularity + ",").onNewLine().add("location:['right', 'middle'], content: function(d) {return d[2]},").onNewLine().add("cssClass:function(d) {return 'label L' + d[4]}").indentLess().onNewLine().add("}").endStatement();
        this.out.add("BrunelD3.label(merged, labels, labeling, 0, geom)").endStatement();
    }

    @Override
    public boolean needsDiagramLabels() {
        return false;
    }

    @Override
    public void writeDiagramEnter() {
        this.out.add("merged.classed('map', true)").endStatement();
    }

    private int radiusFor(LabelPoint p, int high, int low) {
        return (int)Math.round((double)(p.pop - low) * 4.0 / (double)(high - low) + 3.0);
    }
}

