/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.d3;

import org.brunel.build.info.ChartStructure;
import org.brunel.build.util.Accessibility;
import org.brunel.build.util.ScriptWriter;

public class SVGGroupUtility {
    public final String className;
    private final ChartStructure structure;
    private final ScriptWriter out;

    public SVGGroupUtility(ChartStructure structure, String className, ScriptWriter out) {
        this.className = className;
        this.structure = structure;
        this.out = out;
    }

    public void addAccessibleChartInfo() {
        if (this.structure.accessible) {
            this.addAccessibleTitle(Accessibility.makeNumberingTitle("chart", this.structure.chartIndex));
        }
    }

    public void addAccessibleTitle(String title) {
        if (this.structure.accessible) {
            Accessibility.writeLabelAttribute(title, this.out);
        }
    }

    public void addClipPathReference(String part) {
        this.out.addChained("attr('clip-path', 'url(#" + this.clipID(part) + ")')");
    }

    public String createChart() {
        return "vis.append('g').attr('class', '" + this.className + "')";
    }

    public void defineInnerClipPath() {
        this.out.add("vis.append('clipPath').attr('id', '" + this.clipID("inner") + "').append('rect')").addChained("attr('x', 0).attr('y', 0)").addChained("attr('width', geom.inner_rawWidth+1).attr('height', geom.inner_rawHeight+1)").endStatement();
    }

    public void defineHorizontalAxisClipPath() {
        this.out.add("vis.append('clipPath').attr('id', '" + this.clipID("haxis") + "').append('polyline')").addChained("attr('points', '-1,-1000, -1,-1 -5,5, -1000,5, -100,1000, 10000,1000 10000,-1000')").endStatement();
    }

    public void defineVerticalAxisClipPath() {
        this.out.add("vis.append('clipPath').attr('id', '" + this.clipID("vaxis") + "').append('polyline')").addChained("attr('points', '-1000,-10000, 10000,-10000, 10000,' + (geom.inner_rawHeight+1) + ', -1,' + (geom.inner_rawHeight+1) + ', -1,' + (geom.inner_rawHeight+5) + ', -1000,' + (geom.inner_rawHeight+5) )").endStatement();
    }

    private String clipID(String part) {
        return "clip_" + this.structure.visIdentifier + "_chart" + (this.structure.chartIndex + 1) + "_" + part;
    }
}

