/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.d3;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.brunel.action.Param;
import org.brunel.build.d3.D3ScaleBuilder;
import org.brunel.build.info.ChartStructure;
import org.brunel.build.info.ElementStructure;
import org.brunel.build.util.ScriptWriter;
import org.brunel.model.VisSingle;
import org.brunel.model.VisTypes;

public class D3Interaction {
    private static final boolean[] ZOOM_ALL = new boolean[]{true, true};
    private static final boolean[] ZOOM_NONE = new boolean[]{false, false};
    public static final String DEFAULT_SNAP_DISTANCE = "geom.inner_radius/4";
    private final ChartStructure structure;
    private final D3ScaleBuilder scales;
    private final ScriptWriter out;
    private final boolean canZoomX;
    private final boolean canZoomY;

    public D3Interaction(ChartStructure structure, D3ScaleBuilder scales, ScriptWriter out) {
        this.structure = structure;
        this.scales = scales;
        this.out = out;
        boolean[] zoomTypes = this.zoomRequested(structure.elementStructure);
        if (zoomTypes == null) {
            zoomTypes = this.defaultZooms();
        }
        this.canZoomX = zoomTypes[0];
        this.canZoomY = zoomTypes[1];
    }

    private boolean[] defaultZooms() {
        if (this.structure.diagram == VisTypes.Diagram.network || this.structure.diagram == VisTypes.Diagram.map || this.structure.diagram == VisTypes.Diagram.tree) {
            return ZOOM_ALL;
        }
        if (this.structure.diagram != null) {
            return ZOOM_NONE;
        }
        if (this.scales.coords == VisTypes.Coordinates.polar) {
            return ZOOM_NONE;
        }
        return new boolean[]{!this.structure.coordinates.xCategorical, !this.structure.coordinates.yCategorical};
    }

    public void defineChartZoomFunction() {
        this.out.onNewLine().add("zoom: function(params, time) {").indentMore().indentMore().onNewLine().add("if (params) zoom.on('zoom').call(zoomNode, params, time)").endStatement().add("return d3.zoomTransform(zoomNode)").endStatement();
        this.out.indentLess().indentLess().onNewLine().add("},");
    }

    private boolean[] zoomRequested(ElementStructure[] elements) {
        for (ElementStructure e : elements) {
            String s;
            if (D3Interaction.getInteractionParam(e.vis, VisTypes.Interaction.none) != null) {
                return ZOOM_NONE;
            }
            Param param = D3Interaction.getInteractionParam(e.vis, VisTypes.Interaction.panzoom);
            if (param == null) continue;
            String string = s = param.hasModifiers() ? param.firstModifier().asString() : "both";
            if (s.equals("none")) {
                return ZOOM_NONE;
            }
            if (s.equals("x")) {
                return new boolean[]{true, false};
            }
            if (s.equals("y")) {
                return new boolean[]{false, true};
            }
            return ZOOM_ALL;
        }
        return null;
    }

    public boolean hasElementInteraction(ElementStructure structure) {
        if (!structure.vis.itemsTooltip.isEmpty()) {
            return true;
        }
        if (structure.chart.diagram == VisTypes.Diagram.network) {
            return true;
        }
        for (Param p : structure.vis.tInteraction) {
            String s = p.asString();
            if (!s.equals(VisTypes.Interaction.select.name()) && !s.equals(VisTypes.Interaction.call.name()) || !this.targetsElement(p)) continue;
            return true;
        }
        return false;
    }

    private boolean targetsElement(Param param) {
        if (param == null) {
            return false;
        }
        for (Param p : param.modifiers()) {
            if (!p.asString().startsWith("snap")) continue;
            return false;
        }
        return true;
    }

    public static Param getInteractionParam(VisSingle vis, VisTypes.Interaction type) {
        for (Param p : vis.tInteraction) {
            if (p.asEnum(VisTypes.Interaction.class) != type) continue;
            return p;
        }
        return null;
    }

    public void addHandlers(List<Param> interactions) {
        LinkedHashMap<String, List<String>> elementEvents = new LinkedHashMap<String, List<String>>();
        LinkedHashMap<String, List<String>> overlayEvents = new LinkedHashMap<String, List<String>>();
        String[] snapInfo = null;
        for (Param p : interactions) {
            if (snapInfo != null) continue;
            snapInfo = this.findSnapInfo(p);
        }
        for (Param p : interactions) {
            String functionName;
            VisTypes.Interaction type = p.asEnum(VisTypes.Interaction.class);
            if (type == VisTypes.Interaction.select) {
                if (snapInfo != null) {
                    this.addFunctionDefinition("mousemove.snap", "BrunelD3.select(c.item, c.target, element, updateAll)", overlayEvents);
                    this.addFunctionDefinition("mouseout.snap", "BrunelD3.select(null, c.target, element, updateAll)", overlayEvents);
                    continue;
                }
                String eventName = p.hasModifiers() ? p.firstModifier().asString() : "click";
                this.addFunctionDefinition(eventName + ".interact", "BrunelD3.select(d, this, element, updateAll)", elementEvents);
                if (eventName.equals("mouseover") || eventName.equals("mousemove")) {
                    this.addFunctionDefinition("mouseout.interact", "BrunelD3.select(null, this, element, updateAll)", elementEvents);
                }
                if (!eventName.equals("click")) continue;
                this.addFunctionDefinition("click.interact", "BrunelD3.select(null, this, element, updateAll)", overlayEvents);
                continue;
            }
            if (type != VisTypes.Interaction.call) continue;
            String string = functionName = p.hasModifiers() ? p.firstModifier().asString() : "BrunelD3.crosshairs";
            if (functionName.isEmpty()) {
                functionName = "BrunelD3.crosshairs";
            }
            if (snapInfo != null) {
                this.addFunctionDefinition("mousemove.user", functionName + "(c.item, c.target, element, '" + snapInfo[0] + "')", overlayEvents);
                this.addFunctionDefinition("mouseout.user", functionName + "(null, c.target, element, '" + snapInfo[0] + "')", overlayEvents);
                continue;
            }
            String eventName = p.modifiers().length > 1 ? p.modifiers()[1].toString() : "click";
            this.addFunctionDefinition(eventName + ".user", functionName + "(d, this, element)", elementEvents);
            if (eventName.equals("mouseover") || eventName.equals("mousemove")) {
                this.addFunctionDefinition("mouseout.user", functionName + "(null, this, element)", elementEvents);
            }
            if (!eventName.equals("click")) continue;
            this.addFunctionDefinition("click.user", functionName + "(null, c.target, element, 'xy')", overlayEvents);
        }
        if (!overlayEvents.isEmpty()) {
            for (List e : overlayEvents.values()) {
                if (snapInfo == null) {
                    e.add(0, "var c = BrunelD3.closest(merged, 'xy', geom.inner_radius/4 )");
                    continue;
                }
                e.add(0, "var c = BrunelD3.closest(merged, '" + snapInfo[0] + "', " + snapInfo[1] + " )");
            }
            this.out.add("chart.select('rect.overlay')").at(60).comment("Attach handlers to the overlay");
            this.addDispatchers(overlayEvents);
        }
        if (!elementEvents.isEmpty()) {
            this.out.add("merged").at(60).comment("Attach handlers to the element");
            this.addDispatchers(elementEvents);
        }
    }

    private void addDispatchers(Map<String, List<String>> dispatching) {
        for (Map.Entry<String, List<String>> e : dispatching.entrySet()) {
            String event = e.getKey();
            this.out.addChained("on('" + event + "', function(d) {");
            List<String> calls = e.getValue();
            if (calls.size() == 1) {
                this.out.add(calls.get(0), "})");
                continue;
            }
            this.out.onNewLine().indentMore().indentMore();
            for (String s : calls) {
                this.out.onNewLine().add(s).endStatement();
            }
            this.out.onNewLine().indentLess().add("})").indentLess();
        }
        this.out.endStatement();
    }

    private void addFunctionDefinition(String eventName, String definition, Map<String, List<String>> dispatching) {
        List<String> list = dispatching.get(eventName);
        if (list == null) {
            list = new ArrayList<String>();
            dispatching.put(eventName, list);
        }
        list.add(definition);
    }

    private String[] findSnapInfo(Param param) {
        String snapFunction = null;
        for (Param p : param.modifiers()) {
            String[] stringArray;
            if (p.asString().startsWith("snap")) {
                if (p.asString().equalsIgnoreCase("snapx")) {
                    snapFunction = "x";
                    continue;
                }
                if (p.asString().equalsIgnoreCase("snapy")) {
                    snapFunction = "y";
                    continue;
                }
                snapFunction = "xy";
                continue;
            }
            if (snapFunction == null) continue;
            double d = p.asDouble();
            if (d < 1.0) {
                stringArray = null;
            } else {
                String[] stringArray2 = new String[2];
                stringArray2[0] = snapFunction;
                stringArray = stringArray2;
                stringArray2[1] = "" + (int)d;
            }
            return stringArray;
        }
        if (snapFunction != null) {
            return new String[]{snapFunction, DEFAULT_SNAP_DISTANCE};
        }
        return null;
    }

    public void addOverlayForZoom() {
        this.out.add("var overlay = chart.append('g').attr('class', 'element')").addChained("attr('class', 'overlay').style('cursor','move').style('fill','none').style('pointer-events','all')").endStatement();
        this.out.add("var zoom = d3.zoom().scaleExtent([1/3,3])").endStatement();
        this.out.add("var zoomNode = overlay.append('rect').attr('class', 'overlay')").addChained("attr('x', geom.inner_left).attr('y', geom.inner_top)").addChained("attr('width', geom.inner_rawWidth).attr('height', geom.inner_rawHeight)");
        if (this.hasZoomInteractivity()) {
            this.out.addChained("call(zoom)");
        }
        this.out.addChained("node()").endStatement();
        this.out.add("zoomNode.__zoom = d3.zoomIdentity").endStatement();
    }

    public boolean hasZoomInteractivity() {
        return this.canZoomX || this.canZoomY;
    }

    public void addZoomFunctionality() {
        this.out.add("zoom.on('zoom', function(t, time) {").indentMore().indentMore().onNewLine();
        if (this.structure.diagram == null) {
            this.out.add("t = t ||BrunelD3.restrictZoom(d3.event.transform, geom, this)");
        } else {
            this.out.add("t = t || d3.event.transform");
        }
        this.out.endStatement();
        if (this.structure.diagram != VisTypes.Diagram.map) {
            if (this.canZoomX) {
                this.applyZoomToScale(0);
            }
            if (this.canZoomY) {
                this.applyZoomToScale(1);
            }
        }
        this.out.add("zoomNode.__zoom = t").endStatement();
        if (this.structure.diagram == VisTypes.Diagram.network) {
            this.out.comment("If the simulation has stopped, run one pass to use the scale");
            this.out.add("if (simulation && simulation.alpha() < simulation.alphaMin()) simulation.on('tick')()").endStatement();
        } else if (this.structure.diagram == VisTypes.Diagram.cloud) {
            this.out.add("interior.attr('transform', d3.zoomTransform(zoomNode))").endStatement();
        } else {
            this.out.add("build(time || -1)").endStatement();
        }
        this.out.indentLess().indentLess().add("})").endStatement();
    }

    private void applyZoomToScale(int dimension) {
        boolean yCategorical;
        boolean isScreenX = this.structure.coordinates.isTransposed() ? dimension == 1 : dimension == 0;
        String offset = isScreenX ? "t.x" : "t.y";
        this.out.add(dimension == 0 ? "scale_x" : "scale_y");
        boolean xCategorical = this.structure.diagram == null && this.structure.coordinates.xCategorical;
        boolean bl = yCategorical = this.structure.diagram == null && this.structure.coordinates.yCategorical;
        if (dimension == 0 && xCategorical) {
            this.out.add(".range([" + offset + ", " + offset + " + t.k * geom.inner_width])");
        } else if (dimension == 1 && yCategorical) {
            this.out.add(".range([" + offset + ", " + offset + " + + t.k * geom.inner_height])");
        } else {
            this.out.add(" =", isScreenX ? "t.rescaleX" : "t.rescaleY");
            this.out.add("(base_scales[" + dimension + "])");
        }
        this.out.endStatement();
    }
}

