# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class CorrelationFilter(Model):
    """Represents the correlation filter expression.

    :param correlation_id: Identifier of the correlation.
    :type correlation_id: str
    :param message_id: Identifier of the message.
    :type message_id: str
    :param to: Address to send to.
    :type to: str
    :param reply_to: Address of the queue to reply to.
    :type reply_to: str
    :param label: Application specific label.
    :type label: str
    :param session_id: Session identifier.
    :type session_id: str
    :param reply_to_session_id: Session identifier to reply to.
    :type reply_to_session_id: str
    :param content_type: Content type of the message.
    :type content_type: str
    :param requires_preprocessing: Value that indicates whether the rule
     action requires preprocessing. Default value: True .
    :type requires_preprocessing: bool
    """

    _attribute_map = {
        'correlation_id': {'key': 'correlationId', 'type': 'str'},
        'message_id': {'key': 'messageId', 'type': 'str'},
        'to': {'key': 'to', 'type': 'str'},
        'reply_to': {'key': 'replyTo', 'type': 'str'},
        'label': {'key': 'label', 'type': 'str'},
        'session_id': {'key': 'sessionId', 'type': 'str'},
        'reply_to_session_id': {'key': 'replyToSessionId', 'type': 'str'},
        'content_type': {'key': 'contentType', 'type': 'str'},
        'requires_preprocessing': {'key': 'requiresPreprocessing', 'type': 'bool'},
    }

    def __init__(self, correlation_id=None, message_id=None, to=None, reply_to=None, label=None, session_id=None, reply_to_session_id=None, content_type=None, requires_preprocessing=True):
        self.correlation_id = correlation_id
        self.message_id = message_id
        self.to = to
        self.reply_to = reply_to
        self.label = label
        self.session_id = session_id
        self.reply_to_session_id = reply_to_session_id
        self.content_type = content_type
        self.requires_preprocessing = requires_preprocessing
