#!/usr/bin/env python

# COmmon Data model Events eXtraction (CODEX)
# Denormalization of CDM-formatted, PostgreSQL-hosted
# EHR datasets into time-stamped transactional tables.
# Contact: Aurelien Mazurie <ajmazurie@oenone.net>

import glob, shutil
import sys, os
import setuptools

__NAME__ = "codex"
__VERSION__ = "0.2.4"

static_files = glob.glob("share/*")
if (len(static_files) > 0):
    with open("MANIFEST.in", "w") as manifest_fh:
        for static_file in static_files:
            manifest_fh.write("include lib/%s\n" % static_file)

    if (os.path.isdir("lib/share")):
        shutil.rmtree("lib/share")

    shutil.copytree("share", "lib/share")

setuptools.setup(
    name = __NAME__,
    version = __VERSION__,
    description = (
        "Denormalization of Common Data Model-formated "
        "electronic health records for time-oriented queries"),

    author = "Aurelien Mazurie",
    author_email = "ajmazurie@oenone.net",

    # package content
    packages = [
        __NAME__],
    package_dir = {
        __NAME__: "lib"},
    scripts = glob.glob("bin/*"),
    include_package_data = True,

    # package requirements
    install_requires = [
        "docopt",
        "psycopg2",
        "sqlparse",
        "six"],

    # package metadata
    url = "https://github.com/ajmazurie/" + __NAME__,
    download_url = (
        "https://github.com/ajmazurie/"
        "%s/archive/%s.zip" % (__NAME__, __VERSION__)),

    classifiers = [
        "Development Status :: 4 - Beta",
        "Environment :: Console",
        "Intended Audience :: Healthcare Industry",
        "Intended Audience :: Science/Research",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
        "Programming Language :: Python :: 2.7",
        "Programming Language :: Python :: 3.5",
        "Topic :: Database",
        "Topic :: Scientific/Engineering :: Bio-Informatics",
        "Topic :: Scientific/Engineering :: Medical Science Apps.",
        "Topic :: Software Development :: Libraries :: Python Modules"])

if (len(static_files) > 0):
    os.remove("MANIFEST.in")
    shutil.rmtree("lib/share")
