-- main structures for CODEX

DROP TYPE IF EXISTS codex_eventclass CASCADE;

CREATE TYPE codex_eventclass AS enum (
    'birth', 'death',
    'observation_period',
    'specimen_collection',
    'visit',
    'procedure',
    'drug_exposure',
    'device_exposure',
    'condition',
    'measurement',
    'observation'
    );

-- INFO: creating events table
DROP TABLE IF EXISTS {{codex_events}} CASCADE;

CREATE TABLE {{codex_events}} (
    -- person associated to this event
    person_id integer NOT NULL REFERENCES person,

    -- identifier in the original table, if any
    event_id integer,

    -- class of event
    event_class codex_eventclass NOT NULL,

    -- range of date for this event
    event_period daterange NOT NULL,

    -- data associated with this event, if any
    event_data jsonb,

    -- visit associated with this event, if any
    event_visit_id integer REFERENCES visit_occurrence,

    -- provider associated with this event, if any
    event_provider_id integer REFERENCES provider
    );
