
-- INFO: indexing events table
CREATE INDEX idx_codex_events_person
          ON {{codex_events}} (person_id);

CREATE INDEX idx_codex_events_class
          ON {{codex_events}} (event_class);

CREATE INDEX idx_codex_events_period_btree
          ON {{codex_events}} USING BTREE (event_period);

CREATE INDEX idx_codex_events_period_gist
          ON {{codex_events}} USING GIST (event_period);

CREATE INDEX idx_codex_events_data
          ON {{codex_events}} USING GIN (event_data);

-- INFO: clustering events table
CLUSTER {{codex_events}} USING idx_codex_events_person;

-- INFO: analyzing events table
ANALYZE {{codex_events}};
